# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetChannelPartnerLinkResult',
    'AwaitableGetChannelPartnerLinkResult',
    'get_channel_partner_link',
    'get_channel_partner_link_output',
]

@pulumi.output_type
class GetChannelPartnerLinkResult:
    def __init__(__self__, channel_partner_cloud_identity_info=None, create_time=None, invite_link_uri=None, link_state=None, name=None, public_id=None, reseller_cloud_identity_id=None, update_time=None):
        if channel_partner_cloud_identity_info and not isinstance(channel_partner_cloud_identity_info, dict):
            raise TypeError("Expected argument 'channel_partner_cloud_identity_info' to be a dict")
        pulumi.set(__self__, "channel_partner_cloud_identity_info", channel_partner_cloud_identity_info)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if invite_link_uri and not isinstance(invite_link_uri, str):
            raise TypeError("Expected argument 'invite_link_uri' to be a str")
        pulumi.set(__self__, "invite_link_uri", invite_link_uri)
        if link_state and not isinstance(link_state, str):
            raise TypeError("Expected argument 'link_state' to be a str")
        pulumi.set(__self__, "link_state", link_state)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_id and not isinstance(public_id, str):
            raise TypeError("Expected argument 'public_id' to be a str")
        pulumi.set(__self__, "public_id", public_id)
        if reseller_cloud_identity_id and not isinstance(reseller_cloud_identity_id, str):
            raise TypeError("Expected argument 'reseller_cloud_identity_id' to be a str")
        pulumi.set(__self__, "reseller_cloud_identity_id", reseller_cloud_identity_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="channelPartnerCloudIdentityInfo")
    def channel_partner_cloud_identity_info(self) -> 'outputs.GoogleCloudChannelV1CloudIdentityInfoResponse':
        """
        Cloud Identity info of the channel partner (IR).
        """
        return pulumi.get(self, "channel_partner_cloud_identity_info")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp of when the channel partner link is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="inviteLinkUri")
    def invite_link_uri(self) -> str:
        """
        URI of the web page where partner accepts the link invitation.
        """
        return pulumi.get(self, "invite_link_uri")

    @property
    @pulumi.getter(name="linkState")
    def link_state(self) -> str:
        """
        State of the channel partner link.
        """
        return pulumi.get(self, "link_state")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the channel partner link, in the format accounts/{account_id}/channelPartnerLinks/{id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicId")
    def public_id(self) -> str:
        """
        Public identifier that a customer must use to generate a transfer token to move to this distributor-reseller combination.
        """
        return pulumi.get(self, "public_id")

    @property
    @pulumi.getter(name="resellerCloudIdentityId")
    def reseller_cloud_identity_id(self) -> str:
        """
        Cloud Identity ID of the linked reseller.
        """
        return pulumi.get(self, "reseller_cloud_identity_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp of when the channel partner link is updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetChannelPartnerLinkResult(GetChannelPartnerLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelPartnerLinkResult(
            channel_partner_cloud_identity_info=self.channel_partner_cloud_identity_info,
            create_time=self.create_time,
            invite_link_uri=self.invite_link_uri,
            link_state=self.link_state,
            name=self.name,
            public_id=self.public_id,
            reseller_cloud_identity_id=self.reseller_cloud_identity_id,
            update_time=self.update_time)


def get_channel_partner_link(account_id: Optional[str] = None,
                             channel_partner_link_id: Optional[str] = None,
                             view: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelPartnerLinkResult:
    """
    Returns the requested ChannelPartnerLink resource. You must be a distributor to call this method. Possible error codes: * PERMISSION_DENIED: The reseller account making the request is different from the reseller account in the API request. * INVALID_ARGUMENT: Required request parameters are missing or invalid. * NOT_FOUND: ChannelPartnerLink resource not found because of an invalid channel partner link name. Return value: The ChannelPartnerLink resource.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['channelPartnerLinkId'] = channel_partner_link_id
    __args__['view'] = view
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudchannel/v1:getChannelPartnerLink', __args__, opts=opts, typ=GetChannelPartnerLinkResult).value

    return AwaitableGetChannelPartnerLinkResult(
        channel_partner_cloud_identity_info=__ret__.channel_partner_cloud_identity_info,
        create_time=__ret__.create_time,
        invite_link_uri=__ret__.invite_link_uri,
        link_state=__ret__.link_state,
        name=__ret__.name,
        public_id=__ret__.public_id,
        reseller_cloud_identity_id=__ret__.reseller_cloud_identity_id,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_channel_partner_link)
def get_channel_partner_link_output(account_id: Optional[pulumi.Input[str]] = None,
                                    channel_partner_link_id: Optional[pulumi.Input[str]] = None,
                                    view: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetChannelPartnerLinkResult]:
    """
    Returns the requested ChannelPartnerLink resource. You must be a distributor to call this method. Possible error codes: * PERMISSION_DENIED: The reseller account making the request is different from the reseller account in the API request. * INVALID_ARGUMENT: Required request parameters are missing or invalid. * NOT_FOUND: ChannelPartnerLink resource not found because of an invalid channel partner link name. Return value: The ChannelPartnerLink resource.
    """
    ...
