# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetGithubEnterpriseConfigResult',
    'AwaitableGetGithubEnterpriseConfigResult',
    'get_github_enterprise_config',
    'get_github_enterprise_config_output',
]

@pulumi.output_type
class GetGithubEnterpriseConfigResult:
    def __init__(__self__, app_id=None, create_time=None, display_name=None, host_url=None, name=None, peered_network=None, secrets=None, ssl_ca=None, webhook_key=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if host_url and not isinstance(host_url, str):
            raise TypeError("Expected argument 'host_url' to be a str")
        pulumi.set(__self__, "host_url", host_url)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peered_network and not isinstance(peered_network, str):
            raise TypeError("Expected argument 'peered_network' to be a str")
        pulumi.set(__self__, "peered_network", peered_network)
        if secrets and not isinstance(secrets, dict):
            raise TypeError("Expected argument 'secrets' to be a dict")
        pulumi.set(__self__, "secrets", secrets)
        if ssl_ca and not isinstance(ssl_ca, str):
            raise TypeError("Expected argument 'ssl_ca' to be a str")
        pulumi.set(__self__, "ssl_ca", ssl_ca)
        if webhook_key and not isinstance(webhook_key, str):
            raise TypeError("Expected argument 'webhook_key' to be a str")
        pulumi.set(__self__, "webhook_key", webhook_key)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        """
        The GitHub app id of the Cloud Build app on the GitHub Enterprise server.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when the installation was associated with the project.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name to display for this config.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> str:
        """
        The URL of the github enterprise host the configuration is for.
        """
        return pulumi.get(self, "host_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. The full resource name for the GitHubEnterpriseConfig For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> str:
        """
        Optional. The network to be used when reaching out to the GitHub Enterprise server. The VPC network must be enabled for private service connection. This should be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the GitHub Enterprise server will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @property
    @pulumi.getter
    def secrets(self) -> 'outputs.GitHubEnterpriseSecretsResponse':
        """
        Names of secrets in Secret Manager.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> str:
        """
        Optional. SSL certificate to use for requests to GitHub Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> str:
        """
        The key that should be attached to webhook calls to the ReceiveWebhook endpoint.
        """
        return pulumi.get(self, "webhook_key")


class AwaitableGetGithubEnterpriseConfigResult(GetGithubEnterpriseConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGithubEnterpriseConfigResult(
            app_id=self.app_id,
            create_time=self.create_time,
            display_name=self.display_name,
            host_url=self.host_url,
            name=self.name,
            peered_network=self.peered_network,
            secrets=self.secrets,
            ssl_ca=self.ssl_ca,
            webhook_key=self.webhook_key)


def get_github_enterprise_config(config_id: Optional[str] = None,
                                 github_enterprise_config_id: Optional[str] = None,
                                 location: Optional[str] = None,
                                 project: Optional[str] = None,
                                 project_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGithubEnterpriseConfigResult:
    """
    Retrieve a GitHubEnterpriseConfig.
    """
    __args__ = dict()
    __args__['configId'] = config_id
    __args__['githubEnterpriseConfigId'] = github_enterprise_config_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['projectId'] = project_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudbuild/v1:getGithubEnterpriseConfig', __args__, opts=opts, typ=GetGithubEnterpriseConfigResult).value

    return AwaitableGetGithubEnterpriseConfigResult(
        app_id=__ret__.app_id,
        create_time=__ret__.create_time,
        display_name=__ret__.display_name,
        host_url=__ret__.host_url,
        name=__ret__.name,
        peered_network=__ret__.peered_network,
        secrets=__ret__.secrets,
        ssl_ca=__ret__.ssl_ca,
        webhook_key=__ret__.webhook_key)


@_utilities.lift_output_func(get_github_enterprise_config)
def get_github_enterprise_config_output(config_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        github_enterprise_config_id: Optional[pulumi.Input[str]] = None,
                                        location: Optional[pulumi.Input[str]] = None,
                                        project: Optional[pulumi.Input[Optional[str]]] = None,
                                        project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGithubEnterpriseConfigResult]:
    """
    Retrieve a GitHubEnterpriseConfig.
    """
    ...
