# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetFeedResult',
    'AwaitableGetFeedResult',
    'get_feed',
    'get_feed_output',
]

@pulumi.output_type
class GetFeedResult:
    def __init__(__self__, asset_names=None, asset_types=None, condition=None, content_type=None, feed_output_config=None, name=None, relationship_types=None):
        if asset_names and not isinstance(asset_names, list):
            raise TypeError("Expected argument 'asset_names' to be a list")
        pulumi.set(__self__, "asset_names", asset_names)
        if asset_types and not isinstance(asset_types, list):
            raise TypeError("Expected argument 'asset_types' to be a list")
        pulumi.set(__self__, "asset_types", asset_types)
        if condition and not isinstance(condition, dict):
            raise TypeError("Expected argument 'condition' to be a dict")
        pulumi.set(__self__, "condition", condition)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if feed_output_config and not isinstance(feed_output_config, dict):
            raise TypeError("Expected argument 'feed_output_config' to be a dict")
        pulumi.set(__self__, "feed_output_config", feed_output_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if relationship_types and not isinstance(relationship_types, list):
            raise TypeError("Expected argument 'relationship_types' to be a list")
        pulumi.set(__self__, "relationship_types", relationship_types)

    @property
    @pulumi.getter(name="assetNames")
    def asset_names(self) -> Sequence[str]:
        """
        A list of the full names of the assets to receive updates. You must specify either or both of asset_names and asset_types. Only asset updates matching specified asset_names or asset_types are exported to the feed. Example: `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`. For a list of the full names for supported asset types, see [Resource name format](/asset-inventory/docs/resource-name-format).
        """
        return pulumi.get(self, "asset_names")

    @property
    @pulumi.getter(name="assetTypes")
    def asset_types(self) -> Sequence[str]:
        """
        A list of types of the assets to receive updates. You must specify either or both of asset_names and asset_types. Only asset updates matching specified asset_names or asset_types are exported to the feed. Example: `"compute.googleapis.com/Disk"` For a list of all supported asset types, see [Supported asset types](/asset-inventory/docs/supported-asset-types).
        """
        return pulumi.get(self, "asset_types")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        A condition which determines whether an asset update should be published. If specified, an asset will be returned only when the expression evaluates to true. When set, `expression` field in the `Expr` must be a valid [CEL expression] (https://github.com/google/cel-spec) on a TemporalAsset with name `temporal_asset`. Example: a Feed with expression ("temporal_asset.deleted == true") will only publish Asset deletions. Other fields of `Expr` are optional. See our [user guide](https://cloud.google.com/asset-inventory/docs/monitoring-asset-changes-with-condition) for detailed instructions.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Asset content type. If not specified, no content but the asset name and type will be returned.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="feedOutputConfig")
    def feed_output_config(self) -> 'outputs.FeedOutputConfigResponse':
        """
        Feed output configuration defining where the asset updates are published to.
        """
        return pulumi.get(self, "feed_output_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The format will be projects/{project_number}/feeds/{client-assigned_feed_identifier} or folders/{folder_number}/feeds/{client-assigned_feed_identifier} or organizations/{organization_number}/feeds/{client-assigned_feed_identifier} The client-assigned feed identifier must be unique within the parent project/folder/organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="relationshipTypes")
    def relationship_types(self) -> Sequence[str]:
        """
        A list of relationship types to output, for example: `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if content_type=RELATIONSHIP. * If specified: it outputs specified relationship updates on the [asset_names] or the [asset_types]. It returns an error if any of the [relationship_types] doesn't belong to the supported relationship types of the [asset_names] or [asset_types], or any of the [asset_names] or the [asset_types] doesn't belong to the source types of the [relationship_types]. * Otherwise: it outputs the supported relationships of the types of [asset_names] and [asset_types] or returns an error if any of the [asset_names] or the [asset_types] has no replationship support. See [Introduction to Cloud Asset Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all supported asset types and relationship types.
        """
        return pulumi.get(self, "relationship_types")


class AwaitableGetFeedResult(GetFeedResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeedResult(
            asset_names=self.asset_names,
            asset_types=self.asset_types,
            condition=self.condition,
            content_type=self.content_type,
            feed_output_config=self.feed_output_config,
            name=self.name,
            relationship_types=self.relationship_types)


def get_feed(feed_id: Optional[str] = None,
             v1_id: Optional[str] = None,
             v1_id1: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeedResult:
    """
    Gets details about an asset feed.
    """
    __args__ = dict()
    __args__['feedId'] = feed_id
    __args__['v1Id'] = v1_id
    __args__['v1Id1'] = v1_id1
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudasset/v1:getFeed', __args__, opts=opts, typ=GetFeedResult).value

    return AwaitableGetFeedResult(
        asset_names=__ret__.asset_names,
        asset_types=__ret__.asset_types,
        condition=__ret__.condition,
        content_type=__ret__.content_type,
        feed_output_config=__ret__.feed_output_config,
        name=__ret__.name,
        relationship_types=__ret__.relationship_types)


@_utilities.lift_output_func(get_feed)
def get_feed_output(feed_id: Optional[pulumi.Input[str]] = None,
                    v1_id: Optional[pulumi.Input[str]] = None,
                    v1_id1: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFeedResult]:
    """
    Gets details about an asset feed.
    """
    ...
