# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTransferConfigResult',
    'AwaitableGetTransferConfigResult',
    'get_transfer_config',
    'get_transfer_config_output',
]

@pulumi.output_type
class GetTransferConfigResult:
    def __init__(__self__, data_refresh_window_days=None, data_source_id=None, dataset_region=None, destination_dataset_id=None, disabled=None, display_name=None, email_preferences=None, name=None, next_run_time=None, notification_pubsub_topic=None, owner_info=None, params=None, schedule=None, schedule_options=None, state=None, update_time=None, user_id=None):
        if data_refresh_window_days and not isinstance(data_refresh_window_days, int):
            raise TypeError("Expected argument 'data_refresh_window_days' to be a int")
        pulumi.set(__self__, "data_refresh_window_days", data_refresh_window_days)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if dataset_region and not isinstance(dataset_region, str):
            raise TypeError("Expected argument 'dataset_region' to be a str")
        pulumi.set(__self__, "dataset_region", dataset_region)
        if destination_dataset_id and not isinstance(destination_dataset_id, str):
            raise TypeError("Expected argument 'destination_dataset_id' to be a str")
        pulumi.set(__self__, "destination_dataset_id", destination_dataset_id)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if email_preferences and not isinstance(email_preferences, dict):
            raise TypeError("Expected argument 'email_preferences' to be a dict")
        pulumi.set(__self__, "email_preferences", email_preferences)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if next_run_time and not isinstance(next_run_time, str):
            raise TypeError("Expected argument 'next_run_time' to be a str")
        pulumi.set(__self__, "next_run_time", next_run_time)
        if notification_pubsub_topic and not isinstance(notification_pubsub_topic, str):
            raise TypeError("Expected argument 'notification_pubsub_topic' to be a str")
        pulumi.set(__self__, "notification_pubsub_topic", notification_pubsub_topic)
        if owner_info and not isinstance(owner_info, dict):
            raise TypeError("Expected argument 'owner_info' to be a dict")
        pulumi.set(__self__, "owner_info", owner_info)
        if params and not isinstance(params, dict):
            raise TypeError("Expected argument 'params' to be a dict")
        pulumi.set(__self__, "params", params)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if schedule_options and not isinstance(schedule_options, dict):
            raise TypeError("Expected argument 'schedule_options' to be a dict")
        pulumi.set(__self__, "schedule_options", schedule_options)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        if user_id is not None:
            warnings.warn("""Deprecated. Unique ID of the user on whose behalf transfer is done.""", DeprecationWarning)
            pulumi.log.warn("""user_id is deprecated: Deprecated. Unique ID of the user on whose behalf transfer is done.""")

        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="dataRefreshWindowDays")
    def data_refresh_window_days(self) -> int:
        """
        The number of days to look back to automatically refresh the data. For example, if `data_refresh_window_days = 10`, then every day BigQuery reingests data for [today-10, today-1], rather than ingesting data for just [today-1]. Only valid if the data source supports the feature. Set the value to 0 to use the default value.
        """
        return pulumi.get(self, "data_refresh_window_days")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> str:
        """
        Data source id. Cannot be changed once data transfer is created.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="datasetRegion")
    def dataset_region(self) -> str:
        """
        Region in which BigQuery dataset is located.
        """
        return pulumi.get(self, "dataset_region")

    @property
    @pulumi.getter(name="destinationDatasetId")
    def destination_dataset_id(self) -> str:
        """
        The BigQuery target dataset id.
        """
        return pulumi.get(self, "destination_dataset_id")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Is this config disabled. When set to true, no runs are scheduled for a given transfer.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User specified display name for the data transfer.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emailPreferences")
    def email_preferences(self) -> 'outputs.EmailPreferencesResponse':
        """
        Email notifications will be sent according to these preferences to the email address of the user who owns this transfer config.
        """
        return pulumi.get(self, "email_preferences")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the transfer config. Transfer config names have the form `projects/{project_id}/locations/{region}/transferConfigs/{config_id}`. Where `config_id` is usually a uuid, even though it is not guaranteed or required. The name is ignored when creating a transfer config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextRunTime")
    def next_run_time(self) -> str:
        """
        Next time when data transfer will run.
        """
        return pulumi.get(self, "next_run_time")

    @property
    @pulumi.getter(name="notificationPubsubTopic")
    def notification_pubsub_topic(self) -> str:
        """
        Pub/Sub topic where notifications will be sent after transfer runs associated with this transfer config finish. The format for specifying a pubsub topic is: `projects/{project}/topics/{topic}`
        """
        return pulumi.get(self, "notification_pubsub_topic")

    @property
    @pulumi.getter(name="ownerInfo")
    def owner_info(self) -> 'outputs.UserInfoResponse':
        """
        Information about the user whose credentials are used to transfer data. Populated only for `transferConfigs.get` requests. In case the user information is not available, this field will not be populated.
        """
        return pulumi.get(self, "owner_info")

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, str]:
        """
        Parameters specific to each data source. For more information see the bq tab in the 'Setting up a data transfer' section for each data source. For example the parameters for Cloud Storage transfers are listed here: https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Data transfer schedule. If the data source does not support a custom schedule, this should be empty. If it is empty, the default value for the data source will be used. The specified times are in UTC. Examples of valid format: `1st,3rd monday of month 15:30`, `every wed,fri of jan,jun 13:15`, and `first sunday of quarter 00:00`. See more explanation about the format here: https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format NOTE: The minimum interval time between recurring transfers depends on the data source; refer to the documentation for your data source.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="scheduleOptions")
    def schedule_options(self) -> 'outputs.ScheduleOptionsResponse':
        """
        Options customizing the data transfer schedule.
        """
        return pulumi.get(self, "schedule_options")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the most recently updated transfer run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Data transfer modification time. Ignored by server on input.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Deprecated. Unique ID of the user on whose behalf transfer is done.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetTransferConfigResult(GetTransferConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransferConfigResult(
            data_refresh_window_days=self.data_refresh_window_days,
            data_source_id=self.data_source_id,
            dataset_region=self.dataset_region,
            destination_dataset_id=self.destination_dataset_id,
            disabled=self.disabled,
            display_name=self.display_name,
            email_preferences=self.email_preferences,
            name=self.name,
            next_run_time=self.next_run_time,
            notification_pubsub_topic=self.notification_pubsub_topic,
            owner_info=self.owner_info,
            params=self.params,
            schedule=self.schedule,
            schedule_options=self.schedule_options,
            state=self.state,
            update_time=self.update_time,
            user_id=self.user_id)


def get_transfer_config(location: Optional[str] = None,
                        project: Optional[str] = None,
                        transfer_config_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransferConfigResult:
    """
    Returns information about a data transfer config.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['transferConfigId'] = transfer_config_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:bigquerydatatransfer/v1:getTransferConfig', __args__, opts=opts, typ=GetTransferConfigResult).value

    return AwaitableGetTransferConfigResult(
        data_refresh_window_days=__ret__.data_refresh_window_days,
        data_source_id=__ret__.data_source_id,
        dataset_region=__ret__.dataset_region,
        destination_dataset_id=__ret__.destination_dataset_id,
        disabled=__ret__.disabled,
        display_name=__ret__.display_name,
        email_preferences=__ret__.email_preferences,
        name=__ret__.name,
        next_run_time=__ret__.next_run_time,
        notification_pubsub_topic=__ret__.notification_pubsub_topic,
        owner_info=__ret__.owner_info,
        params=__ret__.params,
        schedule=__ret__.schedule,
        schedule_options=__ret__.schedule_options,
        state=__ret__.state,
        update_time=__ret__.update_time,
        user_id=__ret__.user_id)


@_utilities.lift_output_func(get_transfer_config)
def get_transfer_config_output(location: Optional[pulumi.Input[str]] = None,
                               project: Optional[pulumi.Input[Optional[str]]] = None,
                               transfer_config_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransferConfigResult]:
    """
    Returns information about a data transfer config.
    """
    ...
