# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ArgumentArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'AvroOptionsArgs',
    'BigtableColumnFamilyArgs',
    'BigtableColumnArgs',
    'BigtableOptionsArgs',
    'BindingArgs',
    'BqmlIterationResultArgs',
    'BqmlTrainingRunTrainingOptionsArgs',
    'BqmlTrainingRunArgs',
    'ClusteringArgs',
    'ConnectionPropertyArgs',
    'CsvOptionsArgs',
    'DatasetAccessEntryArgs',
    'DatasetAccessItemArgs',
    'DatasetReferenceArgs',
    'DatasetTagsItemArgs',
    'DestinationTablePropertiesArgs',
    'EncryptionConfigurationArgs',
    'ExprArgs',
    'ExternalDataConfigurationArgs',
    'GoogleSheetsOptionsArgs',
    'HivePartitioningOptionsArgs',
    'JobConfigurationExtractArgs',
    'JobConfigurationLoadArgs',
    'JobConfigurationQueryArgs',
    'JobConfigurationTableCopyArgs',
    'JobConfigurationArgs',
    'JobReferenceArgs',
    'MaterializedViewDefinitionArgs',
    'ModelDefinitionModelOptionsArgs',
    'ModelDefinitionArgs',
    'ModelReferenceArgs',
    'ParquetOptionsArgs',
    'QueryParameterTypeStructTypesItemArgs',
    'QueryParameterTypeArgs',
    'QueryParameterValueArgs',
    'QueryParameterArgs',
    'RangePartitioningRangeArgs',
    'RangePartitioningArgs',
    'RemoteFunctionOptionsArgs',
    'RoutineReferenceArgs',
    'StandardSqlDataTypeArgs',
    'StandardSqlFieldArgs',
    'StandardSqlStructTypeArgs',
    'StandardSqlTableTypeArgs',
    'TableFieldSchemaCategoriesArgs',
    'TableFieldSchemaPolicyTagsArgs',
    'TableFieldSchemaArgs',
    'TableReferenceArgs',
    'TableSchemaArgs',
    'TimePartitioningArgs',
    'UserDefinedFunctionResourceArgs',
    'ViewDefinitionArgs',
]

@pulumi.input_type
class ArgumentArgs:
    def __init__(__self__, *,
                 argument_kind: Optional[pulumi.Input['ArgumentArgumentKind']] = None,
                 data_type: Optional[pulumi.Input['StandardSqlDataTypeArgs']] = None,
                 mode: Optional[pulumi.Input['ArgumentMode']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input/output argument of a function or a stored procedure.
        :param pulumi.Input['ArgumentArgumentKind'] argument_kind: Optional. Defaults to FIXED_TYPE.
        :param pulumi.Input['StandardSqlDataTypeArgs'] data_type: Required unless argument_kind = ANY_TYPE.
        :param pulumi.Input['ArgumentMode'] mode: Optional. Specifies whether the argument is input or output. Can be set for procedures only.
        :param pulumi.Input[str] name: Optional. The name of this argument. Can be absent for function return argument.
        """
        if argument_kind is not None:
            pulumi.set(__self__, "argument_kind", argument_kind)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="argumentKind")
    def argument_kind(self) -> Optional[pulumi.Input['ArgumentArgumentKind']]:
        """
        Optional. Defaults to FIXED_TYPE.
        """
        return pulumi.get(self, "argument_kind")

    @argument_kind.setter
    def argument_kind(self, value: Optional[pulumi.Input['ArgumentArgumentKind']]):
        pulumi.set(self, "argument_kind", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input['StandardSqlDataTypeArgs']]:
        """
        Required unless argument_kind = ANY_TYPE.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input['StandardSqlDataTypeArgs']]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['ArgumentMode']]:
        """
        Optional. Specifies whether the argument is input or output. Can be set for procedures only.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['ArgumentMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of this argument. Can be absent for function return argument.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class AvroOptionsArgs:
    def __init__(__self__, *,
                 use_avro_logical_types: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] use_avro_logical_types: [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        if use_avro_logical_types is not None:
            pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        return pulumi.get(self, "use_avro_logical_types")

    @use_avro_logical_types.setter
    def use_avro_logical_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_avro_logical_types", value)


@pulumi.input_type
class BigtableColumnFamilyArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['BigtableColumnArgs']]]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 family_id: Optional[pulumi.Input[str]] = None,
                 only_read_latest: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['BigtableColumnArgs']]] columns: [Optional] Lists of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as .. Other columns can be accessed as a list through .Column field.
        :param pulumi.Input[str] encoding: [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
        :param pulumi.Input[str] family_id: Identifier of the column family.
        :param pulumi.Input[bool] only_read_latest: [Optional] If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
        :param pulumi.Input[str] type: [Optional] The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if family_id is not None:
            pulumi.set(__self__, "family_id", family_id)
        if only_read_latest is not None:
            pulumi.set(__self__, "only_read_latest", only_read_latest)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BigtableColumnArgs']]]]:
        """
        [Optional] Lists of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as .. Other columns can be accessed as a list through .Column field.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BigtableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="familyId")
    def family_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the column family.
        """
        return pulumi.get(self, "family_id")

    @family_id.setter
    def family_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family_id", value)

    @property
    @pulumi.getter(name="onlyReadLatest")
    def only_read_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
        """
        return pulumi.get(self, "only_read_latest")

    @only_read_latest.setter
    def only_read_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_read_latest", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class BigtableColumnArgs:
    def __init__(__self__, *,
                 encoding: Optional[pulumi.Input[str]] = None,
                 field_name: Optional[pulumi.Input[str]] = None,
                 only_read_latest: Optional[pulumi.Input[bool]] = None,
                 qualifier_encoded: Optional[pulumi.Input[str]] = None,
                 qualifier_string: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] encoding: [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
        :param pulumi.Input[str] field_name: [Optional] If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
        :param pulumi.Input[bool] only_read_latest: [Optional] If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
        :param pulumi.Input[str] qualifier_encoded: [Required] Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifier_string field. Otherwise, a base-64 encoded value must be set to qualifier_encoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as field_name.
        :param pulumi.Input[str] type: [Optional] The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
        """
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if only_read_latest is not None:
            pulumi.set(__self__, "only_read_latest", only_read_latest)
        if qualifier_encoded is not None:
            pulumi.set(__self__, "qualifier_encoded", qualifier_encoded)
        if qualifier_string is not None:
            pulumi.set(__self__, "qualifier_string", qualifier_string)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
        """
        return pulumi.get(self, "field_name")

    @field_name.setter
    def field_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_name", value)

    @property
    @pulumi.getter(name="onlyReadLatest")
    def only_read_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
        """
        return pulumi.get(self, "only_read_latest")

    @only_read_latest.setter
    def only_read_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_read_latest", value)

    @property
    @pulumi.getter(name="qualifierEncoded")
    def qualifier_encoded(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifier_string field. Otherwise, a base-64 encoded value must be set to qualifier_encoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as field_name.
        """
        return pulumi.get(self, "qualifier_encoded")

    @qualifier_encoded.setter
    def qualifier_encoded(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier_encoded", value)

    @property
    @pulumi.getter(name="qualifierString")
    def qualifier_string(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "qualifier_string")

    @qualifier_string.setter
    def qualifier_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier_string", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class BigtableOptionsArgs:
    def __init__(__self__, *,
                 column_families: Optional[pulumi.Input[Sequence[pulumi.Input['BigtableColumnFamilyArgs']]]] = None,
                 ignore_unspecified_column_families: Optional[pulumi.Input[bool]] = None,
                 read_rowkey_as_string: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['BigtableColumnFamilyArgs']]] column_families: [Optional] List of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.
        :param pulumi.Input[bool] ignore_unspecified_column_families: [Optional] If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
        :param pulumi.Input[bool] read_rowkey_as_string: [Optional] If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
        """
        if column_families is not None:
            pulumi.set(__self__, "column_families", column_families)
        if ignore_unspecified_column_families is not None:
            pulumi.set(__self__, "ignore_unspecified_column_families", ignore_unspecified_column_families)
        if read_rowkey_as_string is not None:
            pulumi.set(__self__, "read_rowkey_as_string", read_rowkey_as_string)

    @property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BigtableColumnFamilyArgs']]]]:
        """
        [Optional] List of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.
        """
        return pulumi.get(self, "column_families")

    @column_families.setter
    def column_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BigtableColumnFamilyArgs']]]]):
        pulumi.set(self, "column_families", value)

    @property
    @pulumi.getter(name="ignoreUnspecifiedColumnFamilies")
    def ignore_unspecified_column_families(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
        """
        return pulumi.get(self, "ignore_unspecified_column_families")

    @ignore_unspecified_column_families.setter
    def ignore_unspecified_column_families(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unspecified_column_families", value)

    @property
    @pulumi.getter(name="readRowkeyAsString")
    def read_rowkey_as_string(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
        """
        return pulumi.get(self, "read_rowkey_as_string")

    @read_rowkey_as_string.setter
    def read_rowkey_as_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_rowkey_as_string", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BqmlIterationResultArgs:
    def __init__(__self__, *,
                 duration_ms: Optional[pulumi.Input[str]] = None,
                 eval_loss: Optional[pulumi.Input[float]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 learn_rate: Optional[pulumi.Input[float]] = None,
                 training_loss: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] duration_ms: [Output-only, Beta] Time taken to run the training iteration in milliseconds.
        :param pulumi.Input[float] eval_loss: [Output-only, Beta] Eval loss computed on the eval data at the end of the iteration. The eval loss is used for early stopping to avoid overfitting. No eval loss if eval_split_method option is specified as no_split or auto_split with input data size less than 500 rows.
        :param pulumi.Input[int] index: [Output-only, Beta] Index of the ML training iteration, starting from zero for each training run.
        :param pulumi.Input[float] learn_rate: [Output-only, Beta] Learning rate used for this iteration, it varies for different training iterations if learn_rate_strategy option is not constant.
        :param pulumi.Input[float] training_loss: [Output-only, Beta] Training loss computed on the training data at the end of the iteration. The training loss function is defined by model type.
        """
        if duration_ms is not None:
            pulumi.set(__self__, "duration_ms", duration_ms)
        if eval_loss is not None:
            pulumi.set(__self__, "eval_loss", eval_loss)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if learn_rate is not None:
            pulumi.set(__self__, "learn_rate", learn_rate)
        if training_loss is not None:
            pulumi.set(__self__, "training_loss", training_loss)

    @property
    @pulumi.getter(name="durationMs")
    def duration_ms(self) -> Optional[pulumi.Input[str]]:
        """
        [Output-only, Beta] Time taken to run the training iteration in milliseconds.
        """
        return pulumi.get(self, "duration_ms")

    @duration_ms.setter
    def duration_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration_ms", value)

    @property
    @pulumi.getter(name="evalLoss")
    def eval_loss(self) -> Optional[pulumi.Input[float]]:
        """
        [Output-only, Beta] Eval loss computed on the eval data at the end of the iteration. The eval loss is used for early stopping to avoid overfitting. No eval loss if eval_split_method option is specified as no_split or auto_split with input data size less than 500 rows.
        """
        return pulumi.get(self, "eval_loss")

    @eval_loss.setter
    def eval_loss(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "eval_loss", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        [Output-only, Beta] Index of the ML training iteration, starting from zero for each training run.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="learnRate")
    def learn_rate(self) -> Optional[pulumi.Input[float]]:
        """
        [Output-only, Beta] Learning rate used for this iteration, it varies for different training iterations if learn_rate_strategy option is not constant.
        """
        return pulumi.get(self, "learn_rate")

    @learn_rate.setter
    def learn_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "learn_rate", value)

    @property
    @pulumi.getter(name="trainingLoss")
    def training_loss(self) -> Optional[pulumi.Input[float]]:
        """
        [Output-only, Beta] Training loss computed on the training data at the end of the iteration. The training loss function is defined by model type.
        """
        return pulumi.get(self, "training_loss")

    @training_loss.setter
    def training_loss(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "training_loss", value)


@pulumi.input_type
class BqmlTrainingRunTrainingOptionsArgs:
    def __init__(__self__, *,
                 early_stop: Optional[pulumi.Input[bool]] = None,
                 l1_reg: Optional[pulumi.Input[float]] = None,
                 l2_reg: Optional[pulumi.Input[float]] = None,
                 learn_rate: Optional[pulumi.Input[float]] = None,
                 learn_rate_strategy: Optional[pulumi.Input[str]] = None,
                 line_search_init_learn_rate: Optional[pulumi.Input[float]] = None,
                 max_iteration: Optional[pulumi.Input[str]] = None,
                 min_rel_progress: Optional[pulumi.Input[float]] = None,
                 warm_start: Optional[pulumi.Input[bool]] = None):
        """
        [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
        """
        if early_stop is not None:
            pulumi.set(__self__, "early_stop", early_stop)
        if l1_reg is not None:
            pulumi.set(__self__, "l1_reg", l1_reg)
        if l2_reg is not None:
            pulumi.set(__self__, "l2_reg", l2_reg)
        if learn_rate is not None:
            pulumi.set(__self__, "learn_rate", learn_rate)
        if learn_rate_strategy is not None:
            pulumi.set(__self__, "learn_rate_strategy", learn_rate_strategy)
        if line_search_init_learn_rate is not None:
            pulumi.set(__self__, "line_search_init_learn_rate", line_search_init_learn_rate)
        if max_iteration is not None:
            pulumi.set(__self__, "max_iteration", max_iteration)
        if min_rel_progress is not None:
            pulumi.set(__self__, "min_rel_progress", min_rel_progress)
        if warm_start is not None:
            pulumi.set(__self__, "warm_start", warm_start)

    @property
    @pulumi.getter(name="earlyStop")
    def early_stop(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "early_stop")

    @early_stop.setter
    def early_stop(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "early_stop", value)

    @property
    @pulumi.getter(name="l1Reg")
    def l1_reg(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "l1_reg")

    @l1_reg.setter
    def l1_reg(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "l1_reg", value)

    @property
    @pulumi.getter(name="l2Reg")
    def l2_reg(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "l2_reg")

    @l2_reg.setter
    def l2_reg(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "l2_reg", value)

    @property
    @pulumi.getter(name="learnRate")
    def learn_rate(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "learn_rate")

    @learn_rate.setter
    def learn_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "learn_rate", value)

    @property
    @pulumi.getter(name="learnRateStrategy")
    def learn_rate_strategy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "learn_rate_strategy")

    @learn_rate_strategy.setter
    def learn_rate_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learn_rate_strategy", value)

    @property
    @pulumi.getter(name="lineSearchInitLearnRate")
    def line_search_init_learn_rate(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "line_search_init_learn_rate")

    @line_search_init_learn_rate.setter
    def line_search_init_learn_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "line_search_init_learn_rate", value)

    @property
    @pulumi.getter(name="maxIteration")
    def max_iteration(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "max_iteration")

    @max_iteration.setter
    def max_iteration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_iteration", value)

    @property
    @pulumi.getter(name="minRelProgress")
    def min_rel_progress(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "min_rel_progress")

    @min_rel_progress.setter
    def min_rel_progress(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_rel_progress", value)

    @property
    @pulumi.getter(name="warmStart")
    def warm_start(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "warm_start")

    @warm_start.setter
    def warm_start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "warm_start", value)


@pulumi.input_type
class BqmlTrainingRunArgs:
    def __init__(__self__, *,
                 iteration_results: Optional[pulumi.Input[Sequence[pulumi.Input['BqmlIterationResultArgs']]]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 training_options: Optional[pulumi.Input['BqmlTrainingRunTrainingOptionsArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['BqmlIterationResultArgs']]] iteration_results: [Output-only, Beta] List of each iteration results.
        :param pulumi.Input[str] start_time: [Output-only, Beta] Training run start time in milliseconds since the epoch.
        :param pulumi.Input[str] state: [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run successfully completed. CANCELLED: Training run cancelled by the user.
        :param pulumi.Input['BqmlTrainingRunTrainingOptionsArgs'] training_options: [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
        """
        if iteration_results is not None:
            pulumi.set(__self__, "iteration_results", iteration_results)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if training_options is not None:
            pulumi.set(__self__, "training_options", training_options)

    @property
    @pulumi.getter(name="iterationResults")
    def iteration_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BqmlIterationResultArgs']]]]:
        """
        [Output-only, Beta] List of each iteration results.
        """
        return pulumi.get(self, "iteration_results")

    @iteration_results.setter
    def iteration_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BqmlIterationResultArgs']]]]):
        pulumi.set(self, "iteration_results", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        [Output-only, Beta] Training run start time in milliseconds since the epoch.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run successfully completed. CANCELLED: Training run cancelled by the user.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="trainingOptions")
    def training_options(self) -> Optional[pulumi.Input['BqmlTrainingRunTrainingOptionsArgs']]:
        """
        [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
        """
        return pulumi.get(self, "training_options")

    @training_options.setter
    def training_options(self, value: Optional[pulumi.Input['BqmlTrainingRunTrainingOptionsArgs']]):
        pulumi.set(self, "training_options", value)


@pulumi.input_type
class ClusteringArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fields: [Repeated] One or more fields on which data should be clustered. Only top-level, non-repeated, simple-type fields are supported. When you cluster a table using multiple columns, the order of columns you specify is important. The order of the specified columns determines the sort order of the data.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Repeated] One or more fields on which data should be clustered. Only top-level, non-repeated, simple-type fields are supported. When you cluster a table using multiple columns, the order of columns you specify is important. The order of the specified columns determines the sort order of the data.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)


@pulumi.input_type
class ConnectionPropertyArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: [Required] Name of the connection property to set.
        :param pulumi.Input[str] value: [Required] Value of the connection property.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] Name of the connection property to set.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] Value of the connection property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CsvOptionsArgs:
    def __init__(__self__, *,
                 allow_jagged_rows: Optional[pulumi.Input[bool]] = None,
                 allow_quoted_newlines: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 null_marker: Optional[pulumi.Input[str]] = None,
                 quote: Optional[pulumi.Input[str]] = None,
                 skip_leading_rows: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_jagged_rows: [Optional] Indicates if BigQuery should accept rows that are missing trailing optional columns. If true, BigQuery treats missing trailing columns as null values. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
        :param pulumi.Input[bool] allow_quoted_newlines: [Optional] Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        :param pulumi.Input[str] encoding: [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        :param pulumi.Input[str] field_delimiter: [Optional] The separator for fields in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        :param pulumi.Input[str] null_marker: [Optional] An custom string that will represent a NULL value in CSV import data.
        :param pulumi.Input[str] quote: [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param pulumi.Input[str] skip_leading_rows: [Optional] The number of rows at the top of a CSV file that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        if allow_jagged_rows is not None:
            pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        if allow_quoted_newlines is not None:
            pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if null_marker is not None:
            pulumi.set(__self__, "null_marker", null_marker)
        if quote is not None:
            pulumi.set(__self__, "quote", quote)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates if BigQuery should accept rows that are missing trailing optional columns. If true, BigQuery treats missing trailing columns as null values. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @allow_jagged_rows.setter
    def allow_jagged_rows(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_jagged_rows", value)

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @allow_quoted_newlines.setter
    def allow_quoted_newlines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_quoted_newlines", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The separator for fields in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="nullMarker")
    def null_marker(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] An custom string that will represent a NULL value in CSV import data.
        """
        return pulumi.get(self, "null_marker")

    @null_marker.setter
    def null_marker(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_marker", value)

    @property
    @pulumi.getter
    def quote(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return pulumi.get(self, "quote")

    @quote.setter
    def quote(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote", value)

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The number of rows at the top of a CSV file that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return pulumi.get(self, "skip_leading_rows")

    @skip_leading_rows.setter
    def skip_leading_rows(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_leading_rows", value)


@pulumi.input_type
class DatasetAccessEntryArgs:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input['DatasetReferenceArgs']] = None,
                 target_types: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessEntryTargetTypesItem']]]] = None):
        """
        :param pulumi.Input['DatasetReferenceArgs'] dataset: [Required] The dataset this entry applies to.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if target_types is not None:
            pulumi.set(__self__, "target_types", target_types)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input['DatasetReferenceArgs']]:
        """
        [Required] The dataset this entry applies to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input['DatasetReferenceArgs']]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="targetTypes")
    def target_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessEntryTargetTypesItem']]]]:
        return pulumi.get(self, "target_types")

    @target_types.setter
    def target_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAccessEntryTargetTypesItem']]]]):
        pulumi.set(self, "target_types", value)


@pulumi.input_type
class DatasetAccessItemArgs:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input['DatasetAccessEntryArgs']] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 group_by_email: Optional[pulumi.Input[str]] = None,
                 iam_member: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 routine: Optional[pulumi.Input['RoutineReferenceArgs']] = None,
                 special_group: Optional[pulumi.Input[str]] = None,
                 user_by_email: Optional[pulumi.Input[str]] = None,
                 view: Optional[pulumi.Input['TableReferenceArgs']] = None):
        """
        :param pulumi.Input['DatasetAccessEntryArgs'] dataset: [Pick one] A grant authorizing all resources of a particular type in a particular dataset access to this dataset. Only views are supported for now. The role field is not required when this field is set. If that dataset is deleted and re-created, its access needs to be granted again via an update operation.
        :param pulumi.Input[str] domain: [Pick one] A domain to grant access to. Any users signed in with the domain specified will be granted the specified access. Example: "example.com". Maps to IAM policy member "domain:DOMAIN".
        :param pulumi.Input[str] group_by_email: [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member "group:GROUP".
        :param pulumi.Input[str] iam_member: [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
        :param pulumi.Input[str] role: [Required] An IAM role ID that should be granted to the user, group, or domain specified in this access entry. The following legacy mappings will be applied: OWNER  roles/bigquery.dataOwner WRITER  roles/bigquery.dataEditor READER  roles/bigquery.dataViewer This field will accept any of the above formats, but will return only the legacy format. For example, if you set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
        :param pulumi.Input['RoutineReferenceArgs'] routine: [Pick one] A routine from a different dataset to grant access to. Queries executed against that routine will have read access to views/tables/routines in this dataset. Only UDF is supported for now. The role field is not required when this field is set. If that routine is updated by any user, access to the routine needs to be granted again via an update operation.
        :param pulumi.Input[str] special_group: [Pick one] A special group to grant access to. Possible values include: projectOwners: Owners of the enclosing project. projectReaders: Readers of the enclosing project. projectWriters: Writers of the enclosing project. allAuthenticatedUsers: All authenticated BigQuery users. Maps to similarly-named IAM members.
        :param pulumi.Input[str] user_by_email: [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
        :param pulumi.Input['TableReferenceArgs'] view: [Pick one] A view from a different dataset to grant access to. Queries executed against that view will have read access to tables in this dataset. The role field is not required when this field is set. If that view is updated by any user, access to the view needs to be granted again via an update operation.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if group_by_email is not None:
            pulumi.set(__self__, "group_by_email", group_by_email)
        if iam_member is not None:
            pulumi.set(__self__, "iam_member", iam_member)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if routine is not None:
            pulumi.set(__self__, "routine", routine)
        if special_group is not None:
            pulumi.set(__self__, "special_group", special_group)
        if user_by_email is not None:
            pulumi.set(__self__, "user_by_email", user_by_email)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input['DatasetAccessEntryArgs']]:
        """
        [Pick one] A grant authorizing all resources of a particular type in a particular dataset access to this dataset. Only views are supported for now. The role field is not required when this field is set. If that dataset is deleted and re-created, its access needs to be granted again via an update operation.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input['DatasetAccessEntryArgs']]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] A domain to grant access to. Any users signed in with the domain specified will be granted the specified access. Example: "example.com". Maps to IAM policy member "domain:DOMAIN".
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member "group:GROUP".
        """
        return pulumi.get(self, "group_by_email")

    @group_by_email.setter
    def group_by_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_by_email", value)

    @property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
        """
        return pulumi.get(self, "iam_member")

    @iam_member.setter
    def iam_member(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_member", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] An IAM role ID that should be granted to the user, group, or domain specified in this access entry. The following legacy mappings will be applied: OWNER  roles/bigquery.dataOwner WRITER  roles/bigquery.dataEditor READER  roles/bigquery.dataViewer This field will accept any of the above formats, but will return only the legacy format. For example, if you set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def routine(self) -> Optional[pulumi.Input['RoutineReferenceArgs']]:
        """
        [Pick one] A routine from a different dataset to grant access to. Queries executed against that routine will have read access to views/tables/routines in this dataset. Only UDF is supported for now. The role field is not required when this field is set. If that routine is updated by any user, access to the routine needs to be granted again via an update operation.
        """
        return pulumi.get(self, "routine")

    @routine.setter
    def routine(self, value: Optional[pulumi.Input['RoutineReferenceArgs']]):
        pulumi.set(self, "routine", value)

    @property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] A special group to grant access to. Possible values include: projectOwners: Owners of the enclosing project. projectReaders: Readers of the enclosing project. projectWriters: Writers of the enclosing project. allAuthenticatedUsers: All authenticated BigQuery users. Maps to similarly-named IAM members.
        """
        return pulumi.get(self, "special_group")

    @special_group.setter
    def special_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "special_group", value)

    @property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
        """
        return pulumi.get(self, "user_by_email")

    @user_by_email.setter
    def user_by_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_by_email", value)

    @property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['TableReferenceArgs']]:
        """
        [Pick one] A view from a different dataset to grant access to. Queries executed against that view will have read access to tables in this dataset. The role field is not required when this field is set. If that view is updated by any user, access to the view needs to be granted again via an update operation.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['TableReferenceArgs']]):
        pulumi.set(self, "view", value)


@pulumi.input_type
class DatasetReferenceArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_id: [Required] A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param pulumi.Input[str] project: [Optional] The ID of the project containing this dataset.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The ID of the project containing this dataset.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class DatasetTagsItemArgs:
    def __init__(__self__, *,
                 tag_key: Optional[pulumi.Input[str]] = None,
                 tag_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] tag_key: [Required] The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is org id.
        :param pulumi.Input[str] tag_value: [Required] Friendly short name of the tag value, e.g. "production".
        """
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is org id.
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_key", value)

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] Friendly short name of the tag value, e.g. "production".
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_value", value)


@pulumi.input_type
class DestinationTablePropertiesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] description: [Optional] The description for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current description is provided, the job will fail.
        :param pulumi.Input[str] expiration_time: [Internal] This field is for Google internal use only.
        :param pulumi.Input[str] friendly_name: [Optional] The friendly name for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current friendly name is provided, the job will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: [Optional] The labels associated with this table. You can use these to organize and group your tables. This will only be used if the destination table is newly created. If the table already exists and labels are different than the current labels are provided, the job will fail.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The description for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current description is provided, the job will fail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        [Internal] This field is for Google internal use only.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The friendly name for the destination table. This will only be used if the destination table is newly created. If the table already exists and a value different than the current friendly name is provided, the job will fail.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        [Optional] The labels associated with this table. You can use these to organize and group your tables. This will only be used if the destination table is newly created. If the table already exists and labels are different than the current labels are provided, the job will fail.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class EncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: [Optional] Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ExternalDataConfigurationArgs:
    def __init__(__self__, *,
                 autodetect: Optional[pulumi.Input[bool]] = None,
                 avro_options: Optional[pulumi.Input['AvroOptionsArgs']] = None,
                 bigtable_options: Optional[pulumi.Input['BigtableOptionsArgs']] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 csv_options: Optional[pulumi.Input['CsvOptionsArgs']] = None,
                 decimal_target_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 google_sheets_options: Optional[pulumi.Input['GoogleSheetsOptionsArgs']] = None,
                 hive_partitioning_options: Optional[pulumi.Input['HivePartitioningOptionsArgs']] = None,
                 ignore_unknown_values: Optional[pulumi.Input[bool]] = None,
                 max_bad_records: Optional[pulumi.Input[int]] = None,
                 parquet_options: Optional[pulumi.Input['ParquetOptionsArgs']] = None,
                 schema: Optional[pulumi.Input['TableSchemaArgs']] = None,
                 source_format: Optional[pulumi.Input[str]] = None,
                 source_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] autodetect: Try to detect schema and format options automatically. Any option specified explicitly will be honored.
        :param pulumi.Input['AvroOptionsArgs'] avro_options: Additional properties to set if sourceFormat is set to Avro.
        :param pulumi.Input['BigtableOptionsArgs'] bigtable_options: [Optional] Additional options if sourceFormat is set to BIGTABLE.
        :param pulumi.Input[str] compression: [Optional] The compression type of the data source. Possible values include GZIP and NONE. The default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        :param pulumi.Input[str] connection_id: [Optional, Trusted Tester] Connection for external data source.
        :param pulumi.Input['CsvOptionsArgs'] csv_options: Additional properties to set if sourceFormat is set to CSV.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] decimal_target_types: [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        :param pulumi.Input['GoogleSheetsOptionsArgs'] google_sheets_options: [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
        :param pulumi.Input['HivePartitioningOptionsArgs'] hive_partitioning_options: [Optional] Options to configure hive partitioning support.
        :param pulumi.Input[bool] ignore_unknown_values: [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is ignored. Avro: This setting is ignored.
        :param pulumi.Input[int] max_bad_records: [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV, JSON, and Google Sheets. The default value is 0, which requires that all records are valid. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        :param pulumi.Input['ParquetOptionsArgs'] parquet_options: Additional properties to set if sourceFormat is set to Parquet.
        :param pulumi.Input['TableSchemaArgs'] schema: [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
        :param pulumi.Input[str] source_format: [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_uris: [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        if autodetect is not None:
            pulumi.set(__self__, "autodetect", autodetect)
        if avro_options is not None:
            pulumi.set(__self__, "avro_options", avro_options)
        if bigtable_options is not None:
            pulumi.set(__self__, "bigtable_options", bigtable_options)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if decimal_target_types is not None:
            pulumi.set(__self__, "decimal_target_types", decimal_target_types)
        if google_sheets_options is not None:
            pulumi.set(__self__, "google_sheets_options", google_sheets_options)
        if hive_partitioning_options is not None:
            pulumi.set(__self__, "hive_partitioning_options", hive_partitioning_options)
        if ignore_unknown_values is not None:
            pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        if max_bad_records is not None:
            pulumi.set(__self__, "max_bad_records", max_bad_records)
        if parquet_options is not None:
            pulumi.set(__self__, "parquet_options", parquet_options)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if source_format is not None:
            pulumi.set(__self__, "source_format", source_format)
        if source_uris is not None:
            pulumi.set(__self__, "source_uris", source_uris)

    @property
    @pulumi.getter
    def autodetect(self) -> Optional[pulumi.Input[bool]]:
        """
        Try to detect schema and format options automatically. Any option specified explicitly will be honored.
        """
        return pulumi.get(self, "autodetect")

    @autodetect.setter
    def autodetect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autodetect", value)

    @property
    @pulumi.getter(name="avroOptions")
    def avro_options(self) -> Optional[pulumi.Input['AvroOptionsArgs']]:
        """
        Additional properties to set if sourceFormat is set to Avro.
        """
        return pulumi.get(self, "avro_options")

    @avro_options.setter
    def avro_options(self, value: Optional[pulumi.Input['AvroOptionsArgs']]):
        pulumi.set(self, "avro_options", value)

    @property
    @pulumi.getter(name="bigtableOptions")
    def bigtable_options(self) -> Optional[pulumi.Input['BigtableOptionsArgs']]:
        """
        [Optional] Additional options if sourceFormat is set to BIGTABLE.
        """
        return pulumi.get(self, "bigtable_options")

    @bigtable_options.setter
    def bigtable_options(self, value: Optional[pulumi.Input['BigtableOptionsArgs']]):
        pulumi.set(self, "bigtable_options", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The compression type of the data source. Possible values include GZIP and NONE. The default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional, Trusted Tester] Connection for external data source.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional[pulumi.Input['CsvOptionsArgs']]:
        """
        Additional properties to set if sourceFormat is set to CSV.
        """
        return pulumi.get(self, "csv_options")

    @csv_options.setter
    def csv_options(self, value: Optional[pulumi.Input['CsvOptionsArgs']]):
        pulumi.set(self, "csv_options", value)

    @property
    @pulumi.getter(name="decimalTargetTypes")
    def decimal_target_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        """
        return pulumi.get(self, "decimal_target_types")

    @decimal_target_types.setter
    def decimal_target_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "decimal_target_types", value)

    @property
    @pulumi.getter(name="googleSheetsOptions")
    def google_sheets_options(self) -> Optional[pulumi.Input['GoogleSheetsOptionsArgs']]:
        """
        [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
        """
        return pulumi.get(self, "google_sheets_options")

    @google_sheets_options.setter
    def google_sheets_options(self, value: Optional[pulumi.Input['GoogleSheetsOptionsArgs']]):
        pulumi.set(self, "google_sheets_options", value)

    @property
    @pulumi.getter(name="hivePartitioningOptions")
    def hive_partitioning_options(self) -> Optional[pulumi.Input['HivePartitioningOptionsArgs']]:
        """
        [Optional] Options to configure hive partitioning support.
        """
        return pulumi.get(self, "hive_partitioning_options")

    @hive_partitioning_options.setter
    def hive_partitioning_options(self, value: Optional[pulumi.Input['HivePartitioningOptionsArgs']]):
        pulumi.set(self, "hive_partitioning_options", value)

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is ignored. Avro: This setting is ignored.
        """
        return pulumi.get(self, "ignore_unknown_values")

    @ignore_unknown_values.setter
    def ignore_unknown_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unknown_values", value)

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> Optional[pulumi.Input[int]]:
        """
        [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV, JSON, and Google Sheets. The default value is 0, which requires that all records are valid. This setting is ignored for Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
        """
        return pulumi.get(self, "max_bad_records")

    @max_bad_records.setter
    def max_bad_records(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bad_records", value)

    @property
    @pulumi.getter(name="parquetOptions")
    def parquet_options(self) -> Optional[pulumi.Input['ParquetOptionsArgs']]:
        """
        Additional properties to set if sourceFormat is set to Parquet.
        """
        return pulumi.get(self, "parquet_options")

    @parquet_options.setter
    def parquet_options(self, value: Optional[pulumi.Input['ParquetOptionsArgs']]):
        pulumi.set(self, "parquet_options", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['TableSchemaArgs']]:
        """
        [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['TableSchemaArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
        """
        return pulumi.get(self, "source_format")

    @source_format.setter
    def source_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_format", value)

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        return pulumi.get(self, "source_uris")

    @source_uris.setter
    def source_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_uris", value)


@pulumi.input_type
class GoogleSheetsOptionsArgs:
    def __init__(__self__, *,
                 range: Optional[pulumi.Input[str]] = None,
                 skip_leading_rows: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] range: [Optional] Range of a sheet to query from. Only used when non-empty. Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id For example: sheet1!A1:B20
        :param pulumi.Input[str] skip_leading_rows: [Optional] The number of rows at the top of a sheet that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows that should be skipped. When autodetect is on, behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        if range is not None:
            pulumi.set(__self__, "range", range)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Range of a sheet to query from. Only used when non-empty. Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id For example: sheet1!A1:B20
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The number of rows at the top of a sheet that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows that should be skipped. When autodetect is on, behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return pulumi.get(self, "skip_leading_rows")

    @skip_leading_rows.setter
    def skip_leading_rows(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_leading_rows", value)


@pulumi.input_type
class HivePartitioningOptionsArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None,
                 require_partition_filter: Optional[pulumi.Input[bool]] = None,
                 source_uri_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mode: [Optional] When set, what mode of hive partitioning to use when reading data. The following modes are supported. (1) AUTO: automatically infer partition key name(s) and type(s). (2) STRINGS: automatically infer partition key name(s). All types are interpreted as strings. (3) CUSTOM: partition key schema is encoded in the source URI prefix. Not all storage formats support hive partitioning. Requesting hive partitioning on an unsupported format will lead to an error. Currently supported types include: AVRO, CSV, JSON, ORC and Parquet.
        :param pulumi.Input[bool] require_partition_filter: [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified. Note that this field should only be true when creating a permanent external table or querying a temporary external table. Hive-partitioned loads with requirePartitionFilter explicitly set to true will fail.
        :param pulumi.Input[str] source_uri_prefix: [Optional] When hive partition detection is requested, a common prefix for all source uris should be supplied. The prefix must end immediately before the partition key encoding begins. For example, consider files following this data layout. gs://bucket/path_to_table/dt=2019-01-01/country=BR/id=7/file.avro gs://bucket/path_to_table/dt=2018-12-31/country=CA/id=3/file.avro When hive partitioning is requested with either AUTO or STRINGS detection, the common prefix can be either of gs://bucket/path_to_table or gs://bucket/path_to_table/ (trailing slash does not matter).
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        if source_uri_prefix is not None:
            pulumi.set(__self__, "source_uri_prefix", source_uri_prefix)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] When set, what mode of hive partitioning to use when reading data. The following modes are supported. (1) AUTO: automatically infer partition key name(s) and type(s). (2) STRINGS: automatically infer partition key name(s). All types are interpreted as strings. (3) CUSTOM: partition key schema is encoded in the source URI prefix. Not all storage formats support hive partitioning. Requesting hive partitioning on an unsupported format will lead to an error. Currently supported types include: AVRO, CSV, JSON, ORC and Parquet.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified. Note that this field should only be true when creating a permanent external table or querying a temporary external table. Hive-partitioned loads with requirePartitionFilter explicitly set to true will fail.
        """
        return pulumi.get(self, "require_partition_filter")

    @require_partition_filter.setter
    def require_partition_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_partition_filter", value)

    @property
    @pulumi.getter(name="sourceUriPrefix")
    def source_uri_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] When hive partition detection is requested, a common prefix for all source uris should be supplied. The prefix must end immediately before the partition key encoding begins. For example, consider files following this data layout. gs://bucket/path_to_table/dt=2019-01-01/country=BR/id=7/file.avro gs://bucket/path_to_table/dt=2018-12-31/country=CA/id=3/file.avro When hive partitioning is requested with either AUTO or STRINGS detection, the common prefix can be either of gs://bucket/path_to_table or gs://bucket/path_to_table/ (trailing slash does not matter).
        """
        return pulumi.get(self, "source_uri_prefix")

    @source_uri_prefix.setter
    def source_uri_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_uri_prefix", value)


@pulumi.input_type
class JobConfigurationExtractArgs:
    def __init__(__self__, *,
                 compression: Optional[pulumi.Input[str]] = None,
                 destination_format: Optional[pulumi.Input[str]] = None,
                 destination_uri: Optional[pulumi.Input[str]] = None,
                 destination_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 print_header: Optional[pulumi.Input[bool]] = None,
                 source_model: Optional[pulumi.Input['ModelReferenceArgs']] = None,
                 source_table: Optional[pulumi.Input['TableReferenceArgs']] = None,
                 use_avro_logical_types: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] compression: [Optional] The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default value is NONE. DEFLATE and SNAPPY are only supported for Avro. Not applicable when extracting models.
        :param pulumi.Input[str] destination_format: [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON, PARQUET or AVRO for tables and ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV. The default value for models is ML_TF_SAVED_MODEL.
        :param pulumi.Input[str] destination_uri: [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The fully-qualified Google Cloud Storage URI where the extracted table should be written.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_uris: [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        :param pulumi.Input[str] field_delimiter: [Optional] Delimiter to use between fields in the exported data. Default is ','. Not applicable when extracting models.
        :param pulumi.Input[bool] print_header: [Optional] Whether to print out a header row in the results. Default is true. Not applicable when extracting models.
        :param pulumi.Input['ModelReferenceArgs'] source_model: A reference to the model being exported.
        :param pulumi.Input['TableReferenceArgs'] source_table: A reference to the table being exported.
        :param pulumi.Input[bool] use_avro_logical_types: [Optional] If destinationFormat is set to "AVRO", this flag indicates whether to enable extracting applicable column types (such as TIMESTAMP) to their corresponding AVRO logical types (timestamp-micros), instead of only using their raw types (avro-long). Not applicable when extracting models.
        """
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if destination_format is not None:
            pulumi.set(__self__, "destination_format", destination_format)
        if destination_uri is not None:
            pulumi.set(__self__, "destination_uri", destination_uri)
        if destination_uris is not None:
            pulumi.set(__self__, "destination_uris", destination_uris)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if print_header is not None:
            pulumi.set(__self__, "print_header", print_header)
        if source_model is not None:
            pulumi.set(__self__, "source_model", source_model)
        if source_table is not None:
            pulumi.set(__self__, "source_table", source_table)
        if use_avro_logical_types is not None:
            pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default value is NONE. DEFLATE and SNAPPY are only supported for Avro. Not applicable when extracting models.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="destinationFormat")
    def destination_format(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON, PARQUET or AVRO for tables and ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV. The default value for models is ML_TF_SAVED_MODEL.
        """
        return pulumi.get(self, "destination_format")

    @destination_format.setter
    def destination_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_format", value)

    @property
    @pulumi.getter(name="destinationUri")
    def destination_uri(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The fully-qualified Google Cloud Storage URI where the extracted table should be written.
        """
        return pulumi.get(self, "destination_uri")

    @destination_uri.setter
    def destination_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_uri", value)

    @property
    @pulumi.getter(name="destinationUris")
    def destination_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        """
        return pulumi.get(self, "destination_uris")

    @destination_uris.setter
    def destination_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_uris", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Delimiter to use between fields in the exported data. Default is ','. Not applicable when extracting models.
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="printHeader")
    def print_header(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Whether to print out a header row in the results. Default is true. Not applicable when extracting models.
        """
        return pulumi.get(self, "print_header")

    @print_header.setter
    def print_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "print_header", value)

    @property
    @pulumi.getter(name="sourceModel")
    def source_model(self) -> Optional[pulumi.Input['ModelReferenceArgs']]:
        """
        A reference to the model being exported.
        """
        return pulumi.get(self, "source_model")

    @source_model.setter
    def source_model(self, value: Optional[pulumi.Input['ModelReferenceArgs']]):
        pulumi.set(self, "source_model", value)

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> Optional[pulumi.Input['TableReferenceArgs']]:
        """
        A reference to the table being exported.
        """
        return pulumi.get(self, "source_table")

    @source_table.setter
    def source_table(self, value: Optional[pulumi.Input['TableReferenceArgs']]):
        pulumi.set(self, "source_table", value)

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If destinationFormat is set to "AVRO", this flag indicates whether to enable extracting applicable column types (such as TIMESTAMP) to their corresponding AVRO logical types (timestamp-micros), instead of only using their raw types (avro-long). Not applicable when extracting models.
        """
        return pulumi.get(self, "use_avro_logical_types")

    @use_avro_logical_types.setter
    def use_avro_logical_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_avro_logical_types", value)


@pulumi.input_type
class JobConfigurationLoadArgs:
    def __init__(__self__, *,
                 allow_jagged_rows: Optional[pulumi.Input[bool]] = None,
                 allow_quoted_newlines: Optional[pulumi.Input[bool]] = None,
                 autodetect: Optional[pulumi.Input[bool]] = None,
                 clustering: Optional[pulumi.Input['ClusteringArgs']] = None,
                 create_disposition: Optional[pulumi.Input[str]] = None,
                 decimal_target_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_encryption_configuration: Optional[pulumi.Input['EncryptionConfigurationArgs']] = None,
                 destination_table: Optional[pulumi.Input['TableReferenceArgs']] = None,
                 destination_table_properties: Optional[pulumi.Input['DestinationTablePropertiesArgs']] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 hive_partitioning_options: Optional[pulumi.Input['HivePartitioningOptionsArgs']] = None,
                 ignore_unknown_values: Optional[pulumi.Input[bool]] = None,
                 json_extension: Optional[pulumi.Input[str]] = None,
                 max_bad_records: Optional[pulumi.Input[int]] = None,
                 null_marker: Optional[pulumi.Input[str]] = None,
                 parquet_options: Optional[pulumi.Input['ParquetOptionsArgs']] = None,
                 preserve_ascii_control_characters: Optional[pulumi.Input[bool]] = None,
                 projection_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 quote: Optional[pulumi.Input[str]] = None,
                 range_partitioning: Optional[pulumi.Input['RangePartitioningArgs']] = None,
                 schema: Optional[pulumi.Input['TableSchemaArgs']] = None,
                 schema_inline: Optional[pulumi.Input[str]] = None,
                 schema_inline_format: Optional[pulumi.Input[str]] = None,
                 schema_update_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_leading_rows: Optional[pulumi.Input[int]] = None,
                 source_format: Optional[pulumi.Input[str]] = None,
                 source_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_partitioning: Optional[pulumi.Input['TimePartitioningArgs']] = None,
                 use_avro_logical_types: Optional[pulumi.Input[bool]] = None,
                 write_disposition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_jagged_rows: [Optional] Accept rows that are missing trailing optional columns. The missing values are treated as nulls. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        :param pulumi.Input[bool] allow_quoted_newlines: Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        :param pulumi.Input[bool] autodetect: [Optional] Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        :param pulumi.Input['ClusteringArgs'] clustering: [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        :param pulumi.Input[str] create_disposition: [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] decimal_target_types: [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        :param pulumi.Input['EncryptionConfigurationArgs'] destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys).
        :param pulumi.Input['TableReferenceArgs'] destination_table: [Required] The destination table to load the data into.
        :param pulumi.Input['DestinationTablePropertiesArgs'] destination_table_properties: [Beta] [Optional] Properties with which to create the destination table if it is new.
        :param pulumi.Input[str] encoding: [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        :param pulumi.Input[str] field_delimiter: [Optional] The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character. To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        :param pulumi.Input['HivePartitioningOptionsArgs'] hive_partitioning_options: [Optional] Options to configure hive partitioning support.
        :param pulumi.Input[bool] ignore_unknown_values: [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
        :param pulumi.Input[str] json_extension: [Optional] If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON. For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited GeoJSON: set to GEOJSON.
        :param pulumi.Input[int] max_bad_records: [Optional] The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV and JSON. The default value is 0, which requires that all records are valid.
        :param pulumi.Input[str] null_marker: [Optional] Specifies a string that represents a null value in a CSV file. For example, if you specify "\\N", BigQuery interprets "\\N" as a null value when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as an empty value.
        :param pulumi.Input['ParquetOptionsArgs'] parquet_options: [Optional] Options to configure parquet support.
        :param pulumi.Input[bool] preserve_ascii_control_characters: [Optional] Preserves the embedded ASCII control characters (the first 32 characters in the ASCII-table, from '\\x00' to '\\x1F') when loading from CSV. Only applicable to CSV, ignored for other formats.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] projection_fields: If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup. Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties. If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        :param pulumi.Input[str] quote: [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param pulumi.Input['RangePartitioningArgs'] range_partitioning: [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        :param pulumi.Input['TableSchemaArgs'] schema: [Optional] The schema for the destination table. The schema can be omitted if the destination table already exists, or if you're loading data from Google Cloud Datastore.
        :param pulumi.Input[str] schema_inline: [Deprecated] The inline schema. For CSV schemas, specify as "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER, baz:FLOAT".
        :param pulumi.Input[str] schema_inline_format: [Deprecated] The format of the schemaInline property.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param pulumi.Input[int] skip_leading_rows: [Optional] The number of rows at the top of a CSV file that BigQuery will skip when loading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        :param pulumi.Input[str] source_format: [Optional] The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default value is CSV.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_uris: [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        :param pulumi.Input['TimePartitioningArgs'] time_partitioning: Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        :param pulumi.Input[bool] use_avro_logical_types: [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        :param pulumi.Input[str] write_disposition: [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_APPEND. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        if allow_jagged_rows is not None:
            pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        if allow_quoted_newlines is not None:
            pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        if autodetect is not None:
            pulumi.set(__self__, "autodetect", autodetect)
        if clustering is not None:
            pulumi.set(__self__, "clustering", clustering)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if decimal_target_types is not None:
            pulumi.set(__self__, "decimal_target_types", decimal_target_types)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if destination_table_properties is not None:
            pulumi.set(__self__, "destination_table_properties", destination_table_properties)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if hive_partitioning_options is not None:
            pulumi.set(__self__, "hive_partitioning_options", hive_partitioning_options)
        if ignore_unknown_values is not None:
            pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        if json_extension is not None:
            pulumi.set(__self__, "json_extension", json_extension)
        if max_bad_records is not None:
            pulumi.set(__self__, "max_bad_records", max_bad_records)
        if null_marker is not None:
            pulumi.set(__self__, "null_marker", null_marker)
        if parquet_options is not None:
            pulumi.set(__self__, "parquet_options", parquet_options)
        if preserve_ascii_control_characters is not None:
            pulumi.set(__self__, "preserve_ascii_control_characters", preserve_ascii_control_characters)
        if projection_fields is not None:
            pulumi.set(__self__, "projection_fields", projection_fields)
        if quote is not None:
            pulumi.set(__self__, "quote", quote)
        if range_partitioning is not None:
            pulumi.set(__self__, "range_partitioning", range_partitioning)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_inline is not None:
            warnings.warn("""[Deprecated] The inline schema. For CSV schemas, specify as \"Field1:Type1[,Field2:Type2]*\". For example, \"foo:STRING, bar:INTEGER, baz:FLOAT\".""", DeprecationWarning)
            pulumi.log.warn("""schema_inline is deprecated: [Deprecated] The inline schema. For CSV schemas, specify as \"Field1:Type1[,Field2:Type2]*\". For example, \"foo:STRING, bar:INTEGER, baz:FLOAT\".""")
        if schema_inline is not None:
            pulumi.set(__self__, "schema_inline", schema_inline)
        if schema_inline_format is not None:
            warnings.warn("""[Deprecated] The format of the schemaInline property.""", DeprecationWarning)
            pulumi.log.warn("""schema_inline_format is deprecated: [Deprecated] The format of the schemaInline property.""")
        if schema_inline_format is not None:
            pulumi.set(__self__, "schema_inline_format", schema_inline_format)
        if schema_update_options is not None:
            pulumi.set(__self__, "schema_update_options", schema_update_options)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)
        if source_format is not None:
            pulumi.set(__self__, "source_format", source_format)
        if source_uris is not None:
            pulumi.set(__self__, "source_uris", source_uris)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if use_avro_logical_types is not None:
            pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Accept rows that are missing trailing optional columns. The missing values are treated as nulls. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @allow_jagged_rows.setter
    def allow_jagged_rows(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_jagged_rows", value)

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @allow_quoted_newlines.setter
    def allow_quoted_newlines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_quoted_newlines", value)

    @property
    @pulumi.getter
    def autodetect(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        """
        return pulumi.get(self, "autodetect")

    @autodetect.setter
    def autodetect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autodetect", value)

    @property
    @pulumi.getter
    def clustering(self) -> Optional[pulumi.Input['ClusteringArgs']]:
        """
        [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        """
        return pulumi.get(self, "clustering")

    @clustering.setter
    def clustering(self, value: Optional[pulumi.Input['ClusteringArgs']]):
        pulumi.set(self, "clustering", value)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "create_disposition")

    @create_disposition.setter
    def create_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_disposition", value)

    @property
    @pulumi.getter(name="decimalTargetTypes")
    def decimal_target_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Optional] Defines the list of possible SQL data types to which the source decimal values are converted. This list and the precision and the scale parameters of the decimal field determine the target type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the specified list and if it supports the precision and the scale. STRING supports all precision and scale values. If none of the listed types supports the precision and the scale, the type supporting the widest range in the specified list is picked, and if a value exceeds the supported range when reading the data, an error will be thrown. Example: Suppose the value of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: (38,9) -> NUMERIC; (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits); (76,38) -> BIGNUMERIC; (77,38) -> BIGNUMERIC (error if value exeeds supported range). This field cannot contain duplicate types. The order of the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"] for the other file formats.
        """
        return pulumi.get(self, "decimal_target_types")

    @decimal_target_types.setter
    def decimal_target_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "decimal_target_types", value)

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional[pulumi.Input['EncryptionConfigurationArgs']]:
        """
        Custom encryption configuration (e.g., Cloud KMS keys).
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @destination_encryption_configuration.setter
    def destination_encryption_configuration(self, value: Optional[pulumi.Input['EncryptionConfigurationArgs']]):
        pulumi.set(self, "destination_encryption_configuration", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional[pulumi.Input['TableReferenceArgs']]:
        """
        [Required] The destination table to load the data into.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: Optional[pulumi.Input['TableReferenceArgs']]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="destinationTableProperties")
    def destination_table_properties(self) -> Optional[pulumi.Input['DestinationTablePropertiesArgs']]:
        """
        [Beta] [Optional] Properties with which to create the destination table if it is new.
        """
        return pulumi.get(self, "destination_table_properties")

    @destination_table_properties.setter
    def destination_table_properties(self, value: Optional[pulumi.Input['DestinationTablePropertiesArgs']]):
        pulumi.set(self, "destination_table_properties", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character. To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="hivePartitioningOptions")
    def hive_partitioning_options(self) -> Optional[pulumi.Input['HivePartitioningOptionsArgs']]:
        """
        [Optional] Options to configure hive partitioning support.
        """
        return pulumi.get(self, "hive_partitioning_options")

    @hive_partitioning_options.setter
    def hive_partitioning_options(self, value: Optional[pulumi.Input['HivePartitioningOptionsArgs']]):
        pulumi.set(self, "hive_partitioning_options", value)

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
        """
        return pulumi.get(self, "ignore_unknown_values")

    @ignore_unknown_values.setter
    def ignore_unknown_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unknown_values", value)

    @property
    @pulumi.getter(name="jsonExtension")
    def json_extension(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON. For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited GeoJSON: set to GEOJSON.
        """
        return pulumi.get(self, "json_extension")

    @json_extension.setter
    def json_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_extension", value)

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> Optional[pulumi.Input[int]]:
        """
        [Optional] The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. This is only valid for CSV and JSON. The default value is 0, which requires that all records are valid.
        """
        return pulumi.get(self, "max_bad_records")

    @max_bad_records.setter
    def max_bad_records(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bad_records", value)

    @property
    @pulumi.getter(name="nullMarker")
    def null_marker(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies a string that represents a null value in a CSV file. For example, if you specify "\\N", BigQuery interprets "\\N" as a null value when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as an empty value.
        """
        return pulumi.get(self, "null_marker")

    @null_marker.setter
    def null_marker(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_marker", value)

    @property
    @pulumi.getter(name="parquetOptions")
    def parquet_options(self) -> Optional[pulumi.Input['ParquetOptionsArgs']]:
        """
        [Optional] Options to configure parquet support.
        """
        return pulumi.get(self, "parquet_options")

    @parquet_options.setter
    def parquet_options(self, value: Optional[pulumi.Input['ParquetOptionsArgs']]):
        pulumi.set(self, "parquet_options", value)

    @property
    @pulumi.getter(name="preserveAsciiControlCharacters")
    def preserve_ascii_control_characters(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Preserves the embedded ASCII control characters (the first 32 characters in the ASCII-table, from '\\x00' to '\\x1F') when loading from CSV. Only applicable to CSV, ignored for other formats.
        """
        return pulumi.get(self, "preserve_ascii_control_characters")

    @preserve_ascii_control_characters.setter
    def preserve_ascii_control_characters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_ascii_control_characters", value)

    @property
    @pulumi.getter(name="projectionFields")
    def projection_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup. Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties. If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        """
        return pulumi.get(self, "projection_fields")

    @projection_fields.setter
    def projection_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "projection_fields", value)

    @property
    @pulumi.getter
    def quote(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return pulumi.get(self, "quote")

    @quote.setter
    def quote(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote", value)

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> Optional[pulumi.Input['RangePartitioningArgs']]:
        """
        [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "range_partitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: Optional[pulumi.Input['RangePartitioningArgs']]):
        pulumi.set(self, "range_partitioning", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['TableSchemaArgs']]:
        """
        [Optional] The schema for the destination table. The schema can be omitted if the destination table already exists, or if you're loading data from Google Cloud Datastore.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['TableSchemaArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="schemaInline")
    def schema_inline(self) -> Optional[pulumi.Input[str]]:
        """
        [Deprecated] The inline schema. For CSV schemas, specify as "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER, baz:FLOAT".
        """
        return pulumi.get(self, "schema_inline")

    @schema_inline.setter
    def schema_inline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_inline", value)

    @property
    @pulumi.getter(name="schemaInlineFormat")
    def schema_inline_format(self) -> Optional[pulumi.Input[str]]:
        """
        [Deprecated] The format of the schemaInline property.
        """
        return pulumi.get(self, "schema_inline_format")

    @schema_inline_format.setter
    def schema_inline_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_inline_format", value)

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @schema_update_options.setter
    def schema_update_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schema_update_options", value)

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[pulumi.Input[int]]:
        """
        [Optional] The number of rows at the top of a CSV file that BigQuery will skip when loading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        """
        return pulumi.get(self, "skip_leading_rows")

    @skip_leading_rows.setter
    def skip_leading_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "skip_leading_rows", value)

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default value is CSV.
        """
        return pulumi.get(self, "source_format")

    @source_format.setter
    def source_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_format", value)

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        return pulumi.get(self, "source_uris")

    @source_uris.setter
    def source_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_uris", value)

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['TimePartitioningArgs']]:
        """
        Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['TimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        return pulumi.get(self, "use_avro_logical_types")

    @use_avro_logical_types.setter
    def use_avro_logical_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_avro_logical_types", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_APPEND. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class JobConfigurationQueryArgs:
    def __init__(__self__, *,
                 allow_large_results: Optional[pulumi.Input[bool]] = None,
                 clustering: Optional[pulumi.Input['ClusteringArgs']] = None,
                 connection_properties: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionPropertyArgs']]]] = None,
                 create_disposition: Optional[pulumi.Input[str]] = None,
                 create_session: Optional[pulumi.Input[bool]] = None,
                 default_dataset: Optional[pulumi.Input['DatasetReferenceArgs']] = None,
                 destination_encryption_configuration: Optional[pulumi.Input['EncryptionConfigurationArgs']] = None,
                 destination_table: Optional[pulumi.Input['TableReferenceArgs']] = None,
                 flatten_results: Optional[pulumi.Input[bool]] = None,
                 maximum_billing_tier: Optional[pulumi.Input[int]] = None,
                 maximum_bytes_billed: Optional[pulumi.Input[str]] = None,
                 parameter_mode: Optional[pulumi.Input[str]] = None,
                 preserve_nulls: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 query_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]] = None,
                 range_partitioning: Optional[pulumi.Input['RangePartitioningArgs']] = None,
                 schema_update_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 table_definitions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_partitioning: Optional[pulumi.Input['TimePartitioningArgs']] = None,
                 use_legacy_sql: Optional[pulumi.Input[bool]] = None,
                 use_query_cache: Optional[pulumi.Input[bool]] = None,
                 user_defined_function_resources: Optional[pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]]] = None,
                 write_disposition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_large_results: [Optional] If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance. Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed. However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        :param pulumi.Input['ClusteringArgs'] clustering: [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionPropertyArgs']]] connection_properties: Connection properties.
        :param pulumi.Input[str] create_disposition: [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        :param pulumi.Input[bool] create_session: If true, creates a new session, where session id will be a server generated random id. If false, runs query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-session mode.
        :param pulumi.Input['DatasetReferenceArgs'] default_dataset: [Optional] Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
        :param pulumi.Input['EncryptionConfigurationArgs'] destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys).
        :param pulumi.Input['TableReferenceArgs'] destination_table: [Optional] Describes the table where the query results should be stored. If not present, a new table will be created to store the results. This property must be set for large results that exceed the maximum response size.
        :param pulumi.Input[bool] flatten_results: [Optional] If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results. allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        :param pulumi.Input[int] maximum_billing_tier: [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge). If unspecified, this will be set to your project default.
        :param pulumi.Input[str] maximum_bytes_billed: [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge). If unspecified, this will be set to your project default.
        :param pulumi.Input[str] parameter_mode: Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        :param pulumi.Input[bool] preserve_nulls: [Deprecated] This property is deprecated.
        :param pulumi.Input[str] priority: [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH. The default value is INTERACTIVE.
        :param pulumi.Input[str] query: [Required] SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        :param pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]] query_parameters: Query parameters for standard SQL queries.
        :param pulumi.Input['RangePartitioningArgs'] range_partitioning: [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the query job. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] table_definitions: [Optional] If querying an external data source outside of BigQuery, describes the data format, location and other properties of the data source. By defining these properties, the data source can then be queried as if it were a standard BigQuery table.
        :param pulumi.Input['TimePartitioningArgs'] time_partitioning: Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        :param pulumi.Input[bool] use_legacy_sql: Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true. If set to false, the query will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be run as if flattenResults is false.
        :param pulumi.Input[bool] use_query_cache: [Optional] Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]] user_defined_function_resources: Describes user-defined function resources used in the query.
        :param pulumi.Input[str] write_disposition: [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        if allow_large_results is not None:
            pulumi.set(__self__, "allow_large_results", allow_large_results)
        if clustering is not None:
            pulumi.set(__self__, "clustering", clustering)
        if connection_properties is not None:
            pulumi.set(__self__, "connection_properties", connection_properties)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if create_session is not None:
            pulumi.set(__self__, "create_session", create_session)
        if default_dataset is not None:
            pulumi.set(__self__, "default_dataset", default_dataset)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if flatten_results is not None:
            pulumi.set(__self__, "flatten_results", flatten_results)
        if maximum_billing_tier is not None:
            pulumi.set(__self__, "maximum_billing_tier", maximum_billing_tier)
        if maximum_bytes_billed is not None:
            pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        if parameter_mode is not None:
            pulumi.set(__self__, "parameter_mode", parameter_mode)
        if preserve_nulls is not None:
            warnings.warn("""[Deprecated] This property is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""preserve_nulls is deprecated: [Deprecated] This property is deprecated.""")
        if preserve_nulls is not None:
            pulumi.set(__self__, "preserve_nulls", preserve_nulls)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if range_partitioning is not None:
            pulumi.set(__self__, "range_partitioning", range_partitioning)
        if schema_update_options is not None:
            pulumi.set(__self__, "schema_update_options", schema_update_options)
        if table_definitions is not None:
            pulumi.set(__self__, "table_definitions", table_definitions)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if use_legacy_sql is not None:
            pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)
        if use_query_cache is not None:
            pulumi.set(__self__, "use_query_cache", use_query_cache)
        if user_defined_function_resources is not None:
            pulumi.set(__self__, "user_defined_function_resources", user_defined_function_resources)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="allowLargeResults")
    def allow_large_results(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance. Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed. However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        """
        return pulumi.get(self, "allow_large_results")

    @allow_large_results.setter
    def allow_large_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_large_results", value)

    @property
    @pulumi.getter
    def clustering(self) -> Optional[pulumi.Input['ClusteringArgs']]:
        """
        [Beta] Clustering specification for the destination table. Must be specified with time-based partitioning, data in the table will be first partitioned and subsequently clustered.
        """
        return pulumi.get(self, "clustering")

    @clustering.setter
    def clustering(self, value: Optional[pulumi.Input['ClusteringArgs']]):
        pulumi.set(self, "clustering", value)

    @property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionPropertyArgs']]]]:
        """
        Connection properties.
        """
        return pulumi.get(self, "connection_properties")

    @connection_properties.setter
    def connection_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionPropertyArgs']]]]):
        pulumi.set(self, "connection_properties", value)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "create_disposition")

    @create_disposition.setter
    def create_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_disposition", value)

    @property
    @pulumi.getter(name="createSession")
    def create_session(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, creates a new session, where session id will be a server generated random id. If false, runs query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-session mode.
        """
        return pulumi.get(self, "create_session")

    @create_session.setter
    def create_session(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_session", value)

    @property
    @pulumi.getter(name="defaultDataset")
    def default_dataset(self) -> Optional[pulumi.Input['DatasetReferenceArgs']]:
        """
        [Optional] Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
        """
        return pulumi.get(self, "default_dataset")

    @default_dataset.setter
    def default_dataset(self, value: Optional[pulumi.Input['DatasetReferenceArgs']]):
        pulumi.set(self, "default_dataset", value)

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional[pulumi.Input['EncryptionConfigurationArgs']]:
        """
        Custom encryption configuration (e.g., Cloud KMS keys).
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @destination_encryption_configuration.setter
    def destination_encryption_configuration(self, value: Optional[pulumi.Input['EncryptionConfigurationArgs']]):
        pulumi.set(self, "destination_encryption_configuration", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional[pulumi.Input['TableReferenceArgs']]:
        """
        [Optional] Describes the table where the query results should be stored. If not present, a new table will be created to store the results. This property must be set for large results that exceed the maximum response size.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: Optional[pulumi.Input['TableReferenceArgs']]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="flattenResults")
    def flatten_results(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results. allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        """
        return pulumi.get(self, "flatten_results")

    @flatten_results.setter
    def flatten_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flatten_results", value)

    @property
    @pulumi.getter(name="maximumBillingTier")
    def maximum_billing_tier(self) -> Optional[pulumi.Input[int]]:
        """
        [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge). If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_billing_tier")

    @maximum_billing_tier.setter
    def maximum_billing_tier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_billing_tier", value)

    @property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge). If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @maximum_bytes_billed.setter
    def maximum_bytes_billed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_bytes_billed", value)

    @property
    @pulumi.getter(name="parameterMode")
    def parameter_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        """
        return pulumi.get(self, "parameter_mode")

    @parameter_mode.setter
    def parameter_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_mode", value)

    @property
    @pulumi.getter(name="preserveNulls")
    def preserve_nulls(self) -> Optional[pulumi.Input[bool]]:
        """
        [Deprecated] This property is deprecated.
        """
        return pulumi.get(self, "preserve_nulls")

    @preserve_nulls.setter
    def preserve_nulls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_nulls", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH. The default value is INTERACTIVE.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]]:
        """
        Query parameters for standard SQL queries.
        """
        return pulumi.get(self, "query_parameters")

    @query_parameters.setter
    def query_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterArgs']]]]):
        pulumi.set(self, "query_parameters", value)

    @property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> Optional[pulumi.Input['RangePartitioningArgs']]:
        """
        [TrustedTester] Range partitioning specification for this table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "range_partitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: Optional[pulumi.Input['RangePartitioningArgs']]):
        pulumi.set(self, "range_partitioning", value)

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allows the schema of the destination table to be updated as a side effect of the query job. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @schema_update_options.setter
    def schema_update_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schema_update_options", value)

    @property
    @pulumi.getter(name="tableDefinitions")
    def table_definitions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        [Optional] If querying an external data source outside of BigQuery, describes the data format, location and other properties of the data source. By defining these properties, the data source can then be queried as if it were a standard BigQuery table.
        """
        return pulumi.get(self, "table_definitions")

    @table_definitions.setter
    def table_definitions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "table_definitions", value)

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['TimePartitioningArgs']]:
        """
        Time-based partitioning specification for the destination table. Only one of timePartitioning and rangePartitioning should be specified.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['TimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true. If set to false, the query will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be run as if flattenResults is false.
        """
        return pulumi.get(self, "use_legacy_sql")

    @use_legacy_sql.setter
    def use_legacy_sql(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_legacy_sql", value)

    @property
    @pulumi.getter(name="useQueryCache")
    def use_query_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified. The default value is true.
        """
        return pulumi.get(self, "use_query_cache")

    @use_query_cache.setter
    def use_query_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_query_cache", value)

    @property
    @pulumi.getter(name="userDefinedFunctionResources")
    def user_defined_function_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]]]:
        """
        Describes user-defined function resources used in the query.
        """
        return pulumi.get(self, "user_defined_function_resources")

    @user_defined_function_resources.setter
    def user_defined_function_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]]]):
        pulumi.set(self, "user_defined_function_resources", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class JobConfigurationTableCopyArgs:
    def __init__(__self__, *,
                 create_disposition: Optional[pulumi.Input[str]] = None,
                 destination_encryption_configuration: Optional[pulumi.Input['EncryptionConfigurationArgs']] = None,
                 destination_expiration_time: Optional[Any] = None,
                 destination_table: Optional[pulumi.Input['TableReferenceArgs']] = None,
                 operation_type: Optional[pulumi.Input[str]] = None,
                 source_table: Optional[pulumi.Input['TableReferenceArgs']] = None,
                 source_tables: Optional[pulumi.Input[Sequence[pulumi.Input['TableReferenceArgs']]]] = None,
                 write_disposition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create_disposition: [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        :param pulumi.Input['EncryptionConfigurationArgs'] destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys).
        :param Any destination_expiration_time: [Optional] The time when the destination table expires. Expired tables will be deleted and their storage reclaimed.
        :param pulumi.Input['TableReferenceArgs'] destination_table: [Required] The destination table
        :param pulumi.Input[str] operation_type: [Optional] Supported operation types in table copy job.
        :param pulumi.Input['TableReferenceArgs'] source_table: [Pick one] Source table to copy.
        :param pulumi.Input[Sequence[pulumi.Input['TableReferenceArgs']]] source_tables: [Pick one] Source tables to copy.
        :param pulumi.Input[str] write_disposition: [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_expiration_time is not None:
            pulumi.set(__self__, "destination_expiration_time", destination_expiration_time)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if source_table is not None:
            pulumi.set(__self__, "source_table", source_table)
        if source_tables is not None:
            pulumi.set(__self__, "source_tables", source_tables)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "create_disposition")

    @create_disposition.setter
    def create_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_disposition", value)

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional[pulumi.Input['EncryptionConfigurationArgs']]:
        """
        Custom encryption configuration (e.g., Cloud KMS keys).
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @destination_encryption_configuration.setter
    def destination_encryption_configuration(self, value: Optional[pulumi.Input['EncryptionConfigurationArgs']]):
        pulumi.set(self, "destination_encryption_configuration", value)

    @property
    @pulumi.getter(name="destinationExpirationTime")
    def destination_expiration_time(self) -> Optional[Any]:
        """
        [Optional] The time when the destination table expires. Expired tables will be deleted and their storage reclaimed.
        """
        return pulumi.get(self, "destination_expiration_time")

    @destination_expiration_time.setter
    def destination_expiration_time(self, value: Optional[Any]):
        pulumi.set(self, "destination_expiration_time", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional[pulumi.Input['TableReferenceArgs']]:
        """
        [Required] The destination table
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: Optional[pulumi.Input['TableReferenceArgs']]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Supported operation types in table copy job.
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> Optional[pulumi.Input['TableReferenceArgs']]:
        """
        [Pick one] Source table to copy.
        """
        return pulumi.get(self, "source_table")

    @source_table.setter
    def source_table(self, value: Optional[pulumi.Input['TableReferenceArgs']]):
        pulumi.set(self, "source_table", value)

    @property
    @pulumi.getter(name="sourceTables")
    def source_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableReferenceArgs']]]]:
        """
        [Pick one] Source tables to copy.
        """
        return pulumi.get(self, "source_tables")

    @source_tables.setter
    def source_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableReferenceArgs']]]]):
        pulumi.set(self, "source_tables", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class JobConfigurationArgs:
    def __init__(__self__, *,
                 copy: Optional[pulumi.Input['JobConfigurationTableCopyArgs']] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 extract: Optional[pulumi.Input['JobConfigurationExtractArgs']] = None,
                 job_timeout_ms: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load: Optional[pulumi.Input['JobConfigurationLoadArgs']] = None,
                 query: Optional[pulumi.Input['JobConfigurationQueryArgs']] = None):
        """
        :param pulumi.Input['JobConfigurationTableCopyArgs'] copy: [Pick one] Copies a table.
        :param pulumi.Input[bool] dry_run: [Optional] If set, don't actually run this job. A valid query will return a mostly empty response with some processing statistics, while an invalid query will return the same error it would if it wasn't a dry run. Behavior of non-query jobs is undefined.
        :param pulumi.Input['JobConfigurationExtractArgs'] extract: [Pick one] Configures an extract job.
        :param pulumi.Input[str] job_timeout_ms: [Optional] Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels associated with this job. You can use these to organize and group your jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
        :param pulumi.Input['JobConfigurationLoadArgs'] load: [Pick one] Configures a load job.
        :param pulumi.Input['JobConfigurationQueryArgs'] query: [Pick one] Configures a query job.
        """
        if copy is not None:
            pulumi.set(__self__, "copy", copy)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if extract is not None:
            pulumi.set(__self__, "extract", extract)
        if job_timeout_ms is not None:
            pulumi.set(__self__, "job_timeout_ms", job_timeout_ms)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load is not None:
            pulumi.set(__self__, "load", load)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def copy(self) -> Optional[pulumi.Input['JobConfigurationTableCopyArgs']]:
        """
        [Pick one] Copies a table.
        """
        return pulumi.get(self, "copy")

    @copy.setter
    def copy(self, value: Optional[pulumi.Input['JobConfigurationTableCopyArgs']]):
        pulumi.set(self, "copy", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] If set, don't actually run this job. A valid query will return a mostly empty response with some processing statistics, while an invalid query will return the same error it would if it wasn't a dry run. Behavior of non-query jobs is undefined.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['JobConfigurationExtractArgs']]:
        """
        [Pick one] Configures an extract job.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['JobConfigurationExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter(name="jobTimeoutMs")
    def job_timeout_ms(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        """
        return pulumi.get(self, "job_timeout_ms")

    @job_timeout_ms.setter
    def job_timeout_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_timeout_ms", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels associated with this job. You can use these to organize and group your jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def load(self) -> Optional[pulumi.Input['JobConfigurationLoadArgs']]:
        """
        [Pick one] Configures a load job.
        """
        return pulumi.get(self, "load")

    @load.setter
    def load(self, value: Optional[pulumi.Input['JobConfigurationLoadArgs']]):
        pulumi.set(self, "load", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input['JobConfigurationQueryArgs']]:
        """
        [Pick one] Configures a query job.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input['JobConfigurationQueryArgs']]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class JobReferenceArgs:
    def __init__(__self__, *,
                 job_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_id: [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param pulumi.Input[str] location: The geographic location of the job. See details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
        :param pulumi.Input[str] project: [Required] The ID of the project containing this job.
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geographic location of the job. See details at https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the project containing this job.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class MaterializedViewDefinitionArgs:
    def __init__(__self__, *,
                 enable_refresh: Optional[pulumi.Input[bool]] = None,
                 max_staleness: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 refresh_interval_ms: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enable_refresh: [Optional] [TrustedTester] Enable automatic refresh of the materialized view when the base table is updated. The default value is "true".
        :param pulumi.Input[str] max_staleness: [Optional] Max staleness of data that could be returned when materizlized view is queried (formatted as Google SQL Interval type).
        :param pulumi.Input[str] query: [Required] A query whose result is persisted.
        :param pulumi.Input[str] refresh_interval_ms: [Optional] [TrustedTester] The maximum frequency at which this materialized view will be refreshed. The default value is "1800000" (30 minutes).
        """
        if enable_refresh is not None:
            pulumi.set(__self__, "enable_refresh", enable_refresh)
        if max_staleness is not None:
            pulumi.set(__self__, "max_staleness", max_staleness)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if refresh_interval_ms is not None:
            pulumi.set(__self__, "refresh_interval_ms", refresh_interval_ms)

    @property
    @pulumi.getter(name="enableRefresh")
    def enable_refresh(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] [TrustedTester] Enable automatic refresh of the materialized view when the base table is updated. The default value is "true".
        """
        return pulumi.get(self, "enable_refresh")

    @enable_refresh.setter
    def enable_refresh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_refresh", value)

    @property
    @pulumi.getter(name="maxStaleness")
    def max_staleness(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Max staleness of data that could be returned when materizlized view is queried (formatted as Google SQL Interval type).
        """
        return pulumi.get(self, "max_staleness")

    @max_staleness.setter
    def max_staleness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_staleness", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] A query whose result is persisted.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="refreshIntervalMs")
    def refresh_interval_ms(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] [TrustedTester] The maximum frequency at which this materialized view will be refreshed. The default value is "1800000" (30 minutes).
        """
        return pulumi.get(self, "refresh_interval_ms")

    @refresh_interval_ms.setter
    def refresh_interval_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_interval_ms", value)


@pulumi.input_type
class ModelDefinitionModelOptionsArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 loss_type: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None):
        """
        [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if loss_type is not None:
            pulumi.set(__self__, "loss_type", loss_type)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lossType")
    def loss_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "loss_type")

    @loss_type.setter
    def loss_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loss_type", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)


@pulumi.input_type
class ModelDefinitionArgs:
    def __init__(__self__, *,
                 model_options: Optional[pulumi.Input['ModelDefinitionModelOptionsArgs']] = None,
                 training_runs: Optional[pulumi.Input[Sequence[pulumi.Input['BqmlTrainingRunArgs']]]] = None):
        """
        :param pulumi.Input['ModelDefinitionModelOptionsArgs'] model_options: [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
        :param pulumi.Input[Sequence[pulumi.Input['BqmlTrainingRunArgs']]] training_runs: [Output-only, Beta] Information about ml training runs, each training run comprises of multiple iterations and there may be multiple training runs for the model if warm start is used or if a user decides to continue a previously cancelled query.
        """
        if model_options is not None:
            pulumi.set(__self__, "model_options", model_options)
        if training_runs is not None:
            pulumi.set(__self__, "training_runs", training_runs)

    @property
    @pulumi.getter(name="modelOptions")
    def model_options(self) -> Optional[pulumi.Input['ModelDefinitionModelOptionsArgs']]:
        """
        [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
        """
        return pulumi.get(self, "model_options")

    @model_options.setter
    def model_options(self, value: Optional[pulumi.Input['ModelDefinitionModelOptionsArgs']]):
        pulumi.set(self, "model_options", value)

    @property
    @pulumi.getter(name="trainingRuns")
    def training_runs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BqmlTrainingRunArgs']]]]:
        """
        [Output-only, Beta] Information about ml training runs, each training run comprises of multiple iterations and there may be multiple training runs for the model if warm start is used or if a user decides to continue a previously cancelled query.
        """
        return pulumi.get(self, "training_runs")

    @training_runs.setter
    def training_runs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BqmlTrainingRunArgs']]]]):
        pulumi.set(self, "training_runs", value)


@pulumi.input_type
class ModelReferenceArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_id: [Required] The ID of the dataset containing this model.
        :param pulumi.Input[str] model_id: [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param pulumi.Input[str] project: [Required] The ID of the project containing this model.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the project containing this model.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class ParquetOptionsArgs:
    def __init__(__self__, *,
                 enable_list_inference: Optional[pulumi.Input[bool]] = None,
                 enum_as_string: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enable_list_inference: [Optional] Indicates whether to use schema inference specifically for Parquet LIST logical type.
        :param pulumi.Input[bool] enum_as_string: [Optional] Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        if enable_list_inference is not None:
            pulumi.set(__self__, "enable_list_inference", enable_list_inference)
        if enum_as_string is not None:
            pulumi.set(__self__, "enum_as_string", enum_as_string)

    @property
    @pulumi.getter(name="enableListInference")
    def enable_list_inference(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates whether to use schema inference specifically for Parquet LIST logical type.
        """
        return pulumi.get(self, "enable_list_inference")

    @enable_list_inference.setter
    def enable_list_inference(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_list_inference", value)

    @property
    @pulumi.getter(name="enumAsString")
    def enum_as_string(self) -> Optional[pulumi.Input[bool]]:
        """
        [Optional] Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        return pulumi.get(self, "enum_as_string")

    @enum_as_string.setter
    def enum_as_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enum_as_string", value)


@pulumi.input_type
class QueryParameterTypeStructTypesItemArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['QueryParameterTypeArgs']] = None):
        """
        :param pulumi.Input[str] description: [Optional] Human-oriented description of the field.
        :param pulumi.Input[str] name: [Optional] The name of this field.
        :param pulumi.Input['QueryParameterTypeArgs'] type: [Required] The type of this field.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Human-oriented description of the field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The name of this field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['QueryParameterTypeArgs']]:
        """
        [Required] The type of this field.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['QueryParameterTypeArgs']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class QueryParameterTypeArgs:
    def __init__(__self__, *,
                 array_type: Optional[pulumi.Input['QueryParameterTypeArgs']] = None,
                 struct_types: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterTypeStructTypesItemArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['QueryParameterTypeArgs'] array_type: [Optional] The type of the array's elements, if this is an array.
        :param pulumi.Input[Sequence[pulumi.Input['QueryParameterTypeStructTypesItemArgs']]] struct_types: [Optional] The types of the fields of this struct, in order, if this is a struct.
        :param pulumi.Input[str] type: [Required] The top level type of this field.
        """
        if array_type is not None:
            pulumi.set(__self__, "array_type", array_type)
        if struct_types is not None:
            pulumi.set(__self__, "struct_types", struct_types)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="arrayType")
    def array_type(self) -> Optional[pulumi.Input['QueryParameterTypeArgs']]:
        """
        [Optional] The type of the array's elements, if this is an array.
        """
        return pulumi.get(self, "array_type")

    @array_type.setter
    def array_type(self, value: Optional[pulumi.Input['QueryParameterTypeArgs']]):
        pulumi.set(self, "array_type", value)

    @property
    @pulumi.getter(name="structTypes")
    def struct_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterTypeStructTypesItemArgs']]]]:
        """
        [Optional] The types of the fields of this struct, in order, if this is a struct.
        """
        return pulumi.get(self, "struct_types")

    @struct_types.setter
    def struct_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterTypeStructTypesItemArgs']]]]):
        pulumi.set(self, "struct_types", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The top level type of this field.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class QueryParameterValueArgs:
    def __init__(__self__, *,
                 array_values: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterValueArgs']]]] = None,
                 struct_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['QueryParameterValueArgs']]] array_values: [Optional] The array values, if this is an array type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] struct_values: [Optional] The struct field values, in order of the struct type's declaration.
        :param pulumi.Input[str] value: [Optional] The value of this value, if a simple scalar type.
        """
        if array_values is not None:
            pulumi.set(__self__, "array_values", array_values)
        if struct_values is not None:
            pulumi.set(__self__, "struct_values", struct_values)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="arrayValues")
    def array_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterValueArgs']]]]:
        """
        [Optional] The array values, if this is an array type.
        """
        return pulumi.get(self, "array_values")

    @array_values.setter
    def array_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryParameterValueArgs']]]]):
        pulumi.set(self, "array_values", value)

    @property
    @pulumi.getter(name="structValues")
    def struct_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        [Optional] The struct field values, in order of the struct type's declaration.
        """
        return pulumi.get(self, "struct_values")

    @struct_values.setter
    def struct_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "struct_values", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The value of this value, if a simple scalar type.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class QueryParameterArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_type: Optional[pulumi.Input['QueryParameterTypeArgs']] = None,
                 parameter_value: Optional[pulumi.Input['QueryParameterValueArgs']] = None):
        """
        :param pulumi.Input[str] name: [Optional] If unset, this is a positional parameter. Otherwise, should be unique within a query.
        :param pulumi.Input['QueryParameterTypeArgs'] parameter_type: [Required] The type of this parameter.
        :param pulumi.Input['QueryParameterValueArgs'] parameter_value: [Required] The value of this parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_type is not None:
            pulumi.set(__self__, "parameter_type", parameter_type)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] If unset, this is a positional parameter. Otherwise, should be unique within a query.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> Optional[pulumi.Input['QueryParameterTypeArgs']]:
        """
        [Required] The type of this parameter.
        """
        return pulumi.get(self, "parameter_type")

    @parameter_type.setter
    def parameter_type(self, value: Optional[pulumi.Input['QueryParameterTypeArgs']]):
        pulumi.set(self, "parameter_type", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[pulumi.Input['QueryParameterValueArgs']]:
        """
        [Required] The value of this parameter.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: Optional[pulumi.Input['QueryParameterValueArgs']]):
        pulumi.set(self, "parameter_value", value)


@pulumi.input_type
class RangePartitioningRangeArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        [TrustedTester] [Required] Defines the ranges for range partitioning.
        :param pulumi.Input[str] end: [TrustedTester] [Required] The end of range partitioning, exclusive.
        :param pulumi.Input[str] interval: [TrustedTester] [Required] The width of each interval.
        :param pulumi.Input[str] start: [TrustedTester] [Required] The start of range partitioning, inclusive.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        [TrustedTester] [Required] The end of range partitioning, exclusive.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        [TrustedTester] [Required] The width of each interval.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        [TrustedTester] [Required] The start of range partitioning, inclusive.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class RangePartitioningArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 range: Optional[pulumi.Input['RangePartitioningRangeArgs']] = None):
        """
        :param pulumi.Input[str] field: [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
        :param pulumi.Input['RangePartitioningRangeArgs'] range: [TrustedTester] [Required] Defines the ranges for range partitioning.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if range is not None:
            pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input['RangePartitioningRangeArgs']]:
        """
        [TrustedTester] [Required] Defines the ranges for range partitioning.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input['RangePartitioningRangeArgs']]):
        pulumi.set(self, "range", value)


@pulumi.input_type
class RemoteFunctionOptionsArgs:
    def __init__(__self__, *,
                 connection: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 max_batching_rows: Optional[pulumi.Input[str]] = None,
                 user_defined_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Options for a remote user-defined function.
        :param pulumi.Input[str] connection: Fully qualified name of the user-provided connection object which holds the authentication information to send requests to the remote service. projects/{project_id}/locations/{location_id}/connections/{connection_id}
        :param pulumi.Input[str] endpoint: Endpoint of the user-provided remote service (e.g. a function url in Google Cloud Functions).
        :param pulumi.Input[str] max_batching_rows: Max number of rows in each batch sent to the remote service. If absent or if 0, it means no limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_defined_context: User-defined context as a set of key/value pairs, which will be sent as function invocation context together with batched arguments in the requests to the remote service. The total number of bytes of keys and values must be less than 8KB.
        """
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if max_batching_rows is not None:
            pulumi.set(__self__, "max_batching_rows", max_batching_rows)
        if user_defined_context is not None:
            pulumi.set(__self__, "user_defined_context", user_defined_context)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified name of the user-provided connection object which holds the authentication information to send requests to the remote service. projects/{project_id}/locations/{location_id}/connections/{connection_id}
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint of the user-provided remote service (e.g. a function url in Google Cloud Functions).
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="maxBatchingRows")
    def max_batching_rows(self) -> Optional[pulumi.Input[str]]:
        """
        Max number of rows in each batch sent to the remote service. If absent or if 0, it means no limit.
        """
        return pulumi.get(self, "max_batching_rows")

    @max_batching_rows.setter
    def max_batching_rows(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_batching_rows", value)

    @property
    @pulumi.getter(name="userDefinedContext")
    def user_defined_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined context as a set of key/value pairs, which will be sent as function invocation context together with batched arguments in the requests to the remote service. The total number of bytes of keys and values must be less than 8KB.
        """
        return pulumi.get(self, "user_defined_context")

    @user_defined_context.setter
    def user_defined_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_defined_context", value)


@pulumi.input_type
class RoutineReferenceArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routine_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_id: [Required] The ID of the dataset containing this routine.
        :param pulumi.Input[str] project: [Required] The ID of the project containing this routine.
        :param pulumi.Input[str] routine_id: [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routine_id is not None:
            pulumi.set(__self__, "routine_id", routine_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the dataset containing this routine.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the project containing this routine.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "routine_id")

    @routine_id.setter
    def routine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routine_id", value)


@pulumi.input_type
class StandardSqlDataTypeArgs:
    def __init__(__self__, *,
                 type_kind: pulumi.Input['StandardSqlDataTypeTypeKind'],
                 array_element_type: Optional[pulumi.Input['StandardSqlDataTypeArgs']] = None,
                 struct_type: Optional[pulumi.Input['StandardSqlStructTypeArgs']] = None):
        """
        The data type of a variable such as a function argument. Examples include: * INT64: `{"typeKind": "INT64"}` * ARRAY: { "typeKind": "ARRAY", "arrayElementType": {"typeKind": "STRING"} } * STRUCT>: { "typeKind": "STRUCT", "structType": { "fields": [ { "name": "x", "type": {"typeKind: "STRING"} }, { "name": "y", "type": { "typeKind": "ARRAY", "arrayElementType": {"typekind": "DATE"} } } ] } }
        :param pulumi.Input['StandardSqlDataTypeTypeKind'] type_kind: The top level type of this field. Can be any standard SQL data type (e.g., "INT64", "DATE", "ARRAY").
        :param pulumi.Input['StandardSqlDataTypeArgs'] array_element_type: The type of the array's elements, if type_kind = "ARRAY".
        :param pulumi.Input['StandardSqlStructTypeArgs'] struct_type: The fields of this struct, in order, if type_kind = "STRUCT".
        """
        pulumi.set(__self__, "type_kind", type_kind)
        if array_element_type is not None:
            pulumi.set(__self__, "array_element_type", array_element_type)
        if struct_type is not None:
            pulumi.set(__self__, "struct_type", struct_type)

    @property
    @pulumi.getter(name="typeKind")
    def type_kind(self) -> pulumi.Input['StandardSqlDataTypeTypeKind']:
        """
        The top level type of this field. Can be any standard SQL data type (e.g., "INT64", "DATE", "ARRAY").
        """
        return pulumi.get(self, "type_kind")

    @type_kind.setter
    def type_kind(self, value: pulumi.Input['StandardSqlDataTypeTypeKind']):
        pulumi.set(self, "type_kind", value)

    @property
    @pulumi.getter(name="arrayElementType")
    def array_element_type(self) -> Optional[pulumi.Input['StandardSqlDataTypeArgs']]:
        """
        The type of the array's elements, if type_kind = "ARRAY".
        """
        return pulumi.get(self, "array_element_type")

    @array_element_type.setter
    def array_element_type(self, value: Optional[pulumi.Input['StandardSqlDataTypeArgs']]):
        pulumi.set(self, "array_element_type", value)

    @property
    @pulumi.getter(name="structType")
    def struct_type(self) -> Optional[pulumi.Input['StandardSqlStructTypeArgs']]:
        """
        The fields of this struct, in order, if type_kind = "STRUCT".
        """
        return pulumi.get(self, "struct_type")

    @struct_type.setter
    def struct_type(self, value: Optional[pulumi.Input['StandardSqlStructTypeArgs']]):
        pulumi.set(self, "struct_type", value)


@pulumi.input_type
class StandardSqlFieldArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['StandardSqlDataTypeArgs']] = None):
        """
        A field or a column.
        :param pulumi.Input[str] name: Optional. The name of this field. Can be absent for struct fields.
        :param pulumi.Input['StandardSqlDataTypeArgs'] type: Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION statement can omit the return type; in this case the output parameter does not have this "type" field).
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of this field. Can be absent for struct fields.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['StandardSqlDataTypeArgs']]:
        """
        Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION statement can omit the return type; in this case the output parameter does not have this "type" field).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['StandardSqlDataTypeArgs']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StandardSqlStructTypeArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]]] = None):
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]]]):
        pulumi.set(self, "fields", value)


@pulumi.input_type
class StandardSqlTableTypeArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]]] = None):
        """
        A table type
        :param pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]] columns: The columns in this table type
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]]]:
        """
        The columns in this table type
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardSqlFieldArgs']]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class TableFieldSchemaCategoriesArgs:
    def __init__(__self__, *,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        [Optional] The categories attached to this field, used for field-level access control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most 5 categories are allowed.
        """
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most 5 categories are allowed.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class TableFieldSchemaPolicyTagsArgs:
    def __init__(__self__, *,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: A list of category resource names. For example, "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
        """
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of category resource names. For example, "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class TableFieldSchemaArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input['TableFieldSchemaCategoriesArgs']] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 default_value_expression: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]]] = None,
                 max_length: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_tags: Optional[pulumi.Input['TableFieldSchemaPolicyTagsArgs']] = None,
                 precision: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['TableFieldSchemaCategoriesArgs'] categories: [Optional] The categories attached to this field, used for field-level access control.
        :param pulumi.Input[str] collation: Optional. Collation specification of the field. It only can be set on string type field.
        :param pulumi.Input[str] default_value_expression: Optional. A SQL expression to specify the default value for this field. It can only be set for top level fields (columns). You can use struct or array expression to specify default value for the entire struct or array. The valid SQL expressions are: - Literals for all data types, including STRUCT and ARRAY. - Following functions: - CURRENT_TIMESTAMP - CURRENT_TIME - CURRENT_DATE - CURRENT_DATETIME - GENERATE_UUID - RAND - SESSION_USER - ST_GEOGPOINT - Struct or array composed with the above allowed functions, for example, [CURRENT_DATE(), DATE '2020-01-01']
        :param pulumi.Input[str] description: [Optional] The field description. The maximum length is 1,024 characters.
        :param pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]] fields: [Optional] Describes the nested schema fields if the type property is set to RECORD.
        :param pulumi.Input[str] max_length: [Optional] Maximum length of values of this field for STRINGS or BYTES. If max_length is not specified, no maximum length constraint is imposed on this field. If type = "STRING", then max_length represents the maximum UTF-8 length of strings in this field. If type = "BYTES", then max_length represents the maximum number of bytes in this field. It is invalid to set this field if type ≠ "STRING" and ≠ "BYTES".
        :param pulumi.Input[str] mode: [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default value is NULLABLE.
        :param pulumi.Input[str] name: [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and must start with a letter or underscore. The maximum length is 300 characters.
        :param pulumi.Input[str] precision: [Optional] Precision (maximum number of total digits in base 10) and scale (maximum number of digits in the fractional part in base 10) constraints for values of this field for NUMERIC or BIGNUMERIC. It is invalid to set precision or scale if type ≠ "NUMERIC" and ≠ "BIGNUMERIC". If precision and scale are not specified, no value range constraint is imposed on this field insofar as values are permitted by the type. Values of this NUMERIC or BIGNUMERIC field must be in this range when: - Precision (P) and scale (S) are specified: [-10P-S + 10-S, 10P-S - 10-S] - Precision (P) is specified but not scale (and thus scale is interpreted to be equal to zero): [-10P + 1, 10P - 1]. Acceptable values for precision and scale if both are specified: - If type = "NUMERIC": 1 ≤ precision - scale ≤ 29 and 0 ≤ scale ≤ 9. - If type = "BIGNUMERIC": 1 ≤ precision - scale ≤ 38 and 0 ≤ scale ≤ 38. Acceptable values for precision if only precision is specified but not scale (and thus scale is interpreted to be equal to zero): - If type = "NUMERIC": 1 ≤ precision ≤ 29. - If type = "BIGNUMERIC": 1 ≤ precision ≤ 38. If scale is specified but not precision, then it is invalid.
        :param pulumi.Input[str] scale: [Optional] See documentation for precision.
        :param pulumi.Input[str] type: [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as INTEGER), FLOAT, FLOAT64 (same as FLOAT), NUMERIC, BIGNUMERIC, BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE, TIME, DATETIME, INTERVAL, RECORD (where RECORD indicates that the field contains a nested schema) or STRUCT (same as RECORD).
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if default_value_expression is not None:
            pulumi.set(__self__, "default_value_expression", default_value_expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_tags is not None:
            pulumi.set(__self__, "policy_tags", policy_tags)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input['TableFieldSchemaCategoriesArgs']]:
        """
        [Optional] The categories attached to this field, used for field-level access control.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input['TableFieldSchemaCategoriesArgs']]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Collation specification of the field. It only can be set on string type field.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="defaultValueExpression")
    def default_value_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A SQL expression to specify the default value for this field. It can only be set for top level fields (columns). You can use struct or array expression to specify default value for the entire struct or array. The valid SQL expressions are: - Literals for all data types, including STRUCT and ARRAY. - Following functions: - CURRENT_TIMESTAMP - CURRENT_TIME - CURRENT_DATE - CURRENT_DATETIME - GENERATE_UUID - RAND - SESSION_USER - ST_GEOGPOINT - Struct or array composed with the above allowed functions, for example, [CURRENT_DATE(), DATE '2020-01-01']
        """
        return pulumi.get(self, "default_value_expression")

    @default_value_expression.setter
    def default_value_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value_expression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The field description. The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]]]:
        """
        [Optional] Describes the nested schema fields if the type property is set to RECORD.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Maximum length of values of this field for STRINGS or BYTES. If max_length is not specified, no maximum length constraint is imposed on this field. If type = "STRING", then max_length represents the maximum UTF-8 length of strings in this field. If type = "BYTES", then max_length represents the maximum number of bytes in this field. It is invalid to set this field if type ≠ "STRING" and ≠ "BYTES".
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default value is NULLABLE.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_), and must start with a letter or underscore. The maximum length is 300 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyTags")
    def policy_tags(self) -> Optional[pulumi.Input['TableFieldSchemaPolicyTagsArgs']]:
        return pulumi.get(self, "policy_tags")

    @policy_tags.setter
    def policy_tags(self, value: Optional[pulumi.Input['TableFieldSchemaPolicyTagsArgs']]):
        pulumi.set(self, "policy_tags", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Precision (maximum number of total digits in base 10) and scale (maximum number of digits in the fractional part in base 10) constraints for values of this field for NUMERIC or BIGNUMERIC. It is invalid to set precision or scale if type ≠ "NUMERIC" and ≠ "BIGNUMERIC". If precision and scale are not specified, no value range constraint is imposed on this field insofar as values are permitted by the type. Values of this NUMERIC or BIGNUMERIC field must be in this range when: - Precision (P) and scale (S) are specified: [-10P-S + 10-S, 10P-S - 10-S] - Precision (P) is specified but not scale (and thus scale is interpreted to be equal to zero): [-10P + 1, 10P - 1]. Acceptable values for precision and scale if both are specified: - If type = "NUMERIC": 1 ≤ precision - scale ≤ 29 and 0 ≤ scale ≤ 9. - If type = "BIGNUMERIC": 1 ≤ precision - scale ≤ 38 and 0 ≤ scale ≤ 38. Acceptable values for precision if only precision is specified but not scale (and thus scale is interpreted to be equal to zero): - If type = "NUMERIC": 1 ≤ precision ≤ 29. - If type = "BIGNUMERIC": 1 ≤ precision ≤ 38. If scale is specified but not precision, then it is invalid.
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] See documentation for precision.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as INTEGER), FLOAT, FLOAT64 (same as FLOAT), NUMERIC, BIGNUMERIC, BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE, TIME, DATETIME, INTERVAL, RECORD (where RECORD indicates that the field contains a nested schema) or STRUCT (same as RECORD).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TableReferenceArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_id: [Required] The ID of the dataset containing this table.
        :param pulumi.Input[str] project: [Required] The ID of the project containing this table.
        :param pulumi.Input[str] table_id: [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the project containing this table.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_id", value)


@pulumi.input_type
class TableSchemaArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]] fields: Describes the fields in a table.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]]]:
        """
        Describes the fields in a table.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableFieldSchemaArgs']]]]):
        pulumi.set(self, "fields", value)


@pulumi.input_type
class TimePartitioningArgs:
    def __init__(__self__, *,
                 expiration_ms: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 require_partition_filter: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expiration_ms: [Optional] Number of milliseconds for which to keep the storage for partitions in the table. The storage in a partition will have an expiration time of its partition time plus this value.
        :param pulumi.Input[str] field: [Beta] [Optional] If not set, the table is partitioned by pseudo column, referenced via either '_PARTITIONTIME' as TIMESTAMP type, or '_PARTITIONDATE' as DATE type. If field is specified, the table is instead partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        :param pulumi.Input[str] type: [Required] The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively. When the type is not specified, the default behavior is DAY.
        """
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Number of milliseconds for which to keep the storage for partitions in the table. The storage in a partition will have an expiration time of its partition time plus this value.
        """
        return pulumi.get(self, "expiration_ms")

    @expiration_ms.setter
    def expiration_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_ms", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        [Beta] [Optional] If not set, the table is partitioned by pseudo column, referenced via either '_PARTITIONTIME' as TIMESTAMP type, or '_PARTITIONDATE' as DATE type. If field is specified, the table is instead partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "require_partition_filter")

    @require_partition_filter.setter
    def require_partition_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_partition_filter", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively. When the type is not specified, the default behavior is DAY.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class UserDefinedFunctionResourceArgs:
    def __init__(__self__, *,
                 inline_code: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None):
        """
        This is used for defining User Defined Function (UDF) resources only when using legacy SQL. Users of Standard SQL should leverage either DDL (e.g. CREATE [TEMPORARY] FUNCTION ... ) or the Routines API to define UDF resources. For additional information on migrating, see: https://cloud.google.com/bigquery/docs/reference/standard-sql/migrating-from-legacy-sql#differences_in_user-defined_javascript_functions
        :param pulumi.Input[str] inline_code: [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        :param pulumi.Input[str] resource_uri: [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        if inline_code is not None:
            pulumi.set(__self__, "inline_code", inline_code)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="inlineCode")
    def inline_code(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] An inline resource that contains code for a user-defined function (UDF). Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        """
        return pulumi.get(self, "inline_code")

    @inline_code.setter
    def inline_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inline_code", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        [Pick one] A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class ViewDefinitionArgs:
    def __init__(__self__, *,
                 query: Optional[pulumi.Input[str]] = None,
                 use_explicit_column_names: Optional[pulumi.Input[bool]] = None,
                 use_legacy_sql: Optional[pulumi.Input[bool]] = None,
                 user_defined_function_resources: Optional[pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]]] = None):
        """
        :param pulumi.Input[str] query: [Required] A query that BigQuery executes when the view is referenced.
        :param pulumi.Input[bool] use_explicit_column_names: True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1, c2) AS ...' syntax. Can only be set using BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/
        :param pulumi.Input[bool] use_legacy_sql: Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ Queries and views that reference this view must use the same flag value.
        :param pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]] user_defined_function_resources: Describes user-defined function resources used in the query.
        """
        if query is not None:
            pulumi.set(__self__, "query", query)
        if use_explicit_column_names is not None:
            pulumi.set(__self__, "use_explicit_column_names", use_explicit_column_names)
        if use_legacy_sql is not None:
            pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)
        if user_defined_function_resources is not None:
            pulumi.set(__self__, "user_defined_function_resources", user_defined_function_resources)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        [Required] A query that BigQuery executes when the view is referenced.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="useExplicitColumnNames")
    def use_explicit_column_names(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the column names are explicitly specified. For example by using the 'CREATE VIEW v(c1, c2) AS ...' syntax. Can only be set using BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/
        """
        return pulumi.get(self, "use_explicit_column_names")

    @use_explicit_column_names.setter
    def use_explicit_column_names(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_explicit_column_names", value)

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-reference/ Queries and views that reference this view must use the same flag value.
        """
        return pulumi.get(self, "use_legacy_sql")

    @use_legacy_sql.setter
    def use_legacy_sql(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_legacy_sql", value)

    @property
    @pulumi.getter(name="userDefinedFunctionResources")
    def user_defined_function_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]]]:
        """
        Describes user-defined function resources used in the query.
        """
        return pulumi.get(self, "user_defined_function_resources")

    @user_defined_function_resources.setter
    def user_defined_function_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserDefinedFunctionResourceArgs']]]]):
        pulumi.set(self, "user_defined_function_resources", value)


