# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetClientGatewayResult',
    'AwaitableGetClientGatewayResult',
    'get_client_gateway',
    'get_client_gateway_output',
]

@pulumi.output_type
class GetClientGatewayResult:
    def __init__(__self__, client_connector_service=None, create_time=None, name=None, state=None, update_time=None):
        if client_connector_service and not isinstance(client_connector_service, str):
            raise TypeError("Expected argument 'client_connector_service' to be a str")
        pulumi.set(__self__, "client_connector_service", client_connector_service)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="clientConnectorService")
    def client_connector_service(self) -> str:
        """
        The client connector service name that the client gateway is associated to. Client Connector Services, named as follows: `projects/{project_id}/locations/{location_id}/client_connector_services/{client_connector_service_id}`.
        """
        return pulumi.get(self, "client_connector_service")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        [Output only] Create time stamp.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of resource. The name is ignored during creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The operational state of the gateway.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        [Output only] Update time stamp.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetClientGatewayResult(GetClientGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientGatewayResult(
            client_connector_service=self.client_connector_service,
            create_time=self.create_time,
            name=self.name,
            state=self.state,
            update_time=self.update_time)


def get_client_gateway(client_gateway_id: Optional[str] = None,
                       location: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientGatewayResult:
    """
    Gets details of a single ClientGateway.
    """
    __args__ = dict()
    __args__['clientGatewayId'] = client_gateway_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:beyondcorp/v1alpha:getClientGateway', __args__, opts=opts, typ=GetClientGatewayResult).value

    return AwaitableGetClientGatewayResult(
        client_connector_service=__ret__.client_connector_service,
        create_time=__ret__.create_time,
        name=__ret__.name,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_client_gateway)
def get_client_gateway_output(client_gateway_id: Optional[pulumi.Input[str]] = None,
                              location: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClientGatewayResult]:
    """
    Gets details of a single ClientGateway.
    """
    ...
