# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 analytics_region: pulumi.Input[str],
                 parent: pulumi.Input[str],
                 runtime_type: pulumi.Input['OrganizationRuntimeType'],
                 addons_config: Optional[pulumi.Input['GoogleCloudApigeeV1AddonsConfigArgs']] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input['OrganizationBillingType']] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 portal_disabled: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['GoogleCloudApigeeV1PropertiesArgs']] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['OrganizationType']] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[str] analytics_region: DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[str] parent: Required. Name of the GCP project in which to associate the Apigee organization. Pass the information as a query parameter using the following structure in your request: `projects/`
        :param pulumi.Input['OrganizationRuntimeType'] runtime_type: Runtime type of the Apigee organization based on the Apigee subscription purchased.
        :param pulumi.Input['GoogleCloudApigeeV1AddonsConfigArgs'] addons_config: Addon configurations of the Apigee organization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attributes: Not used by Apigee.
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        :param pulumi.Input['OrganizationBillingType'] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] customer_name: Not used by Apigee.
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[str] display_name: Display name for the Apigee organization. Unused, but reserved for future use.
        :param pulumi.Input[bool] portal_disabled: Configuration for the Portals settings.
        :param pulumi.Input['GoogleCloudApigeeV1PropertiesArgs'] properties: Properties defined in the Apigee organization profile.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        :param pulumi.Input['OrganizationType'] type: Not used by Apigee.
        """
        if analytics_region is not None:
            warnings.warn("""Required. DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).""", DeprecationWarning)
            pulumi.log.warn("""analytics_region is deprecated: Required. DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).""")
        pulumi.set(__self__, "analytics_region", analytics_region)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "runtime_type", runtime_type)
        if addons_config is not None:
            pulumi.set(__self__, "addons_config", addons_config)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if customer_name is not None:
            pulumi.set(__self__, "customer_name", customer_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if portal_disabled is not None:
            pulumi.set(__self__, "portal_disabled", portal_disabled)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if runtime_database_encryption_key_name is not None:
            pulumi.set(__self__, "runtime_database_encryption_key_name", runtime_database_encryption_key_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> pulumi.Input[str]:
        """
        DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @analytics_region.setter
    def analytics_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "analytics_region", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[str]:
        """
        Required. Name of the GCP project in which to associate the Apigee organization. Pass the information as a query parameter using the following structure in your request: `projects/`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Input['OrganizationRuntimeType']:
        """
        Runtime type of the Apigee organization based on the Apigee subscription purchased.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: pulumi.Input['OrganizationRuntimeType']):
        pulumi.set(self, "runtime_type", value)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1AddonsConfigArgs']]:
        """
        Addon configurations of the Apigee organization.
        """
        return pulumi.get(self, "addons_config")

    @addons_config.setter
    def addons_config(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1AddonsConfigArgs']]):
        pulumi.set(self, "addons_config", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input['OrganizationBillingType']]:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input['OrganizationBillingType']]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "customer_name")

    @customer_name.setter
    def customer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for the Apigee organization. Unused, but reserved for future use.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="portalDisabled")
    def portal_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Configuration for the Portals settings.
        """
        return pulumi.get(self, "portal_disabled")

    @portal_disabled.setter
    def portal_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "portal_disabled", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1PropertiesArgs']]:
        """
        Properties defined in the Apigee organization profile.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1PropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @runtime_database_encryption_key_name.setter
    def runtime_database_encryption_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_database_encryption_key_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['OrganizationType']]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['OrganizationType']]):
        pulumi.set(self, "type", value)


class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AddonsConfigArgs']]] = None,
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input['OrganizationBillingType']] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 portal_disabled: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1PropertiesArgs']]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input['OrganizationRuntimeType']] = None,
                 type: Optional[pulumi.Input['OrganizationType']] = None,
                 __props__=None):
        """
        Creates an Apigee organization. See [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AddonsConfigArgs']] addons_config: Addon configurations of the Apigee organization.
        :param pulumi.Input[str] analytics_region: DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attributes: Not used by Apigee.
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        :param pulumi.Input['OrganizationBillingType'] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] customer_name: Not used by Apigee.
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[str] display_name: Display name for the Apigee organization. Unused, but reserved for future use.
        :param pulumi.Input[str] parent: Required. Name of the GCP project in which to associate the Apigee organization. Pass the information as a query parameter using the following structure in your request: `projects/`
        :param pulumi.Input[bool] portal_disabled: Configuration for the Portals settings.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1PropertiesArgs']] properties: Properties defined in the Apigee organization profile.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        :param pulumi.Input['OrganizationRuntimeType'] runtime_type: Runtime type of the Apigee organization based on the Apigee subscription purchased.
        :param pulumi.Input['OrganizationType'] type: Not used by Apigee.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Apigee organization. See [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AddonsConfigArgs']]] = None,
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input['OrganizationBillingType']] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 portal_disabled: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1PropertiesArgs']]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input['OrganizationRuntimeType']] = None,
                 type: Optional[pulumi.Input['OrganizationType']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["addons_config"] = addons_config
            if analytics_region is None and not opts.urn:
                raise TypeError("Missing required property 'analytics_region'")
            if analytics_region is not None and not opts.urn:
                warnings.warn("""Required. DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).""", DeprecationWarning)
                pulumi.log.warn("""analytics_region is deprecated: Required. DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).""")
            __props__.__dict__["analytics_region"] = analytics_region
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorized_network"] = authorized_network
            __props__.__dict__["billing_type"] = billing_type
            __props__.__dict__["customer_name"] = customer_name
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["portal_disabled"] = portal_disabled
            __props__.__dict__["properties"] = properties
            __props__.__dict__["runtime_database_encryption_key_name"] = runtime_database_encryption_key_name
            if runtime_type is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_type'")
            __props__.__dict__["runtime_type"] = runtime_type
            __props__.__dict__["type"] = type
            __props__.__dict__["apigee_project_id"] = None
            __props__.__dict__["ca_certificate"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["environments"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["last_modified_at"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["project"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subscription_type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["parent"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Organization, __self__).__init__(
            'google-native:apigee/v1:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OrganizationArgs.__new__(OrganizationArgs)

        __props__.__dict__["addons_config"] = None
        __props__.__dict__["analytics_region"] = None
        __props__.__dict__["apigee_project_id"] = None
        __props__.__dict__["attributes"] = None
        __props__.__dict__["authorized_network"] = None
        __props__.__dict__["billing_type"] = None
        __props__.__dict__["ca_certificate"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["customer_name"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["environments"] = None
        __props__.__dict__["expires_at"] = None
        __props__.__dict__["last_modified_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parent"] = None
        __props__.__dict__["portal_disabled"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["runtime_database_encryption_key_name"] = None
        __props__.__dict__["runtime_type"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["subscription_type"] = None
        __props__.__dict__["type"] = None
        return Organization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1AddonsConfigResponse']:
        """
        Addon configurations of the Apigee organization.
        """
        return pulumi.get(self, "addons_config")

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> pulumi.Output[str]:
        """
        DEPRECATED: This field will be deprecated once Apigee supports DRZ. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @property
    @pulumi.getter(name="apigeeProjectId")
    def apigee_project_id(self) -> pulumi.Output[str]:
        """
        Apigee Project ID associated with the organization. Use this project to allowlist Apigee in the Service Attachment when using private service connect with Apigee.
        """
        return pulumi.get(self, "apigee_project_id")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence[str]]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[str]:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[str]:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[str]:
        """
        Base64-encoded public certificate for the root CA of the Apigee organization. Valid only when [RuntimeType](#RuntimeType) is `CLOUD`.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time that the Apigee organization was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> pulumi.Output[str]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "customer_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name for the Apigee organization. Unused, but reserved for future use.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Sequence[str]]:
        """
        List of environments in the Apigee organization.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[str]:
        """
        Time that the Apigee organization is scheduled for deletion.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[str]:
        """
        Time that the Apigee organization was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        Required. Name of the GCP project in which to associate the Apigee organization. Pass the information as a query parameter using the following structure in your request: `projects/`
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="portalDisabled")
    def portal_disabled(self) -> pulumi.Output[bool]:
        """
        Configuration for the Portals settings.
        """
        return pulumi.get(self, "portal_disabled")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project ID associated with the Apigee organization.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1PropertiesResponse']:
        """
        Properties defined in the Apigee organization profile.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> pulumi.Output[str]:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[str]:
        """
        Runtime type of the Apigee organization based on the Apigee subscription purchased.
        """
        return pulumi.get(self, "runtime_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the organization. Values other than ACTIVE means the resource is not ready to use.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[str]:
        """
        DEPRECATED: This will eventually be replaced by BillingType. Subscription type of the Apigee organization. Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased). See [Apigee pricing](https://cloud.google.com/apigee/pricing/).
        """
        return pulumi.get(self, "subscription_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "type")

