# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetResourcefileResult',
    'AwaitableGetResourcefileResult',
    'get_resourcefile',
    'get_resourcefile_output',
]

@pulumi.output_type
class GetResourcefileResult:
    def __init__(__self__, content_type=None, data=None, extensions=None):
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if extensions and not isinstance(extensions, list):
            raise TypeError("Expected argument 'extensions' to be a list")
        pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The HTTP Content-Type header value specifying the content type of the body.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The HTTP request/response body as raw binary.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def extensions(self) -> Sequence[Mapping[str, str]]:
        """
        Application specific response metadata. Must be set in the first response for streaming APIs.
        """
        return pulumi.get(self, "extensions")


class AwaitableGetResourcefileResult(GetResourcefileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcefileResult(
            content_type=self.content_type,
            data=self.data,
            extensions=self.extensions)


def get_resourcefile(environment_id: Optional[str] = None,
                     name: Optional[str] = None,
                     organization_id: Optional[str] = None,
                     type: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcefileResult:
    """
    Gets the contents of a resource file. For more information about resource files, see [Resource files](https://cloud.google.com/apigee/docs/api-platform/develop/resource-files).
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    __args__['type'] = type
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getResourcefile', __args__, opts=opts, typ=GetResourcefileResult).value

    return AwaitableGetResourcefileResult(
        content_type=__ret__.content_type,
        data=__ret__.data,
        extensions=__ret__.extensions)


@_utilities.lift_output_func(get_resourcefile)
def get_resourcefile_output(environment_id: Optional[pulumi.Input[str]] = None,
                            name: Optional[pulumi.Input[str]] = None,
                            organization_id: Optional[pulumi.Input[str]] = None,
                            type: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourcefileResult]:
    """
    Gets the contents of a resource file. For more information about resource files, see [Resource files](https://cloud.google.com/apigee/docs/api-platform/develop/resource-files).
    """
    ...
