# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetReportResult',
    'AwaitableGetReportResult',
    'get_report',
    'get_report_output',
]

@pulumi.output_type
class GetReportResult:
    def __init__(__self__, chart_type=None, comments=None, created_at=None, dimensions=None, display_name=None, environment=None, filter=None, from_time=None, last_modified_at=None, last_viewed_at=None, limit=None, metrics=None, name=None, offset=None, organization=None, properties=None, sort_by_cols=None, sort_order=None, tags=None, time_unit=None, to_time=None, topk=None):
        if chart_type and not isinstance(chart_type, str):
            raise TypeError("Expected argument 'chart_type' to be a str")
        pulumi.set(__self__, "chart_type", chart_type)
        if comments and not isinstance(comments, list):
            raise TypeError("Expected argument 'comments' to be a list")
        pulumi.set(__self__, "comments", comments)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if dimensions and not isinstance(dimensions, list):
            raise TypeError("Expected argument 'dimensions' to be a list")
        pulumi.set(__self__, "dimensions", dimensions)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if from_time and not isinstance(from_time, str):
            raise TypeError("Expected argument 'from_time' to be a str")
        pulumi.set(__self__, "from_time", from_time)
        if last_modified_at and not isinstance(last_modified_at, str):
            raise TypeError("Expected argument 'last_modified_at' to be a str")
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_viewed_at and not isinstance(last_viewed_at, str):
            raise TypeError("Expected argument 'last_viewed_at' to be a str")
        pulumi.set(__self__, "last_viewed_at", last_viewed_at)
        if limit and not isinstance(limit, str):
            raise TypeError("Expected argument 'limit' to be a str")
        pulumi.set(__self__, "limit", limit)
        if metrics and not isinstance(metrics, list):
            raise TypeError("Expected argument 'metrics' to be a list")
        pulumi.set(__self__, "metrics", metrics)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if offset and not isinstance(offset, str):
            raise TypeError("Expected argument 'offset' to be a str")
        pulumi.set(__self__, "offset", offset)
        if organization and not isinstance(organization, str):
            raise TypeError("Expected argument 'organization' to be a str")
        pulumi.set(__self__, "organization", organization)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if sort_by_cols and not isinstance(sort_by_cols, list):
            raise TypeError("Expected argument 'sort_by_cols' to be a list")
        pulumi.set(__self__, "sort_by_cols", sort_by_cols)
        if sort_order and not isinstance(sort_order, str):
            raise TypeError("Expected argument 'sort_order' to be a str")
        pulumi.set(__self__, "sort_order", sort_order)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if time_unit and not isinstance(time_unit, str):
            raise TypeError("Expected argument 'time_unit' to be a str")
        pulumi.set(__self__, "time_unit", time_unit)
        if to_time and not isinstance(to_time, str):
            raise TypeError("Expected argument 'to_time' to be a str")
        pulumi.set(__self__, "to_time", to_time)
        if topk and not isinstance(topk, str):
            raise TypeError("Expected argument 'topk' to be a str")
        pulumi.set(__self__, "topk", topk)

    @property
    @pulumi.getter(name="chartType")
    def chart_type(self) -> str:
        """
        This field contains the chart type for the report
        """
        return pulumi.get(self, "chart_type")

    @property
    @pulumi.getter
    def comments(self) -> Sequence[str]:
        """
        Legacy field: not used. This field contains a list of comments associated with custom report
        """
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Unix time when the app was created json key: createdAt
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence[str]:
        """
        This contains the list of dimensions for the report
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        This is the display name for the report
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environment(self) -> str:
        """
        Environment name
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        This field contains the filter expression
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> str:
        """
        Legacy field: not used. Contains the from time for the report
        """
        return pulumi.get(self, "from_time")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        Modified time of this entity as milliseconds since epoch. json key: lastModifiedAt
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastViewedAt")
    def last_viewed_at(self) -> str:
        """
        Last viewed time of this entity as milliseconds since epoch
        """
        return pulumi.get(self, "last_viewed_at")

    @property
    @pulumi.getter
    def limit(self) -> str:
        """
        Legacy field: not used This field contains the limit for the result retrieved
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GoogleCloudApigeeV1CustomReportMetricResponse']:
        """
        This contains the list of metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the report T his is a legacy field used to encode custom report unique id
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offset(self) -> str:
        """
        Legacy field: not used. This field contains the offset for the data
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Organization name
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GoogleCloudApigeeV1ReportPropertyResponse']:
        """
        This field contains report properties such as ui metadata etc.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="sortByCols")
    def sort_by_cols(self) -> Sequence[str]:
        """
        Legacy field: not used much. Contains the list of sort by columns
        """
        return pulumi.get(self, "sort_by_cols")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> str:
        """
        Legacy field: not used much. Contains the sort order for the sort columns
        """
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Legacy field: not used. This field contains a list of tags associated with custom report
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        This field contains the time unit of aggregation for the report
        """
        return pulumi.get(self, "time_unit")

    @property
    @pulumi.getter(name="toTime")
    def to_time(self) -> str:
        """
        Legacy field: not used. Contains the end time for the report
        """
        return pulumi.get(self, "to_time")

    @property
    @pulumi.getter
    def topk(self) -> str:
        """
        Legacy field: not used. This field contains the top k parameter value for restricting the result
        """
        return pulumi.get(self, "topk")


class AwaitableGetReportResult(GetReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReportResult(
            chart_type=self.chart_type,
            comments=self.comments,
            created_at=self.created_at,
            dimensions=self.dimensions,
            display_name=self.display_name,
            environment=self.environment,
            filter=self.filter,
            from_time=self.from_time,
            last_modified_at=self.last_modified_at,
            last_viewed_at=self.last_viewed_at,
            limit=self.limit,
            metrics=self.metrics,
            name=self.name,
            offset=self.offset,
            organization=self.organization,
            properties=self.properties,
            sort_by_cols=self.sort_by_cols,
            sort_order=self.sort_order,
            tags=self.tags,
            time_unit=self.time_unit,
            to_time=self.to_time,
            topk=self.topk)


def get_report(organization_id: Optional[str] = None,
               report_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReportResult:
    """
    Retrieve a custom report definition.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['reportId'] = report_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getReport', __args__, opts=opts, typ=GetReportResult).value

    return AwaitableGetReportResult(
        chart_type=__ret__.chart_type,
        comments=__ret__.comments,
        created_at=__ret__.created_at,
        dimensions=__ret__.dimensions,
        display_name=__ret__.display_name,
        environment=__ret__.environment,
        filter=__ret__.filter,
        from_time=__ret__.from_time,
        last_modified_at=__ret__.last_modified_at,
        last_viewed_at=__ret__.last_viewed_at,
        limit=__ret__.limit,
        metrics=__ret__.metrics,
        name=__ret__.name,
        offset=__ret__.offset,
        organization=__ret__.organization,
        properties=__ret__.properties,
        sort_by_cols=__ret__.sort_by_cols,
        sort_order=__ret__.sort_order,
        tags=__ret__.tags,
        time_unit=__ret__.time_unit,
        to_time=__ret__.to_time,
        topk=__ret__.topk)


@_utilities.lift_output_func(get_report)
def get_report_output(organization_id: Optional[pulumi.Input[str]] = None,
                      report_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReportResult]:
    """
    Retrieve a custom report definition.
    """
    ...
