# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CanaryEvaluationArgs', 'CanaryEvaluation']

@pulumi.input_type
class CanaryEvaluationArgs:
    def __init__(__self__, *,
                 control: pulumi.Input[str],
                 end_time: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 metric_labels: pulumi.Input['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs'],
                 organization_id: pulumi.Input[str],
                 start_time: pulumi.Input[str],
                 treatment: pulumi.Input[str]):
        """
        The set of arguments for constructing a CanaryEvaluation resource.
        :param pulumi.Input[str] control: The stable version that is serving requests.
        :param pulumi.Input[str] end_time: End time for the evaluation's analysis.
        :param pulumi.Input['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs'] metric_labels: Labels used to filter the metrics used for a canary evaluation.
        :param pulumi.Input[str] start_time: Start time for the canary evaluation's analysis.
        :param pulumi.Input[str] treatment: The newer version that is serving requests.
        """
        pulumi.set(__self__, "control", control)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "metric_labels", metric_labels)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "treatment", treatment)

    @property
    @pulumi.getter
    def control(self) -> pulumi.Input[str]:
        """
        The stable version that is serving requests.
        """
        return pulumi.get(self, "control")

    @control.setter
    def control(self, value: pulumi.Input[str]):
        pulumi.set(self, "control", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[str]:
        """
        End time for the evaluation's analysis.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="metricLabels")
    def metric_labels(self) -> pulumi.Input['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs']:
        """
        Labels used to filter the metrics used for a canary evaluation.
        """
        return pulumi.get(self, "metric_labels")

    @metric_labels.setter
    def metric_labels(self, value: pulumi.Input['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs']):
        pulumi.set(self, "metric_labels", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Start time for the canary evaluation's analysis.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def treatment(self) -> pulumi.Input[str]:
        """
        The newer version that is serving requests.
        """
        return pulumi.get(self, "treatment")

    @treatment.setter
    def treatment(self, value: pulumi.Input[str]):
        pulumi.set(self, "treatment", value)


class CanaryEvaluation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 metric_labels: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs']]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 treatment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new canary evaluation for an organization.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] control: The stable version that is serving requests.
        :param pulumi.Input[str] end_time: End time for the evaluation's analysis.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs']] metric_labels: Labels used to filter the metrics used for a canary evaluation.
        :param pulumi.Input[str] start_time: Start time for the canary evaluation's analysis.
        :param pulumi.Input[str] treatment: The newer version that is serving requests.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CanaryEvaluationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new canary evaluation for an organization.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param CanaryEvaluationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CanaryEvaluationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 metric_labels: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs']]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 treatment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CanaryEvaluationArgs.__new__(CanaryEvaluationArgs)

            if control is None and not opts.urn:
                raise TypeError("Missing required property 'control'")
            __props__.__dict__["control"] = control
            if end_time is None and not opts.urn:
                raise TypeError("Missing required property 'end_time'")
            __props__.__dict__["end_time"] = end_time
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if metric_labels is None and not opts.urn:
                raise TypeError("Missing required property 'metric_labels'")
            __props__.__dict__["metric_labels"] = metric_labels
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            if treatment is None and not opts.urn:
                raise TypeError("Missing required property 'treatment'")
            __props__.__dict__["treatment"] = treatment
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["verdict"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instance_id", "organization_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CanaryEvaluation, __self__).__init__(
            'google-native:apigee/v1:CanaryEvaluation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CanaryEvaluation':
        """
        Get an existing CanaryEvaluation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CanaryEvaluationArgs.__new__(CanaryEvaluationArgs)

        __props__.__dict__["control"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["end_time"] = None
        __props__.__dict__["instance_id"] = None
        __props__.__dict__["metric_labels"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["organization_id"] = None
        __props__.__dict__["start_time"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["treatment"] = None
        __props__.__dict__["verdict"] = None
        return CanaryEvaluation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def control(self) -> pulumi.Output[str]:
        """
        The stable version that is serving requests.
        """
        return pulumi.get(self, "control")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Create time of the canary evaluation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        End time for the evaluation's analysis.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="metricLabels")
    def metric_labels(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse']:
        """
        Labels used to filter the metrics used for a canary evaluation.
        """
        return pulumi.get(self, "metric_labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the canary evalution.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Start time for the canary evaluation's analysis.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the canary evaluation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def treatment(self) -> pulumi.Output[str]:
        """
        The newer version that is serving requests.
        """
        return pulumi.get(self, "treatment")

    @property
    @pulumi.getter
    def verdict(self) -> pulumi.Output[str]:
        """
        The resulting verdict of the canary evaluations: NONE, PASS, or FAIL.
        """
        return pulumi.get(self, "verdict")

