# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApiOperationArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BasicLevelArgs',
    'BindingArgs',
    'ConditionArgs',
    'CustomLevelArgs',
    'DevicePolicyArgs',
    'EgressFromArgs',
    'EgressPolicyArgs',
    'EgressToArgs',
    'ExprArgs',
    'IngressFromArgs',
    'IngressPolicyArgs',
    'IngressSourceArgs',
    'IngressToArgs',
    'MethodSelectorArgs',
    'OsConstraintArgs',
    'ServicePerimeterConfigArgs',
    'VpcAccessibleServicesArgs',
]

@pulumi.input_type
class ApiOperationArgs:
    def __init__(__self__, *,
                 method_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['MethodSelectorArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Identification for an API Operation.
        :param pulumi.Input[Sequence[pulumi.Input['MethodSelectorArgs']]] method_selectors: API methods or permissions to allow. Method or permission must belong to the service specified by `service_name` field. A single MethodSelector entry with `*` specified for the `method` field will allow all methods AND permissions for the service specified in `service_name`.
        :param pulumi.Input[str] service_name: The name of the API whose methods or permissions the IngressPolicy or EgressPolicy want to allow. A single ApiOperation with `service_name` field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MethodSelectorArgs']]]]:
        """
        API methods or permissions to allow. Method or permission must belong to the service specified by `service_name` field. A single MethodSelector entry with `*` specified for the `method` field will allow all methods AND permissions for the service specified in `service_name`.
        """
        return pulumi.get(self, "method_selectors")

    @method_selectors.setter
    def method_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MethodSelectorArgs']]]]):
        pulumi.set(self, "method_selectors", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the API whose methods or permissions the IngressPolicy or EgressPolicy want to allow. A single ApiOperation with `service_name` field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BasicLevelArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]],
                 combining_function: Optional[pulumi.Input['BasicLevelCombiningFunction']] = None):
        """
        `BasicLevel` is an `AccessLevel` using a set of recommended features.
        :param pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]] conditions: A list of requirements for the `AccessLevel` to be granted.
        :param pulumi.Input['BasicLevelCombiningFunction'] combining_function: How the `conditions` list should be combined to determine if a request is granted this `AccessLevel`. If AND is used, each `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. If OR is used, at least one `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. Default behavior is AND.
        """
        pulumi.set(__self__, "conditions", conditions)
        if combining_function is not None:
            pulumi.set(__self__, "combining_function", combining_function)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]:
        """
        A list of requirements for the `AccessLevel` to be granted.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> Optional[pulumi.Input['BasicLevelCombiningFunction']]:
        """
        How the `conditions` list should be combined to determine if a request is granted this `AccessLevel`. If AND is used, each `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. If OR is used, at least one `Condition` in `conditions` must be satisfied for the `AccessLevel` to be applied. Default behavior is AND.
        """
        return pulumi.get(self, "combining_function")

    @combining_function.setter
    def combining_function(self, value: Optional[pulumi.Input['BasicLevelCombiningFunction']]):
        pulumi.set(self, "combining_function", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ConditionArgs:
    def __init__(__self__, *,
                 device_policy: Optional[pulumi.Input['DevicePolicyArgs']] = None,
                 ip_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A condition necessary for an `AccessLevel` to be granted. The Condition is an AND over its fields. So a Condition is true if: 1) the request IP is from one of the listed subnetworks AND 2) the originating device complies with the listed device policy AND 3) all listed access levels are granted AND 4) the request was sent at a time allowed by the DateTimeRestriction.
        :param pulumi.Input['DevicePolicyArgs'] device_policy: Device specific restrictions, all restrictions must hold for the Condition to be true. If not specified, all devices are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_subnetworks: CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: The request must be made by one of the provided user or service accounts. Groups are not supported. Syntax: `user:{emailid}` `serviceAccount:{emailid}` If not specified, a request may come from any user.
        :param pulumi.Input[bool] negate: Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The request must originate from one of the provided countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_access_levels: A list of other access levels defined in the same `Policy`, referenced by resource name. Referencing an `AccessLevel` which does not exist is an error. All access levels listed must be granted for the Condition to be true. Example: "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
        """
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional[pulumi.Input['DevicePolicyArgs']]:
        """
        Device specific restrictions, all restrictions must hold for the Condition to be true. If not specified, all devices are allowed.
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: Optional[pulumi.Input['DevicePolicyArgs']]):
        pulumi.set(self, "device_policy", value)

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @ip_subnetworks.setter
    def ip_subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_subnetworks", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The request must be made by one of the provided user or service accounts. Groups are not supported. Syntax: `user:{emailid}` `serviceAccount:{emailid}` If not specified, a request may come from any user.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The request must originate from one of the provided countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of other access levels defined in the same `Policy`, referenced by resource name. Referencing an `AccessLevel` which does not exist is an error. All access levels listed must be granted for the Condition to be true. Example: "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
        """
        return pulumi.get(self, "required_access_levels")

    @required_access_levels.setter
    def required_access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_access_levels", value)


@pulumi.input_type
class CustomLevelArgs:
    def __init__(__self__, *,
                 expr: pulumi.Input['ExprArgs']):
        """
        `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request. See CEL spec at: https://github.com/google/cel-spec
        :param pulumi.Input['ExprArgs'] expr: A Cloud CEL expression evaluating to a boolean.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> pulumi.Input['ExprArgs']:
        """
        A Cloud CEL expression evaluating to a boolean.
        """
        return pulumi.get(self, "expr")

    @expr.setter
    def expr(self, value: pulumi.Input['ExprArgs']):
        pulumi.set(self, "expr", value)


@pulumi.input_type
class DevicePolicyArgs:
    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedDeviceManagementLevelsItem']]]] = None,
                 allowed_encryption_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedEncryptionStatusesItem']]]] = None,
                 os_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['OsConstraintArgs']]]] = None,
                 require_admin_approval: Optional[pulumi.Input[bool]] = None,
                 require_corp_owned: Optional[pulumi.Input[bool]] = None,
                 require_screenlock: Optional[pulumi.Input[bool]] = None):
        """
        `DevicePolicy` specifies device specific restrictions necessary to acquire a given access level. A `DevicePolicy` specifies requirements for requests from devices to be granted access levels, it does not do any enforcement on the device. `DevicePolicy` acts as an AND over all specified fields, and each repeated field is an OR over its elements. Any unset fields are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS, os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be true for requests originating from encrypted Linux desktops and encrypted Windows desktops.
        :param pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedDeviceManagementLevelsItem']]] allowed_device_management_levels: Allowed device management levels, an empty list allows all management levels.
        :param pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedEncryptionStatusesItem']]] allowed_encryption_statuses: Allowed encryptions statuses, an empty list allows all statuses.
        :param pulumi.Input[Sequence[pulumi.Input['OsConstraintArgs']]] os_constraints: Allowed OS versions, an empty list allows all types and all versions.
        :param pulumi.Input[bool] require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param pulumi.Input[bool] require_corp_owned: Whether the device needs to be corp owned.
        :param pulumi.Input[bool] require_screenlock: Whether or not screenlock is required for the DevicePolicy to be true. Defaults to `false`.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screenlock is not None:
            pulumi.set(__self__, "require_screenlock", require_screenlock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedDeviceManagementLevelsItem']]]]:
        """
        Allowed device management levels, an empty list allows all management levels.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @allowed_device_management_levels.setter
    def allowed_device_management_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedDeviceManagementLevelsItem']]]]):
        pulumi.set(self, "allowed_device_management_levels", value)

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedEncryptionStatusesItem']]]]:
        """
        Allowed encryptions statuses, an empty list allows all statuses.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @allowed_encryption_statuses.setter
    def allowed_encryption_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePolicyAllowedEncryptionStatusesItem']]]]):
        pulumi.set(self, "allowed_encryption_statuses", value)

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OsConstraintArgs']]]]:
        """
        Allowed OS versions, an empty list allows all types and all versions.
        """
        return pulumi.get(self, "os_constraints")

    @os_constraints.setter
    def os_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OsConstraintArgs']]]]):
        pulumi.set(self, "os_constraints", value)

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @require_admin_approval.setter
    def require_admin_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_admin_approval", value)

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @require_corp_owned.setter
    def require_corp_owned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_corp_owned", value)

    @property
    @pulumi.getter(name="requireScreenlock")
    def require_screenlock(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not screenlock is required for the DevicePolicy to be true. Defaults to `false`.
        """
        return pulumi.get(self, "require_screenlock")

    @require_screenlock.setter
    def require_screenlock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_screenlock", value)


@pulumi.input_type
class EgressFromArgs:
    def __init__(__self__, *,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identity_type: Optional[pulumi.Input['EgressFromIdentityType']] = None):
        """
        Defines the conditions under which an EgressPolicy matches a request. Conditions based on information about the source of the request. Note that if the destination of the request is also protected by a ServicePerimeter, then that ServicePerimeter must have an IngressPolicy which allows access in order for this request to succeed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: A list of identities that are allowed access through this [EgressPolicy]. Should be in the format of email address. The email address should represent individual user or service account only.
        :param pulumi.Input['EgressFromIdentityType'] identity_type: Specifies the type of identities that are allowed access to outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of identities that are allowed access through this [EgressPolicy]. Should be in the format of email address. The email address should represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[pulumi.Input['EgressFromIdentityType']]:
        """
        Specifies the type of identities that are allowed access to outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: Optional[pulumi.Input['EgressFromIdentityType']]):
        pulumi.set(self, "identity_type", value)


@pulumi.input_type
class EgressPolicyArgs:
    def __init__(__self__, *,
                 egress_from: Optional[pulumi.Input['EgressFromArgs']] = None,
                 egress_to: Optional[pulumi.Input['EgressToArgs']] = None):
        """
        Policy for egress from perimeter. EgressPolicies match requests based on `egress_from` and `egress_to` stanzas. For an EgressPolicy to match, both `egress_from` and `egress_to` stanzas must be matched. If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter boundary. For example, an EgressPolicy can be used to allow VMs on networks within the ServicePerimeter to access a defined set of projects outside the perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket or query against a BigQuery dataset). EgressPolicies are concerned with the *resources* that a request relates as well as the API services and API actions being used. They do not related to the direction of data movement. More detailed documentation for this concept can be found in the descriptions of EgressFrom and EgressTo.
        :param pulumi.Input['EgressFromArgs'] egress_from: Defines conditions on the source of a request causing this EgressPolicy to apply.
        :param pulumi.Input['EgressToArgs'] egress_to: Defines the conditions on the ApiOperation and destination resources that cause this EgressPolicy to apply.
        """
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional[pulumi.Input['EgressFromArgs']]:
        """
        Defines conditions on the source of a request causing this EgressPolicy to apply.
        """
        return pulumi.get(self, "egress_from")

    @egress_from.setter
    def egress_from(self, value: Optional[pulumi.Input['EgressFromArgs']]):
        pulumi.set(self, "egress_from", value)

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional[pulumi.Input['EgressToArgs']]:
        """
        Defines the conditions on the ApiOperation and destination resources that cause this EgressPolicy to apply.
        """
        return pulumi.get(self, "egress_to")

    @egress_to.setter
    def egress_to(self, value: Optional[pulumi.Input['EgressToArgs']]):
        pulumi.set(self, "egress_to", value)


@pulumi.input_type
class EgressToArgs:
    def __init__(__self__, *,
                 external_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines the conditions under which an EgressPolicy matches a request. Conditions are based on information about the ApiOperation intended to be performed on the `resources` specified. Note that if the destination of the request is also protected by a ServicePerimeter, then that ServicePerimeter must have an IngressPolicy which allows access in order for this request to succeed. The request must match `operations` AND `resources` fields in order to be allowed egress out of the perimeter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_resources: A list of external resources that are allowed to be accessed. Only AWS and Azure resources are supported. For Amazon S3, the supported format is s3://BUCKET_NAME. For Azure Storage, the supported format is azure://myaccount.blob.core.windows.net/CONTAINER_NAME. A request matches if it contains an external resource in this list (Example: s3://bucket/path). Currently '*' is not allowed.
        :param pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]] operations: A list of ApiOperations allowed to be performed by the sources specified in the corresponding EgressFrom. A request matches if it uses an operation/service in this list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: A list of resources, currently only projects in the form `projects/`, that are allowed to be accessed by sources defined in the corresponding EgressFrom. A request matches if it contains a resource in this list. If `*` is specified for `resources`, then this EgressTo rule will authorize access to all resources outside the perimeter.
        """
        if external_resources is not None:
            pulumi.set(__self__, "external_resources", external_resources)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="externalResources")
    def external_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of external resources that are allowed to be accessed. Only AWS and Azure resources are supported. For Amazon S3, the supported format is s3://BUCKET_NAME. For Azure Storage, the supported format is azure://myaccount.blob.core.windows.net/CONTAINER_NAME. A request matches if it contains an external resource in this list (Example: s3://bucket/path). Currently '*' is not allowed.
        """
        return pulumi.get(self, "external_resources")

    @external_resources.setter
    def external_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_resources", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]]]:
        """
        A list of ApiOperations allowed to be performed by the sources specified in the corresponding EgressFrom. A request matches if it uses an operation/service in this list.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of resources, currently only projects in the form `projects/`, that are allowed to be accessed by sources defined in the corresponding EgressFrom. A request matches if it contains a resource in this list. If `*` is specified for `resources`, then this EgressTo rule will authorize access to all resources outside the perimeter.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class IngressFromArgs:
    def __init__(__self__, *,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identity_type: Optional[pulumi.Input['IngressFromIdentityType']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['IngressSourceArgs']]]] = None):
        """
        Defines the conditions under which an IngressPolicy matches a request. Conditions are based on information about the source of the request. The request must satisfy what is defined in `sources` AND identity related fields in order to match.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: A list of identities that are allowed access through this ingress policy. Should be in the format of email address. The email address should represent individual user or service account only.
        :param pulumi.Input['IngressFromIdentityType'] identity_type: Specifies the type of identities that are allowed access from outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        :param pulumi.Input[Sequence[pulumi.Input['IngressSourceArgs']]] sources: Sources that this IngressPolicy authorizes access from.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of identities that are allowed access through this ingress policy. Should be in the format of email address. The email address should represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[pulumi.Input['IngressFromIdentityType']]:
        """
        Specifies the type of identities that are allowed access from outside the perimeter. If left unspecified, then members of `identities` field will be allowed access.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: Optional[pulumi.Input['IngressFromIdentityType']]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressSourceArgs']]]]:
        """
        Sources that this IngressPolicy authorizes access from.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressSourceArgs']]]]):
        pulumi.set(self, "sources", value)


@pulumi.input_type
class IngressPolicyArgs:
    def __init__(__self__, *,
                 ingress_from: Optional[pulumi.Input['IngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['IngressToArgs']] = None):
        """
        Policy for ingress into ServicePerimeter. IngressPolicies match requests based on `ingress_from` and `ingress_to` stanzas. For an ingress policy to match, both the `ingress_from` and `ingress_to` stanzas must be matched. If an IngressPolicy matches a request, the request is allowed through the perimeter boundary from outside the perimeter. For example, access from the internet can be allowed either based on an AccessLevel or, for traffic hosted on Google Cloud, the project of the source network. For access from private networks, using the project of the hosting network is required. Individual ingress policies can be limited by restricting which services and/or actions they match using the `ingress_to` field.
        :param pulumi.Input['IngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this IngressPolicy to apply.
        :param pulumi.Input['IngressToArgs'] ingress_to: Defines the conditions on the ApiOperation and request destination that cause this IngressPolicy to apply.
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['IngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this IngressPolicy to apply.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['IngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['IngressToArgs']]:
        """
        Defines the conditions on the ApiOperation and request destination that cause this IngressPolicy to apply.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['IngressToArgs']]):
        pulumi.set(self, "ingress_to", value)


@pulumi.input_type
class IngressSourceArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[str]] = None):
        """
        The source that IngressPolicy authorizes access from.
        :param pulumi.Input[str] access_level: An AccessLevel resource name that allow resources within the ServicePerimeters to be accessed from the internet. AccessLevels listed must be in the same policy as this ServicePerimeter. Referencing a nonexistent AccessLevel will cause an error. If no AccessLevel names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`. If a single `*` is specified for `access_level`, then all IngressSources will be allowed.
        :param pulumi.Input[str] resource: A Google Cloud resource that is allowed to ingress the perimeter. Requests from these resources will be allowed to access perimeter data. Currently only projects are allowed. Format: `projects/{project_number}` The project may be in any Google Cloud organization, not just the organization that the perimeter is defined in. `*` is not allowed, the case of allowing all Google Cloud resources only is not supported.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        An AccessLevel resource name that allow resources within the ServicePerimeters to be accessed from the internet. AccessLevels listed must be in the same policy as this ServicePerimeter. Referencing a nonexistent AccessLevel will cause an error. If no AccessLevel names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`. If a single `*` is specified for `access_level`, then all IngressSources will be allowed.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[str]]:
        """
        A Google Cloud resource that is allowed to ingress the perimeter. Requests from these resources will be allowed to access perimeter data. Currently only projects are allowed. Format: `projects/{project_number}` The project may be in any Google Cloud organization, not just the organization that the perimeter is defined in. `*` is not allowed, the case of allowing all Google Cloud resources only is not supported.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class IngressToArgs:
    def __init__(__self__, *,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines the conditions under which an IngressPolicy matches a request. Conditions are based on information about the ApiOperation intended to be performed on the target resource of the request. The request must satisfy what is defined in `operations` AND `resources` in order to match.
        :param pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]] operations: A list of ApiOperations allowed to be performed by the sources specified in corresponding IngressFrom in this ServicePerimeter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: A list of resources, currently only projects in the form `projects/`, protected by this ServicePerimeter that are allowed to be accessed by sources defined in the corresponding IngressFrom. If a single `*` is specified, then access to all resources inside the perimeter are allowed.
        """
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]]]:
        """
        A list of ApiOperations allowed to be performed by the sources specified in corresponding IngressFrom in this ServicePerimeter.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of resources, currently only projects in the form `projects/`, protected by this ServicePerimeter that are allowed to be accessed by sources defined in the corresponding IngressFrom. If a single `*` is specified, then access to all resources inside the perimeter are allowed.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class MethodSelectorArgs:
    def __init__(__self__, *,
                 method: Optional[pulumi.Input[str]] = None,
                 permission: Optional[pulumi.Input[str]] = None):
        """
        An allowed method or permission of a service specified in ApiOperation.
        :param pulumi.Input[str] method: Value for `method` should be a valid method name for the corresponding `service_name` in ApiOperation. If `*` used as value for `method`, then ALL methods and permissions are allowed.
        :param pulumi.Input[str] permission: Value for `permission` should be a valid Cloud IAM permission for the corresponding `service_name` in ApiOperation.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Value for `method` should be a valid method name for the corresponding `service_name` in ApiOperation. If `*` used as value for `method`, then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[str]]:
        """
        Value for `permission` should be a valid Cloud IAM permission for the corresponding `service_name` in ApiOperation.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission", value)


@pulumi.input_type
class OsConstraintArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input['OsConstraintOsType'],
                 minimum_version: Optional[pulumi.Input[str]] = None,
                 require_verified_chrome_os: Optional[pulumi.Input[bool]] = None):
        """
        A restriction on the OS type and version of devices making requests.
        :param pulumi.Input['OsConstraintOsType'] os_type: The allowed OS type.
        :param pulumi.Input[str] minimum_version: The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: `"major.minor.patch"`. Examples: `"10.5.301"`, `"9.2.1"`.
        :param pulumi.Input[bool] require_verified_chrome_os: Only allows requests from devices with a verified Chrome OS. Verifications includes requirements that the device is enterprise-managed, conformant to domain policies, and the caller has permission to call the API targeted by the request.
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)
        if require_verified_chrome_os is not None:
            pulumi.set(__self__, "require_verified_chrome_os", require_verified_chrome_os)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input['OsConstraintOsType']:
        """
        The allowed OS type.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input['OsConstraintOsType']):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: `"major.minor.patch"`. Examples: `"10.5.301"`, `"9.2.1"`.
        """
        return pulumi.get(self, "minimum_version")

    @minimum_version.setter
    def minimum_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_version", value)

    @property
    @pulumi.getter(name="requireVerifiedChromeOs")
    def require_verified_chrome_os(self) -> Optional[pulumi.Input[bool]]:
        """
        Only allows requests from devices with a verified Chrome OS. Verifications includes requirements that the device is enterprise-managed, conformant to domain policies, and the caller has permission to call the API targeted by the request.
        """
        return pulumi.get(self, "require_verified_chrome_os")

    @require_verified_chrome_os.setter
    def require_verified_chrome_os(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_verified_chrome_os", value)


@pulumi.input_type
class ServicePerimeterConfigArgs:
    def __init__(__self__, *,
                 access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 egress_policies: Optional[pulumi.Input[Sequence[pulumi.Input['EgressPolicyArgs']]]] = None,
                 ingress_policies: Optional[pulumi.Input[Sequence[pulumi.Input['IngressPolicyArgs']]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 restricted_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_accessible_services: Optional[pulumi.Input['VpcAccessibleServicesArgs']] = None):
        """
        `ServicePerimeterConfig` specifies a set of Google Cloud resources that describe specific Service Perimeter configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_levels: A list of `AccessLevel` resource names that allow resources within the `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service Perimeter Bridge, must be empty.
        :param pulumi.Input[Sequence[pulumi.Input['EgressPolicyArgs']]] egress_policies: List of EgressPolicies to apply to the perimeter. A perimeter may have multiple EgressPolicies, each of which is evaluated separately. Access is granted if any EgressPolicy grants it. Must be empty for a perimeter bridge.
        :param pulumi.Input[Sequence[pulumi.Input['IngressPolicyArgs']]] ingress_policies: List of IngressPolicies to apply to the perimeter. A perimeter may have multiple IngressPolicies, each of which is evaluated separately. Access is granted if any Ingress Policy grants it. Must be empty for a perimeter bridge.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: A list of Google Cloud resources that are inside of the service perimeter. Currently only projects are allowed. Format: `projects/{project_number}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] restricted_services: Google Cloud services that are subject to the Service Perimeter restrictions. For example, if `storage.googleapis.com` is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        :param pulumi.Input['VpcAccessibleServicesArgs'] vpc_accessible_services: Configuration for APIs allowed within Perimeter.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if egress_policies is not None:
            pulumi.set(__self__, "egress_policies", egress_policies)
        if ingress_policies is not None:
            pulumi.set(__self__, "ingress_policies", ingress_policies)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of `AccessLevel` resource names that allow resources within the `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are listed, resources within the perimeter can only be accessed via Google Cloud calls with request origins within the perimeter. Example: `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service Perimeter Bridge, must be empty.
        """
        return pulumi.get(self, "access_levels")

    @access_levels.setter
    def access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_levels", value)

    @property
    @pulumi.getter(name="egressPolicies")
    def egress_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EgressPolicyArgs']]]]:
        """
        List of EgressPolicies to apply to the perimeter. A perimeter may have multiple EgressPolicies, each of which is evaluated separately. Access is granted if any EgressPolicy grants it. Must be empty for a perimeter bridge.
        """
        return pulumi.get(self, "egress_policies")

    @egress_policies.setter
    def egress_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EgressPolicyArgs']]]]):
        pulumi.set(self, "egress_policies", value)

    @property
    @pulumi.getter(name="ingressPolicies")
    def ingress_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressPolicyArgs']]]]:
        """
        List of IngressPolicies to apply to the perimeter. A perimeter may have multiple IngressPolicies, each of which is evaluated separately. Access is granted if any Ingress Policy grants it. Must be empty for a perimeter bridge.
        """
        return pulumi.get(self, "ingress_policies")

    @ingress_policies.setter
    def ingress_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressPolicyArgs']]]]):
        pulumi.set(self, "ingress_policies", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Google Cloud resources that are inside of the service perimeter. Currently only projects are allowed. Format: `projects/{project_number}`
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Google Cloud services that are subject to the Service Perimeter restrictions. For example, if `storage.googleapis.com` is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @restricted_services.setter
    def restricted_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "restricted_services", value)

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional[pulumi.Input['VpcAccessibleServicesArgs']]:
        """
        Configuration for APIs allowed within Perimeter.
        """
        return pulumi.get(self, "vpc_accessible_services")

    @vpc_accessible_services.setter
    def vpc_accessible_services(self, value: Optional[pulumi.Input['VpcAccessibleServicesArgs']]):
        pulumi.set(self, "vpc_accessible_services", value)


@pulumi.input_type
class VpcAccessibleServicesArgs:
    def __init__(__self__, *,
                 allowed_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_restriction: Optional[pulumi.Input[bool]] = None):
        """
        Specifies how APIs are allowed to communicate within the Service Perimeter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_services: The list of APIs usable within the Service Perimeter. Must be empty unless 'enable_restriction' is True. You can specify a list of individual services, as well as include the 'RESTRICTED-SERVICES' value, which automatically includes all of the services protected by the perimeter.
        :param pulumi.Input[bool] enable_restriction: Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowed_services'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of APIs usable within the Service Perimeter. Must be empty unless 'enable_restriction' is True. You can specify a list of individual services, as well as include the 'RESTRICTED-SERVICES' value, which automatically includes all of the services protected by the perimeter.
        """
        return pulumi.get(self, "allowed_services")

    @allowed_services.setter
    def allowed_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_services", value)

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowed_services'.
        """
        return pulumi.get(self, "enable_restriction")

    @enable_restriction.setter
    def enable_restriction(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_restriction", value)


