/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.pca;

import hex.genmodel.MojoModel;

public class PCAMojoModel
extends MojoModel {
    double[][] _eigenvectors_raw;
    public int[] _catOffsets;
    public int[] _permutation;
    public int _ncats;
    public int _nnums;
    public double[] _normSub;
    public double[] _normMul;
    public boolean _use_all_factor_levels;
    public String _pca_method;
    public String _pca_impl;
    public int _k;
    public int _eigenVectorSize;

    public PCAMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        assert (row != null) : "input data row is null";
        double[] tpred = preds == null ? new double[this._k] : preds;
        int numStart = this._catOffsets[this._ncats];
        assert (row.length == this._nnums + this._ncats) : "assert dataset input size does not eqaul to expected size";
        for (int i = 0; i < this._k; ++i) {
            tpred[i] = 0.0;
            for (int j = 0; j < this._ncats; ++j) {
                double tmp = row[this._permutation[j]];
                if (Double.isNaN(tmp)) continue;
                int last_cat = this._catOffsets[j + 1] - this._catOffsets[j] - 1;
                int level = (int)tmp - (this._use_all_factor_levels ? 0 : 1);
                if (level < 0 || level > last_cat) continue;
                int n = i;
                tpred[n] = tpred[n] + this._eigenvectors_raw[this._catOffsets[j] + level][i];
            }
            int dcol = this._ncats;
            int vcol = numStart;
            for (int j = 0; j < this._nnums; ++j) {
                int n = i;
                tpred[n] = tpred[n] + (row[this._permutation[dcol]] - this._normSub[j]) * this._normMul[j] * this._eigenvectors_raw[vcol][i];
                ++dcol;
                ++vcol;
            }
        }
        return tpred;
    }

    @Override
    public int getPredsSize() {
        return this._k;
    }

    @Override
    public int nclasses() {
        return this._k;
    }

    @Override
    public String[] getOutputNames() {
        String[] names = new String[this._k];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "PC" + (i + 1);
        }
        return names;
    }
}

