/*
 * Decompiled with CFR 0.152.
 */
package sklearn.impute;

import java.util.Collections;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class ImputerUtil {
    private ImputerUtil() {
    }

    public static Feature encodeFeature(Transformer transformer, Feature feature, Boolean addIndicator, Object missingValue, Object replacementValue, MissingValueTreatmentMethod missingValueTreatmentMethod, SkLearnEncoder encoder) {
        Field field = feature.getField();
        if (field instanceof DataField && !addIndicator.booleanValue()) {
            DataField dataField = (DataField)field;
            encoder.addDecorator((Field)dataField, (Decorator)new MissingValueDecorator(missingValueTreatmentMethod, replacementValue));
            if (missingValue != null) {
                PMMLUtil.addValues((Field)dataField, (Value.Property)Value.Property.MISSING, Collections.singletonList(missingValue));
            }
            return feature;
        }
        if (field instanceof DataField || field instanceof DerivedField) {
            FieldRef expression = feature.ref();
            expression = missingValue != null ? PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)missingValue, (DataType)feature.getDataType())}) : PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression});
            expression = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)replacementValue, (DataType)feature.getDataType()), feature.ref()});
            DerivedField derivedField = encoder.createDerivedField(transformer.createFieldName("imputer", feature), field.requireOpType(), field.requireDataType(), (Expression)expression);
            return TransformerUtil.createFeature(derivedField, encoder);
        }
        throw new UnsupportedElementException((PMMLObject)field);
    }

    public static Feature encodeIndicatorFeature(Transformer transformer, Feature feature, Object missingValue, SkLearnEncoder encoder) {
        FieldRef expression = feature.ref();
        expression = missingValue != null ? PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)missingValue, (DataType)feature.getDataType())}) : PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression});
        DerivedField derivedField = encoder.createDerivedField(transformer.createFieldName("missingIndicator", feature), OpType.CATEGORICAL, DataType.BOOLEAN, (Expression)expression);
        return new BooleanFeature((PMMLEncoder)encoder, (Field)derivedField);
    }
}

