/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import numpy.DType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.PythonEncoder;
import sklearn.ensemble.hist_gradient_boosting.TreePredictor;
import sklearn.neighbors.BinaryTree;
import sklearn.tree.Tree;
import sklearn2pmml.decoration.Alias;
import sklearn2pmml.decoration.Domain;

public class SkLearnEncoder
extends PythonEncoder {
    private Map<String, Domain> domains = new LinkedHashMap<String, Domain>();
    private Model model = null;

    public DataField createDataField(String name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(String name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public void addDerivedField(DerivedField derivedField) {
        try {
            super.addDerivedField(derivedField);
        }
        catch (RuntimeException re) {
            String name = derivedField.requireName();
            String message = "Field " + name + " is already defined. Please refactor the pipeline so that it would not contain duplicate field declarations, or use the " + Alias.class.getName() + " wrapper class to override the default name with a custom name (eg. " + Alias.formatAliasExample() + ")";
            throw new IllegalArgumentException(message, re);
        }
    }

    public void renameFeature(Feature feature, String renamedName) {
        String name = feature.getName();
        org.dmg.pmml.Field pmmlField = this.getField(name);
        if (pmmlField instanceof DataField) {
            throw new IllegalArgumentException("User input field " + name + " cannot be renamed");
        }
        DerivedField derivedField = this.removeDerivedField(name);
        try {
            Field nameField = Feature.class.getDeclaredField("name");
            ReflectionUtil.setFieldValue((Field)nameField, (Object)feature, (Object)renamedName);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        derivedField.setName(renamedName);
        this.addDerivedField(derivedField);
    }

    public boolean isFrozen(String name) {
        return this.domains.containsKey(name);
    }

    public Domain getDomain(String name) {
        return this.domains.get(name);
    }

    public void setDomain(String name, Domain domain) {
        if (domain != null) {
            this.domains.put(name, domain);
        } else {
            this.domains.remove(name);
        }
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    static {
        ClassLoader clazzLoader = SkLearnEncoder.class.getClassLoader();
        PickleUtil.init((ClassLoader)clazzLoader, (String)"sklearn2pmml.properties");
        DType.addDefinition(BinaryTree.DTYPE_NODEDATA);
        DType.addDefinition(Tree.DTYPE_TREE);
        DType.addDefinition(TreePredictor.DTYPE_PREDICTOR_OLD);
        DType.addDefinition(TreePredictor.DTYPE_PREDICTOR_NEW);
    }
}

