# Generated by Django 4.1.7 on 2023-02-15 12:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField()),
                ('is_spoiler', models.BooleanField(default=False)),
                ('is_pinned', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('d', 'Delivered'), ('a', 'Accepted'), ('r', 'Rejected')], default='d', max_length=1)),
                ('urlhash', models.CharField(editable=False, max_length=50, unique=True)),
                ('posted', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='comment.comment')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-is_pinned', '-posted'),
            },
        ),
        migrations.CreateModel(
            name='CommentSettings',
            fields=[
                ('name', models.CharField(max_length=30)),
                ('slug', models.SlugField(help_text='This value will be used in render_comments tag', primary_key=True, serialize=False)),
                ('content_words_count', models.PositiveSmallIntegerField(default=40, help_text='More than this value will have Read More button in comment content')),
                ('status_check', models.BooleanField(default=False, help_text='If True, comment status will be set as d(Delivered) otherwise it will be set as a(Accepted).')),
                ('allow_spoiler', models.BooleanField(default=True)),
                ('allow_reply', models.BooleanField(default=True)),
                ('allow_edit', models.BooleanField(default=True)),
                ('allow_delete', models.BooleanField(default=True)),
                ('allow_reaction', models.BooleanField(default=True, help_text='First, create a react emoji in React models')),
                ('reaction_type', models.CharField(choices=[('emoji', 'Emoji'), ('source', 'Source')], default='emoji', help_text='Add source in React model', max_length=6)),
                ('per_page', models.PositiveSmallIntegerField(default=10, help_text="Set 0 if you don't want pagination (All comments will be shown at once)")),
                ('time_type', models.PositiveSmallIntegerField(choices=[(1, 'Compound'), (2, 'From Now'), (3, 'Date & Time')], default=1, help_text='Comment posted time style')),
                ('time_days', models.PositiveSmallIntegerField(default=3, help_text='Less than this value will use FROM NOW type , more will use DATE & TIME type')),
                ('theme_direction', models.CharField(choices=[('ltr', 'LTR (Left to Right)'), ('rtl', 'RTL (Right to Left)')], default='ltr', max_length=3)),
                ('theme_dark_mode', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Comment Settings',
                'verbose_name_plural': 'Comment Settings',
            },
        ),
        migrations.CreateModel(
            name='React',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.CharField(max_length=20, unique=True)),
                ('emoji', models.CharField(max_length=5)),
                ('source', models.ImageField(blank=True, null=True, upload_to='react_source')),
            ],
        ),
        migrations.CreateModel(
            name='Reaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comment', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='reactions', to='comment.comment')),
                ('react', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='reactions', to='comment.react')),
                ('user', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='reactions', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'comment')},
            },
        ),
    ]
