# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SourceIpMappingList(ListResource):
    """  """

    def __init__(self, version):
        """
        Initialize the SourceIpMappingList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingList
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingList
        """
        super(SourceIpMappingList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/SourceIpMappings'.format(**self._solution)

    def create(self, ip_record_sid, sip_domain_sid):
        """
        Create the SourceIpMappingInstance

        :param unicode ip_record_sid: The unique string that identifies an IP Record
        :param unicode sip_domain_sid: The unique string that identifies a SIP Domain

        :returns: The created SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        data = values.of({'IpRecordSid': ip_record_sid, 'SipDomainSid': sip_domain_sid, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return SourceIpMappingInstance(self._version, payload, )

    def stream(self, limit=None, page_size=None):
        """
        Streams SourceIpMappingInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists SourceIpMappingInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of SourceIpMappingInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return SourceIpMappingPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of SourceIpMappingInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return SourceIpMappingPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a SourceIpMappingContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        """
        return SourceIpMappingContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a SourceIpMappingContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        """
        return SourceIpMappingContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.SourceIpMappingList>'


class SourceIpMappingPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the SourceIpMappingPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingPage
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingPage
        """
        super(SourceIpMappingPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SourceIpMappingInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        return SourceIpMappingInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.SourceIpMappingPage>'


class SourceIpMappingContext(InstanceContext):
    """  """

    def __init__(self, version, sid):
        """
        Initialize the SourceIpMappingContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        """
        super(SourceIpMappingContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/SourceIpMappings/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the SourceIpMappingInstance

        :returns: The fetched SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return SourceIpMappingInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, sip_domain_sid):
        """
        Update the SourceIpMappingInstance

        :param unicode sip_domain_sid: The unique string that identifies a SIP Domain

        :returns: The updated SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        data = values.of({'SipDomainSid': sip_domain_sid, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return SourceIpMappingInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the SourceIpMappingInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.SourceIpMappingContext {}>'.format(context)


class SourceIpMappingInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, sid=None):
        """
        Initialize the SourceIpMappingInstance

        :returns: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        super(SourceIpMappingInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'ip_record_sid': payload.get('ip_record_sid'),
            'sip_domain_sid': payload.get('sip_domain_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SourceIpMappingContext for this SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingContext
        """
        if self._context is None:
            self._context = SourceIpMappingContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def ip_record_sid(self):
        """
        :returns: The unique string that identifies an IP Record
        :rtype: unicode
        """
        return self._properties['ip_record_sid']

    @property
    def sip_domain_sid(self):
        """
        :returns: The unique string that identifies a SIP Domain
        :rtype: unicode
        """
        return self._properties['sip_domain_sid']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the SourceIpMappingInstance

        :returns: The fetched SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        return self._proxy.fetch()

    def update(self, sip_domain_sid):
        """
        Update the SourceIpMappingInstance

        :param unicode sip_domain_sid: The unique string that identifies a SIP Domain

        :returns: The updated SourceIpMappingInstance
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingInstance
        """
        return self._proxy.update(sip_domain_sid, )

    def delete(self):
        """
        Deletes the SourceIpMappingInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.SourceIpMappingInstance {}>'.format(context)
