# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ConnectionPolicyTargetList(ListResource):
    """  """

    def __init__(self, version, connection_policy_sid):
        """
        Initialize the ConnectionPolicyTargetList

        :param Version version: Version that contains the resource
        :param connection_policy_sid: The SID of the Connection Policy that owns the Target

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetList
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetList
        """
        super(ConnectionPolicyTargetList, self).__init__(version)

        # Path Solution
        self._solution = {'connection_policy_sid': connection_policy_sid, }
        self._uri = '/ConnectionPolicies/{connection_policy_sid}/Targets'.format(**self._solution)

    def create(self, target, friendly_name=values.unset, priority=values.unset,
               weight=values.unset, enabled=values.unset):
        """
        Create the ConnectionPolicyTargetInstance

        :param unicode target: The SIP address you want Twilio to route your calls to
        :param unicode friendly_name: A string to describe the resource
        :param unicode priority: The relative importance of the target
        :param unicode weight: The value that determines the relative load the Target should receive compared to others with the same priority
        :param bool enabled: Whether the Target is enabled

        :returns: The created ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        data = values.of({
            'Target': target,
            'FriendlyName': friendly_name,
            'Priority': priority,
            'Weight': weight,
            'Enabled': enabled,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ConnectionPolicyTargetInstance(
            self._version,
            payload,
            connection_policy_sid=self._solution['connection_policy_sid'],
        )

    def stream(self, limit=None, page_size=None):
        """
        Streams ConnectionPolicyTargetInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ConnectionPolicyTargetInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ConnectionPolicyTargetInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ConnectionPolicyTargetPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ConnectionPolicyTargetInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ConnectionPolicyTargetPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a ConnectionPolicyTargetContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        """
        return ConnectionPolicyTargetContext(
            self._version,
            connection_policy_sid=self._solution['connection_policy_sid'],
            sid=sid,
        )

    def __call__(self, sid):
        """
        Constructs a ConnectionPolicyTargetContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        """
        return ConnectionPolicyTargetContext(
            self._version,
            connection_policy_sid=self._solution['connection_policy_sid'],
            sid=sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.ConnectionPolicyTargetList>'


class ConnectionPolicyTargetPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the ConnectionPolicyTargetPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param connection_policy_sid: The SID of the Connection Policy that owns the Target

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetPage
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetPage
        """
        super(ConnectionPolicyTargetPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ConnectionPolicyTargetInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        return ConnectionPolicyTargetInstance(
            self._version,
            payload,
            connection_policy_sid=self._solution['connection_policy_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.ConnectionPolicyTargetPage>'


class ConnectionPolicyTargetContext(InstanceContext):
    """  """

    def __init__(self, version, connection_policy_sid, sid):
        """
        Initialize the ConnectionPolicyTargetContext

        :param Version version: Version that contains the resource
        :param connection_policy_sid: The SID of the Connection Policy that owns the Target
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        """
        super(ConnectionPolicyTargetContext, self).__init__(version)

        # Path Solution
        self._solution = {'connection_policy_sid': connection_policy_sid, 'sid': sid, }
        self._uri = '/ConnectionPolicies/{connection_policy_sid}/Targets/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the ConnectionPolicyTargetInstance

        :returns: The fetched ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ConnectionPolicyTargetInstance(
            self._version,
            payload,
            connection_policy_sid=self._solution['connection_policy_sid'],
            sid=self._solution['sid'],
        )

    def update(self, friendly_name=values.unset, target=values.unset,
               priority=values.unset, weight=values.unset, enabled=values.unset):
        """
        Update the ConnectionPolicyTargetInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode target: The SIP address you want Twilio to route your calls to
        :param unicode priority: The relative importance of the target
        :param unicode weight: The value that determines the relative load the Target should receive compared to others with the same priority
        :param bool enabled: Whether the Target is enabled

        :returns: The updated ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'Target': target,
            'Priority': priority,
            'Weight': weight,
            'Enabled': enabled,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return ConnectionPolicyTargetInstance(
            self._version,
            payload,
            connection_policy_sid=self._solution['connection_policy_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the ConnectionPolicyTargetInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.ConnectionPolicyTargetContext {}>'.format(context)


class ConnectionPolicyTargetInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, connection_policy_sid, sid=None):
        """
        Initialize the ConnectionPolicyTargetInstance

        :returns: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        super(ConnectionPolicyTargetInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'connection_policy_sid': payload.get('connection_policy_sid'),
            'sid': payload.get('sid'),
            'friendly_name': payload.get('friendly_name'),
            'target': payload.get('target'),
            'priority': deserialize.integer(payload.get('priority')),
            'weight': deserialize.integer(payload.get('weight')),
            'enabled': payload.get('enabled'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {
            'connection_policy_sid': connection_policy_sid,
            'sid': sid or self._properties['sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ConnectionPolicyTargetContext for this ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetContext
        """
        if self._context is None:
            self._context = ConnectionPolicyTargetContext(
                self._version,
                connection_policy_sid=self._solution['connection_policy_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def connection_policy_sid(self):
        """
        :returns: The SID of the Connection Policy that owns the Target
        :rtype: unicode
        """
        return self._properties['connection_policy_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def target(self):
        """
        :returns: The SIP address you want Twilio to route your calls to
        :rtype: unicode
        """
        return self._properties['target']

    @property
    def priority(self):
        """
        :returns: The relative importance of the target
        :rtype: unicode
        """
        return self._properties['priority']

    @property
    def weight(self):
        """
        :returns: The value that determines the relative load the Target should receive compared to others with the same priority
        :rtype: unicode
        """
        return self._properties['weight']

    @property
    def enabled(self):
        """
        :returns: Whether the target is enabled
        :rtype: bool
        """
        return self._properties['enabled']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the ConnectionPolicyTargetInstance

        :returns: The fetched ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset, target=values.unset,
               priority=values.unset, weight=values.unset, enabled=values.unset):
        """
        Update the ConnectionPolicyTargetInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode target: The SIP address you want Twilio to route your calls to
        :param unicode priority: The relative importance of the target
        :param unicode weight: The value that determines the relative load the Target should receive compared to others with the same priority
        :param bool enabled: Whether the Target is enabled

        :returns: The updated ConnectionPolicyTargetInstance
        :rtype: twilio.rest.voice.v1.connection_policy.connection_policy_target.ConnectionPolicyTargetInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            target=target,
            priority=priority,
            weight=weight,
            enabled=enabled,
        )

    def delete(self):
        """
        Deletes the ConnectionPolicyTargetInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.ConnectionPolicyTargetInstance {}>'.format(context)
