# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.taskrouter.v1.workspace.workflow.workflow_cumulative_statistics import WorkflowCumulativeStatisticsList
from twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics import WorkflowRealTimeStatisticsList
from twilio.rest.taskrouter.v1.workspace.workflow.workflow_statistics import WorkflowStatisticsList


class WorkflowList(ListResource):
    """  """

    def __init__(self, version, workspace_sid):
        """
        Initialize the WorkflowList

        :param Version version: Version that contains the resource
        :param workspace_sid: The SID of the Workspace that contains the Workflow

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowList
        """
        super(WorkflowList, self).__init__(version)

        # Path Solution
        self._solution = {'workspace_sid': workspace_sid, }
        self._uri = '/Workspaces/{workspace_sid}/Workflows'.format(**self._solution)

    def stream(self, friendly_name=values.unset, limit=None, page_size=None):
        """
        Streams WorkflowInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode friendly_name: The friendly_name of the Workflow resources to read
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(friendly_name=friendly_name, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, friendly_name=values.unset, limit=None, page_size=None):
        """
        Lists WorkflowInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode friendly_name: The friendly_name of the Workflow resources to read
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance]
        """
        return list(self.stream(friendly_name=friendly_name, limit=limit, page_size=page_size, ))

    def page(self, friendly_name=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of WorkflowInstance records from the API.
        Request is executed immediately

        :param unicode friendly_name: The friendly_name of the Workflow resources to read
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowPage
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return WorkflowPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of WorkflowInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return WorkflowPage(self._version, response, self._solution)

    def create(self, friendly_name, configuration,
               assignment_callback_url=values.unset,
               fallback_assignment_callback_url=values.unset,
               task_reservation_timeout=values.unset):
        """
        Create the WorkflowInstance

        :param unicode friendly_name:  descriptive string that you create to describe the Workflow resource
        :param unicode configuration: A JSON string that contains the rules to apply to the Workflow
        :param unicode assignment_callback_url: The URL from your application that will process task assignment events
        :param unicode fallback_assignment_callback_url: The URL that we should call when a call to the `assignment_callback_url` fails
        :param unicode task_reservation_timeout: How long TaskRouter will wait for a confirmation response from your application after it assigns a Task to a Worker

        :returns: The created WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'Configuration': configuration,
            'AssignmentCallbackUrl': assignment_callback_url,
            'FallbackAssignmentCallbackUrl': fallback_assignment_callback_url,
            'TaskReservationTimeout': task_reservation_timeout,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return WorkflowInstance(self._version, payload, workspace_sid=self._solution['workspace_sid'], )

    def get(self, sid):
        """
        Constructs a WorkflowContext

        :param sid: The SID of the resource

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        """
        return WorkflowContext(self._version, workspace_sid=self._solution['workspace_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a WorkflowContext

        :param sid: The SID of the resource

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        """
        return WorkflowContext(self._version, workspace_sid=self._solution['workspace_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Taskrouter.V1.WorkflowList>'


class WorkflowPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the WorkflowPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param workspace_sid: The SID of the Workspace that contains the Workflow

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowPage
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowPage
        """
        super(WorkflowPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of WorkflowInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        return WorkflowInstance(self._version, payload, workspace_sid=self._solution['workspace_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Taskrouter.V1.WorkflowPage>'


class WorkflowContext(InstanceContext):
    """  """

    def __init__(self, version, workspace_sid, sid):
        """
        Initialize the WorkflowContext

        :param Version version: Version that contains the resource
        :param workspace_sid: The SID of the Workspace with the Workflow to fetch
        :param sid: The SID of the resource

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        """
        super(WorkflowContext, self).__init__(version)

        # Path Solution
        self._solution = {'workspace_sid': workspace_sid, 'sid': sid, }
        self._uri = '/Workspaces/{workspace_sid}/Workflows/{sid}'.format(**self._solution)

        # Dependents
        self._statistics = None
        self._real_time_statistics = None
        self._cumulative_statistics = None

    def fetch(self):
        """
        Fetch the WorkflowInstance

        :returns: The fetched WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return WorkflowInstance(
            self._version,
            payload,
            workspace_sid=self._solution['workspace_sid'],
            sid=self._solution['sid'],
        )

    def update(self, friendly_name=values.unset,
               assignment_callback_url=values.unset,
               fallback_assignment_callback_url=values.unset,
               configuration=values.unset, task_reservation_timeout=values.unset,
               re_evaluate_tasks=values.unset):
        """
        Update the WorkflowInstance

        :param unicode friendly_name:  descriptive string that you create to describe the Workflow resource
        :param unicode assignment_callback_url: The URL from your application that will process task assignment events
        :param unicode fallback_assignment_callback_url: The URL that we should call when a call to the `assignment_callback_url` fails
        :param unicode configuration: A JSON string that contains the rules to apply to the Workflow
        :param unicode task_reservation_timeout: How long TaskRouter will wait for a confirmation response from your application after it assigns a Task to a Worker
        :param unicode re_evaluate_tasks: Whether or not to re-evaluate Tasks

        :returns: The updated WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'AssignmentCallbackUrl': assignment_callback_url,
            'FallbackAssignmentCallbackUrl': fallback_assignment_callback_url,
            'Configuration': configuration,
            'TaskReservationTimeout': task_reservation_timeout,
            'ReEvaluateTasks': re_evaluate_tasks,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return WorkflowInstance(
            self._version,
            payload,
            workspace_sid=self._solution['workspace_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the WorkflowInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    @property
    def statistics(self):
        """
        Access the statistics

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_statistics.WorkflowStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_statistics.WorkflowStatisticsList
        """
        if self._statistics is None:
            self._statistics = WorkflowStatisticsList(
                self._version,
                workspace_sid=self._solution['workspace_sid'],
                workflow_sid=self._solution['sid'],
            )
        return self._statistics

    @property
    def real_time_statistics(self):
        """
        Access the real_time_statistics

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsList
        """
        if self._real_time_statistics is None:
            self._real_time_statistics = WorkflowRealTimeStatisticsList(
                self._version,
                workspace_sid=self._solution['workspace_sid'],
                workflow_sid=self._solution['sid'],
            )
        return self._real_time_statistics

    @property
    def cumulative_statistics(self):
        """
        Access the cumulative_statistics

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_cumulative_statistics.WorkflowCumulativeStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_cumulative_statistics.WorkflowCumulativeStatisticsList
        """
        if self._cumulative_statistics is None:
            self._cumulative_statistics = WorkflowCumulativeStatisticsList(
                self._version,
                workspace_sid=self._solution['workspace_sid'],
                workflow_sid=self._solution['sid'],
            )
        return self._cumulative_statistics

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Taskrouter.V1.WorkflowContext {}>'.format(context)


class WorkflowInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, workspace_sid, sid=None):
        """
        Initialize the WorkflowInstance

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        super(WorkflowInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assignment_callback_url': payload.get('assignment_callback_url'),
            'configuration': payload.get('configuration'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'document_content_type': payload.get('document_content_type'),
            'fallback_assignment_callback_url': payload.get('fallback_assignment_callback_url'),
            'friendly_name': payload.get('friendly_name'),
            'sid': payload.get('sid'),
            'task_reservation_timeout': deserialize.integer(payload.get('task_reservation_timeout')),
            'workspace_sid': payload.get('workspace_sid'),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'workspace_sid': workspace_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: WorkflowContext for this WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowContext
        """
        if self._context is None:
            self._context = WorkflowContext(
                self._version,
                workspace_sid=self._solution['workspace_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assignment_callback_url(self):
        """
        :returns: The URL that we call when a task managed by the Workflow is assigned to a Worker
        :rtype: unicode
        """
        return self._properties['assignment_callback_url']

    @property
    def configuration(self):
        """
        :returns: A JSON string that contains the Workflow's configuration
        :rtype: unicode
        """
        return self._properties['configuration']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def document_content_type(self):
        """
        :returns: The MIME type of the document
        :rtype: unicode
        """
        return self._properties['document_content_type']

    @property
    def fallback_assignment_callback_url(self):
        """
        :returns: The URL that we call when a call to the `assignment_callback_url` fails
        :rtype: unicode
        """
        return self._properties['fallback_assignment_callback_url']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the Workflow resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def task_reservation_timeout(self):
        """
        :returns: How long TaskRouter will wait for a confirmation response from your application after it assigns a Task to a Worker
        :rtype: unicode
        """
        return self._properties['task_reservation_timeout']

    @property
    def workspace_sid(self):
        """
        :returns: The SID of the Workspace that contains the Workflow
        :rtype: unicode
        """
        return self._properties['workspace_sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Workflow resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The URLs of related resources
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the WorkflowInstance

        :returns: The fetched WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset,
               assignment_callback_url=values.unset,
               fallback_assignment_callback_url=values.unset,
               configuration=values.unset, task_reservation_timeout=values.unset,
               re_evaluate_tasks=values.unset):
        """
        Update the WorkflowInstance

        :param unicode friendly_name:  descriptive string that you create to describe the Workflow resource
        :param unicode assignment_callback_url: The URL from your application that will process task assignment events
        :param unicode fallback_assignment_callback_url: The URL that we should call when a call to the `assignment_callback_url` fails
        :param unicode configuration: A JSON string that contains the rules to apply to the Workflow
        :param unicode task_reservation_timeout: How long TaskRouter will wait for a confirmation response from your application after it assigns a Task to a Worker
        :param unicode re_evaluate_tasks: Whether or not to re-evaluate Tasks

        :returns: The updated WorkflowInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.WorkflowInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            assignment_callback_url=assignment_callback_url,
            fallback_assignment_callback_url=fallback_assignment_callback_url,
            configuration=configuration,
            task_reservation_timeout=task_reservation_timeout,
            re_evaluate_tasks=re_evaluate_tasks,
        )

    def delete(self):
        """
        Deletes the WorkflowInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    @property
    def statistics(self):
        """
        Access the statistics

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_statistics.WorkflowStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_statistics.WorkflowStatisticsList
        """
        return self._proxy.statistics

    @property
    def real_time_statistics(self):
        """
        Access the real_time_statistics

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsList
        """
        return self._proxy.real_time_statistics

    @property
    def cumulative_statistics(self):
        """
        Access the cumulative_statistics

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_cumulative_statistics.WorkflowCumulativeStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_cumulative_statistics.WorkflowCumulativeStatisticsList
        """
        return self._proxy.cumulative_statistics

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Taskrouter.V1.WorkflowInstance {}>'.format(context)
