# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.conversations.v1.conversation.message import MessageList
from twilio.rest.conversations.v1.conversation.participant import ParticipantList
from twilio.rest.conversations.v1.conversation.webhook import WebhookList


class ConversationList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the ConversationList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.conversation.ConversationList
        :rtype: twilio.rest.conversations.v1.conversation.ConversationList
        """
        super(ConversationList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Conversations'.format(**self._solution)

    def create(self, friendly_name=values.unset, date_created=values.unset,
               date_updated=values.unset, messaging_service_sid=values.unset,
               attributes=values.unset, state=values.unset,
               x_twilio_webhook_enabled=values.unset):
        """
        Create the ConversationInstance

        :param unicode friendly_name: The human-readable name of this conversation.
        :param datetime date_created: The date that this resource was created.
        :param datetime date_updated: The date that this resource was last updated.
        :param unicode messaging_service_sid: The unique id of the SMS Service this conversation belongs to.
        :param unicode attributes: An optional string metadata field you can use to store any data you wish.
        :param ConversationInstance.State state: Current state of this conversation.
        :param ConversationInstance.WebhookEnabledType x_twilio_webhook_enabled: The X-Twilio-Webhook-Enabled HTTP request header

        :returns: The created ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'DateCreated': serialize.iso8601_datetime(date_created),
            'DateUpdated': serialize.iso8601_datetime(date_updated),
            'MessagingServiceSid': messaging_service_sid,
            'Attributes': attributes,
            'State': state,
        })
        headers = values.of({'X-Twilio-Webhook-Enabled': x_twilio_webhook_enabled, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, headers=headers, )

        return ConversationInstance(self._version, payload, )

    def stream(self, limit=None, page_size=None):
        """
        Streams ConversationInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.conversation.ConversationInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ConversationInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.conversation.ConversationInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ConversationInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ConversationPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ConversationInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ConversationPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a ConversationContext

        :param sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.conversations.v1.conversation.ConversationContext
        :rtype: twilio.rest.conversations.v1.conversation.ConversationContext
        """
        return ConversationContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a ConversationContext

        :param sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.conversations.v1.conversation.ConversationContext
        :rtype: twilio.rest.conversations.v1.conversation.ConversationContext
        """
        return ConversationContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ConversationList>'


class ConversationPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the ConversationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.conversations.v1.conversation.ConversationPage
        :rtype: twilio.rest.conversations.v1.conversation.ConversationPage
        """
        super(ConversationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ConversationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.conversation.ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        return ConversationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ConversationPage>'


class ConversationContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, sid):
        """
        Initialize the ConversationContext

        :param Version version: Version that contains the resource
        :param sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.conversations.v1.conversation.ConversationContext
        :rtype: twilio.rest.conversations.v1.conversation.ConversationContext
        """
        super(ConversationContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Conversations/{sid}'.format(**self._solution)

        # Dependents
        self._participants = None
        self._messages = None
        self._webhooks = None

    def update(self, friendly_name=values.unset, date_created=values.unset,
               date_updated=values.unset, attributes=values.unset,
               messaging_service_sid=values.unset, state=values.unset,
               x_twilio_webhook_enabled=values.unset):
        """
        Update the ConversationInstance

        :param unicode friendly_name: The human-readable name of this conversation.
        :param datetime date_created: The date that this resource was created.
        :param datetime date_updated: The date that this resource was last updated.
        :param unicode attributes: An optional string metadata field you can use to store any data you wish.
        :param unicode messaging_service_sid: The unique id of the SMS Service this conversation belongs to.
        :param ConversationInstance.State state: Current state of this conversation.
        :param ConversationInstance.WebhookEnabledType x_twilio_webhook_enabled: The X-Twilio-Webhook-Enabled HTTP request header

        :returns: The updated ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'DateCreated': serialize.iso8601_datetime(date_created),
            'DateUpdated': serialize.iso8601_datetime(date_updated),
            'Attributes': attributes,
            'MessagingServiceSid': messaging_service_sid,
            'State': state,
        })
        headers = values.of({'X-Twilio-Webhook-Enabled': x_twilio_webhook_enabled, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, headers=headers, )

        return ConversationInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self, x_twilio_webhook_enabled=values.unset):
        """
        Deletes the ConversationInstance

        :param ConversationInstance.WebhookEnabledType x_twilio_webhook_enabled: The X-Twilio-Webhook-Enabled HTTP request header

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        headers = values.of({'X-Twilio-Webhook-Enabled': x_twilio_webhook_enabled, })

        return self._version.delete(method='DELETE', uri=self._uri, headers=headers, )

    def fetch(self):
        """
        Fetch the ConversationInstance

        :returns: The fetched ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ConversationInstance(self._version, payload, sid=self._solution['sid'], )

    @property
    def participants(self):
        """
        Access the participants

        :returns: twilio.rest.conversations.v1.conversation.participant.ParticipantList
        :rtype: twilio.rest.conversations.v1.conversation.participant.ParticipantList
        """
        if self._participants is None:
            self._participants = ParticipantList(self._version, conversation_sid=self._solution['sid'], )
        return self._participants

    @property
    def messages(self):
        """
        Access the messages

        :returns: twilio.rest.conversations.v1.conversation.message.MessageList
        :rtype: twilio.rest.conversations.v1.conversation.message.MessageList
        """
        if self._messages is None:
            self._messages = MessageList(self._version, conversation_sid=self._solution['sid'], )
        return self._messages

    @property
    def webhooks(self):
        """
        Access the webhooks

        :returns: twilio.rest.conversations.v1.conversation.webhook.WebhookList
        :rtype: twilio.rest.conversations.v1.conversation.webhook.WebhookList
        """
        if self._webhooks is None:
            self._webhooks = WebhookList(self._version, conversation_sid=self._solution['sid'], )
        return self._webhooks

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.ConversationContext {}>'.format(context)


class ConversationInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class WebhookEnabledType(object):
        TRUE = "true"
        FALSE = "false"

    class State(object):
        INACTIVE = "inactive"
        ACTIVE = "active"
        CLOSED = "closed"

    def __init__(self, version, payload, sid=None):
        """
        Initialize the ConversationInstance

        :returns: twilio.rest.conversations.v1.conversation.ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        super(ConversationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'chat_service_sid': payload.get('chat_service_sid'),
            'messaging_service_sid': payload.get('messaging_service_sid'),
            'sid': payload.get('sid'),
            'friendly_name': payload.get('friendly_name'),
            'attributes': payload.get('attributes'),
            'state': payload.get('state'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ConversationContext for this ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationContext
        """
        if self._context is None:
            self._context = ConversationContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique id of the Account responsible for this conversation.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def chat_service_sid(self):
        """
        :returns: The unique id of the Chat Service this conversation belongs to.
        :rtype: unicode
        """
        return self._properties['chat_service_sid']

    @property
    def messaging_service_sid(self):
        """
        :returns: The unique id of the SMS Service this conversation belongs to.
        :rtype: unicode
        """
        return self._properties['messaging_service_sid']

    @property
    def sid(self):
        """
        :returns: A 34 character string that uniquely identifies this resource.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def friendly_name(self):
        """
        :returns: The human-readable name of this conversation.
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def attributes(self):
        """
        :returns: An optional string metadata field you can use to store any data you wish.
        :rtype: unicode
        """
        return self._properties['attributes']

    @property
    def state(self):
        """
        :returns: Current state of this conversation.
        :rtype: ConversationInstance.State
        """
        return self._properties['state']

    @property
    def date_created(self):
        """
        :returns: The date that this resource was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date that this resource was last updated.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: An absolute URL for this conversation.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: Absolute URLs to access the Participants of this Conversation.
        :rtype: unicode
        """
        return self._properties['links']

    def update(self, friendly_name=values.unset, date_created=values.unset,
               date_updated=values.unset, attributes=values.unset,
               messaging_service_sid=values.unset, state=values.unset,
               x_twilio_webhook_enabled=values.unset):
        """
        Update the ConversationInstance

        :param unicode friendly_name: The human-readable name of this conversation.
        :param datetime date_created: The date that this resource was created.
        :param datetime date_updated: The date that this resource was last updated.
        :param unicode attributes: An optional string metadata field you can use to store any data you wish.
        :param unicode messaging_service_sid: The unique id of the SMS Service this conversation belongs to.
        :param ConversationInstance.State state: Current state of this conversation.
        :param ConversationInstance.WebhookEnabledType x_twilio_webhook_enabled: The X-Twilio-Webhook-Enabled HTTP request header

        :returns: The updated ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            date_created=date_created,
            date_updated=date_updated,
            attributes=attributes,
            messaging_service_sid=messaging_service_sid,
            state=state,
            x_twilio_webhook_enabled=x_twilio_webhook_enabled,
        )

    def delete(self, x_twilio_webhook_enabled=values.unset):
        """
        Deletes the ConversationInstance

        :param ConversationInstance.WebhookEnabledType x_twilio_webhook_enabled: The X-Twilio-Webhook-Enabled HTTP request header

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete(x_twilio_webhook_enabled=x_twilio_webhook_enabled, )

    def fetch(self):
        """
        Fetch the ConversationInstance

        :returns: The fetched ConversationInstance
        :rtype: twilio.rest.conversations.v1.conversation.ConversationInstance
        """
        return self._proxy.fetch()

    @property
    def participants(self):
        """
        Access the participants

        :returns: twilio.rest.conversations.v1.conversation.participant.ParticipantList
        :rtype: twilio.rest.conversations.v1.conversation.participant.ParticipantList
        """
        return self._proxy.participants

    @property
    def messages(self):
        """
        Access the messages

        :returns: twilio.rest.conversations.v1.conversation.message.MessageList
        :rtype: twilio.rest.conversations.v1.conversation.message.MessageList
        """
        return self._proxy.messages

    @property
    def webhooks(self):
        """
        Access the webhooks

        :returns: twilio.rest.conversations.v1.conversation.webhook.WebhookList
        :rtype: twilio.rest.conversations.v1.conversation.webhook.WebhookList
        """
        return self._proxy.webhooks

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.ConversationInstance {}>'.format(context)
