# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ValidationRequestList(ListResource):
    """  """

    def __init__(self, version, account_sid):
        """
        Initialize the ValidationRequestList

        :param Version version: Version that contains the resource
        :param account_sid: The SID of the Account that created the resource

        :returns: twilio.rest.api.v2010.account.validation_request.ValidationRequestList
        :rtype: twilio.rest.api.v2010.account.validation_request.ValidationRequestList
        """
        super(ValidationRequestList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, }
        self._uri = '/Accounts/{account_sid}/OutgoingCallerIds.json'.format(**self._solution)

    def create(self, phone_number, friendly_name=values.unset,
               call_delay=values.unset, extension=values.unset,
               status_callback=values.unset, status_callback_method=values.unset):
        """
        Create the ValidationRequestInstance

        :param unicode phone_number: The phone number to verify in E.164 format
        :param unicode friendly_name: A string to describe the resource
        :param unicode call_delay: The number of seconds to delay before initiating the verification call
        :param unicode extension: The digits to dial after connecting the verification call
        :param unicode status_callback: The URL we should call to send status information to your application
        :param unicode status_callback_method: The HTTP method we should use to call status_callback

        :returns: The created ValidationRequestInstance
        :rtype: twilio.rest.api.v2010.account.validation_request.ValidationRequestInstance
        """
        data = values.of({
            'PhoneNumber': phone_number,
            'FriendlyName': friendly_name,
            'CallDelay': call_delay,
            'Extension': extension,
            'StatusCallback': status_callback,
            'StatusCallbackMethod': status_callback_method,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ValidationRequestInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.ValidationRequestList>'


class ValidationRequestPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the ValidationRequestPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: The SID of the Account that created the resource

        :returns: twilio.rest.api.v2010.account.validation_request.ValidationRequestPage
        :rtype: twilio.rest.api.v2010.account.validation_request.ValidationRequestPage
        """
        super(ValidationRequestPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ValidationRequestInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.validation_request.ValidationRequestInstance
        :rtype: twilio.rest.api.v2010.account.validation_request.ValidationRequestInstance
        """
        return ValidationRequestInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.ValidationRequestPage>'


class ValidationRequestInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, account_sid):
        """
        Initialize the ValidationRequestInstance

        :returns: twilio.rest.api.v2010.account.validation_request.ValidationRequestInstance
        :rtype: twilio.rest.api.v2010.account.validation_request.ValidationRequestInstance
        """
        super(ValidationRequestInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'phone_number': payload.get('phone_number'),
            'friendly_name': payload.get('friendly_name'),
            'validation_code': deserialize.integer(payload.get('validation_code')),
            'call_sid': payload.get('call_sid'),
        }

        # Context
        self._context = None
        self._solution = {'account_sid': account_sid, }

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def phone_number(self):
        """
        :returns: The phone number to verify in E.164 format
        :rtype: unicode
        """
        return self._properties['phone_number']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def validation_code(self):
        """
        :returns: The 6 digit validation code that someone must enter to validate the Caller ID  when `phone_number` is called
        :rtype: unicode
        """
        return self._properties['validation_code']

    @property
    def call_sid(self):
        """
        :returns: The SID of the Call the resource is associated with
        :rtype: unicode
        """
        return self._properties['call_sid']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.ValidationRequestInstance>'
