export interface FeatureFlagProvider {
    getBoolean(featureName: string, defaultValue?: boolean | null): boolean;
    getString(featureName: string, defaultValue?: string): string;
    getNumber(featureName: string, defaultValue?: Number): Number;
    getObject(featureName: string, defaultValue?: object): object;
}
export declare class NoopFeatureFlagProvider implements FeatureFlagProvider {
    getBoolean(featureName: string, options?: boolean): boolean;
    getString(featureName: string, options?: string): string;
    getNumber(featureName: string, options?: number): number;
    getObject(): object;
    protected getValue<T extends string | number | boolean>(featureName: string, defaultValue?: T): T;
}
//# sourceMappingURL=FeatureFlags.d.ts.map