# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class BouncedRecipientDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'sent_email_id': 'str',
        'recipient': 'str',
        'diagnostic_code': 'str',
        'action': 'str',
        'status': 'str',
        'created_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'sent_email_id': 'sentEmailId',
        'recipient': 'recipient',
        'diagnostic_code': 'diagnosticCode',
        'action': 'action',
        'status': 'status',
        'created_at': 'createdAt'
    }

    def __init__(self, id=None, user_id=None, sent_email_id=None, recipient=None, diagnostic_code=None, action=None, status=None, created_at=None, local_vars_configuration=None):  # noqa: E501
        """BouncedRecipientDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._sent_email_id = None
        self._recipient = None
        self._diagnostic_code = None
        self._action = None
        self._status = None
        self._created_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if user_id is not None:
            self.user_id = user_id
        if sent_email_id is not None:
            self.sent_email_id = sent_email_id
        self.recipient = recipient
        if diagnostic_code is not None:
            self.diagnostic_code = diagnostic_code
        if action is not None:
            self.action = action
        if status is not None:
            self.status = status
        self.created_at = created_at

    @property
    def id(self):
        """Gets the id of this BouncedRecipientDto.  # noqa: E501


        :return: The id of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BouncedRecipientDto.


        :param id: The id of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this BouncedRecipientDto.  # noqa: E501


        :return: The user_id of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this BouncedRecipientDto.


        :param user_id: The user_id of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def sent_email_id(self):
        """Gets the sent_email_id of this BouncedRecipientDto.  # noqa: E501


        :return: The sent_email_id of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._sent_email_id

    @sent_email_id.setter
    def sent_email_id(self, sent_email_id):
        """Sets the sent_email_id of this BouncedRecipientDto.


        :param sent_email_id: The sent_email_id of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """

        self._sent_email_id = sent_email_id

    @property
    def recipient(self):
        """Gets the recipient of this BouncedRecipientDto.  # noqa: E501


        :return: The recipient of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this BouncedRecipientDto.


        :param recipient: The recipient of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and recipient is None:  # noqa: E501
            raise ValueError("Invalid value for `recipient`, must not be `None`")  # noqa: E501

        self._recipient = recipient

    @property
    def diagnostic_code(self):
        """Gets the diagnostic_code of this BouncedRecipientDto.  # noqa: E501


        :return: The diagnostic_code of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._diagnostic_code

    @diagnostic_code.setter
    def diagnostic_code(self, diagnostic_code):
        """Sets the diagnostic_code of this BouncedRecipientDto.


        :param diagnostic_code: The diagnostic_code of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """

        self._diagnostic_code = diagnostic_code

    @property
    def action(self):
        """Gets the action of this BouncedRecipientDto.  # noqa: E501


        :return: The action of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this BouncedRecipientDto.


        :param action: The action of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """

        self._action = action

    @property
    def status(self):
        """Gets the status of this BouncedRecipientDto.  # noqa: E501


        :return: The status of this BouncedRecipientDto.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BouncedRecipientDto.


        :param status: The status of this BouncedRecipientDto.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def created_at(self):
        """Gets the created_at of this BouncedRecipientDto.  # noqa: E501


        :return: The created_at of this BouncedRecipientDto.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BouncedRecipientDto.


        :param created_at: The created_at of this BouncedRecipientDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BouncedRecipientDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BouncedRecipientDto):
            return True

        return self.to_dict() != other.to_dict()
