# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_async_orm']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'django-async-orm',
    'version': '0.1.3',
    'description': 'Bringing async capabilities to django ORM',
    'long_description': '# Django Async Orm\nDjango module that brings async to django ORM.\n\n# Installing\n```\npython -m pip install django-async-orm\n``` \n\nthen add `django_async_orm` to your `INSTALLED_APPS` list:\n\n```python\nINSTALLED_APPS = [\n    ...,\n    \'django_async_orm\'\n]\n```\n# Usage\n\nDjango Async Orm will patch all your existing models to add `async_*` prefixed methods.\nTo be\n\nexample:\n\n```python\nclass MyModel(models.Model):\n    name = models.CharField(max_length=250)\n\n```\n\nyou can use it as follow:\n\n```python\nasync def get_model():\n    return await  MyModel.objects.async_get(name="something")\n```\n\nyou can also iterate over a query set with `async for`:\n\n```python\nasync def all_models():\n    all_result_set = await MyModel.objects.async_all()\n    async for obj in all_result_set:\n        print(obj)\n```\n\nSome wrappers are also available for template rendering, form validation and login/logout\n\n\n#### Async login\n```python\nfrom django_async_orm.wrappers import async_login\n\nasync def my_async_view(request):\n    await async_login(request)\n    ...\n```\n\n#### Form validation\n```python\n\nfrom django_async_orm.wrappers import async_form_is_valid\nasync def a_view(request):\n    form = MyForm(request.POST)\n    is_valid_form = await async_form_is_valid(form)\n    if is_valid_form:\n        ...\n    \n```\n\n\n# Django ORM support:\n\nThis is an on going projects, not all model methods are ported.\n\n### Manager:\n\n| methods                    | supported  | comments |\n|----------------------------|------------|----------|\n| `Model.objects.async_get`                | ✅ |  |\n| `Model.objects.async_create`             | ✅ |  |\n| `Model.objects.async_bulk_create`        | ✅ |  |\n| `Model.objects.async_bulk_update`        | ✅ |  |\n| `Model.objects.async_get_or_create`      | ✅ |  |\n| `Model.objects.async_update_or_create`   | ✅ |  |\n| `Model.objects.async_earliest`           | ✅ |  |\n| `Model.objects.async_latest`             | ✅ |  |\n| `Model.objects.async_first`              | ✅ |  |\n| `Model.objects.async_last`               | ✅ |  |\n| `Model.objects.async_in_bulk`            | ✅ |  |\n| `Model.objects.async_delete`             | ✅ |  |\n| `Model.objects.async_update`             | ✅ |  |\n| `Model.objects.async_exists`             | ✅ |  |\n| `Model.objects.async_explain`            | ✅ |  |\n| `Model.objects.async_raw`                | ✅ |  |\n| `Model.objects.async_all`                | ✅ |  |\n| `Model.objects.async_filter`             | ✅ |  |\n| `Model.objects.async_exclude`            | ✅ |  |\n| `Model.objects.async_complex_filter`     | ✅ |  |\n| `Model.objects.async_union`              | ✅ |  |\n| `Model.objects.async_intersection`       | ✅ |  |\n| `Model.objects.async_difference`         | ✅ |  |\n| `Model.objects.async_select_for_update`  | ✅ |  |\n| `Model.objects.async_prefetch_related`   | ✅ |  |\n| `Model.objects.async_annotate`           | ✅ |  |\n| `Model.objects.async_order_by`           | ✅ |  |\n| `Model.objects.async_distinct`           | ✅ |  |\n| `Model.objects.async_difference`         | ✅ |  |\n| `Model.objects.async_extra`              | ✅ |  |\n| `Model.objects.async_reverse`            | ✅ |  |\n| `Model.objects.async_defer`              | ✅ |  |\n| `Model.objects.async_only`               | ✅ |  |\n| `Model.objects.async_using`              | ✅ |  |\n| `Model.objects.async_resolve_expression` | ✅ |  |\n| `Model.objects.async_ordered`            | ✅ |  |\n| `__aiter__`                              | ✅ |  |\n| `__repr__`                               | ✅ |  |\n| `Model.objects.async_iterator            | ❌ |  |\n\n\n### Model:\n\n| methods                    | supported  | comments |\n|----------------------------|------------|----------|\n| `Model.async_save`                      | ❌ |  |\n| `Model.async_update`                    | ❌ |  |\n| `Model.async_delete`                    | ❌ |  |\n| `...`                                   | ❌ |  |\n\n\n### User Model / Manager\n| methods                    | supported  | comments |\n|----------------------------|------------|----------|\n| `UserModel.is_authenticated`            | ✅ |  |\n| `UserModel.is_super_user`               | ✅ |  |\n| `UserModel.objects.async_create_user`   | ❌ |  |\n| `...`                                   | ❌ |  |\n\n\n### Foreign object lazy loading:\nNot supported ❌\n\n\n### Wrappers:\n| methods                    | supported  | comments |\n|----------------------------|------------|----------|\n| `wrappers.async_render`            | ✅  |  |\n| `wrappers.async_login`            | ✅  |  |\n| `wrappers.async_logout`            | ✅  |  |\n\n\n\n',
    'author': 'SkanderBM',
    'author_email': 'skander.bmahmoud@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rednaks/django-async-orm',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
