# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetGlossaryEntryResult',
    'AwaitableGetGlossaryEntryResult',
    'get_glossary_entry',
    'get_glossary_entry_output',
]

@pulumi.output_type
class GetGlossaryEntryResult:
    def __init__(__self__, description=None, name=None, terms_pair=None, terms_set=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if terms_pair and not isinstance(terms_pair, dict):
            raise TypeError("Expected argument 'terms_pair' to be a dict")
        pulumi.set(__self__, "terms_pair", terms_pair)
        if terms_set and not isinstance(terms_set, dict):
            raise TypeError("Expected argument 'terms_set' to be a dict")
        pulumi.set(__self__, "terms_set", terms_set)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Describes the glossary entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the entry. Format: "projects/*/locations/*/glossaries/*/glossaryEntries/*"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="termsPair")
    def terms_pair(self) -> 'outputs.GlossaryTermsPairResponse':
        """
        Used for an unidirectional glossary.
        """
        return pulumi.get(self, "terms_pair")

    @property
    @pulumi.getter(name="termsSet")
    def terms_set(self) -> 'outputs.GlossaryTermsSetResponse':
        """
        Used for an equivalent term sets glossary.
        """
        return pulumi.get(self, "terms_set")


class AwaitableGetGlossaryEntryResult(GetGlossaryEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlossaryEntryResult(
            description=self.description,
            name=self.name,
            terms_pair=self.terms_pair,
            terms_set=self.terms_set)


def get_glossary_entry(glossary_entry_id: Optional[str] = None,
                       glossary_id: Optional[str] = None,
                       location: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlossaryEntryResult:
    """
    Gets a single glossary entry by the given id.
    """
    __args__ = dict()
    __args__['glossaryEntryId'] = glossary_entry_id
    __args__['glossaryId'] = glossary_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:translate/v3:getGlossaryEntry', __args__, opts=opts, typ=GetGlossaryEntryResult).value

    return AwaitableGetGlossaryEntryResult(
        description=__ret__.description,
        name=__ret__.name,
        terms_pair=__ret__.terms_pair,
        terms_set=__ret__.terms_set)


@_utilities.lift_output_func(get_glossary_entry)
def get_glossary_entry_output(glossary_entry_id: Optional[pulumi.Input[str]] = None,
                              glossary_id: Optional[pulumi.Input[str]] = None,
                              location: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGlossaryEntryResult]:
    """
    Gets a single glossary entry by the given id.
    """
    ...
