# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetControlResult',
    'AwaitableGetControlResult',
    'get_control',
    'get_control_output',
]

@pulumi.output_type
class GetControlResult:
    def __init__(__self__, associated_serving_config_ids=None, display_name=None, facet_spec=None, name=None, rule=None, search_solution_use_case=None, solution_types=None):
        if associated_serving_config_ids and not isinstance(associated_serving_config_ids, list):
            raise TypeError("Expected argument 'associated_serving_config_ids' to be a list")
        pulumi.set(__self__, "associated_serving_config_ids", associated_serving_config_ids)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if facet_spec and not isinstance(facet_spec, dict):
            raise TypeError("Expected argument 'facet_spec' to be a dict")
        pulumi.set(__self__, "facet_spec", facet_spec)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rule and not isinstance(rule, dict):
            raise TypeError("Expected argument 'rule' to be a dict")
        pulumi.set(__self__, "rule", rule)
        if search_solution_use_case and not isinstance(search_solution_use_case, list):
            raise TypeError("Expected argument 'search_solution_use_case' to be a list")
        pulumi.set(__self__, "search_solution_use_case", search_solution_use_case)
        if solution_types and not isinstance(solution_types, list):
            raise TypeError("Expected argument 'solution_types' to be a list")
        pulumi.set(__self__, "solution_types", solution_types)

    @property
    @pulumi.getter(name="associatedServingConfigIds")
    def associated_serving_config_ids(self) -> Sequence[str]:
        """
        List of serving configuration ids that are associated with this control in the same Catalog. Note the association is managed via the ServingConfig, this is an output only denormalized view.
        """
        return pulumi.get(self, "associated_serving_config_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human readable control display name. Used in Retail UI. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is thrown.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="facetSpec")
    def facet_spec(self) -> 'outputs.GoogleCloudRetailV2alphaSearchRequestFacetSpecResponse':
        """
        A facet specification to perform faceted search. Note that this field is deprecated and will throw NOT_IMPLEMENTED if used for creating a control.
        """
        return pulumi.get(self, "facet_spec")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. Fully qualified name `projects/*/locations/global/catalogs/*/controls/*`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rule(self) -> 'outputs.GoogleCloudRetailV2alphaRuleResponse':
        """
        A rule control - a condition-action pair. Enacts a set action when the condition is triggered. For example: Boost "gShoe" when query full matches "Running Shoes".
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter(name="searchSolutionUseCase")
    def search_solution_use_case(self) -> Sequence[str]:
        """
        Specifies the use case for the control. Affects what condition fields can be set. Only settable by search controls. Will default to SEARCH_SOLUTION_USE_CASE_SEARCH if not specified. Currently only allow one search_solution_use_case per control.
        """
        return pulumi.get(self, "search_solution_use_case")

    @property
    @pulumi.getter(name="solutionTypes")
    def solution_types(self) -> Sequence[str]:
        """
        Immutable. The solution types that the control is used for. Currently we support setting only one type of solution at creation time. Only `SOLUTION_TYPE_SEARCH` value is supported at the moment. If no solution type is provided at creation time, will default to SOLUTION_TYPE_SEARCH.
        """
        return pulumi.get(self, "solution_types")


class AwaitableGetControlResult(GetControlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetControlResult(
            associated_serving_config_ids=self.associated_serving_config_ids,
            display_name=self.display_name,
            facet_spec=self.facet_spec,
            name=self.name,
            rule=self.rule,
            search_solution_use_case=self.search_solution_use_case,
            solution_types=self.solution_types)


def get_control(catalog_id: Optional[str] = None,
                control_id: Optional[str] = None,
                location: Optional[str] = None,
                project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetControlResult:
    """
    Gets a Control.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    __args__['controlId'] = control_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:retail/v2alpha:getControl', __args__, opts=opts, typ=GetControlResult).value

    return AwaitableGetControlResult(
        associated_serving_config_ids=__ret__.associated_serving_config_ids,
        display_name=__ret__.display_name,
        facet_spec=__ret__.facet_spec,
        name=__ret__.name,
        rule=__ret__.rule,
        search_solution_use_case=__ret__.search_solution_use_case,
        solution_types=__ret__.solution_types)


@_utilities.lift_output_func(get_control)
def get_control_output(catalog_id: Optional[pulumi.Input[str]] = None,
                       control_id: Optional[pulumi.Input[str]] = None,
                       location: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetControlResult]:
    """
    Gets a Control.
    """
    ...
