# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudRecaptchaenterpriseV1AndroidKeySettingsArgs',
    'GoogleCloudRecaptchaenterpriseV1IOSKeySettingsArgs',
    'GoogleCloudRecaptchaenterpriseV1TestingOptionsArgs',
    'GoogleCloudRecaptchaenterpriseV1WafSettingsArgs',
    'GoogleCloudRecaptchaenterpriseV1WebKeySettingsArgs',
]

@pulumi.input_type
class GoogleCloudRecaptchaenterpriseV1AndroidKeySettingsArgs:
    def __init__(__self__, *,
                 allow_all_package_names: Optional[pulumi.Input[bool]] = None,
                 allowed_package_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Settings specific to keys that can be used by Android apps.
        :param pulumi.Input[bool] allow_all_package_names: If set to true, allowed_package_names are not enforced.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_package_names: Android package names of apps allowed to use the key. Example: 'com.companyname.appname'
        """
        if allow_all_package_names is not None:
            pulumi.set(__self__, "allow_all_package_names", allow_all_package_names)
        if allowed_package_names is not None:
            pulumi.set(__self__, "allowed_package_names", allowed_package_names)

    @property
    @pulumi.getter(name="allowAllPackageNames")
    def allow_all_package_names(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, allowed_package_names are not enforced.
        """
        return pulumi.get(self, "allow_all_package_names")

    @allow_all_package_names.setter
    def allow_all_package_names(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_all_package_names", value)

    @property
    @pulumi.getter(name="allowedPackageNames")
    def allowed_package_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Android package names of apps allowed to use the key. Example: 'com.companyname.appname'
        """
        return pulumi.get(self, "allowed_package_names")

    @allowed_package_names.setter
    def allowed_package_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_package_names", value)


@pulumi.input_type
class GoogleCloudRecaptchaenterpriseV1IOSKeySettingsArgs:
    def __init__(__self__, *,
                 allow_all_bundle_ids: Optional[pulumi.Input[bool]] = None,
                 allowed_bundle_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Settings specific to keys that can be used by iOS apps.
        :param pulumi.Input[bool] allow_all_bundle_ids: If set to true, allowed_bundle_ids are not enforced.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_bundle_ids: iOS bundle ids of apps allowed to use the key. Example: 'com.companyname.productname.appname'
        """
        if allow_all_bundle_ids is not None:
            pulumi.set(__self__, "allow_all_bundle_ids", allow_all_bundle_ids)
        if allowed_bundle_ids is not None:
            pulumi.set(__self__, "allowed_bundle_ids", allowed_bundle_ids)

    @property
    @pulumi.getter(name="allowAllBundleIds")
    def allow_all_bundle_ids(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, allowed_bundle_ids are not enforced.
        """
        return pulumi.get(self, "allow_all_bundle_ids")

    @allow_all_bundle_ids.setter
    def allow_all_bundle_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_all_bundle_ids", value)

    @property
    @pulumi.getter(name="allowedBundleIds")
    def allowed_bundle_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        iOS bundle ids of apps allowed to use the key. Example: 'com.companyname.productname.appname'
        """
        return pulumi.get(self, "allowed_bundle_ids")

    @allowed_bundle_ids.setter
    def allowed_bundle_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_bundle_ids", value)


@pulumi.input_type
class GoogleCloudRecaptchaenterpriseV1TestingOptionsArgs:
    def __init__(__self__, *,
                 testing_challenge: Optional[pulumi.Input['GoogleCloudRecaptchaenterpriseV1TestingOptionsTestingChallenge']] = None,
                 testing_score: Optional[pulumi.Input[float]] = None):
        """
        Options for user acceptance testing.
        :param pulumi.Input['GoogleCloudRecaptchaenterpriseV1TestingOptionsTestingChallenge'] testing_challenge: For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests for this site will return nocaptcha if NOCAPTCHA, or an unsolvable challenge if CHALLENGE.
        :param pulumi.Input[float] testing_score: All assessments for this Key will return this score. Must be between 0 (likely not legitimate) and 1 (likely legitimate) inclusive.
        """
        if testing_challenge is not None:
            pulumi.set(__self__, "testing_challenge", testing_challenge)
        if testing_score is not None:
            pulumi.set(__self__, "testing_score", testing_score)

    @property
    @pulumi.getter(name="testingChallenge")
    def testing_challenge(self) -> Optional[pulumi.Input['GoogleCloudRecaptchaenterpriseV1TestingOptionsTestingChallenge']]:
        """
        For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests for this site will return nocaptcha if NOCAPTCHA, or an unsolvable challenge if CHALLENGE.
        """
        return pulumi.get(self, "testing_challenge")

    @testing_challenge.setter
    def testing_challenge(self, value: Optional[pulumi.Input['GoogleCloudRecaptchaenterpriseV1TestingOptionsTestingChallenge']]):
        pulumi.set(self, "testing_challenge", value)

    @property
    @pulumi.getter(name="testingScore")
    def testing_score(self) -> Optional[pulumi.Input[float]]:
        """
        All assessments for this Key will return this score. Must be between 0 (likely not legitimate) and 1 (likely legitimate) inclusive.
        """
        return pulumi.get(self, "testing_score")

    @testing_score.setter
    def testing_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "testing_score", value)


@pulumi.input_type
class GoogleCloudRecaptchaenterpriseV1WafSettingsArgs:
    def __init__(__self__, *,
                 waf_feature: pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafFeature'],
                 waf_service: pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafService']):
        """
        Settings specific to keys that can be used for WAF (Web Application Firewall).
        :param pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafFeature'] waf_feature: The WAF feature for which this key is enabled.
        :param pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafService'] waf_service: The WAF service that uses this key.
        """
        pulumi.set(__self__, "waf_feature", waf_feature)
        pulumi.set(__self__, "waf_service", waf_service)

    @property
    @pulumi.getter(name="wafFeature")
    def waf_feature(self) -> pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafFeature']:
        """
        The WAF feature for which this key is enabled.
        """
        return pulumi.get(self, "waf_feature")

    @waf_feature.setter
    def waf_feature(self, value: pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafFeature']):
        pulumi.set(self, "waf_feature", value)

    @property
    @pulumi.getter(name="wafService")
    def waf_service(self) -> pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafService']:
        """
        The WAF service that uses this key.
        """
        return pulumi.get(self, "waf_service")

    @waf_service.setter
    def waf_service(self, value: pulumi.Input['GoogleCloudRecaptchaenterpriseV1WafSettingsWafService']):
        pulumi.set(self, "waf_service", value)


@pulumi.input_type
class GoogleCloudRecaptchaenterpriseV1WebKeySettingsArgs:
    def __init__(__self__, *,
                 integration_type: pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsIntegrationType'],
                 allow_all_domains: Optional[pulumi.Input[bool]] = None,
                 allow_amp_traffic: Optional[pulumi.Input[bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 challenge_security_preference: Optional[pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsChallengeSecurityPreference']] = None):
        """
        Settings specific to keys that can be used by websites.
        :param pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsIntegrationType'] integration_type: Describes how this key is integrated with the website.
        :param pulumi.Input[bool] allow_all_domains: If set to true, it means allowed_domains will not be enforced.
        :param pulumi.Input[bool] allow_amp_traffic: If set to true, the key can be used on AMP (Accelerated Mobile Pages) websites. This is supported only for the SCORE integration type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_domains: Domains or subdomains of websites allowed to use the key. All subdomains of an allowed domain are automatically allowed. A valid domain requires a host and must not include any path, port, query or fragment. Examples: 'example.com' or 'subdomain.example.com'
        :param pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsChallengeSecurityPreference'] challenge_security_preference: Settings for the frequency and difficulty at which this key triggers captcha challenges. This should only be specified for IntegrationTypes CHECKBOX and INVISIBLE.
        """
        pulumi.set(__self__, "integration_type", integration_type)
        if allow_all_domains is not None:
            pulumi.set(__self__, "allow_all_domains", allow_all_domains)
        if allow_amp_traffic is not None:
            pulumi.set(__self__, "allow_amp_traffic", allow_amp_traffic)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if challenge_security_preference is not None:
            pulumi.set(__self__, "challenge_security_preference", challenge_security_preference)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsIntegrationType']:
        """
        Describes how this key is integrated with the website.
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsIntegrationType']):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="allowAllDomains")
    def allow_all_domains(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, it means allowed_domains will not be enforced.
        """
        return pulumi.get(self, "allow_all_domains")

    @allow_all_domains.setter
    def allow_all_domains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_all_domains", value)

    @property
    @pulumi.getter(name="allowAmpTraffic")
    def allow_amp_traffic(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the key can be used on AMP (Accelerated Mobile Pages) websites. This is supported only for the SCORE integration type.
        """
        return pulumi.get(self, "allow_amp_traffic")

    @allow_amp_traffic.setter
    def allow_amp_traffic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_amp_traffic", value)

    @property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Domains or subdomains of websites allowed to use the key. All subdomains of an allowed domain are automatically allowed. A valid domain requires a host and must not include any path, port, query or fragment. Examples: 'example.com' or 'subdomain.example.com'
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_domains", value)

    @property
    @pulumi.getter(name="challengeSecurityPreference")
    def challenge_security_preference(self) -> Optional[pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsChallengeSecurityPreference']]:
        """
        Settings for the frequency and difficulty at which this key triggers captcha challenges. This should only be specified for IntegrationTypes CHECKBOX and INVISIBLE.
        """
        return pulumi.get(self, "challenge_security_preference")

    @challenge_security_preference.setter
    def challenge_security_preference(self, value: Optional[pulumi.Input['GoogleCloudRecaptchaenterpriseV1WebKeySettingsChallengeSecurityPreference']]):
        pulumi.set(self, "challenge_security_preference", value)


