# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetCustomConstraintResult',
    'AwaitableGetCustomConstraintResult',
    'get_custom_constraint',
    'get_custom_constraint_output',
]

@pulumi.output_type
class GetCustomConstraintResult:
    def __init__(__self__, action_type=None, condition=None, description=None, display_name=None, method_types=None, name=None, resource_types=None, update_time=None):
        if action_type and not isinstance(action_type, str):
            raise TypeError("Expected argument 'action_type' to be a str")
        pulumi.set(__self__, "action_type", action_type)
        if condition and not isinstance(condition, str):
            raise TypeError("Expected argument 'condition' to be a str")
        pulumi.set(__self__, "condition", condition)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if method_types and not isinstance(method_types, list):
            raise TypeError("Expected argument 'method_types' to be a list")
        pulumi.set(__self__, "method_types", method_types)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_types and not isinstance(resource_types, list):
            raise TypeError("Expected argument 'resource_types' to be a list")
        pulumi.set(__self__, "resource_types", resource_types)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        Allow or deny type.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Org policy condition/expression. For example: `resource.instanceName.matches("[production|test]_.*_(\\d)+")'` or, `resource.management.auto_upgrade == true`
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Detailed information about this custom policy constraint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        One line display name for the UI.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="methodTypes")
    def method_types(self) -> Sequence[str]:
        """
        All the operations being applied for this constraint.
        """
        return pulumi.get(self, "method_types")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. Name of the constraint. This is unique within the organization. Format of the name should be * `organizations/{organization_id}/customConstraints/{custom_constraint_id}` Example : "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Sequence[str]:
        """
        Immutable. The Resource Instance type on which this policy applies to. Format will be of the form : "/" Example: * `compute.googleapis.com/Instance`.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last time this custom constraint was updated. This represents the last time that the `CreateCustomConstraint` or `UpdateCustomConstraint` RPC was called
        """
        return pulumi.get(self, "update_time")


class AwaitableGetCustomConstraintResult(GetCustomConstraintResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomConstraintResult(
            action_type=self.action_type,
            condition=self.condition,
            description=self.description,
            display_name=self.display_name,
            method_types=self.method_types,
            name=self.name,
            resource_types=self.resource_types,
            update_time=self.update_time)


def get_custom_constraint(custom_constraint_id: Optional[str] = None,
                          organization_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomConstraintResult:
    """
    Gets a CustomConstraint. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the CustomConstraint does not exist.
    """
    __args__ = dict()
    __args__['customConstraintId'] = custom_constraint_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:orgpolicy/v2:getCustomConstraint', __args__, opts=opts, typ=GetCustomConstraintResult).value

    return AwaitableGetCustomConstraintResult(
        action_type=__ret__.action_type,
        condition=__ret__.condition,
        description=__ret__.description,
        display_name=__ret__.display_name,
        method_types=__ret__.method_types,
        name=__ret__.name,
        resource_types=__ret__.resource_types,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_custom_constraint)
def get_custom_constraint_output(custom_constraint_id: Optional[pulumi.Input[str]] = None,
                                 organization_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomConstraintResult]:
    """
    Gets a CustomConstraint. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the CustomConstraint does not exist.
    """
    ...
