# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['CustomConstraintArgs', 'CustomConstraint']

@pulumi.input_type
class CustomConstraintArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 action_type: Optional[pulumi.Input['CustomConstraintActionType']] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 method_types: Optional[pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CustomConstraint resource.
        :param pulumi.Input['CustomConstraintActionType'] action_type: Allow or deny type.
        :param pulumi.Input[str] condition: Org policy condition/expression. For example: `resource.instanceName.matches("[production|test]_.*_(\\d)+")'` or, `resource.management.auto_upgrade == true`
        :param pulumi.Input[str] description: Detailed information about this custom policy constraint.
        :param pulumi.Input[str] display_name: One line display name for the UI.
        :param pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]] method_types: All the operations being applied for this constraint.
        :param pulumi.Input[str] name: Immutable. Name of the constraint. This is unique within the organization. Format of the name should be * `organizations/{organization_id}/customConstraints/{custom_constraint_id}` Example : "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Immutable. The Resource Instance type on which this policy applies to. Format will be of the form : "/" Example: * `compute.googleapis.com/Instance`.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if method_types is not None:
            pulumi.set(__self__, "method_types", method_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input['CustomConstraintActionType']]:
        """
        Allow or deny type.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input['CustomConstraintActionType']]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        Org policy condition/expression. For example: `resource.instanceName.matches("[production|test]_.*_(\\d)+")'` or, `resource.management.auto_upgrade == true`
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed information about this custom policy constraint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        One line display name for the UI.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="methodTypes")
    def method_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]]]:
        """
        All the operations being applied for this constraint.
        """
        return pulumi.get(self, "method_types")

    @method_types.setter
    def method_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]]]):
        pulumi.set(self, "method_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Name of the constraint. This is unique within the organization. Format of the name should be * `organizations/{organization_id}/customConstraints/{custom_constraint_id}` Example : "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Immutable. The Resource Instance type on which this policy applies to. Format will be of the form : "/" Example: * `compute.googleapis.com/Instance`.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_types", value)


class CustomConstraint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input['CustomConstraintActionType']] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 method_types: Optional[pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates a CustomConstraint. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the organization does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the constraint already exists on the given organization.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['CustomConstraintActionType'] action_type: Allow or deny type.
        :param pulumi.Input[str] condition: Org policy condition/expression. For example: `resource.instanceName.matches("[production|test]_.*_(\\d)+")'` or, `resource.management.auto_upgrade == true`
        :param pulumi.Input[str] description: Detailed information about this custom policy constraint.
        :param pulumi.Input[str] display_name: One line display name for the UI.
        :param pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]] method_types: All the operations being applied for this constraint.
        :param pulumi.Input[str] name: Immutable. Name of the constraint. This is unique within the organization. Format of the name should be * `organizations/{organization_id}/customConstraints/{custom_constraint_id}` Example : "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Immutable. The Resource Instance type on which this policy applies to. Format will be of the form : "/" Example: * `compute.googleapis.com/Instance`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomConstraintArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a CustomConstraint. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the organization does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the constraint already exists on the given organization.

        :param str resource_name: The name of the resource.
        :param CustomConstraintArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomConstraintArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input['CustomConstraintActionType']] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 method_types: Optional[pulumi.Input[Sequence[pulumi.Input['CustomConstraintMethodTypesItem']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomConstraintArgs.__new__(CustomConstraintArgs)

            __props__.__dict__["action_type"] = action_type
            __props__.__dict__["condition"] = condition
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["method_types"] = method_types
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["resource_types"] = resource_types
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["organization_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CustomConstraint, __self__).__init__(
            'google-native:orgpolicy/v2:CustomConstraint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CustomConstraint':
        """
        Get an existing CustomConstraint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CustomConstraintArgs.__new__(CustomConstraintArgs)

        __props__.__dict__["action_type"] = None
        __props__.__dict__["condition"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["method_types"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["organization_id"] = None
        __props__.__dict__["resource_types"] = None
        __props__.__dict__["update_time"] = None
        return CustomConstraint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[str]:
        """
        Allow or deny type.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[str]:
        """
        Org policy condition/expression. For example: `resource.instanceName.matches("[production|test]_.*_(\\d)+")'` or, `resource.management.auto_upgrade == true`
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Detailed information about this custom policy constraint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        One line display name for the UI.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="methodTypes")
    def method_types(self) -> pulumi.Output[Sequence[str]]:
        """
        All the operations being applied for this constraint.
        """
        return pulumi.get(self, "method_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. Name of the constraint. This is unique within the organization. Format of the name should be * `organizations/{organization_id}/customConstraints/{custom_constraint_id}` Example : "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Immutable. The Resource Instance type on which this policy applies to. Format will be of the form : "/" Example: * `compute.googleapis.com/Instance`.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last time this custom constraint was updated. This represents the last time that the `CreateCustomConstraint` or `UpdateCustomConstraint` RPC was called
        """
        return pulumi.get(self, "update_time")

