# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetOauthIdpConfigResult',
    'AwaitableGetOauthIdpConfigResult',
    'get_oauth_idp_config',
    'get_oauth_idp_config_output',
]

@pulumi.output_type
class GetOauthIdpConfigResult:
    def __init__(__self__, client_id=None, client_secret=None, display_name=None, enabled=None, issuer=None, name=None, response_type=None):
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if client_secret and not isinstance(client_secret, str):
            raise TypeError("Expected argument 'client_secret' to be a str")
        pulumi.set(__self__, "client_secret", client_secret)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if response_type and not isinstance(response_type, dict):
            raise TypeError("Expected argument 'response_type' to be a dict")
        pulumi.set(__self__, "response_type", response_type)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of an OAuth client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret of the OAuth client, to enable OIDC code flow.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The config's display name set by developers.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        True if allows the user to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        For OIDC Idps, the issuer identifier.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the OAuthIdpConfig resource, for example: 'projects/my-awesome-project/oauthIdpConfigs/oauth-config-id'. Ignored during create requests.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> 'outputs.GoogleCloudIdentitytoolkitAdminV2OAuthResponseTypeResponse':
        """
        The response type to request for in the OAuth authorization flow. You can set either `id_token` or `code` to true, but not both. Setting both types to be simultaneously true (`{code: true, id_token: true}`) is not yet supported.
        """
        return pulumi.get(self, "response_type")


class AwaitableGetOauthIdpConfigResult(GetOauthIdpConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOauthIdpConfigResult(
            client_id=self.client_id,
            client_secret=self.client_secret,
            display_name=self.display_name,
            enabled=self.enabled,
            issuer=self.issuer,
            name=self.name,
            response_type=self.response_type)


def get_oauth_idp_config(oauth_idp_config_id: Optional[str] = None,
                         project: Optional[str] = None,
                         tenant_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOauthIdpConfigResult:
    """
    Retrieve an Oidc Idp configuration for an Identity Toolkit project.
    """
    __args__ = dict()
    __args__['oauthIdpConfigId'] = oauth_idp_config_id
    __args__['project'] = project
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:identitytoolkit/v2:getOauthIdpConfig', __args__, opts=opts, typ=GetOauthIdpConfigResult).value

    return AwaitableGetOauthIdpConfigResult(
        client_id=__ret__.client_id,
        client_secret=__ret__.client_secret,
        display_name=__ret__.display_name,
        enabled=__ret__.enabled,
        issuer=__ret__.issuer,
        name=__ret__.name,
        response_type=__ret__.response_type)


@_utilities.lift_output_func(get_oauth_idp_config)
def get_oauth_idp_config_output(oauth_idp_config_id: Optional[pulumi.Input[str]] = None,
                                project: Optional[pulumi.Input[Optional[str]]] = None,
                                tenant_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOauthIdpConfigResult]:
    """
    Retrieve an Oidc Idp configuration for an Identity Toolkit project.
    """
    ...
