# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetInboundSamlConfigResult',
    'AwaitableGetInboundSamlConfigResult',
    'get_inbound_saml_config',
    'get_inbound_saml_config_output',
]

@pulumi.output_type
class GetInboundSamlConfigResult:
    def __init__(__self__, display_name=None, enabled=None, idp_config=None, name=None, sp_config=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if idp_config and not isinstance(idp_config, dict):
            raise TypeError("Expected argument 'idp_config' to be a dict")
        pulumi.set(__self__, "idp_config", idp_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sp_config and not isinstance(sp_config, dict):
            raise TypeError("Expected argument 'sp_config' to be a dict")
        pulumi.set(__self__, "sp_config", sp_config)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The config's display name set by developers.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        True if allows the user to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> 'outputs.GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse':
        """
        The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
        """
        return pulumi.get(self, "idp_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the InboundSamlConfig resource, for example: 'projects/my-awesome-project/inboundSamlConfigs/my-config-id'. Ignored during create requests.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="spConfig")
    def sp_config(self) -> 'outputs.GoogleCloudIdentitytoolkitAdminV2SpConfigResponse':
        """
        The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
        """
        return pulumi.get(self, "sp_config")


class AwaitableGetInboundSamlConfigResult(GetInboundSamlConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInboundSamlConfigResult(
            display_name=self.display_name,
            enabled=self.enabled,
            idp_config=self.idp_config,
            name=self.name,
            sp_config=self.sp_config)


def get_inbound_saml_config(inbound_saml_config_id: Optional[str] = None,
                            project: Optional[str] = None,
                            tenant_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInboundSamlConfigResult:
    """
    Retrieve an inbound SAML configuration for an Identity Toolkit project.
    """
    __args__ = dict()
    __args__['inboundSamlConfigId'] = inbound_saml_config_id
    __args__['project'] = project
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:identitytoolkit/v2:getInboundSamlConfig', __args__, opts=opts, typ=GetInboundSamlConfigResult).value

    return AwaitableGetInboundSamlConfigResult(
        display_name=__ret__.display_name,
        enabled=__ret__.enabled,
        idp_config=__ret__.idp_config,
        name=__ret__.name,
        sp_config=__ret__.sp_config)


@_utilities.lift_output_func(get_inbound_saml_config)
def get_inbound_saml_config_output(inbound_saml_config_id: Optional[pulumi.Input[str]] = None,
                                   project: Optional[pulumi.Input[Optional[str]]] = None,
                                   tenant_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInboundSamlConfigResult]:
    """
    Retrieve an inbound SAML configuration for an Identity Toolkit project.
    """
    ...
