# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DefaultSupportedIdpConfigArgs', 'DefaultSupportedIdpConfig']

@pulumi.input_type
class DefaultSupportedIdpConfigArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 apple_sign_in_config: Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs']] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DefaultSupportedIdpConfig resource.
        :param pulumi.Input['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs'] apple_sign_in_config: Additional config for Apple-based projects.
        :param pulumi.Input[str] client_id: OAuth client ID.
        :param pulumi.Input[str] client_secret: OAuth client secret.
        :param pulumi.Input[bool] enabled: True if allows the user to sign in with the provider.
        :param pulumi.Input[str] idp_id: The id of the Idp to create a config for. Call ListDefaultSupportedIdps for list of all default supported Idps.
        :param pulumi.Input[str] name: The name of the DefaultSupportedIdpConfig resource, for example: "projects/my-awesome-project/defaultSupportedIdpConfigs/google.com"
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if apple_sign_in_config is not None:
            pulumi.set(__self__, "apple_sign_in_config", apple_sign_in_config)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="appleSignInConfig")
    def apple_sign_in_config(self) -> Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs']]:
        """
        Additional config for Apple-based projects.
        """
        return pulumi.get(self, "apple_sign_in_config")

    @apple_sign_in_config.setter
    def apple_sign_in_config(self, value: Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs']]):
        pulumi.set(self, "apple_sign_in_config", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth client secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if allows the user to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Idp to create a config for. Call ListDefaultSupportedIdps for list of all default supported Idps.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DefaultSupportedIdpConfig resource, for example: "projects/my-awesome-project/defaultSupportedIdpConfigs/google.com"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class DefaultSupportedIdpConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apple_sign_in_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs']]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a default supported Idp configuration for an Identity Toolkit project.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs']] apple_sign_in_config: Additional config for Apple-based projects.
        :param pulumi.Input[str] client_id: OAuth client ID.
        :param pulumi.Input[str] client_secret: OAuth client secret.
        :param pulumi.Input[bool] enabled: True if allows the user to sign in with the provider.
        :param pulumi.Input[str] idp_id: The id of the Idp to create a config for. Call ListDefaultSupportedIdps for list of all default supported Idps.
        :param pulumi.Input[str] name: The name of the DefaultSupportedIdpConfig resource, for example: "projects/my-awesome-project/defaultSupportedIdpConfigs/google.com"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultSupportedIdpConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a default supported Idp configuration for an Identity Toolkit project.

        :param str resource_name: The name of the resource.
        :param DefaultSupportedIdpConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultSupportedIdpConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apple_sign_in_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigArgs']]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultSupportedIdpConfigArgs.__new__(DefaultSupportedIdpConfigArgs)

            __props__.__dict__["apple_sign_in_config"] = apple_sign_in_config
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project", "tenant_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DefaultSupportedIdpConfig, __self__).__init__(
            'google-native:identitytoolkit/v2:DefaultSupportedIdpConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DefaultSupportedIdpConfig':
        """
        Get an existing DefaultSupportedIdpConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DefaultSupportedIdpConfigArgs.__new__(DefaultSupportedIdpConfigArgs)

        __props__.__dict__["apple_sign_in_config"] = None
        __props__.__dict__["client_id"] = None
        __props__.__dict__["client_secret"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["idp_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["tenant_id"] = None
        return DefaultSupportedIdpConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appleSignInConfig")
    def apple_sign_in_config(self) -> pulumi.Output['outputs.GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigResponse']:
        """
        Additional config for Apple-based projects.
        """
        return pulumi.get(self, "apple_sign_in_config")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        OAuth client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        OAuth client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        True if allows the user to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the Idp to create a config for. Call ListDefaultSupportedIdps for list of all default supported Idps.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the DefaultSupportedIdpConfig resource, for example: "projects/my-awesome-project/defaultSupportedIdpConfigs/google.com"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_id")

