# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse',
    'GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse',
    'GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse',
    'GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse',
    'GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse',
    'GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse',
    'GoogleCloudDatapipelinesV1ScheduleSpecResponse',
    'GoogleCloudDatapipelinesV1WorkloadResponse',
]

@pulumi.output_type
class GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse(dict):
    """
    The environment values to be set at runtime for a Flex Template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExperiments":
            suggest = "additional_experiments"
        elif key == "additionalUserLabels":
            suggest = "additional_user_labels"
        elif key == "enableStreamingEngine":
            suggest = "enable_streaming_engine"
        elif key == "flexrsGoal":
            suggest = "flexrs_goal"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "maxWorkers":
            suggest = "max_workers"
        elif key == "numWorkers":
            suggest = "num_workers"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "tempLocation":
            suggest = "temp_location"
        elif key == "workerRegion":
            suggest = "worker_region"
        elif key == "workerZone":
            suggest = "worker_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_experiments: Sequence[str],
                 additional_user_labels: Mapping[str, str],
                 enable_streaming_engine: bool,
                 flexrs_goal: str,
                 ip_configuration: str,
                 kms_key_name: str,
                 machine_type: str,
                 max_workers: int,
                 network: str,
                 num_workers: int,
                 service_account_email: str,
                 subnetwork: str,
                 temp_location: str,
                 worker_region: str,
                 worker_zone: str,
                 zone: str):
        """
        The environment values to be set at runtime for a Flex Template.
        :param Sequence[str] additional_experiments: Additional experiment flags for the job.
        :param Mapping[str, str] additional_user_labels: Additional user labels to be specified for the job. Keys and values must follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions). An object containing a list of key/value pairs. Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.
        :param bool enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param str flexrs_goal: Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        :param str ip_configuration: Configuration for VM IPs.
        :param str kms_key_name: Name for the Cloud KMS key for the job. Key format is: projects//locations//keyRings//cryptoKeys/
        :param str machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param int max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param str network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param int num_workers: The initial number of Compute Engine instances for the job.
        :param str service_account_email: The email address of the service account to run the job as.
        :param str subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param str temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        :param str worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, defaults to the control plane region.
        :param str worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        :param str zone: The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        pulumi.set(__self__, "additional_experiments", additional_experiments)
        pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        pulumi.set(__self__, "flexrs_goal", flexrs_goal)
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "max_workers", max_workers)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "num_workers", num_workers)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "temp_location", temp_location)
        pulumi.set(__self__, "worker_region", worker_region)
        pulumi.set(__self__, "worker_zone", worker_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Sequence[str]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Mapping[str, str]:
        """
        Additional user labels to be specified for the job. Keys and values must follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions). An object containing a list of key/value pairs. Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.
        """
        return pulumi.get(self, "additional_user_labels")

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> bool:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @property
    @pulumi.getter(name="flexrsGoal")
    def flexrs_goal(self) -> str:
        """
        Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        """
        return pulumi.get(self, "flexrs_goal")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> str:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Name for the Cloud KMS key for the job. Key format is: projects//locations//keyRings//cryptoKeys/
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> int:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> int:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> str:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        """
        return pulumi.get(self, "temp_location")

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> str:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, defaults to the control plane region.
        """
        return pulumi.get(self, "worker_region")

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> str:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse(dict):
    """
    Launch Flex Template parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerSpecGcsPath":
            suggest = "container_spec_gcs_path"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "launchOptions":
            suggest = "launch_options"
        elif key == "transformNameMappings":
            suggest = "transform_name_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_spec_gcs_path: str,
                 environment: 'outputs.GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse',
                 job_name: str,
                 launch_options: Mapping[str, str],
                 parameters: Mapping[str, str],
                 transform_name_mappings: Mapping[str, str],
                 update: bool):
        """
        Launch Flex Template parameter.
        :param str container_spec_gcs_path: Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        :param 'GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse' environment: The runtime environment for the Flex Template job.
        :param str job_name: The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        :param Mapping[str, str] launch_options: Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        :param Mapping[str, str] parameters: The parameters for the Flex Template. Example: `{"num_workers":"5"}`
        :param Mapping[str, str] transform_name_mappings: Use this to pass transform name mappings for streaming update jobs. Example: `{"oldTransformName":"newTransformName",...}`
        :param bool update: Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        pulumi.set(__self__, "container_spec_gcs_path", container_spec_gcs_path)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "launch_options", launch_options)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "transform_name_mappings", transform_name_mappings)
        pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> str:
        """
        Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironmentResponse':
        """
        The runtime environment for the Flex Template job.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        """
        The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Mapping[str, str]:
        """
        Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        """
        return pulumi.get(self, "launch_options")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, str]:
        """
        The parameters for the Flex Template. Example: `{"num_workers":"5"}`
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="transformNameMappings")
    def transform_name_mappings(self) -> Mapping[str, str]:
        """
        Use this to pass transform name mappings for streaming update jobs. Example: `{"oldTransformName":"newTransformName",...}`
        """
        return pulumi.get(self, "transform_name_mappings")

    @property
    @pulumi.getter
    def update(self) -> bool:
        """
        Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse(dict):
    """
    A request to launch a Dataflow job from a Flex Template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchParameter":
            suggest = "launch_parameter"
        elif key == "validateOnly":
            suggest = "validate_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_parameter: 'outputs.GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse',
                 location: str,
                 project: str,
                 validate_only: bool):
        """
        A request to launch a Dataflow job from a Flex Template.
        :param 'GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse' launch_parameter: Parameter to launch a job from a Flex Template.
        :param str location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request. For example, `us-central1`, `us-west1`.
        :param str project: The ID of the Cloud Platform project that the job belongs to.
        :param bool validate_only: If true, the request is validated but not actually executed. Defaults to false.
        """
        pulumi.set(__self__, "launch_parameter", launch_parameter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="launchParameter")
    def launch_parameter(self) -> 'outputs.GoogleCloudDatapipelinesV1LaunchFlexTemplateParameterResponse':
        """
        Parameter to launch a job from a Flex Template.
        """
        return pulumi.get(self, "launch_parameter")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request. For example, `us-central1`, `us-west1`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> bool:
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
        return pulumi.get(self, "validate_only")


@pulumi.output_type
class GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse(dict):
    """
    Parameters to provide to the template being launched.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobName":
            suggest = "job_name"
        elif key == "transformNameMapping":
            suggest = "transform_name_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment: 'outputs.GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse',
                 job_name: str,
                 parameters: Mapping[str, str],
                 transform_name_mapping: Mapping[str, str],
                 update: bool):
        """
        Parameters to provide to the template being launched.
        :param 'GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse' environment: The runtime environment for the job.
        :param str job_name: The job name to use for the created job.
        :param Mapping[str, str] parameters: The runtime parameters to pass to the job.
        :param Mapping[str, str] transform_name_mapping: Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        :param bool update: If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)
        pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse':
        """
        The runtime environment for the job.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        """
        The job name to use for the created job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, str]:
        """
        The runtime parameters to pass to the job.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Mapping[str, str]:
        """
        Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        """
        return pulumi.get(self, "transform_name_mapping")

    @property
    @pulumi.getter
    def update(self) -> bool:
        """
        If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse(dict):
    """
    A request to launch a template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsPath":
            suggest = "gcs_path"
        elif key == "launchParameters":
            suggest = "launch_parameters"
        elif key == "validateOnly":
            suggest = "validate_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_path: str,
                 launch_parameters: 'outputs.GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse',
                 location: str,
                 project: str,
                 validate_only: bool):
        """
        A request to launch a template.
        :param str gcs_path: A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        :param 'GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse' launch_parameters: The parameters of the template to launch. This should be part of the body of the POST request.
        :param str location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request.
        :param str project: The ID of the Cloud Platform project that the job belongs to.
        :param bool validate_only: If true, the request is validated but not actually executed. Defaults to false.
        """
        pulumi.set(__self__, "gcs_path", gcs_path)
        pulumi.set(__self__, "launch_parameters", launch_parameters)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> str:
        """
        A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        """
        return pulumi.get(self, "gcs_path")

    @property
    @pulumi.getter(name="launchParameters")
    def launch_parameters(self) -> 'outputs.GoogleCloudDatapipelinesV1LaunchTemplateParametersResponse':
        """
        The parameters of the template to launch. This should be part of the body of the POST request.
        """
        return pulumi.get(self, "launch_parameters")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to which to direct the request.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> bool:
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
        return pulumi.get(self, "validate_only")


@pulumi.output_type
class GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse(dict):
    """
    The environment values to set at runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExperiments":
            suggest = "additional_experiments"
        elif key == "additionalUserLabels":
            suggest = "additional_user_labels"
        elif key == "bypassTempDirValidation":
            suggest = "bypass_temp_dir_validation"
        elif key == "enableStreamingEngine":
            suggest = "enable_streaming_engine"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "maxWorkers":
            suggest = "max_workers"
        elif key == "numWorkers":
            suggest = "num_workers"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "tempLocation":
            suggest = "temp_location"
        elif key == "workerRegion":
            suggest = "worker_region"
        elif key == "workerZone":
            suggest = "worker_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1RuntimeEnvironmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_experiments: Sequence[str],
                 additional_user_labels: Mapping[str, str],
                 bypass_temp_dir_validation: bool,
                 enable_streaming_engine: bool,
                 ip_configuration: str,
                 kms_key_name: str,
                 machine_type: str,
                 max_workers: int,
                 network: str,
                 num_workers: int,
                 service_account_email: str,
                 subnetwork: str,
                 temp_location: str,
                 worker_region: str,
                 worker_zone: str,
                 zone: str):
        """
        The environment values to set at runtime.
        :param Sequence[str] additional_experiments: Additional experiment flags for the job.
        :param Mapping[str, str] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) page. An object containing a list of key/value pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
        :param bool bypass_temp_dir_validation: Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        :param bool enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param str ip_configuration: Configuration for VM IPs.
        :param str kms_key_name: Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/
        :param str machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param int max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param str network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param int num_workers: The initial number of Compute Engine instances for the job.
        :param str service_account_email: The email address of the service account to run the job as.
        :param str subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param str temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        :param str worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        :param str worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        :param str zone: The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        pulumi.set(__self__, "additional_experiments", additional_experiments)
        pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        pulumi.set(__self__, "bypass_temp_dir_validation", bypass_temp_dir_validation)
        pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "max_workers", max_workers)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "num_workers", num_workers)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "temp_location", temp_location)
        pulumi.set(__self__, "worker_region", worker_region)
        pulumi.set(__self__, "worker_zone", worker_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Sequence[str]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Mapping[str, str]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) page. An object containing a list of key/value pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
        """
        return pulumi.get(self, "additional_user_labels")

    @property
    @pulumi.getter(name="bypassTempDirValidation")
    def bypass_temp_dir_validation(self) -> bool:
        """
        Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        """
        return pulumi.get(self, "bypass_temp_dir_validation")

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> bool:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> str:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> int:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> int:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> str:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        """
        return pulumi.get(self, "temp_location")

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> str:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> str:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GoogleCloudDatapipelinesV1ScheduleSpecResponse(dict):
    """
    Details of the schedule the pipeline runs on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextJobTime":
            suggest = "next_job_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1ScheduleSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1ScheduleSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1ScheduleSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_job_time: str,
                 schedule: str,
                 time_zone: str):
        """
        Details of the schedule the pipeline runs on.
        :param str next_job_time: When the next Scheduler job is going to run.
        :param str schedule: Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        :param str time_zone: Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        pulumi.set(__self__, "next_job_time", next_job_time)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="nextJobTime")
    def next_job_time(self) -> str:
        """
        When the next Scheduler job is going to run.
        """
        return pulumi.get(self, "next_job_time")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GoogleCloudDatapipelinesV1WorkloadResponse(dict):
    """
    Workload details for creating the pipeline jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataflowFlexTemplateRequest":
            suggest = "dataflow_flex_template_request"
        elif key == "dataflowLaunchTemplateRequest":
            suggest = "dataflow_launch_template_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatapipelinesV1WorkloadResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatapipelinesV1WorkloadResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatapipelinesV1WorkloadResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataflow_flex_template_request: 'outputs.GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse',
                 dataflow_launch_template_request: 'outputs.GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse'):
        """
        Workload details for creating the pipeline jobs.
        :param 'GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse' dataflow_flex_template_request: Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        :param 'GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse' dataflow_launch_template_request: Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        """
        pulumi.set(__self__, "dataflow_flex_template_request", dataflow_flex_template_request)
        pulumi.set(__self__, "dataflow_launch_template_request", dataflow_launch_template_request)

    @property
    @pulumi.getter(name="dataflowFlexTemplateRequest")
    def dataflow_flex_template_request(self) -> 'outputs.GoogleCloudDatapipelinesV1LaunchFlexTemplateRequestResponse':
        """
        Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        """
        return pulumi.get(self, "dataflow_flex_template_request")

    @property
    @pulumi.getter(name="dataflowLaunchTemplateRequest")
    def dataflow_launch_template_request(self) -> 'outputs.GoogleCloudDatapipelinesV1LaunchTemplateRequestResponse':
        """
        Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        """
        return pulumi.get(self, "dataflow_launch_template_request")


