# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetInstructionResult',
    'AwaitableGetInstructionResult',
    'get_instruction',
    'get_instruction_output',
]

@pulumi.output_type
class GetInstructionResult:
    def __init__(__self__, blocking_resources=None, create_time=None, csv_instruction=None, data_type=None, description=None, display_name=None, name=None, pdf_instruction=None, update_time=None):
        if blocking_resources and not isinstance(blocking_resources, list):
            raise TypeError("Expected argument 'blocking_resources' to be a list")
        pulumi.set(__self__, "blocking_resources", blocking_resources)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if csv_instruction and not isinstance(csv_instruction, dict):
            raise TypeError("Expected argument 'csv_instruction' to be a dict")
        if csv_instruction is not None:
            warnings.warn("""Deprecated: this instruction format is not supported any more. Instruction from a CSV file, such as for classification task. The CSV file should have exact two columns, in the following format: * The first column is labeled data, such as an image reference, text. * The second column is comma separated labels associated with data.""", DeprecationWarning)
            pulumi.log.warn("""csv_instruction is deprecated: Deprecated: this instruction format is not supported any more. Instruction from a CSV file, such as for classification task. The CSV file should have exact two columns, in the following format: * The first column is labeled data, such as an image reference, text. * The second column is comma separated labels associated with data.""")

        pulumi.set(__self__, "csv_instruction", csv_instruction)
        if data_type and not isinstance(data_type, str):
            raise TypeError("Expected argument 'data_type' to be a str")
        pulumi.set(__self__, "data_type", data_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pdf_instruction and not isinstance(pdf_instruction, dict):
            raise TypeError("Expected argument 'pdf_instruction' to be a dict")
        pulumi.set(__self__, "pdf_instruction", pdf_instruction)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="blockingResources")
    def blocking_resources(self) -> Sequence[str]:
        """
        The names of any related resources that are blocking changes to the instruction.
        """
        return pulumi.get(self, "blocking_resources")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation time of instruction.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="csvInstruction")
    def csv_instruction(self) -> 'outputs.GoogleCloudDatalabelingV1beta1CsvInstructionResponse':
        """
        Deprecated: this instruction format is not supported any more. Instruction from a CSV file, such as for classification task. The CSV file should have exact two columns, in the following format: * The first column is labeled data, such as an image reference, text. * The second column is comma separated labels associated with data.
        """
        return pulumi.get(self, "csv_instruction")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        The data type of this instruction.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User-provided description of the instruction. The description can be up to 10000 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the instruction. Maximum of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Instruction resource name, format: projects/{project_id}/instructions/{instruction_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pdfInstruction")
    def pdf_instruction(self) -> 'outputs.GoogleCloudDatalabelingV1beta1PdfInstructionResponse':
        """
        Instruction from a PDF document. The PDF should be in a Cloud Storage bucket.
        """
        return pulumi.get(self, "pdf_instruction")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last update time of instruction.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetInstructionResult(GetInstructionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstructionResult(
            blocking_resources=self.blocking_resources,
            create_time=self.create_time,
            csv_instruction=self.csv_instruction,
            data_type=self.data_type,
            description=self.description,
            display_name=self.display_name,
            name=self.name,
            pdf_instruction=self.pdf_instruction,
            update_time=self.update_time)


def get_instruction(instruction_id: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstructionResult:
    """
    Gets an instruction by resource name.
    """
    __args__ = dict()
    __args__['instructionId'] = instruction_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:datalabeling/v1beta1:getInstruction', __args__, opts=opts, typ=GetInstructionResult).value

    return AwaitableGetInstructionResult(
        blocking_resources=__ret__.blocking_resources,
        create_time=__ret__.create_time,
        csv_instruction=__ret__.csv_instruction,
        data_type=__ret__.data_type,
        description=__ret__.description,
        display_name=__ret__.display_name,
        name=__ret__.name,
        pdf_instruction=__ret__.pdf_instruction,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_instruction)
def get_instruction_output(instruction_id: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstructionResult]:
    """
    Gets an instruction by resource name.
    """
    ...
