# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetServerConfigResult',
    'AwaitableGetServerConfigResult',
    'get_server_config',
    'get_server_config_output',
]

@pulumi.output_type
class GetServerConfigResult:
    def __init__(__self__, channels=None, default_cluster_version=None, default_image_type=None, valid_image_types=None, valid_master_versions=None, valid_node_versions=None):
        if channels and not isinstance(channels, list):
            raise TypeError("Expected argument 'channels' to be a list")
        pulumi.set(__self__, "channels", channels)
        if default_cluster_version and not isinstance(default_cluster_version, str):
            raise TypeError("Expected argument 'default_cluster_version' to be a str")
        pulumi.set(__self__, "default_cluster_version", default_cluster_version)
        if default_image_type and not isinstance(default_image_type, str):
            raise TypeError("Expected argument 'default_image_type' to be a str")
        pulumi.set(__self__, "default_image_type", default_image_type)
        if valid_image_types and not isinstance(valid_image_types, list):
            raise TypeError("Expected argument 'valid_image_types' to be a list")
        pulumi.set(__self__, "valid_image_types", valid_image_types)
        if valid_master_versions and not isinstance(valid_master_versions, list):
            raise TypeError("Expected argument 'valid_master_versions' to be a list")
        pulumi.set(__self__, "valid_master_versions", valid_master_versions)
        if valid_node_versions and not isinstance(valid_node_versions, list):
            raise TypeError("Expected argument 'valid_node_versions' to be a list")
        pulumi.set(__self__, "valid_node_versions", valid_node_versions)

    @property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.ReleaseChannelConfigResponse']:
        """
        List of release channel configurations.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="defaultClusterVersion")
    def default_cluster_version(self) -> str:
        """
        Version of Kubernetes the service deploys by default.
        """
        return pulumi.get(self, "default_cluster_version")

    @property
    @pulumi.getter(name="defaultImageType")
    def default_image_type(self) -> str:
        """
        Default image type.
        """
        return pulumi.get(self, "default_image_type")

    @property
    @pulumi.getter(name="validImageTypes")
    def valid_image_types(self) -> Sequence[str]:
        """
        List of valid image types.
        """
        return pulumi.get(self, "valid_image_types")

    @property
    @pulumi.getter(name="validMasterVersions")
    def valid_master_versions(self) -> Sequence[str]:
        """
        List of valid master versions, in descending order.
        """
        return pulumi.get(self, "valid_master_versions")

    @property
    @pulumi.getter(name="validNodeVersions")
    def valid_node_versions(self) -> Sequence[str]:
        """
        List of valid node upgrade target versions, in descending order.
        """
        return pulumi.get(self, "valid_node_versions")


class AwaitableGetServerConfigResult(GetServerConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerConfigResult(
            channels=self.channels,
            default_cluster_version=self.default_cluster_version,
            default_image_type=self.default_image_type,
            valid_image_types=self.valid_image_types,
            valid_master_versions=self.valid_master_versions,
            valid_node_versions=self.valid_node_versions)


def get_server_config(location: Optional[str] = None,
                      project: Optional[str] = None,
                      project_id: Optional[str] = None,
                      zone: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerConfigResult:
    """
    Returns configuration info about the Google Kubernetes Engine service.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:container/v1:getServerConfig', __args__, opts=opts, typ=GetServerConfigResult).value

    return AwaitableGetServerConfigResult(
        channels=__ret__.channels,
        default_cluster_version=__ret__.default_cluster_version,
        default_image_type=__ret__.default_image_type,
        valid_image_types=__ret__.valid_image_types,
        valid_master_versions=__ret__.valid_master_versions,
        valid_node_versions=__ret__.valid_node_versions)


@_utilities.lift_output_func(get_server_config)
def get_server_config_output(location: Optional[pulumi.Input[str]] = None,
                             project: Optional[pulumi.Input[Optional[str]]] = None,
                             project_id: Optional[pulumi.Input[Optional[str]]] = None,
                             zone: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerConfigResult]:
    """
    Returns configuration info about the Google Kubernetes Engine service.
    """
    ...
