# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['CertificateMapEntryArgs', 'CertificateMapEntry']

@pulumi.input_type
class CertificateMapEntryArgs:
    def __init__(__self__, *,
                 certificate_map_entry_id: pulumi.Input[str],
                 certificate_map_id: pulumi.Input[str],
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 matcher: Optional[pulumi.Input['CertificateMapEntryMatcher']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CertificateMapEntry resource.
        :param pulumi.Input[str] certificate_map_entry_id: Required. A user-provided name of the certificate map entry.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: A set of Certificates defines for the given `hostname`. There can be defined up to fifteen certificates in each Certificate Map Entry. Each certificate must match pattern `projects/*/locations/*/certificates/*`.
        :param pulumi.Input[str] description: One or more paragraphs of text description of a certificate map entry.
        :param pulumi.Input[str] hostname: A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression (`*.example.com`) for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for selecting a proper certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with a Certificate Map Entry.
        :param pulumi.Input['CertificateMapEntryMatcher'] matcher: A predefined matcher for particular cases, other than SNI selection.
        :param pulumi.Input[str] name: A user-defined name of the Certificate Map Entry. Certificate Map Entry names must be unique globally and match pattern `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        """
        pulumi.set(__self__, "certificate_map_entry_id", certificate_map_entry_id)
        pulumi.set(__self__, "certificate_map_id", certificate_map_id)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="certificateMapEntryId")
    def certificate_map_entry_id(self) -> pulumi.Input[str]:
        """
        Required. A user-provided name of the certificate map entry.
        """
        return pulumi.get(self, "certificate_map_entry_id")

    @certificate_map_entry_id.setter
    def certificate_map_entry_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_map_entry_id", value)

    @property
    @pulumi.getter(name="certificateMapId")
    def certificate_map_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "certificate_map_id")

    @certificate_map_id.setter
    def certificate_map_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_map_id", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of Certificates defines for the given `hostname`. There can be defined up to fifteen certificates in each Certificate Map Entry. Each certificate must match pattern `projects/*/locations/*/certificates/*`.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        One or more paragraphs of text description of a certificate map entry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression (`*.example.com`) for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for selecting a proper certificate.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of labels associated with a Certificate Map Entry.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input['CertificateMapEntryMatcher']]:
        """
        A predefined matcher for particular cases, other than SNI selection.
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input['CertificateMapEntryMatcher']]):
        pulumi.set(self, "matcher", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the Certificate Map Entry. Certificate Map Entry names must be unique globally and match pattern `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class CertificateMapEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_map_entry_id: Optional[pulumi.Input[str]] = None,
                 certificate_map_id: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 matcher: Optional[pulumi.Input['CertificateMapEntryMatcher']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new CertificateMapEntry in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_map_entry_id: Required. A user-provided name of the certificate map entry.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: A set of Certificates defines for the given `hostname`. There can be defined up to fifteen certificates in each Certificate Map Entry. Each certificate must match pattern `projects/*/locations/*/certificates/*`.
        :param pulumi.Input[str] description: One or more paragraphs of text description of a certificate map entry.
        :param pulumi.Input[str] hostname: A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression (`*.example.com`) for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for selecting a proper certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with a Certificate Map Entry.
        :param pulumi.Input['CertificateMapEntryMatcher'] matcher: A predefined matcher for particular cases, other than SNI selection.
        :param pulumi.Input[str] name: A user-defined name of the Certificate Map Entry. Certificate Map Entry names must be unique globally and match pattern `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateMapEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new CertificateMapEntry in a given project and location.

        :param str resource_name: The name of the resource.
        :param CertificateMapEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateMapEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_map_entry_id: Optional[pulumi.Input[str]] = None,
                 certificate_map_id: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 matcher: Optional[pulumi.Input['CertificateMapEntryMatcher']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateMapEntryArgs.__new__(CertificateMapEntryArgs)

            if certificate_map_entry_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_map_entry_id'")
            __props__.__dict__["certificate_map_entry_id"] = certificate_map_entry_id
            if certificate_map_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_map_id'")
            __props__.__dict__["certificate_map_id"] = certificate_map_id
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["description"] = description
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["matcher"] = matcher
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["certificate_map_entry_id", "certificate_map_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CertificateMapEntry, __self__).__init__(
            'google-native:certificatemanager/v1:CertificateMapEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CertificateMapEntry':
        """
        Get an existing CertificateMapEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CertificateMapEntryArgs.__new__(CertificateMapEntryArgs)

        __props__.__dict__["certificate_map_entry_id"] = None
        __props__.__dict__["certificate_map_id"] = None
        __props__.__dict__["certificates"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["hostname"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["matcher"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["update_time"] = None
        return CertificateMapEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateMapEntryId")
    def certificate_map_entry_id(self) -> pulumi.Output[str]:
        """
        Required. A user-provided name of the certificate map entry.
        """
        return pulumi.get(self, "certificate_map_entry_id")

    @property
    @pulumi.getter(name="certificateMapId")
    def certificate_map_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "certificate_map_id")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence[str]]:
        """
        A set of Certificates defines for the given `hostname`. There can be defined up to fifteen certificates in each Certificate Map Entry. Each certificate must match pattern `projects/*/locations/*/certificates/*`.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation timestamp of a Certificate Map Entry.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        One or more paragraphs of text description of a certificate map entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression (`*.example.com`) for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for selecting a proper certificate.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Set of labels associated with a Certificate Map Entry.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def matcher(self) -> pulumi.Output[str]:
        """
        A predefined matcher for particular cases, other than SNI selection.
        """
        return pulumi.get(self, "matcher")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-defined name of the Certificate Map Entry. Certificate Map Entry names must be unique globally and match pattern `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        A serving state of this Certificate Map Entry.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update timestamp of a Certificate Map Entry.
        """
        return pulumi.get(self, "update_time")

