# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ManagedCertificateArgs',
    'SelfManagedCertificateArgs',
]

@pulumi.input_type
class ManagedCertificateArgs:
    def __init__(__self__, *,
                 dns_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Configuration and state of a Managed Certificate. Certificate Manager provisions and renews Managed Certificates automatically, for as long as it's authorized to do so.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_authorizations: Immutable. Authorizations that will be used for performing domain authorization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: Immutable. The domains for which a managed SSL certificate will be generated. Wildcard domains are only supported with DNS challenge resolution.
        """
        if dns_authorizations is not None:
            pulumi.set(__self__, "dns_authorizations", dns_authorizations)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)

    @property
    @pulumi.getter(name="dnsAuthorizations")
    def dns_authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Immutable. Authorizations that will be used for performing domain authorization.
        """
        return pulumi.get(self, "dns_authorizations")

    @dns_authorizations.setter
    def dns_authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_authorizations", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Immutable. The domains for which a managed SSL certificate will be generated. Wildcard domains are only supported with DNS challenge resolution.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)


@pulumi.input_type
class SelfManagedCertificateArgs:
    def __init__(__self__, *,
                 pem_certificate: Optional[pulumi.Input[str]] = None,
                 pem_private_key: Optional[pulumi.Input[str]] = None):
        """
        Certificate data for a SelfManaged Certificate. SelfManaged Certificates are uploaded by the user. Updating such certificates before they expire remains the user's responsibility.
        :param pulumi.Input[str] pem_certificate: Input only. The PEM-encoded certificate chain. Leaf certificate comes first, followed by intermediate ones if any.
        :param pulumi.Input[str] pem_private_key: Input only. The PEM-encoded private key of the leaf certificate.
        """
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_private_key is not None:
            pulumi.set(__self__, "pem_private_key", pem_private_key)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The PEM-encoded certificate chain. Leaf certificate comes first, followed by intermediate ones if any.
        """
        return pulumi.get(self, "pem_certificate")

    @pem_certificate.setter
    def pem_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_certificate", value)

    @property
    @pulumi.getter(name="pemPrivateKey")
    def pem_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The PEM-encoded private key of the leaf certificate.
        """
        return pulumi.get(self, "pem_private_key")

    @pem_private_key.setter
    def pem_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_private_key", value)


