# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    def __init__(__self__, create_time=None, hyperthreading_enabled=None, interactive_serial_console_enabled=None, labels=None, logical_interfaces=None, login_info=None, luns=None, machine_type=None, name=None, network_template=None, networks=None, os_image=None, pod=None, state=None, update_time=None, volumes=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if hyperthreading_enabled and not isinstance(hyperthreading_enabled, bool):
            raise TypeError("Expected argument 'hyperthreading_enabled' to be a bool")
        pulumi.set(__self__, "hyperthreading_enabled", hyperthreading_enabled)
        if interactive_serial_console_enabled and not isinstance(interactive_serial_console_enabled, bool):
            raise TypeError("Expected argument 'interactive_serial_console_enabled' to be a bool")
        pulumi.set(__self__, "interactive_serial_console_enabled", interactive_serial_console_enabled)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if logical_interfaces and not isinstance(logical_interfaces, list):
            raise TypeError("Expected argument 'logical_interfaces' to be a list")
        pulumi.set(__self__, "logical_interfaces", logical_interfaces)
        if login_info and not isinstance(login_info, str):
            raise TypeError("Expected argument 'login_info' to be a str")
        pulumi.set(__self__, "login_info", login_info)
        if luns and not isinstance(luns, list):
            raise TypeError("Expected argument 'luns' to be a list")
        pulumi.set(__self__, "luns", luns)
        if machine_type and not isinstance(machine_type, str):
            raise TypeError("Expected argument 'machine_type' to be a str")
        pulumi.set(__self__, "machine_type", machine_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_template and not isinstance(network_template, str):
            raise TypeError("Expected argument 'network_template' to be a str")
        pulumi.set(__self__, "network_template", network_template)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if os_image and not isinstance(os_image, str):
            raise TypeError("Expected argument 'os_image' to be a str")
        pulumi.set(__self__, "os_image", os_image)
        if pod and not isinstance(pod, str):
            raise TypeError("Expected argument 'pod' to be a str")
        pulumi.set(__self__, "pod", pod)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Create a time stamp.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="hyperthreadingEnabled")
    def hyperthreading_enabled(self) -> bool:
        """
        True if you enable hyperthreading for the server, otherwise false. The default value is false.
        """
        return pulumi.get(self, "hyperthreading_enabled")

    @property
    @pulumi.getter(name="interactiveSerialConsoleEnabled")
    def interactive_serial_console_enabled(self) -> bool:
        """
        True if the interactive serial console feature is enabled for the instance, false otherwise. The default value is false.
        """
        return pulumi.get(self, "interactive_serial_console_enabled")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logicalInterfaces")
    def logical_interfaces(self) -> Sequence['outputs.GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse']:
        """
        List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. For the non-multivlan configurations (for eg, existing servers) that use existing default network template (bondaa-bondaa), both the Instance.networks field and the Instance.logical_interfaces fields will be filled to ensure backward compatibility. For the others, only Instance.logical_interfaces will be filled.
        """
        return pulumi.get(self, "logical_interfaces")

    @property
    @pulumi.getter(name="loginInfo")
    def login_info(self) -> str:
        """
        Text field about info for logging in.
        """
        return pulumi.get(self, "login_info")

    @property
    @pulumi.getter
    def luns(self) -> Sequence['outputs.LunResponse']:
        """
        Immutable. List of LUNs associated with this server.
        """
        return pulumi.get(self, "luns")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Immutable. The server type. [Available server types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The resource name of this `Instance`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/instances/{instance}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkTemplate")
    def network_template(self) -> str:
        """
        Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc. Generally, the template name follows the syntax of "bond" or "nic".
        """
        return pulumi.get(self, "network_template")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.NetworkResponse']:
        """
        List of networks associated with this server.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> str:
        """
        The OS image currently installed on the server.
        """
        return pulumi.get(self, "os_image")

    @property
    @pulumi.getter
    def pod(self) -> str:
        """
        Immutable. Pod name. Pod is an independent part of infrastructure. Instance can be connected to the assets (networks, volumes) allocated in the same pod only.
        """
        return pulumi.get(self, "pod")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the server.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Update a time stamp.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Input only. List of Volumes to attach to this Instance on creation. This field won't be populated in Get/List responses.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            create_time=self.create_time,
            hyperthreading_enabled=self.hyperthreading_enabled,
            interactive_serial_console_enabled=self.interactive_serial_console_enabled,
            labels=self.labels,
            logical_interfaces=self.logical_interfaces,
            login_info=self.login_info,
            luns=self.luns,
            machine_type=self.machine_type,
            name=self.name,
            network_template=self.network_template,
            networks=self.networks,
            os_image=self.os_image,
            pod=self.pod,
            state=self.state,
            update_time=self.update_time,
            volumes=self.volumes)


def get_instance(instance_id: Optional[str] = None,
                 location: Optional[str] = None,
                 project: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Get details about a single server.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:baremetalsolution/v2:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        create_time=__ret__.create_time,
        hyperthreading_enabled=__ret__.hyperthreading_enabled,
        interactive_serial_console_enabled=__ret__.interactive_serial_console_enabled,
        labels=__ret__.labels,
        logical_interfaces=__ret__.logical_interfaces,
        login_info=__ret__.login_info,
        luns=__ret__.luns,
        machine_type=__ret__.machine_type,
        name=__ret__.name,
        network_template=__ret__.network_template,
        networks=__ret__.networks,
        os_image=__ret__.os_image,
        pod=__ret__.pod,
        state=__ret__.state,
        update_time=__ret__.update_time,
        volumes=__ret__.volumes)


@_utilities.lift_output_func(get_instance)
def get_instance_output(instance_id: Optional[pulumi.Input[str]] = None,
                        location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Get details about a single server.
    """
    ...
