# generated by datamodel-codegen:
#   filename:  entity/data/topic.json
#   timestamp: 2022-10-04T14:49:18+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, conint

from ...type import basic, entityHistory, entityReference, tagLabel
from ..services import messagingService


class SchemaType(Enum):
    Avro = 'Avro'
    Protobuf = 'Protobuf'
    JSON = 'JSON'
    Other = 'Other'


class CleanupPolicy(Enum):
    delete = 'delete'
    compact = 'compact'


class TopicConfig(BaseModel):
    pass


class TopicSampleData(BaseModel):
    class Config:
        extra = Extra.forbid

    messages: Optional[List[str]] = Field(
        None, description='List of local sample messages for a topic.'
    )


class Topic(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this topic instance.'
    )
    name: basic.EntityName = Field(..., description='Name that identifies the topic.')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description="Name that uniquely identifies a topic in the format 'messagingServiceName.topicName'.",
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this topic. It could be title or label from the source services.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the topic instance.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the messaging cluster/service where this topic is hosted in.',
    )
    serviceType: Optional[messagingService.MessagingServiceType] = Field(
        None, description='Service type where this topic is hosted in.'
    )
    schemaText: Optional[str] = Field(
        None,
        description='Schema used for message serialization. Optional as some topics may not have associated schemas.',
    )
    schemaType: Optional[SchemaType] = Field(
        None, description='Schema used for message serialization.'
    )
    partitions: conint(ge=1) = Field(
        ..., description='Number of partitions into which the topic is divided.'
    )
    cleanupPolicies: Optional[List[CleanupPolicy]] = Field(
        None,
        description='Topic clean up policies. For Kafka - `cleanup.policy` configuration.',
    )
    retentionTime: Optional[float] = Field(
        None,
        description='Retention time in milliseconds. For Kafka - `retention.ms` configuration.',
    )
    replicationFactor: Optional[int] = Field(
        None, description='Replication Factor in integer (more than 1).'
    )
    maximumMessageSize: Optional[int] = Field(
        None,
        description='Maximum message size in bytes. For Kafka - `max.message.bytes` configuration.',
    )
    minimumInSyncReplicas: Optional[int] = Field(
        None,
        description='Minimum number replicas in sync to control durability. For Kafka - `min.insync.replicas` configuration.',
    )
    retentionSize: Optional[float] = Field(
        '-1',
        description='Maximum size of a partition in bytes before old data is discarded. For Kafka - `retention.bytes` configuration.',
    )
    topicConfig: Optional[TopicConfig] = Field(
        None, description='Contains key/value pair of topic configuration.'
    )
    sampleData: Optional[TopicSampleData] = Field(
        None, description='Sample data for a topic.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this topic.'
    )
    followers: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Followers of this table.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this table.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
