# generated by datamodel-codegen:
#   filename:  configuration/authConfig.json
#   timestamp: 2022-10-04T14:49:18+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..security.client import (
    auth0SSOClientConfig,
    azureSSOClientConfig,
    customOidcSSOClientConfig,
    googleSSOClientConfig,
    oktaSSOClientConfig,
    openMetadataJWTClientConfig,
)


class AuthConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    google: Optional[googleSSOClientConfig.GoogleSSOClientConfig] = Field(
        None, description='Google SSO Configuration'
    )
    okta: Optional[oktaSSOClientConfig.OktaSSOClientConfig] = Field(
        None, description='Okta SSO Configuration'
    )
    auth0: Optional[auth0SSOClientConfig.Auth0SSOClientConfig] = Field(
        None, description='Auth0 SSO Configuration'
    )
    azure: Optional[azureSSOClientConfig.AzureSSOClientConfig] = Field(
        None, description='Azure SSO Configuration'
    )
    customOidc: Optional[customOidcSSOClientConfig.CustomOIDCSSOClientConfig] = Field(
        None, description='Custom OIDC SSO Configuration'
    )
    openmetadata: Optional[
        openMetadataJWTClientConfig.OpenMetadataJWTClientConfig
    ] = Field(None, description='OpenMetadata SSO Configuration')
