# generated by datamodel-codegen:
#   filename:  schema/entity/policies/accessControl/rule.json
#   timestamp: 2022-09-14T09:15:16+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ....type import basic, tagLabel


class Operation(Enum):
    Create = 'Create'
    Delete = 'Delete'
    ViewAll = 'ViewAll'
    ViewUsage = 'ViewUsage'
    ViewTests = 'ViewTests'
    TableViewQueries = 'TableViewQueries'
    TableViewDataProfile = 'TableViewDataProfile'
    TableViewSampleData = 'TableViewSampleData'
    EditAll = 'EditAll'
    EditDescription = 'EditDescription'
    EditTags = 'EditTags'
    EditOwner = 'EditOwner'
    EditTier = 'EditTier'
    EditCustomFields = 'EditCustomFields'
    EditLineage = 'EditLineage'
    EditReviewers = 'EditReviewers'
    EditTests = 'EditTests'
    TableEditQueries = 'TableEditQueries'
    TableEditDataProfile = 'TableEditDataProfile'
    TableEditSampleData = 'TableEditSampleData'
    TeamEditUsers = 'TeamEditUsers'


class AccessControlRule(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name for this Rule.')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    entityTypeAttr: Optional[str] = Field(
        None, description='Entity type that the rule should match on.'
    )
    entityTagAttr: Optional[tagLabel.TagFQN] = Field(
        None, description='Entity tag that the rule should match on.'
    )
    operation: Optional[Operation] = Field(None, description='Operation on the entity.')
    allow: Optional[bool] = Field(
        False, description='Allow or Deny operation on the entity.'
    )
    priority: Optional[int] = Field(
        250000, description='Priority of this rule among all rules across all policies.'
    )
    deleted: Optional[bool] = Field(False, description='Is the rule soft-deleted.')
