/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis.stream;

import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.RedisConfig$;
import com.redislabs.provider.redis.util.CollectionUtils$;
import com.redislabs.provider.redis.util.CollectionUtils$RichCollection$;
import com.redislabs.provider.redis.util.ConnectionUtils$;
import com.redislabs.provider.redis.util.Logging;
import com.redislabs.provider.redis.util.ParseUtils$;
import com.redislabs.provider.redis.util.StreamUtils$;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.redis.stream.RedisConsumerConfig;
import org.apache.spark.sql.redis.stream.RedisConsumerOffset;
import org.apache.spark.sql.redis.stream.RedisSource$;
import org.apache.spark.sql.redis.stream.RedisSourceConfig;
import org.apache.spark.sql.redis.stream.RedisSourceConfig$;
import org.apache.spark.sql.redis.stream.RedisSourceOffset;
import org.apache.spark.sql.redis.stream.RedisSourceOffsetRange;
import org.apache.spark.sql.redis.stream.RedisSourceRdd;
import org.apache.spark.sql.redis.stream.RedisSourceRdd$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001=\u00111BU3eSN\u001cv.\u001e:dK*\u00111\u0001B\u0001\u0007gR\u0014X-Y7\u000b\u0005\u00151\u0011!\u0002:fI&\u001c(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00111\u0001\u0002\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033yi\u0011A\u0007\u0006\u00037q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005u1\u0011!C3yK\u000e,H/[8o\u0013\ty\"D\u0001\u0004T_V\u00148-\u001a\t\u0003C-j\u0011A\t\u0006\u0003G\u0011\nA!\u001e;jY*\u0011Q!\n\u0006\u0003M\u001d\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003Q%\n\u0011B]3eSNd\u0017MY:\u000b\u0003)\n1aY8n\u0013\ta#EA\u0004M_\u001e<\u0017N\\4\t\u00119\u0002!\u0011!Q\u0001\n=\n!b]9m\u0007>tG/\u001a=u!\t\u0001\u0014'D\u0001\u0007\u0013\t\u0011dA\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!N\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\t\u0003m}r!aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0005ir\u0011A\u0002\u001fs_>$hHC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 <\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015!E;tKJ$UMZ5oK\u0012\u001c6\r[3nCB\u0019QI\u0012%\u000e\u0003mJ!aR\u001e\u0003\r=\u0003H/[8o!\tIE*D\u0001K\u0015\tYe!A\u0003usB,7/\u0003\u0002N\u0015\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b!\u0002]1sC6,G/\u001a:t!\u00111\u0014+N\u001b\n\u0005I\u000b%aA'ba\")A\u000b\u0001C\u0001+\u00061A(\u001b8jiz\"RA\u0016-Z5n\u0003\"a\u0016\u0001\u000e\u0003\tAQAL*A\u0002=BQ\u0001N*A\u0002UBQaQ*A\u0002\u0011CQaT*A\u0002ACq!\u0018\u0001C\u0002\u0013%a,\u0001\u0002tGV\tq\f\u0005\u0002aC6\t\u0001\"\u0003\u0002c\u0011\ta1\u000b]1sW\u000e{g\u000e^3yi\"1A\r\u0001Q\u0001\n}\u000b1a]2!\u0011\u001d1\u0007A1A\u0005\f\u001d\f1B]3eSN\u001cuN\u001c4jOV\t\u0001\u000e\u0005\u0002jU6\tA%\u0003\u0002lI\tY!+\u001a3jg\u000e{gNZ5h\u0011\u0019i\u0007\u0001)A\u0005Q\u0006a!/\u001a3jg\u000e{gNZ5hA!9q\u000e\u0001b\u0001\n\u0013\u0001\u0018\u0001D:pkJ\u001cWmQ8oM&<W#A9\u0011\u0005]\u0013\u0018BA:\u0003\u0005E\u0011V\rZ5t'>,(oY3D_:4\u0017n\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B9\u0002\u001bM|WO]2f\u0007>tg-[4!\u0011\u001d9\bA1A\u0005\na\fQbY;se\u0016tGoU2iK6\fW#\u0001%\t\ri\u0004\u0001\u0015!\u0003I\u00039\u0019WO\u001d:f]R\u001c6\r[3nC\u0002BQ\u0001 \u0001\u0005\u0002u\fQa\u001d;beR$\u0012A \t\u0003\u000b~L1!!\u0001<\u0005\u0011)f.\u001b;\t\r\u0005\u0015\u0001\u0001\"\u0011y\u0003\u0019\u00198\r[3nC\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011!C4fi>3gm]3u+\t\ti\u0001\u0005\u0003F\r\u0006=\u0001cA\r\u0002\u0012%\u0019\u00111\u0003\u000e\u0003\r=3gm]3u\u0011\u001d\t9\u0002\u0001C!\u00033\t\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u00037\tI$a\u000f\u0011\t\u0005u\u00111\u0007\b\u0005\u0003?\tyC\u0004\u0003\u0002\"\u00055b\u0002BA\u0012\u0003WqA!!\n\u0002*9\u0019\u0001(a\n\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\r\t\tDB\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)$a\u000e\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\u0019\r!9A0!\u0006A\u0002\u00055\u0001\u0002CA\u001f\u0003+\u0001\r!a\u0004\u0002\u0007\u0015tG\rC\u0004\u0002B\u0001!\t%a\u0011\u0002\r\r|W.\\5u)\rq\u0018Q\t\u0005\t\u0003{\ty\u00041\u0001\u0002\u0010!1\u0011\u0011\n\u0001\u0005Bu\fAa\u001d;pa\"9\u0011Q\n\u0001\u0005\n\u0005=\u0013A\b:fg\u0016$8i\u001c8tk6,'o\u0012:pkB\u001c\u0018J\u001a%bg>3gm]3u)\rq\u0018\u0011\u000b\u0005\t\u0003'\nY\u00051\u0001\u0002V\u0005aqN\u001a4tKR\u0014\u0016M\\4fgB1\u0011qKA0\u0003KrA!!\u0017\u0002^9\u0019\u0001(a\u0017\n\u0003qJ1!!\r<\u0013\u0011\t\t'a\u0019\u0003\u0007M+\u0017OC\u0002\u00022m\u00022aVA4\u0013\r\tIG\u0001\u0002\u0017%\u0016$\u0017n]*pkJ\u001cWm\u00144gg\u0016$(+\u00198hK\"9\u0011Q\u000e\u0001\u0005\n\u0005=\u0014A\n4pe\u0016\u000b7\r[(gMN,GOU1oO\u0016<\u0016\u000e\u001e5TiJ,\u0017-\\\"p]:,7\r^5p]R!\u0011\u0011OAH)\rq\u00181\u000f\u0005\t\u0003k\nY\u00071\u0001\u0002x\u0005\u0011q\u000e\u001d\t\t\u000b\u0006e\u0014QPA3}&\u0019\u00111P\u001e\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA@\u0003\u0017k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0006U\u0016$\u0017n\u001d\u0006\u0005\u0003\u000f\u000bI)A\u0004dY&,g\u000e^:\u000b\u0003\u0015IA!!$\u0002\u0002\n)!*\u001a3jg\"A\u00111KA6\u0001\u0004\t)fB\u0004\u0002\u0014\nA\t!!&\u0002\u0017I+G-[:T_V\u00148-\u001a\t\u0004/\u0006]eAB\u0001\u0003\u0011\u0003\tIj\u0005\u0003\u0002\u0018\u0006m\u0005cA#\u0002\u001e&\u0019\u0011qT\u001e\u0003\r\u0005s\u0017PU3g\u0011\u001d!\u0016q\u0013C\u0001\u0003G#\"!!&\t\u0011\u0005\u001d\u0016q\u0013C\u0001\u0003S\u000bqbZ3u\u001f\u001a47/\u001a;SC:<Wm\u001d\u000b\t\u0003+\nY+!,\u00020\"9A0!*A\u0002\u00055\u0001\u0002CA\u001f\u0003K\u0003\r!a\u0004\t\u0011\u0005E\u0016Q\u0015a\u0001\u0003g\u000bqbY8ogVlWM]\"p]\u001aLwm\u001d\t\u0007\u0003/\ny&!.\u0011\u0007]\u000b9,C\u0002\u0002:\n\u00111CU3eSN\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001eD\u0001\"!0\u0002\u0018\u0012\u0005\u0011qX\u0001\rgR\u0014X-Y7MCN$\u0018\n\u001a\u000b\u0006k\u0005\u0005\u0017Q\u0019\u0005\t\u0003\u0007\fY\f1\u0001\u0002~\u0005!1m\u001c8o\u0011\u001d\t9-a/A\u0002U\n\u0011b\u001d;sK\u0006l7*Z=")
public class RedisSource
implements Source,
Logging {
    private final SQLContext sqlContext;
    private final SparkContext sc;
    private final RedisConfig redisConfig;
    private final RedisSourceConfig sourceConfig;
    private final StructType currentSchema;
    private transient Logger com$redislabs$provider$redis$util$Logging$$_logger;

    public static String streamLastId(Jedis jedis, String string) {
        return RedisSource$.MODULE$.streamLastId(jedis, string);
    }

    public static Seq<RedisSourceOffsetRange> getOffsetRanges(Option<org.apache.spark.sql.execution.streaming.Offset> option, org.apache.spark.sql.execution.streaming.Offset offset, Seq<RedisConsumerConfig> seq) {
        return RedisSource$.MODULE$.getOffsetRanges(option, offset, seq);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    @Override
    public Logger com$redislabs$provider$redis$util$Logging$$_logger() {
        return this.com$redislabs$provider$redis$util$Logging$$_logger;
    }

    @Override
    public void com$redislabs$provider$redis$util$Logging$$_logger_$eq(Logger x$1) {
        this.com$redislabs$provider$redis$util$Logging$$_logger = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private RedisConfig redisConfig() {
        return this.redisConfig;
    }

    private RedisSourceConfig sourceConfig() {
        return this.sourceConfig;
    }

    private StructType currentSchema() {
        return this.currentSchema;
    }

    public void start() {
        this.sourceConfig().consumerConfigs().foreach((Function1 & Serializable & scala.Serializable)consumerConfig -> {
            RedisSource.$anonfun$start$1(this, consumerConfig);
            return BoxedUnit.UNIT;
        });
    }

    public StructType schema() {
        return this.currentSchema();
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        RedisSourceOffset initialOffset = new RedisSourceOffset((scala.collection.immutable.Map<String, RedisConsumerOffset>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        RedisSourceOffset sourceOffset = (RedisSourceOffset)((Object)this.sourceConfig().consumerConfigs().foldLeft((Object)initialOffset, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RedisSourceOffset acc = (RedisSourceOffset)((Object)((Object)tuple2._1()));
            RedisConsumerConfig e = (RedisConsumerConfig)tuple2._2();
            String streamKey = e.streamKey();
            RedisSourceOffset redisSourceOffset = (RedisSourceOffset)((Object)((Object)ConnectionUtils$.MODULE$.withConnection(streamKey, (Function1 & Serializable & scala.Serializable)conn -> (RedisSourceOffset)((Object)((Object)((Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String offsetId = RedisSource$.MODULE$.streamLastId((Jedis)conn, streamKey);
                Tuple2 streamOffset = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)streamKey), (Object)new RedisConsumerOffset(e.groupName(), offsetId));
                return acc.copy((scala.collection.immutable.Map<String, RedisConsumerOffset>)acc.offsets().$plus(streamOffset));
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> acc)))), this.redisConfig())));
            return redisSourceOffset;
        }));
        return sourceOffset.offsets().isEmpty() ? None$.MODULE$ : new Some((Object)sourceOffset);
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting batch...\n         |  start: ", "\n         |  end: ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{start, end})))).stripMargin());
        StructType localSchema = this.currentSchema();
        Seq<RedisSourceOffsetRange> offsetRanges = RedisSource$.MODULE$.getOffsetRanges(start, end, this.sourceConfig().consumerConfigs());
        this.resetConsumerGroupsIfHasOffset(offsetRanges);
        RDD internalRdd = new RedisSourceRdd(this.sc(), this.redisConfig(), offsetRanges, RedisSourceRdd$.MODULE$.$lessinit$greater$default$4()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StreamEntryID id = (StreamEntryID)tuple2._1();
            Map fields = (Map)tuple2._2();
            scala.collection.immutable.Map fieldMap = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fields).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_id"), (Object)id.toString()));
            Object[] values = (Object[])Predef$.MODULE$.genericArrayOps((Object)ParseUtils$.MODULE$.parseFields((scala.collection.immutable.Map<String, String>)fieldMap, localSchema)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Object object;
                Object object2 = x0$3;
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = UTF8String.fromString((String)string);
                } else if (object2 instanceof Object) {
                    Object object3 = object2;
                    object = object3;
                } else {
                    throw new MatchError(object2);
                }
                return object;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            InternalRow internalRow = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)values));
            return internalRow;
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sqlContext.internalCreateDataFrame(internalRdd, this.schema(), true);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committing offset..\n         |  end: ", "\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{end.json()})))).stripMargin());
    }

    public void stop() {
    }

    private void resetConsumerGroupsIfHasOffset(Seq<RedisSourceOffsetRange> offsetRanges) {
        this.forEachOffsetRangeWithStreamConnection(offsetRanges, (Function2<Jedis, RedisSourceOffsetRange, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$2) -> {
            RedisSource.$anonfun$resetConsumerGroupsIfHasOffset$1(x0$4, x1$2);
            return BoxedUnit.UNIT;
        });
    }

    private void forEachOffsetRangeWithStreamConnection(Seq<RedisSourceOffsetRange> offsetRanges, Function2<Jedis, RedisSourceOffsetRange, BoxedUnit> op) {
        offsetRanges.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.config().streamKey()).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            RedisSource.$anonfun$forEachOffsetRangeWithStreamConnection$2(this, op, x0$5);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$start$6(String streamKey$1, String groupName$1, Option configOffsetOption$1, Jedis conn) {
        StreamUtils$.MODULE$.createConsumerGroupIfNotExist(conn, streamKey$1, groupName$1, (StreamEntryID)configOffsetOption$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> StreamEntryID.LAST_ENTRY));
        configOffsetOption$1.foreach((Function1 & Serializable & scala.Serializable)offset -> {
            StreamUtils$.MODULE$.resetConsumerGroup(conn, streamKey$1, groupName$1, offset);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$start$1(RedisSource $this, RedisConsumerConfig consumerConfig) {
        scala.collection.immutable.Map offsetsByStreamKey = (scala.collection.immutable.Map)$this.sourceConfig().start().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.offsets()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        String streamKey = consumerConfig.streamKey();
        String groupName = consumerConfig.groupName();
        Option configOffsetOption = offsetsByStreamKey.get((Object)streamKey).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.offset()).map((Function1 & Serializable & scala.Serializable)x$3 -> new StreamEntryID((String)x$3));
        ConnectionUtils$.MODULE$.withConnection(streamKey, (Function1 & Serializable & scala.Serializable)conn -> {
            RedisSource.$anonfun$start$6(streamKey, groupName, configOffsetOption, conn);
            return BoxedUnit.UNIT;
        }, $this.redisConfig());
    }

    public static final /* synthetic */ void $anonfun$resetConsumerGroupsIfHasOffset$3(Jedis conn$1, RedisSourceOffsetRange offsetRange$1, StreamEntryID start) {
        RedisConsumerConfig config = offsetRange$1.config();
        StreamUtils$.MODULE$.resetConsumerGroup(conn$1, config.streamKey(), config.groupName(), start);
    }

    public static final /* synthetic */ void $anonfun$resetConsumerGroupsIfHasOffset$1(Jedis x0$4, RedisSourceOffsetRange x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Jedis conn = (Jedis)tuple2._1();
        RedisSourceOffsetRange offsetRange = (RedisSourceOffsetRange)tuple2._2();
        offsetRange.start().map((Function1 & Serializable & scala.Serializable)x$4 -> new StreamEntryID((String)x$4)).foreach((Function1 & Serializable & scala.Serializable)start -> {
            RedisSource.$anonfun$resetConsumerGroupsIfHasOffset$3(conn, offsetRange, start);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$forEachOffsetRangeWithStreamConnection$3(Function2 op$1, Seq subRanges$1, Jedis conn) {
        ((IterableLike)CollectionUtils$RichCollection$.MODULE$.distinctBy$extension(CollectionUtils$.MODULE$.RichCollection(subRanges$1), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.config().groupName(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)offsetRange -> {
            op$1.apply((Object)conn, (Object)offsetRange);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$forEachOffsetRangeWithStreamConnection$2(RedisSource $this, Function2 op$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String streamKey = (String)tuple2._1();
        Seq subRanges = (Seq)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)ConnectionUtils$.MODULE$.withConnection(streamKey, (Function1 & Serializable & scala.Serializable)conn -> {
            RedisSource.$anonfun$forEachOffsetRangeWithStreamConnection$3(op$1, subRanges, conn);
            return BoxedUnit.UNIT;
        }, $this.redisConfig());
    }

    public RedisSource(SQLContext sqlContext, String metadataPath, Option<StructType> userDefinedSchema, scala.collection.immutable.Map<String, String> parameters) {
        this.sqlContext = sqlContext;
        Source.$init$((Source)this);
        Logging.$init$(this);
        this.sc = sqlContext.sparkContext();
        this.redisConfig = RedisConfig$.MODULE$.fromSparkConfAndParameters(this.sc().getConf(), parameters);
        this.sourceConfig = RedisSourceConfig$.MODULE$.fromMap(parameters);
        this.currentSchema = (StructType)userDefinedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Please specify schema");
        });
    }
}

