# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Role']


class Role(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_row_level_security: Optional[pulumi.Input[bool]] = None,
                 connection_limit: Optional[pulumi.Input[int]] = None,
                 create_database: Optional[pulumi.Input[bool]] = None,
                 create_role: Optional[pulumi.Input[bool]] = None,
                 encrypted: Optional[pulumi.Input[str]] = None,
                 encrypted_password: Optional[pulumi.Input[bool]] = None,
                 inherit: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 replication: Optional[pulumi.Input[bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_drop_role: Optional[pulumi.Input[bool]] = None,
                 skip_reassign_owned: Optional[pulumi.Input[bool]] = None,
                 statement_timeout: Optional[pulumi.Input[int]] = None,
                 superuser: Optional[pulumi.Input[bool]] = None,
                 valid_until: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Role resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] bypass_row_level_security: Defines whether a role bypasses every
               row-level security (RLS) policy.  Default value is `false`.
        :param pulumi.Input[int] connection_limit: If this role can log in, this specifies how
               many concurrent connections the role can establish. `-1` (the default) means no
               limit.
        :param pulumi.Input[bool] create_database: Defines a role's ability to execute `CREATE
               DATABASE`.  Default value is `false`.
        :param pulumi.Input[bool] create_role: Defines a role's ability to execute `CREATE ROLE`.
               A role with this privilege can also alter and drop other roles.  Default value
               is `false`.
        :param pulumi.Input[bool] encrypted_password: Defines whether the password is stored
               encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
               is always set (to the conservative and safe value), but may interfere with the
               behavior of
               [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        :param pulumi.Input[bool] inherit: Defines whether a role "inherits" the privileges of
               roles it is a member of.  Default value is `true`.
        :param pulumi.Input[bool] login: Defines whether role is allowed to log in.  Roles without
               this attribute are useful for managing database privileges, but are not users
               in the usual sense of the word.  Default value is `false`.
        :param pulumi.Input[str] name: The name of the role. Must be unique on the PostgreSQL
               server instance where it is configured.
        :param pulumi.Input[str] password: Sets the role's password. A password is only of use
               for roles having the `login` attribute set to true.
        :param pulumi.Input[bool] replication: Defines whether a role is allowed to initiate
               streaming replication or put the system in and out of backup mode.  Default
               value is `false`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Defines list of roles which will be granted to this new role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Alters the search path of this new role. Note that
               due to limitations in the implementation, values cannot contain the substring
               `", "`.
        :param pulumi.Input[bool] skip_drop_role: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, the
               [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
               in each of the respective databases must occur before the ROLE can be dropped
               from the catalog.  Set this option to true when there are multiple databases
               in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
               This is the third and final step taken when removing a ROLE from a database.
        :param pulumi.Input[bool] skip_reassign_owned: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, a
               [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
               must be executed on each of the respective databases before the `DROP ROLE`
               can be executed to dropped the ROLE from the catalog.  This is the first and
               second steps taken when removing a ROLE from a database (the second step being
               an implicit
               [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        :param pulumi.Input[int] statement_timeout: Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        :param pulumi.Input[bool] superuser: Defines whether the role is a "superuser", and
               therefore can override all access restrictions within the database.  Default
               value is `false`.
        :param pulumi.Input[str] valid_until: Defines the date and time after which the role's
               password is no longer valid.  Established connections past this `valid_time`
               will have to be manually terminated.  This value corresponds to a PostgreSQL
               datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
               set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['bypass_row_level_security'] = bypass_row_level_security
            __props__['connection_limit'] = connection_limit
            __props__['create_database'] = create_database
            __props__['create_role'] = create_role
            if encrypted is not None:
                warnings.warn("""Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""", DeprecationWarning)
                pulumi.log.warn("encrypted is deprecated: Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"")
            __props__['encrypted'] = encrypted
            __props__['encrypted_password'] = encrypted_password
            __props__['inherit'] = inherit
            __props__['login'] = login
            __props__['name'] = name
            __props__['password'] = password
            __props__['replication'] = replication
            __props__['roles'] = roles
            __props__['search_paths'] = search_paths
            __props__['skip_drop_role'] = skip_drop_role
            __props__['skip_reassign_owned'] = skip_reassign_owned
            __props__['statement_timeout'] = statement_timeout
            __props__['superuser'] = superuser
            __props__['valid_until'] = valid_until
        super(Role, __self__).__init__(
            'postgresql:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass_row_level_security: Optional[pulumi.Input[bool]] = None,
            connection_limit: Optional[pulumi.Input[int]] = None,
            create_database: Optional[pulumi.Input[bool]] = None,
            create_role: Optional[pulumi.Input[bool]] = None,
            encrypted: Optional[pulumi.Input[str]] = None,
            encrypted_password: Optional[pulumi.Input[bool]] = None,
            inherit: Optional[pulumi.Input[bool]] = None,
            login: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            replication: Optional[pulumi.Input[bool]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            skip_drop_role: Optional[pulumi.Input[bool]] = None,
            skip_reassign_owned: Optional[pulumi.Input[bool]] = None,
            statement_timeout: Optional[pulumi.Input[int]] = None,
            superuser: Optional[pulumi.Input[bool]] = None,
            valid_until: Optional[pulumi.Input[str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] bypass_row_level_security: Defines whether a role bypasses every
               row-level security (RLS) policy.  Default value is `false`.
        :param pulumi.Input[int] connection_limit: If this role can log in, this specifies how
               many concurrent connections the role can establish. `-1` (the default) means no
               limit.
        :param pulumi.Input[bool] create_database: Defines a role's ability to execute `CREATE
               DATABASE`.  Default value is `false`.
        :param pulumi.Input[bool] create_role: Defines a role's ability to execute `CREATE ROLE`.
               A role with this privilege can also alter and drop other roles.  Default value
               is `false`.
        :param pulumi.Input[bool] encrypted_password: Defines whether the password is stored
               encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
               is always set (to the conservative and safe value), but may interfere with the
               behavior of
               [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        :param pulumi.Input[bool] inherit: Defines whether a role "inherits" the privileges of
               roles it is a member of.  Default value is `true`.
        :param pulumi.Input[bool] login: Defines whether role is allowed to log in.  Roles without
               this attribute are useful for managing database privileges, but are not users
               in the usual sense of the word.  Default value is `false`.
        :param pulumi.Input[str] name: The name of the role. Must be unique on the PostgreSQL
               server instance where it is configured.
        :param pulumi.Input[str] password: Sets the role's password. A password is only of use
               for roles having the `login` attribute set to true.
        :param pulumi.Input[bool] replication: Defines whether a role is allowed to initiate
               streaming replication or put the system in and out of backup mode.  Default
               value is `false`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Defines list of roles which will be granted to this new role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Alters the search path of this new role. Note that
               due to limitations in the implementation, values cannot contain the substring
               `", "`.
        :param pulumi.Input[bool] skip_drop_role: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, the
               [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
               in each of the respective databases must occur before the ROLE can be dropped
               from the catalog.  Set this option to true when there are multiple databases
               in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
               This is the third and final step taken when removing a ROLE from a database.
        :param pulumi.Input[bool] skip_reassign_owned: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, a
               [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
               must be executed on each of the respective databases before the `DROP ROLE`
               can be executed to dropped the ROLE from the catalog.  This is the first and
               second steps taken when removing a ROLE from a database (the second step being
               an implicit
               [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        :param pulumi.Input[int] statement_timeout: Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        :param pulumi.Input[bool] superuser: Defines whether the role is a "superuser", and
               therefore can override all access restrictions within the database.  Default
               value is `false`.
        :param pulumi.Input[str] valid_until: Defines the date and time after which the role's
               password is no longer valid.  Established connections past this `valid_time`
               will have to be manually terminated.  This value corresponds to a PostgreSQL
               datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
               set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["bypass_row_level_security"] = bypass_row_level_security
        __props__["connection_limit"] = connection_limit
        __props__["create_database"] = create_database
        __props__["create_role"] = create_role
        __props__["encrypted"] = encrypted
        __props__["encrypted_password"] = encrypted_password
        __props__["inherit"] = inherit
        __props__["login"] = login
        __props__["name"] = name
        __props__["password"] = password
        __props__["replication"] = replication
        __props__["roles"] = roles
        __props__["search_paths"] = search_paths
        __props__["skip_drop_role"] = skip_drop_role
        __props__["skip_reassign_owned"] = skip_reassign_owned
        __props__["statement_timeout"] = statement_timeout
        __props__["superuser"] = superuser
        __props__["valid_until"] = valid_until
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bypassRowLevelSecurity")
    def bypass_row_level_security(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether a role bypasses every
        row-level security (RLS) policy.  Default value is `false`.
        """
        return pulumi.get(self, "bypass_row_level_security")

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> pulumi.Output[Optional[int]]:
        """
        If this role can log in, this specifies how
        many concurrent connections the role can establish. `-1` (the default) means no
        limit.
        """
        return pulumi.get(self, "connection_limit")

    @property
    @pulumi.getter(name="createDatabase")
    def create_database(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines a role's ability to execute `CREATE
        DATABASE`.  Default value is `false`.
        """
        return pulumi.get(self, "create_database")

    @property
    @pulumi.getter(name="createRole")
    def create_role(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines a role's ability to execute `CREATE ROLE`.
        A role with this privilege can also alter and drop other roles.  Default value
        is `false`.
        """
        return pulumi.get(self, "create_role")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="encryptedPassword")
    def encrypted_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether the password is stored
        encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
        is always set (to the conservative and safe value), but may interfere with the
        behavior of
        [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        """
        return pulumi.get(self, "encrypted_password")

    @property
    @pulumi.getter
    def inherit(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether a role "inherits" the privileges of
        roles it is a member of.  Default value is `true`.
        """
        return pulumi.get(self, "inherit")

    @property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether role is allowed to log in.  Roles without
        this attribute are useful for managing database privileges, but are not users
        in the usual sense of the word.  Default value is `false`.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the role. Must be unique on the PostgreSQL
        server instance where it is configured.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the role's password. A password is only of use
        for roles having the `login` attribute set to true.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def replication(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether a role is allowed to initiate
        streaming replication or put the system in and out of backup mode.  Default
        value is `false`
        """
        return pulumi.get(self, "replication")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Defines list of roles which will be granted to this new role.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Alters the search path of this new role. Note that
        due to limitations in the implementation, values cannot contain the substring
        `", "`.
        """
        return pulumi.get(self, "search_paths")

    @property
    @pulumi.getter(name="skipDropRole")
    def skip_drop_role(self) -> pulumi.Output[Optional[bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, the
        [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
        in each of the respective databases must occur before the ROLE can be dropped
        from the catalog.  Set this option to true when there are multiple databases
        in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
        This is the third and final step taken when removing a ROLE from a database.
        """
        return pulumi.get(self, "skip_drop_role")

    @property
    @pulumi.getter(name="skipReassignOwned")
    def skip_reassign_owned(self) -> pulumi.Output[Optional[bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, a
        [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
        must be executed on each of the respective databases before the `DROP ROLE`
        can be executed to dropped the ROLE from the catalog.  This is the first and
        second steps taken when removing a ROLE from a database (the second step being
        an implicit
        [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        """
        return pulumi.get(self, "skip_reassign_owned")

    @property
    @pulumi.getter(name="statementTimeout")
    def statement_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        """
        return pulumi.get(self, "statement_timeout")

    @property
    @pulumi.getter
    def superuser(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether the role is a "superuser", and
        therefore can override all access restrictions within the database.  Default
        value is `false`.
        """
        return pulumi.get(self, "superuser")

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the date and time after which the role's
        password is no longer valid.  Established connections past this `valid_time`
        will have to be manually terminated.  This value corresponds to a PostgreSQL
        datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
        set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        return pulumi.get(self, "valid_until")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

