---
  
   35005550    22           666     666             165           
  002          77    003    555     555             350           
 056                155677  555     555             3554 337      
 053   89889   00   4559    55555555555  006   400  3557   008    
 059     300   00    051    555     555  059   700  350    850    
 3007    700   00    053    555     555  059   400  350    950    
   900988500   00    90034  000     000  800371650  205847805     
  
---

# Command Line ASCII Art Generator

ASCIIcli is a command line interface that is powered by Python3. You can generate ASCII art by importing an image and then selecting the character set that you want to generate with.  

## Installation & Building

### PIP

The easiest way to install ASCIIcli is by using the [PyPI library](https://pypi.org/project/asciicli/).  
You can run `pip install ASCIIcli` on any command-line with Python3 in order to install it.  

### Releases

If you are unable to use the PyPI library you can access ASCIIcli by going to our [releases page](https://github.com/mrq-andras/asciicli/releases).  
There you can download the .exe file and run the CLI by going to the folder that the program is downloaded in and running `.\asciicli`  

---

## Usage

`asciicli C:/full/path/to/your/image [-h] [-percent VALUE] [-set VALUE] [-gray VALUE] [-random] [-invert]`  
  
If you have downloaded the application through pip input the following command in the terminal:  
`asciicli C:/full/path/to/your/image -p 10 -s 1 -r`

If you are running the .exe package you will need to slightly alter the command by calling the exact folder of ASCIIcli  
`.\path\to\asciicli.exe C:/full/path/to/your/image` -p 10 -s 1 -r

Assuming the file is 1024x219, this command will generate a .txt file that is 21 lines long with each line taking up 201 characters using the character set to one. The `-s` variable is optional as the default character set is one. Random has been set to true and it will take the image from assets/input.jpg and generate a .txt file titled input-ascii.jpg in the same folder as the image.  

Random and Invert are will take effect when called upon with the -random/-r and -invert/-i arguments, whereas the Gray and Set arguments are all integers.  

### [Basic Latin](https://en.wikipedia.org/wiki/Basic_Latin_(Unicode_block)) & [Latin Supliments](https://en.wikipedia.org/wiki/Latin-1_Supplement)

Set 1: a --> z (lowercase)  
Set 2: A --> Z  (uppercase)  
Set 3: 0 --> 9  (numerals)  
Set 4: ,, :, :, -, ″, ., &, @, ^, /, *, -, =, !, ¡, ?, ¡, ¿, 🙻, |, ¦, ‖, •, ·, ©, ℗, ®, “, ”, ', ", «, », (, ), [, ], {, }, ¶, §, †, ‡, ❧, ◊ (punctuation & typographical symbols)  
Set 5: ¤, µ, ¢, ¥, £, $, %, #, №, º, ª, %, °, +, -, ÷, ×,*, /, ±, ¬, ~, _, ^, <, > (mathematical symbols)  

### [Block Elements](https://en.wikipedia.org/wiki/Block_Elements) & [Geometric Shapes](https://en.wikipedia.org/wiki/Geometric_Shapes_(Unicode_block))

Set 6: ░, ▒, ▓, █ (Rectangle element characters)  
Set 7: □, ▢, ◫, ◰, ◱, ◲, ◳, ◧, ◨, ◩, ◪, ◘, ▤, ▥, ▦, ▧, ▨, ▣, ▩, ■

---

[`LICENSE`](./LICENSE)
