
# Copyright (c) 2020 CJ Kucera (cj@apocalyptech.com)
# 
# This software is provided 'as-is', without any express or implied warranty.
# In no event will the authors be held liable for any damages arising from
# the use of this software.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
#    claim that you wrote the original software. If you use this software in a
#    product, an acknowledgment in the product documentation would be
#    appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not be
#    misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source distribution.

# Editor Version
__version__ = '1.1.0'

# Classes
(BEASTMASTER, GUNNER, OPERATIVE, SIREN) = range(4)
class_to_eng = {
        BEASTMASTER: 'Beastmaster',
        GUNNER: 'Gunner',
        OPERATIVE: 'Operative',
        SIREN: 'Siren',
        }
classobj_to_class = {
        '/Game/PlayerCharacters/Beastmaster/PlayerClassId_Beastmaster.PlayerClassId_Beastmaster': BEASTMASTER,
        '/Game/PlayerCharacters/Gunner/PlayerClassId_Gunner.PlayerClassId_Gunner': GUNNER,
        '/Game/PlayerCharacters/Operative/PlayerClassId_Operative.PlayerClassId_Operative': OPERATIVE,
        '/Game/PlayerCharacters/SirenBrawler/PlayerClassId_Siren.PlayerClassId_Siren': SIREN,
        }

# Pets
(JABBER, SPIDERANT, SKAG) = range(3)
pet_to_eng = {
        JABBER: 'Jabber',
        SPIDERANT: 'Spiderant',
        SKAG: 'Skag',
        }
petkey_to_pet = {
        'petmonkey': JABBER,
        'petspiderant': SPIDERANT,
        'petskag': SKAG,
        }
pet_to_petkey = {v: k for k, v in petkey_to_pet.items()}

# Currencies
(MONEY, ERIDIUM) = range(2)
currency_to_eng = {
        MONEY: 'Money',
        ERIDIUM: 'Eridium',
        }
currency_to_curhash = {
        MONEY: 618814354,
        ERIDIUM: 3679636065
        }
curhash_to_currency = {v: k for k, v in currency_to_curhash.items()}

# Inventory Slots
(WEAPON1, WEAPON2, WEAPON3, WEAPON4, SHIELD, GRENADE, COM, ARTIFACT) = range(8)
slot_to_eng = {
        WEAPON1: 'Weapon 1',
        WEAPON2: 'Weapon 2',
        WEAPON3: 'Weapon 3',
        WEAPON4: 'Weapon 4',
        SHIELD: 'Shield',
        GRENADE: 'Grenade',
        COM: 'COM',
        ARTIFACT: 'Artifact',
}
slotobj_to_slot = {
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon1.BPInvSlot_Weapon1': WEAPON1,
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon2.BPInvSlot_Weapon2': WEAPON2,
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon3.BPInvSlot_Weapon3': WEAPON3,
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon4.BPInvSlot_Weapon4': WEAPON4,
        '/Game/Gear/Shields/_Design/A_Data/BPInvSlot_Shield.BPInvSlot_Shield': SHIELD,
        '/Game/Gear/GrenadeMods/_Design/A_Data/BPInvSlot_GrenadeMod.BPInvSlot_GrenadeMod': GRENADE,
        '/Game/Gear/ClassMods/_Design/_Data/BPInvSlot_ClassMod.BPInvSlot_ClassMod': COM,
        '/Game/Gear/Artifacts/_Design/_Data/BPInvSlot_Artifact.BPInvSlot_Artifact': ARTIFACT,
        }
slot_to_slotobj = {v: k for k, v in slotobj_to_slot.items()}

# SDUs
(SDU_BACKPACK, SDU_AR, SDU_PISTOL, SDU_SNIPER, SDU_SHOTGUN, SDU_GRENADE, SDU_SMG, SDU_HEAVY) = range(8)
ammo_sdus = [SDU_AR, SDU_PISTOL, SDU_SNIPER, SDU_SHOTGUN, SDU_GRENADE, SDU_SMG, SDU_HEAVY]
sdu_to_eng = {
        SDU_BACKPACK: 'Backpack',
        SDU_AR: 'AR',
        SDU_PISTOL: 'Pistol',
        SDU_SNIPER: 'Sniper',
        SDU_SHOTGUN: 'Shotgun',
        SDU_GRENADE: 'Grenade',
        SDU_SMG: 'SMG',
        SDU_HEAVY: 'Heavy',
        }
sduobj_to_sdu = {
        '/Game/Pickups/SDU/SDU_Backpack.SDU_Backpack': SDU_BACKPACK,
        '/Game/Pickups/SDU/SDU_AssaultRifle.SDU_AssaultRifle': SDU_AR,
        '/Game/Pickups/SDU/SDU_Pistol.SDU_Pistol': SDU_PISTOL,
        '/Game/Pickups/SDU/SDU_SniperRifle.SDU_SniperRifle': SDU_SNIPER,
        '/Game/Pickups/SDU/SDU_Shotgun.SDU_Shotgun': SDU_SHOTGUN,
        '/Game/Pickups/SDU/SDU_Grenade.SDU_Grenade': SDU_GRENADE,
        '/Game/Pickups/SDU/SDU_SMG.SDU_SMG': SDU_SMG,
        '/Game/Pickups/SDU/SDU_Heavy.SDU_Heavy': SDU_HEAVY,
        }
sdu_to_sduobj = {v: k for k, v in sduobj_to_sdu.items()}
sdu_to_max = {
        SDU_BACKPACK: 8,
        SDU_AR: 8,
        SDU_PISTOL: 8,
        SDU_SNIPER: 8,
        SDU_SHOTGUN: 8,
        SDU_GRENADE: 8,
        SDU_SMG: 8,
        SDU_HEAVY: 8,
        }

# Ammo
(AMMO_AR, AMMO_GRENADE, AMMO_HEAVY, AMMO_PISTOL, AMMO_SMG, AMMO_SHOTGUN, AMMO_SNIPER) = range(7)
ammo_to_eng = {
        AMMO_AR: 'AR',
        AMMO_GRENADE: 'Grenade',
        AMMO_HEAVY: 'Heavy',
        AMMO_PISTOL: 'Pistol',
        AMMO_SMG: 'SMG',
        AMMO_SHOTGUN: 'Shotgun',
        AMMO_SNIPER: 'Sniper',
        }
ammoobj_to_ammo = {
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_AssaultRifle.Resource_Ammo_AssaultRifle': AMMO_AR,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Grenade.Resource_Ammo_Grenade': AMMO_GRENADE,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Heavy.Resource_Ammo_Heavy': AMMO_HEAVY,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Pistol.Resource_Ammo_Pistol': AMMO_PISTOL,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_SMG.Resource_Ammo_SMG': AMMO_SMG,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Shotgun.Resource_Ammo_Shotgun': AMMO_SHOTGUN,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Sniper.Resource_Ammo_Sniper': AMMO_SNIPER,
        }
ammo_to_ammoobj = {v: k for k, v in ammoobj_to_ammo.items()}
ammo_to_max = {
        AMMO_AR: 1400,
        AMMO_GRENADE: 11,
        AMMO_HEAVY: 36,
        AMMO_PISTOL: 1000,
        AMMO_SMG: 1800,
        AMMO_SHOTGUN: 240,
        AMMO_SNIPER: 144,
        }

# Challenges
(ERIDIAN_ANALYZER,
        ERIDIAN_RESONATOR,
        MAYHEM,
        CHAL_ARTIFACT,
        COM_BEASTMASTER,
        COM_GUNNER,
        COM_OPERATIVE,
        COM_SIREN,
        ) = range(8)
challenge_to_eng = {
        ERIDIAN_ANALYZER: 'Eridian Analyzer',
        ERIDIAN_RESONATOR: 'Eridian Resonator',
        MAYHEM: 'Mayhem Mode',
        CHAL_ARTIFACT: 'Artifact Slot',
        COM_BEASTMASTER: 'Beastmaster COM Slot',
        COM_GUNNER: 'Gunner COM Slot',
        COM_OPERATIVE: 'Operative COM Slot',
        COM_SIREN: 'Siren COM Slot',
        }
challenge_char_lock = {
        COM_BEASTMASTER: BEASTMASTER,
        COM_GUNNER: GUNNER,
        COM_OPERATIVE: OPERATIVE,
        COM_SIREN: SIREN,
        }
challengeobj_to_challenge = {
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_Analyzer.Challenge_VaultReward_Analyzer_C': ERIDIAN_ANALYZER,
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_Resonator.Challenge_VaultReward_Resonator_C': ERIDIAN_RESONATOR,
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_Mayhem.Challenge_VaultReward_Mayhem_C': MAYHEM,
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_ArtifactSlot.Challenge_VaultReward_ArtifactSlot_C': CHAL_ARTIFACT,
        '/Game/GameData/Challenges/Character/Beastmaster/BP_Challenge_Beastmaster_ClassMod.BP_Challenge_Beastmaster_ClassMod_C': COM_BEASTMASTER,
        '/Game/GameData/Challenges/Character/Gunner/BP_Challenge_Gunner_ClassMod.BP_Challenge_Gunner_ClassMod_C': COM_GUNNER,
        '/Game/GameData/Challenges/Character/Operative/BP_Challenge_Operative_ClassMod.BP_Challenge_Operative_ClassMod_C': COM_OPERATIVE,
        '/Game/GameData/Challenges/Character/Siren/BP_Challenge_Siren_ClassMod.BP_Challenge_Siren_ClassMod_C': COM_SIREN,

        # This alone is not sufficient to unlock Sanctuary early
        #'/Game/GameData/Challenges/FastTravel/Challenge_FastTravel_Sanctuary3_2.Challenge_FastTravel_Sanctuary3_2_C': FOO,

        # Unlocking Fabricator really doesn't interest me; I think you'd need the item drop to go along with it, too.
        #'/Game/GameData/Challenges/Account/Challenge_VaultReward_Fabricator.Challenge_VaultReward_Fabricator_C': FOO,

        # Also, where are the other two gun slots?
        }
challenge_to_challengeobj = {v: k for k, v in challengeobj_to_challenge.items()}

# Vehicle info.  We're not doing as much object-to-english mapping stuff here, 'cause
# I don't care enough to code it into the editor.  Just doing some more general
# "unlock all" type activity.
(OUTRUNNER, TECHNICAL, CYCLONE) = range(3)
vehicle_to_eng = {
        OUTRUNNER: 'Outrunner',
        TECHNICAL: 'Technical',
        CYCLONE: 'Cyclone',
        }
vehicle_chassis = {
        OUTRUNNER: set([
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_BuggyWheels.WT_Outrunner_BuggyWheels',
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_HoverWheels.WT_Outrunner_HoverWheels',
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_TwitchyWheels.WT_Outrunner_TwitchyWheels',
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_ZipWheels.WT_Outrunner_ZipWheels',
            ]),
        TECHNICAL: set([
            '/Game/Vehicles/Technical/Design/WT_Technical_AllTerrainWheels.WT_Technical_AllTerrainWheels',
            '/Game/Vehicles/Technical/Design/WT_Technical_BarbedWheels.WT_Technical_BarbedWheels',
            '/Game/Vehicles/Technical/Design/WT_Technical_HoverWheels.WT_Technical_HoverWheels',
            '/Game/Vehicles/Technical/Design/WT_Technical_MonsterWheels.WT_Technical_MonsterWheels',
            ]),
        CYCLONE: set([
            '/Game/Vehicles/Revolver/Design/WT_Revolver_DualWheel.WT_Revolver_DualWheel',
            '/Game/Vehicles/Revolver/Design/WT_Revolver_HoverWheel.WT_Revolver_HoverWheel',
            '/Game/Vehicles/Revolver/Design/WT_Revolver_MonoWheel.WT_Revolver_MonoWheel',
            '/Game/Vehicles/Revolver/Design/WT_Revolver_WIdeWheel.WT_Revolver_WIdeWheel',
            ]),
        }
chassis_to_vehicle = {}
for vehicle, chassislist in vehicle_chassis.items():
    for chassis in chassislist:
        chassis_to_vehicle[chassis] = vehicle
vehicle_parts = {
        OUTRUNNER: set([
            '/Game/Vehicles/Outrunner/Design/Parts/Armor/VehiclePart_Outrunner_Armor_BasicArmor.VehiclePart_Outrunner_Armor_BasicArmor',
            '/Game/Vehicles/Outrunner/Design/Parts/Armor/VehiclePart_Outrunner_Armor_HeavyArmor.VehiclePart_Outrunner_Armor_HeavyArmor',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/BlazeBooster/VehiclePart_CoreMod_BlazeBooster.VehiclePart_CoreMod_BlazeBooster',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/BoostCanisters/VehiclePart_CoreMod_BoostCanisters.VehiclePart_CoreMod_BoostCanisters',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/EnergyCells/VehiclePart_CoreMod_EnergyCells.VehiclePart_CoreMod_EnergyCells',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/RazerWings/VehiclePart_CoreMod_RazerWings.VehiclePart_CoreMod_RazerWings',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_FlameThrower/FlameThrower/VehiclePart_WeaponDriver_FlameThrower_Native.VehiclePart_WeaponDriver_FlameThrower_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_FlameThrower/TeslaCoil/VehiclePart_WeaponDriver_TeslaCoil_Native.VehiclePart_WeaponDriver_TeslaCoil_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MachineGun/OutrunnerMachineGun/VehiclePart_WeaponDriver_OutrunnerMachineGun_Native.VehiclePart_WeaponDriver_OutrunnerMachineGun_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_MissileLauncher/HeavyMissile/VehiclePart_Weapon_HeavyMissile_Native.VehiclePart_Weapon_HeavyMissile_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_MissileLauncher/ShotgunMissile/VehiclePart_Weapon_ShotgunMissile_Native.VehiclePart_Weapon_ShotgunMissile_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_MissileLauncher/SwarmerMissile/VehiclePart_Weapon_SwarmerMissile_Native.VehiclePart_Weapon_SwarmerMissile_Native',
            ]),
        TECHNICAL: set([
            '/Game/Vehicles/Technical/Design/Parts/Accessory/FlatBed/VehiclePart_CoreMod_Flatbed.VehiclePart_CoreMod_Flatbed',
            '/Game/Vehicles/Technical/Design/Parts/Accessory/FuelBarrels/VehiclePart_CoreMod_FuelBarrels.VehiclePart_CoreMod_FuelBarrels',
            '/Game/Vehicles/Technical/Design/Parts/Accessory/JetBooster/VehiclePart_CoreMod_JetBooster.VehiclePart_CoreMod_JetBooster',
            '/Game/Vehicles/Technical/Design/Parts/Accessory/ToxicBooster/VehiclePart_CoreMod_ToxicBooster.VehiclePart_CoreMod_ToxicBooster',
            '/Game/Vehicles/Technical/Design/Parts/Armor/VehiclePart_Techincal_Armor_BasicArmor.VehiclePart_Techincal_Armor_BasicArmor',
            '/Game/Vehicles/Technical/Design/Parts/Armor/VehiclePart_Technical_Armor_HeavyArmor.VehiclePart_Technical_Armor_HeavyArmor',
            '/Game/Vehicles/Technical/Design/Parts/Armor/VehiclePart_Technical_Armor_MeatGrinder.VehiclePart_Technical_Armor_MeatGrinder',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MachineGun/FlakCannon/VehiclePart_WeaponDriver_FlakCannon_Native.VehiclePart_WeaponDriver_FlakCannon_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MachineGun/MachineGun/VehiclePart_WeaponDriver_MachineGun_Native.VehiclePart_WeaponDriver_MachineGun_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_Catapult/BarrelLauncher/VehiclePart_Weapon_BarrelLauncher_Native.VehiclePart_Weapon_BarrelLauncher_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_Catapult/PropelledBombsLauncher/VehiclePart_Weapon_PropelledBombsLauncher_Native.VehiclePart_Weapon_PropelledBombsLauncher_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_Catapult/StickyBombLauncher/VehiclePart_Weapon_StickyBombs_Native.VehiclePart_Weapon_StickyBombs_Native',
            ]),
        CYCLONE: set([
            '/Game/Vehicles/Revolver/Design/Parts/Armor/VehiclePart_Revolver_Armor_BasicArmor.VehiclePart_Revolver_Armor_BasicArmor',
            '/Game/Vehicles/Revolver/Design/Parts/Armor/VehiclePart_Revolver_Armor_HeavyArmor.VehiclePart_Revolver_Armor_HeavyArmor',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/CryoBooster/VehiclePart_CryoBooster.VehiclePart_CryoBooster',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/DigiThruster/VehiclePart_DigiThruster.VehiclePart_DigiThruster',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/Firestarter/VehiclePart_FireStarter.VehiclePart_FireStarter',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/HeavyBooster/VehiclePart_HeavyBooster.VehiclePart_HeavyBooster',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MechanicalLauncher/BlazeRodLancer/VehiclePart_WeaponDriver_BlazeRodLauncher_Native.VehiclePart_WeaponDriver_BlazeRodLauncher_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MechanicalLauncher/RevolverMachineGun/VehiclePart_WeaponDriver_RevolverMachineGun_Native.VehiclePart_WeaponDriver_RevolverMachineGun_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MechanicalLauncher/SawBladeLancer/VehiclePart_WeaponDriver_SawBladeLauncher_Native.VehiclePart_WeaponDriver_SawBladeLauncher_Native',
            ]),
        }
part_to_vehicle = {}
for vehicle, parts in vehicle_parts.items():
    for part in parts:
        part_to_vehicle[part] = vehicle
vehicle_skins = {
        OUTRUNNER: set([
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Atlas.VehiclePart_Mat_VehiclePart_Outrunner_Atlas',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Batmobile.VehiclePart_Mat_VehiclePart_Outrunner_Batmobile',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_COV.VehiclePart_Mat_VehiclePart_Outrunner_COV',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Dahl.VehiclePart_Mat_VehiclePart_Outrunner_Dahl',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Default.VehiclePart_Mat_VehiclePart_Outrunner_Default',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Ellie1.VehiclePart_Mat_VehiclePart_Outrunner_Ellie1',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_FF.VehiclePart_Mat_VehiclePart_Outrunner_FF',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Fire.VehiclePart_Mat_VehiclePart_Outrunner_Fire',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Forest.VehiclePart_Mat_VehiclePart_Outrunner_Forest',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_GBX.VehiclePart_Mat_VehiclePart_Outrunner_GBX',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Gold.VehiclePart_Mat_VehiclePart_Outrunner_Gold',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Grog.VehiclePart_Mat_VehiclePart_Outrunner_Grog',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Gulf.VehiclePart_Mat_VehiclePart_Outrunner_Gulf',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Herbie.VehiclePart_Mat_VehiclePart_Outrunner_Herbie',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Hexagon.VehiclePart_Mat_VehiclePart_Outrunner_Hexagon',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Houndstooth.VehiclePart_Mat_VehiclePart_Outrunner_Houndstooth',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_HubbaBubba.VehiclePart_Mat_VehiclePart_Outrunner_HubbaBubba',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Hyp.VehiclePart_Mat_VehiclePart_Outrunner_Hyp',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Hyp2.VehiclePart_Mat_VehiclePart_Outrunner_Hyp2',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Infection.VehiclePart_Mat_VehiclePart_Outrunner_Infection',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Jakobs.VehiclePart_Mat_VehiclePart_Outrunner_Jakobs',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Maliwan.VehiclePart_Mat_VehiclePart_Outrunner_Maliwan',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Maya.VehiclePart_Mat_VehiclePart_Outrunner_Maya',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Pirate.VehiclePart_Mat_VehiclePart_Outrunner_Pirate',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Prisa.VehiclePart_Mat_VehiclePart_Outrunner_Prisa',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_RedMachine.VehiclePart_Mat_VehiclePart_Outrunner_RedMachine',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_SDCC.VehiclePart_Mat_VehiclePart_Outrunner_SDCC',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Stealth.VehiclePart_Mat_VehiclePart_Outrunner_Stealth',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Torgue.VehiclePart_Mat_VehiclePart_Outrunner_Torgue',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Tri.VehiclePart_Mat_VehiclePart_Outrunner_Tri',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Vladof.VehiclePart_Mat_VehiclePart_Outrunner_Vladof',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Wrap.VehiclePart_Mat_VehiclePart_Outrunner_Wrap',
            '/Game/PatchDLC/Hibiscus/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Fish.VehiclePart_Mat_VehiclePart_Outrunner_Fish',
            '/Game/PatchDLC/Hibiscus/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Tentacle.VehiclePart_Mat_VehiclePart_Outrunner_Tentacle',
            ]),
        TECHNICAL: set([
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Atlas.VehiclePart_Mat_VehiclePart_Technical_Atlas',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Bling.VehiclePart_Mat_VehiclePart_Technical_Bling',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_BlueAngel.VehiclePart_Mat_VehiclePart_Technical_BlueAngel',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Bubblegum.VehiclePart_Mat_VehiclePart_Technical_Bubblegum',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Camo.VehiclePart_Mat_VehiclePart_Technical_Camo',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Checker.VehiclePart_Mat_VehiclePart_Technical_Checker',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Cov.VehiclePart_Mat_VehiclePart_Technical_Cov',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Dahl.VehiclePart_Mat_VehiclePart_Technical_Dahl',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Default.VehiclePart_Mat_VehiclePart_Technical_Default',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Dino.VehiclePart_Mat_VehiclePart_Technical_Dino',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_E3.VehiclePart_Mat_VehiclePart_Technical_E3',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Ellie1.VehiclePart_Mat_VehiclePart_Technical_Ellie1',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Festi.VehiclePart_Mat_VehiclePart_Technical_Festi',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Forest.VehiclePart_Mat_VehiclePart_Technical_Forest',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_GBX.VehiclePart_Mat_VehiclePart_Technical_GBX',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_GoldenTicket.VehiclePart_Mat_VehiclePart_Technical_GoldenTicket',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_HYP.VehiclePart_Mat_VehiclePart_Technical_HYP',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Halftone.VehiclePart_Mat_VehiclePart_Technical_Halftone',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_JAK.VehiclePart_Mat_VehiclePart_Technical_JAK',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_MAL.VehiclePart_Mat_VehiclePart_Technical_MAL',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Maya.VehiclePart_Mat_VehiclePart_Technical_Maya',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Plaid.VehiclePart_Mat_VehiclePart_Technical_Plaid',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Roadkill.VehiclePart_Mat_VehiclePart_Technical_Roadkill',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Sand.VehiclePart_Mat_VehiclePart_Technical_Sand',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Skag.VehiclePart_Mat_VehiclePart_Technical_Skag',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Stealth.VehiclePart_Mat_VehiclePart_Technical_Stealth',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Thunderbird.VehiclePart_Mat_VehiclePart_Technical_Thunderbird',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Torgue.VehiclePart_Mat_VehiclePart_Technical_Torgue',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Vaughn.VehiclePart_Mat_VehiclePart_Technical_Vaughn',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Vladof.VehiclePart_Mat_VehiclePart_Technical_Vladof',
            '/Game/PatchDLC/Hibiscus/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Tentacle.VehiclePart_Mat_VehiclePart_Technical_Tentacle',
            '/Game/PatchDLC/Hibiscus/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Fish.VehiclePart_Mat_VehiclePart_Technical_Fish',
            '/Game/PatchDLC/Hibiscus/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Frost.VehiclePart_Mat_VehiclePart_Technical_Frost',
            ]),
        CYCLONE: set([
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Atlas.VehiclePart_Mat_VehiclePart_Revolver_Atlas',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_COV.VehiclePart_Mat_VehiclePart_Revolver_COV',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Chopper.VehiclePart_Mat_VehiclePart_Revolver_Chopper',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Chups.VehiclePart_Mat_VehiclePart_Revolver_Chups',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Dahl.VehiclePart_Mat_VehiclePart_Revolver_Dahl',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Dark.VehiclePart_Mat_VehiclePart_Revolver_Dark',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Default.VehiclePart_Mat_VehiclePart_Revolver_Default',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Ellie1.VehiclePart_Mat_VehiclePart_Revolver_Ellie1',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Forest.VehiclePart_Mat_VehiclePart_Revolver_Forest',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_GBX.VehiclePart_Mat_VehiclePart_Revolver_GBX',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_GC.VehiclePart_Mat_VehiclePart_Revolver_GC',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_HubbaBubba.VehiclePart_Mat_VehiclePart_Revolver_HubbaBubba',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Hyp.VehiclePart_Mat_VehiclePart_Revolver_Hyp',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Hyp2.VehiclePart_Mat_VehiclePart_Revolver_Hyp2',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Jakobs.VehiclePart_Mat_VehiclePart_Revolver_Jakobs',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_LifeSaver.VehiclePart_Mat_VehiclePart_Revolver_LifeSaver',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Maliwan.VehiclePart_Mat_VehiclePart_Revolver_Maliwan',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Mask.VehiclePart_Mat_VehiclePart_Revolver_Mask',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Maya.VehiclePart_Mat_VehiclePart_Revolver_Maya',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Ninja.VehiclePart_Mat_VehiclePart_Revolver_Ninja',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Pepto.VehiclePart_Mat_VehiclePart_Revolver_Pepto',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Police.VehiclePart_Mat_VehiclePart_Revolver_Police',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Stealth.VehiclePart_Mat_VehiclePart_Revolver_Stealth',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Torgue.VehiclePart_Mat_VehiclePart_Revolver_Torgue',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Vladof.VehiclePart_Mat_VehiclePart_Revolver_Vladof',
            '/Game/PatchDLC/Hibiscus/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Fish.VehiclePart_Mat_VehiclePart_Revolver_Fish',
            ]),
        }
skin_to_vehicle = {}
for vehicle, skins in vehicle_skins.items():
    for skin in skins:
        skin_to_vehicle[skin] = vehicle

# XP
max_level = 57
required_xp_list = [
    0,          # lvl 1
    358,        # lvl 2
    1241,       # lvl 3
    2850,       # lvl 4
    5376,       # lvl 5
    8997,       # lvl 6
    13886,      # lvl 7
    20208,      # lvl 8
    28126,      # lvl 9
    37798,      # lvl 10
    49377,      # lvl 11
    63016,      # lvl 12
    78861,      # lvl 13
    97061,      # lvl 14
    117757,     # lvl 15
    141092,     # lvl 16
    167206,     # lvl 17
    196238,     # lvl 18
    228322,     # lvl 19
    263595,     # lvl 20
    302190,     # lvl 21
    344238,     # lvl 22
    389873,     # lvl 23
    439222,     # lvl 24
    492414,     # lvl 25
    549578,     # lvl 26
    610840,     # lvl 27
    676325,     # lvl 28
    746158,     # lvl 29
    820463,     # lvl 30
    899363,     # lvl 31
    982980,     # lvl 32
    1071435,    # lvl 33
    1164850,    # lvl 34
    1263343,    # lvl 35
    1367034,    # lvl 36
    1476041,    # lvl 37
    1590483,    # lvl 38
    1710476,    # lvl 39
    1836137,    # lvl 40
    1967582,    # lvl 41
    2104926,    # lvl 42
    2248285,    # lvl 43
    2397772,    # lvl 44
    2553501,    # lvl 45
    2715586,    # lvl 46
    2884139,    # lvl 47
    3059273,    # lvl 48
    3241098,    # lvl 49
    3429728,    # lvl 50
    3625271,    # lvl 51
    3827840,    # lvl 52
    4037543,    # lvl 53
    4254491,    # lvl 54
    4478792,    # lvl 55
    4710556,    # lvl 56
    4949890,    # lvl 57
    5196902,    # lvl 58
    5451701,    # lvl 59
    5714393,    # lvl 60
    5985086,    # lvl 61
    6263885,    # lvl 62
    6550897,    # lvl 63
    6846227,    # lvl 64
    7149982,    # lvl 65
    7462266,    # lvl 66
    7783184,    # lvl 67
    8112840,    # lvl 68
    8451340,    # lvl 69
    8798786,    # lvl 70
    9155282,    # lvl 71
    9520931,    # lvl 72
    9895837,    # lvl 73
    10280103,    # lvl 74
    10673830,    # lvl 75
    11077120,    # lvl 76
    11490077,    # lvl 77
    11912801,    # lvl 78
    12345393,    # lvl 79
    12787955,    # lvl 80
]

# Mission names
#
# For most missions, the following find statement will generate this list:
#
#    for file in $(find Game/Missions Game/PatchDLC/Dandelion/Missions Game/PatchDLC/Hibiscus/Missions Game/PatchDLC/Raid1/Missions Game/PatchDLC/BloodyHarvest/Missions \( -iname "Mission_*.uexp" -o -name "SideMission_*.uexp" -o -name "EP*_DLC2.uexp" \) -print); do echo -n "'/$(dirname $file)/$(basename $file .uexp)': \""; echo $(strings $file | head -n 2 | tail -n 1)\",; done
#
# Various plot missions, though, from both the main game and DLC1, will need
# some edits by hand (they use a UIName_*_MissionTitle object instead.)  Also,
# the Rare Spawn missions need the second string, not the first, so you'll
# want to run this to grab those:
#
#    for file in $(find Game/Missions/Side/RareSpawn Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn -iname "Mission_*.uexp" -print); do echo -n "'/$(dirname $file)/$(basename $file .uexp)': \""; echo $(strings $file | head -n 4 | tail -n 1)\",; done
#    
# Keep in mind that the El Dragon Jr one will need a hand edit, since `strings`
# only matches on latin1 by default (at least on the GNU/Linux version).
mission_to_name = {
        '/Game/Missions/Plot/Mission_Ep01_ChildrenOfTheVault': "Children of the Vault",
        '/Game/Missions/Plot/Mission_Ep02_Sacrifice': "From the Ground Up",
        '/Game/Missions/Plot/Mission_Ep03_GetVaultMap': "Cult Following",
        '/Game/Missions/Plot/Mission_Ep04_EarnSpaceship': "Taking Flight",
        '/Game/Missions/Plot/Mission_Ep05_OvercomeHQBlockade': "Hostile Takeover",
        '/Game/Missions/Plot/Mission_Ep05_Sanctuary': "Sanctuary",
        '/Game/Missions/Plot/Mission_Ep06_MeetMaya': "The Impending Storm",
        '/Game/Missions/Plot/Mission_Ep08_OrbitalPlatform': "Space-Laser Tag",
        '/Game/Missions/Plot/MIssion_Ep09_AtlasHQ': "Atlas, At Last",
        '/Game/Missions/Plot/Mission_Ep10_CityVault': "Beneath the Meridian",
        '/Game/Missions/Plot/Mission_Ep11_PrisonBreak': "Hammerlocked",
        '/Game/Missions/Plot/Mission_Ep12_GrandTour': "Lair of the Harpy",
        '/Game/Missions/Plot/Mission_Ep13_JakobsRebellion': "The Guns of Reliance",
        '/Game/Missions/Plot/Mission_Ep13_Watership': "The Family Jewel",
        '/Game/Missions/Plot/Mission_Ep15_MarshFields': "Going Rogue",
        '/Game/Missions/Plot/Mission_Ep16_DesertVault': "The Great Vault",
        '/Game/Missions/Plot/Mission_Ep16_SiblingRivalry': "Cold as the Grave",
        '/Game/Missions/Plot/Mission_Ep17_BigChase': "Blood Drive",
        '/Game/Missions/Plot/Mission_Ep19_MinerDetails': "Angels and Speed Demons",
        '/Game/Missions/Plot/Mission_Ep20_FirstVaultHunter': "The First Vault Hunter",
        '/Game/Missions/Plot/Mission_Ep21_Beachhead': "Footsteps of Giants",
        '/Game/Missions/Plot/Mission_Ep22_TheMachine': "In the Shadow of Starlight",
        '/Game/Missions/Plot/Mission_Ep23_TyreenFinalBoss': "Divine Retribution",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds1/Mission_ProvingGrounds_Mission01': "Trial of Survival",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds1/Mission_ProvingGroundsDiscovery_Mission01': "Discover the Trial of Survival",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds4/Mission_ProvingGrounds_Mission04': "Trial of Fervor",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds4/Mission_ProvingGroundsDiscovery_Mission04': "Discover the Trial of Fervor",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds5/Mission_ProvingGrounds_Mission05': "Trial of Cunning",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds5/Mission_ProvingGroundsDiscovery_Mission05': "Discover the Trial of Cunning",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds6/Mission_ProvingGrounds_Mission06': "Trial of Supremacy",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds6/Mission_ProvingGroundsDiscovery_Mission06': "Discover the Trial of Supremacy",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds7/Mission_ProvingGrounds_Mission07': "Trial of Discipline",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds7/Mission_ProvingGroundsDiscovery_Mission07': "Discover the Trial of Discipline",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds8/Mission_ProvingGrounds_Mission08': "Trial of Instinct",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds8/Mission_ProvingGroundsDiscovery_Mission08': "Discover the Trial of Instinct",
        '/Game/Missions/Side/Raid/Raid/Mission_RaidOnMaliwan': "Raid On Maliwan",
        '/Game/Missions/Side/RareSpawn/Mission_Async_BormanNates': "Kill Borman Nates",
        '/Game/Missions/Side/RareSpawn/Mission_Async_CaptainThunkAndSloth': "Kill Captain Thunk and Sloth",
        '/Game/Missions/Side/RareSpawn/Mission_Async_DemoSkag': "Kill Demoskaggon",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Dinklebot': "Kill Dinklebot",
        '/Game/Missions/Side/RareSpawn/Mission_Async_ElDragonJr': "Kill El Dragón Jr",
        '/Game/Missions/Side/RareSpawn/Mission_Async_EnforcerUrist': "Kill Urist McEnforcer",
        '/Game/Missions/Side/RareSpawn/Mission_Async_IndoTyrant': "Kill IndoTyrant",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Maxitrillion': "Kill Maxitrillion",
        '/Game/Missions/Side/RareSpawn/Mission_Async_PowerTroopers': "Kill the Power Troopers",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Rakkman': "Kill Rakkman",
        '/Game/Missions/Side/RareSpawn/Mission_Async_RedJabber': "Kill Red Jabber",
        '/Game/Missions/Side/RareSpawn/Mission_Async_RoadDog': "Kill Road Dog",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Tarantella': "Kill Tarantella",
        '/Game/Missions/Side/RareSpawn/Mission_Async_TheUnstoppable': "Kill The Unstoppable",
        '/Game/Missions/Side/RareSpawn/Mission_Async_ThreeDragons': "Kill the Grogans and Their Mother",
        '/Game/Missions/Side/RareSpawn/Mission_Async_VicAndWarty': "Kill Wick and Warty",
        '/Game/Missions/Side/Sanctuary3/Mission_Infestation': "The Kevin Konundrum",
        '/Game/Missions/Side/Sanctuary3/Mission_JustAPrick': "Just A Prick",
        '/Game/Missions/Side/Slaughters/CoVSlaughter/Mission_COVSlaughter1': "The Slaughter Shaft",
        '/Game/Missions/Side/Slaughters/CreatureSlaughter/Mission_CreatureSlaughter': "Cistern of Slaughter",
        '/Game/Missions/Side/Slaughters/TechSlaughter/Mission_TechSlaughter1': "Tech Slaughter",
        '/Game/Missions/Side/Slaughters/TechSlaughter/Mission_TechSlaughterDiscovery': "Welcome to Slaughterstar 3000",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_BadReception': "Bad Reception",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_FineDining': "Skag Dog Days",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_Scoopers_Bully': "Dump on Dumptruck",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_UnderwearTink': "Under Taker",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_VendingMachineRepair': "Powerful Connections",
        '/Game/Missions/Side/Zone_0/Sacrifice/Mission_GoldenCalves': "Golden Calves",
        '/Game/Missions/Side/Zone_0/Sacrifice/Mission_HeadCase': "Head Case",
        '/Game/Missions/Side/Zone_0/Sacrifice/Mission_PandorasNextTopMouthpiece': "Pandora's Next Top Mouthpiece",
        '/Game/Missions/Side/Zone_1/Athenas/Mission_InvasionOfPrivacy': "Invasion of Privacy",
        '/Game/Missions/Side/Zone_1/Athenas/Mission_MonkMission': "Holy Spirits",
        '/Game/Missions/Side/Zone_1/AtlasHQ/Mission_RatchetItUp': "Ratch'd Up",
        '/Game/Missions/Side/Zone_1/City/Mission_BitterPillToSwallow': "Healers and Dealers",
        '/Game/Missions/Side/Zone_1/City/Mission_DynastyDiner': "Dynasty Diner",
        '/Game/Missions/Side/Zone_1/City/Mission_PissingContest': "Maliwannabees",
        '/Game/Missions/Side/Zone_1/City/Mission_RiseAndGrind': "Rise and Grind",
        '/Game/Missions/Side/Zone_1/City/Mission_WizardOfNogs': "Technical NOGout",
        '/Game/Missions/Side/Zone_1/OrbitalPlatform/OppositionResearch/Mission_OppResearch': "Opposition Research",
        '/Game/Missions/Side/Zone_1/Towers/Mission_KillKillavolt': "Kill Killavolt",
        '/Game/Missions/Side/Zone_1/Towers/Mission_LastKatagawa': "Proof of Wife",
        '/Game/Missions/Side/Zone_1/Towers/Mission_Porta-Prison': "Porta Prison",
        '/Game/Missions/Side/Zone_2/Mansion/Mission_AureliasSkeletons': "Sacked",
        '/Game/Missions/Side/Zone_2/Mansion/Mission_WitchesBrew': "Witch's Brew",
        '/Game/Missions/Side/Zone_2/MarshFields/Mission_RockOnPandora': "Raiders of the Lost Rock",
        '/Game/Missions/Side/Zone_2/MarshFields/Mission_SuckerPunch': "Sell Out",
        '/Game/Missions/Side/Zone_2/Prison/Mission_FreeHugs': "On the Blood Path",
        '/Game/Missions/Side/Zone_2/Prison/Mission_MalevolentPractice': "Malevolent Practice",
        '/Game/Missions/Side/Zone_2/Watership/Mission_RumbleJungle': "Rumble In The Jungle",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DriveAwayThePain': "Get Quick, Slick",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DudeBro': "Swamp Bro",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DynastyDash_Wetlands': "Dynasty Dash: Eden-6",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DynastyDash_Wetlands_Repeatable': "Dynasty Dash: Floodmoor Basin",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_SpecialDelivery': "Capture the Frag",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_TheHangover': "Irregular Customers",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_TortureTruck': "Don't Truck with Eden-6",
        '/Game/Missions/Side/Zone_3/Desert/Mission_BabyDancer': "Baby Dancer",
        '/Game/Missions/Side/Zone_3/Desert/Mission_BirthdaySurprise': "Life of the Party",
        '/Game/Missions/Side/Zone_3/Desert/Mission_BuffFilmBuff': "Buff Film Buff",
        '/Game/Missions/Side/Zone_3/Desert/Mission_CaringForElderly': "The Feeble and the Furious",
        '/Game/Missions/Side/Zone_3/Desert/Mission_ChangeOfHeart': "Sheega's All That",
        '/Game/Missions/Side/Zone_3/Desert/Mission_DynastyDash_Desert': "Dynasty Dash: Pandora",
        '/Game/Missions/Side/Zone_3/Desert/Mission_DynastyDash_Desert_Repeatable': "Dynasty Dash: Devil's Razor",
        '/Game/Missions/Side/Zone_3/Desert/Mission_EchoNetNeutrality': "ECHOnet Neutrality",
        '/Game/Missions/Side/Zone_3/Desert/Mission_ItsComplicated': "Boom Boom Boomtown",
        '/Game/Missions/Side/Zone_3/Mine/Mission_BridgeInTheDark': "The Demon in the Dark",
        '/Game/Missions/Side/Zone_3/Mine/Mission_GrowingPains': "Childhood's End",
        '/Game/Missions/Side/Zone_3/Mine/Mission_WildlifeConservation': "Wildlife Conservation",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Gameshow': "Let's Get It Vaughn",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Homestead_Part1': "The Homestead",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Homestead_Part2': "The Homestead (Part 2)",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Homestead_Part3': "The Homestead (Part 3)",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Just_Desserts': "Just Desserts",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_BetterTimes': "Fire in the Sky",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_BoneDeep': "Bad Vibrations",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_Canonization': "Cannonization",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_DestroyerOfWorlds': "Transaction-Packed",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_Homeopathological': "Homeopathological",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_ItsAlive2': "It's Alive",
        '/Game/PatchDLC/BloodyHarvest/Missions/Side/Seasonal/Mission_Season_01_Intro': "Bloody Harvest: Descent into Heck",
        '/Game/PatchDLC/BloodyHarvest/Missions/Side/Seasonal/Mission_Season_01_Repeatable': "Bloody Harvest: The Rebloodening",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep01_MeetTimothy': "The Handsome Jackpot",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep02_MeetCrad': "Playing with Fire",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep03_Impound': "Winners and Losers",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep04_Trashtown': "One Man's Treasure",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep05_ThePlan': "The Plan",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep06_TheCore': "Jack's Wild",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep07_TheHeist': "All Bets Off",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_AcidTrip': "Acid Trip",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_BrotherlyLove': "Sisterly Love",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoItForDigby_Part1': "Do it for Digby - Part 1",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoItForDigby_Part2': "Do it for Digby - Part 2",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoItForDigby_Part3': "Do it for Digby - Part 3",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoubleDown': "Double Down",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_GreatEscape': "The Great Escape",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_HeartOfGold': "Heart of Gold",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_RagingBot': "Raging Bot",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_RegainingOnesFeet': "Regaining One's Feet",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_TooMuchOfAGoodThing': "Too Much Of A Good Thing",
        '/Game/PatchDLC/Raid1/Missions/Mission_Raid1': "Takedown at the Maliwan Blacksite",
        '/Game/PatchDLC/Raid1/Missions/Mission_Raid1Intro': "Discovery: Takedown at the Maliwan Blacksite",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP01_DLC2': "The Party Out of Space",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP02_DLC2': "The Shadow Over Cursehaven",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP03_DLC2': "The Case of Wainwright Jakobs",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP04_DLC2': "The Horror in the Woods",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP05_DLC2': "On the Mountain of Mayhem",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP06_DLC2': "The Call of Gythian",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_Bounty_BusinessAsUsual': "The Proprietor: Rare Vintage",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_Bounty_DebtCollector': "The Proprietor: Empty Bottles",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_HappilyEverAfter': "Happily Ever After",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_IntoTheDeep': "The Madness Beneath",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_Necrocookmicon': "The Nibblenomicon",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_PrivateEyePart1': "Cold Case: Buried Questions",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_PrivateEyePart2': "Cold Case: Restless Memories",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_PrivateEyePart3': "Cold Case: Forgotten Answers",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_ReturnOfMaxSky': "The Great Escape (Part 2)",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_SinisterSounds': "Sinister Sounds",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WeSlassPart1': "We Slass!",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WeSlassPart2': "We Slass! (Part 2)",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WeSlassPart3': "We Slass! (Part 3)",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WhereIBelong': "Call of the Deep",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_FrostbiteDragon': "Kill Shiverous the Unscathed",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_Shocker': "Kill Voltborn",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_MushroomGiant': "Kill Fungal Gorger",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_ZealotPilfer': "Kill Amach",
        }
for k, v in list(mission_to_name.items()):
    lower = k.lower()
    last_bit = lower.split('/')[-1]
    new_k = '{}.{}_c'.format(lower, last_bit)
    mission_to_name[new_k] = v

# Map-to-eng
map_to_eng = {
        'Archive_P': "Dustbound Archives",
        'AtlasHQ_P': "Atlas HQ",
        'Bar_P': "Lodge",
        'Beach_P': "Tazendeer Ruins",
        'BloodyHarvest_P': "Heck Hole",
        'COVSlaughter_P': "Slaughter Shaft",
        'Camp_P': "Negul Neshai",
        'CasinoIntro_P': "Grand Opening",
        'CityBoss_P': "Forgotten Basilica",
        'CityVault_P': "Neon Arterial",
        'City_P': "Meridian Metroplex",
        'Convoy_P': "Sandblast Scar",
        'Core_P': "Jack's Secret",
        'CreatureSlaughter_P': "Cistern of Slaughter",
        'Crypt_P': "Pyre of Stars",
        'DesertBoss_P': "Great Vault",
        'Desert_P': "Devil's Razor",
        'Desertvault_P': "Cathedral of the Twin Gods",
        'Desolate_P': "Desolation's Edge",
        'FinalBoss_P': "Destroyer's Rift",
        'Impound_P': "Impound Deluxe",
        'Lake_P': "Skittermaw Basin",
        'Mansion_P': "Jakobs Estate",
        'MarshFields_P': "Ambermire",
        'Mine_P': "Konrad's Hold",
        'Monastery_P': "Athenas",
        'MotorcadeFestival_P': "Carnivora",
        'MotorcadeInterior_P': "Guts of Carnivora",
        'Motorcade_P': "Splinterlands",
        'OrbitalPlatform_P': "Skywell-27",
        'Outskirts_P': "Meridian Outskirts",
        'Prison_P': "Anvil",
        'Prologue_P': "Droughts",
        'ProvingGrounds_Trial1_P': "Gradient of Dawn (Survival)",
        'ProvingGrounds_Trial4_P': "Skydrowned Pulpit (Fervor)",
        'ProvingGrounds_Trial5_P': "Ghostlight Beacon (Cunning)",
        'ProvingGrounds_Trial6_P': "Hall Obsidian (Supremacy)",
        'ProvingGrounds_Trial7_P': "Precipice Anchor (Discipline)",
        'ProvingGrounds_Trial8_P': "Wayward Tether (Instinct)",
        'Raid_P': "Midnight's Cairn (Maliwan Takedown)",
        'Recruitment_P': "Covenant Pass",
        'Sacrifice_P': "Ascension Bluff",
        'Sanctuary3_P': "Sanctuary",
        'Strip_P': "Spendopticon",
        'TechSlaughter_P': "Slaughterstar 3000",
        'TowerLair_P': "VIP Tower",
        'Towers_P': "Lectra City",
        'Trashtown_P': "Compactor",
        'Venue_P': "Heart's Desire",
        'Village_P': "Cursehaven",
        'Watership_P': "Voracious Canopy",
        'WetlandsBoss_P': "Floating Tomb",
        'WetlandsVault_P': "Blackbarrel Cellars",
        'Wetlands_P': "Floodmoor Basin",
        'Woods_P': "Cankerwood",
        }

# Autogenerated by gen_fts_mappings.py, in my bl3hotfixmodding project (in dataprocessing)
fts_to_map = {
        '/game/gamedata/fasttravel/fts_atlashq.fts_atlashq': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/fts_atlashq_sendonly.fts_atlashq_sendonly': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/fts_beach.fts_beach': 'Beach_P',
        '/game/gamedata/fasttravel/fts_beach_sendonly.fts_beach_sendonly': 'Beach_P',
        '/game/gamedata/fasttravel/fts_city.fts_city': 'City_P',
        '/game/gamedata/fasttravel/fts_cityboss.fts_cityboss': 'CityBoss_P',
        '/game/gamedata/fasttravel/fts_cityboss_sendonly.fts_cityboss_sendonly': 'CityBoss_P',
        '/game/gamedata/fasttravel/fts_cityvault.fts_cityvault': 'CityVault_P',
        '/game/gamedata/fasttravel/fts_convoy.fts_convoy': 'Convoy_P',
        '/game/gamedata/fasttravel/fts_covslaughter.fts_covslaughter': 'COVSlaughter_P',
        '/game/gamedata/fasttravel/fts_creatureslaughter.fts_creatureslaughter': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/fts_crypt.fts_crypt': 'Crypt_P',
        '/game/gamedata/fasttravel/fts_desert1.fts_desert1': 'Desert_P',
        '/game/gamedata/fasttravel/fts_desert2.fts_desert2': 'Desert_P',
        '/game/gamedata/fasttravel/fts_desertboss.fts_desertboss': 'DesertBoss_P',
        '/game/gamedata/fasttravel/fts_desertboss_sendonly.fts_desertboss_sendonly': 'DesertBoss_P',
        '/game/gamedata/fasttravel/fts_desertvault.fts_desertvault': 'Desertvault_P',
        '/game/gamedata/fasttravel/fts_desolate2.fts_desolate2': 'Desolate_P',
        '/game/gamedata/fasttravel/fts_desolatedroppod.fts_desolatedroppod': 'Desolate_P',
        '/game/gamedata/fasttravel/fts_finalboss.fts_finalboss': 'FinalBoss_P',
        '/game/gamedata/fasttravel/fts_finalboss_sendonly.fts_finalboss_sendonly': 'FinalBoss_P',
        '/game/gamedata/fasttravel/fts_finalbossportal.fts_finalbossportal': 'FinalBoss_P',
        '/game/gamedata/fasttravel/fts_grotto.fts_grotto': 'Grotto_P',
        '/game/gamedata/fasttravel/fts_mansion.fts_mansion': 'Mansion_P',
        '/game/gamedata/fasttravel/fts_marshfields.fts_marshfields': 'MarshFields_P',
        '/game/gamedata/fasttravel/fts_marshfields_sendonly.fts_marshfields_sendonly': 'MarshFields_P',
        '/game/gamedata/fasttravel/fts_marshfieldsship.fts_marshfieldsship': 'MarshFields_P',
        '/game/gamedata/fasttravel/fts_mine.fts_mine': 'Mine_P',
        '/game/gamedata/fasttravel/fts_monastery.fts_monastery': 'Monastery_P',
        '/game/gamedata/fasttravel/fts_monastery_sendonly.fts_monastery_sendonly': 'Monastery_P',
        '/game/gamedata/fasttravel/fts_monasterydroppod.fts_monasterydroppod': 'Monastery_P',
        '/game/gamedata/fasttravel/fts_motorcade.fts_motorcade': 'Motorcade_P',
        '/game/gamedata/fasttravel/fts_motorcade2.fts_motorcade2': 'Motorcade_P',
        '/game/gamedata/fasttravel/fts_motorcadefestival.fts_motorcadefestival': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/fts_motorcadeinterior.fts_motorcadeinterior': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/fts_motorcadeinterior_sendonly.fts_motorcadeinterior_sendonly': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/fts_orbitalplatform.fts_orbitalplatform': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/fts_orbitalplatform_sendonly.fts_orbitalplatform_sendonly': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/fts_orbitalshuttle.fts_orbitalshuttle': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/fts_outskirts.fts_outskirts': 'Outskirts_P',
        '/game/gamedata/fasttravel/fts_outskirtsdroppod.fts_outskirtsdroppod': 'Outskirts_P',
        '/game/gamedata/fasttravel/fts_playableintro_sendonly.fts_playableintro_sendonly': 'PlayableIntro_P',
        '/game/gamedata/fasttravel/fts_prison.fts_prison': 'Prison_P',
        '/game/gamedata/fasttravel/fts_prison_sendonly.fts_prison_sendonly': 'Prison_P',
        '/game/gamedata/fasttravel/fts_prologue.fts_prologue': 'Prologue_P',
        '/game/gamedata/fasttravel/fts_prologue2.fts_prologue2': 'Prologue_P',
        '/game/gamedata/fasttravel/fts_provinggrounds00.fts_provinggrounds00': 'ProvingGrounds_Trial0_P',
        '/game/gamedata/fasttravel/fts_provinggrounds01.fts_provinggrounds01': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/fts_provinggrounds01_droppod.fts_provinggrounds01_droppod': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/fts_provinggrounds01_oneway.fts_provinggrounds01_oneway': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/fts_provinggrounds02.fts_provinggrounds02': 'ProvingGrounds_Trial2_P',
        '/game/gamedata/fasttravel/fts_provinggrounds03.fts_provinggrounds03': 'ProvingGrounds_Trial3_P',
        '/game/gamedata/fasttravel/fts_provinggrounds04.fts_provinggrounds04': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/fts_provinggrounds04_droppod.fts_provinggrounds04_droppod': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/fts_provinggrounds04_oneway.fts_provinggrounds04_oneway': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/fts_provinggrounds05.fts_provinggrounds05': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/fts_provinggrounds05_droppod.fts_provinggrounds05_droppod': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/fts_provinggrounds05_oneway.fts_provinggrounds05_oneway': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/fts_provinggrounds06.fts_provinggrounds06': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/fts_provinggrounds06_droppod.fts_provinggrounds06_droppod': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/fts_provinggrounds06_oneway.fts_provinggrounds06_oneway': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/fts_provinggrounds07.fts_provinggrounds07': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/fts_provinggrounds07_droppod.fts_provinggrounds07_droppod': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/fts_provinggrounds07_oneway.fts_provinggrounds07_oneway': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/fts_provinggrounds08.fts_provinggrounds08': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/fts_provinggrounds08_droppod.fts_provinggrounds08_droppod': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/fts_provinggrounds08_oneway.fts_provinggrounds08_oneway': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/fts_raid.fts_raid': 'Raid_P',
        '/game/gamedata/fasttravel/fts_recruitment.fts_recruitment': 'Recruitment_P',
        '/game/gamedata/fasttravel/fts_sacrifice.fts_sacrifice': 'Sacrifice_P',
        '/game/gamedata/fasttravel/fts_sanctuary.fts_sanctuary': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/fts_sanctuarybridge.fts_sanctuarybridge': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/fts_techslaughter.fts_techslaughter': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/fts_techslaughterdroppod.fts_techslaughterdroppod': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/fts_towers.fts_towers': 'Towers_P',
        '/game/gamedata/fasttravel/fts_watership.fts_watership': 'Watership_P',
        '/game/gamedata/fasttravel/fts_watership_sendonly.fts_watership_sendonly': 'Watership_P',
        '/game/gamedata/fasttravel/fts_wetlands1.fts_wetlands1': 'Wetlands_P',
        '/game/gamedata/fasttravel/fts_wetlands2.fts_wetlands2': 'Wetlands_P',
        '/game/gamedata/fasttravel/fts_wetlandsboss.fts_wetlandsboss': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/fts_wetlandsboss_sendonly.fts_wetlandsboss_sendonly': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/fts_wetlandsdroppod.fts_wetlandsdroppod': 'Wetlands_P',
        '/game/gamedata/fasttravel/fts_wetlandsvault.fts_wetlandsvault': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/fts_zonemaptest.fts_zonemaptest': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/fts_zonemaptest2.fts_zonemaptest2': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_atlashq_city.lts_atlashq_city': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_atlashqside_city.lts_atlashqside_city': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_beach_desolate.lts_beach_desolate': 'Beach_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_beach_vaultinterior.lts_beach_vaultinterior': 'Beach_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_atlashq.lts_city_atlashq': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_atlashqside.lts_city_atlashqside': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_cityvault.lts_city_cityvault': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_creatureslaughter.lts_city_creatureslaughter': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_orbitalplatform.lts_city_orbitalplatform': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_outskirts1.lts_city_outskirts1': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_outskirts2.lts_city_outskirts2': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_sanctuary3.lts_city_sanctuary3': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_towers.lts_city_towers': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityboss_cityvault.lts_cityboss_cityvault': 'CityBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityboss_vaultinterior.lts_cityboss_vaultinterior': 'CityBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityvault_city.lts_cityvault_city': 'CityVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityvault_cityboss.lts_cityvault_cityboss': 'CityVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_convoy_desert.lts_convoy_desert': 'Convoy_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_convoy_mine.lts_convoy_mine': 'Convoy_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_covslaughter_mine.lts_covslaughter_mine': 'COVSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_creatureslaughter_city.lts_creatureslaughter_city': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_creatureslaughter_sanctuary3.lts_creatureslaughter_sanctuary3': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_crypt_desolate.lts_crypt_desolate': 'Crypt_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_crypt_finalboss.lts_crypt_finalboss': 'Crypt_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert2_mine2.lts_desert2_mine2': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_convoy.lts_desert_convoy': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_desertvault.lts_desert_desertvault': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_grotto.lts_desert_grotto': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_mine.lts_desert_mine': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_motorcade.lts_desert_motorcade': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_prologue.lts_desert_prologue': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertboss_desertvault.lts_desertboss_desertvault': 'DesertBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertboss_vaultinterior.lts_desertboss_vaultinterior': 'DesertBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertvault_desert.lts_desertvault_desert': 'Desertvault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertvault_desertboss.lts_desertvault_desertboss': 'Desertvault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_beach.lts_desolate_beach': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_crypt.lts_desolate_crypt': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_sanctuary3.lts_desolate_sanctuary3': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_techslaughter.lts_desolate_techslaughter': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_finalboss_crypt.lts_finalboss_crypt': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_finalboss_prologue.lts_finalboss_prologue': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_finalboss_vaultinterior.lts_finalboss_vaultinterior': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_grotto_desert.lts_grotto_desert': 'Grotto_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_grotto_sanctuary3.lts_grotto_sanctuary3': 'Grotto_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mansion_wetlands.lts_mansion_wetlands': 'Mansion_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_marshfields_wetlands.lts_marshfields_wetlands': 'MarshFields_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine2_desert2.lts_mine2_desert2': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine_convoy.lts_mine_convoy': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine_covslaughter.lts_mine_covslaughter': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine_desert.lts_mine_desert': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_monastery_sanctuary3.lts_monastery_sanctuary3': 'Monastery_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcade_desert.lts_motorcade_desert': 'Motorcade_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcade_motorcadefestival.lts_motorcade_motorcadefestival': 'Motorcade_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcadefestival_motorcadeinterior.lts_motorcadefestival_motorcadeinterior': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcadefestival_motorcademain.lts_motorcadefestival_motorcademain': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcadeinterior_motorcadefestival.lts_motorcadeinterior_motorcadefestival': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_orbitalplatform_city.lts_orbitalplatform_city': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_outskirts_city1.lts_outskirts_city1': 'Outskirts_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_outskirts_city2.lts_outskirts_city2': 'Outskirts_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prison_wetlands.lts_prison_wetlands': 'Prison_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_desert.lts_prologue_desert': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_finalboss.lts_prologue_finalboss': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_recruitment.lts_prologue_recruitment': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_sacrifice.lts_prologue_sacrifice': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_sanctuary3.lts_prologue_sanctuary3': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground1_sanctuary3.lts_provingground1_sanctuary3': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground2_sanctuary3.lts_provingground2_sanctuary3': 'ProvingGrounds_Trial2_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground4_sanctuary3.lts_provingground4_sanctuary3': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground5_sanctuary3.lts_provingground5_sanctuary3': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground6_sanctuary3.lts_provingground6_sanctuary3': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground7_sanctuary3.lts_provingground7_sanctuary3': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground8_sanctuary3.lts_provingground8_sanctuary3': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_recruitment_prologue.lts_recruitment_prologue': 'Recruitment_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sacrifice_prologue.lts_sacrifice_prologue': 'Sacrifice_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sactuary3_provingground1.lts_sactuary3_provingground1': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_creatureslaughter.lts_sanctuary3_creatureslaughter': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_desolate.lts_sanctuary3_desolate': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_grotto.lts_sanctuary3_grotto': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_monastery.lts_sanctuary3_monastery': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_outskirts.lts_sanctuary3_outskirts': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_prologue.lts_sanctuary3_prologue': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground2.lts_sanctuary3_provingground2': 'Monastery_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground4.lts_sanctuary3_provingground4': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground5.lts_sanctuary3_provingground5': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground6.lts_sanctuary3_provingground6': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground7.lts_sanctuary3_provingground7': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground8.lts_sanctuary3_provingground8': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_techslaughter.lts_sanctuary3_techslaughter': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_wetlands.lts_sanctuary3_wetlands': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_techslaughter_desolate.lts_techslaughter_desolate': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_techslaughter_sanctuary3.lts_techslaughter_sanctuary3': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_towers_city.lts_towers_city': 'Towers_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_beach.lts_vaultinterior_beach': 'Beach_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_cityboss.lts_vaultinterior_cityboss': 'CityBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_desertboss.lts_vaultinterior_desertboss': 'DesertBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_finalboss.lts_vaultinterior_finalboss': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_wetlandsboss.lts_vaultinterior_wetlandsboss': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_watership_wetlands.lts_watership_wetlands': 'Watership_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_mansion.lts_wetlands_mansion': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_marshfields.lts_wetlands_marshfields': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_prison.lts_wetlands_prison': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_sanctuary3.lts_wetlands_sanctuary3': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_watership.lts_wetlands_watership': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_wetlandsvault.lts_wetlands_wetlandsvault': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsboss_vaultinterior.lts_wetlandsboss_vaultinterior': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsboss_wetlandsvault.lts_wetlandsboss_wetlandsvault': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsvault_wetlands.lts_wetlandsvault_wetlands': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsvault_wetlandsboss.lts_wetlandsvault_wetlandsboss': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_zonemaptest1_zonemaptest2.lts_zonemaptest1_zonemaptest2': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_zonemaptest2_zonemaptest1.lts_zonemaptest2_zonemaptest1': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_controlroom01.rts_atlashq_controlroom01': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_controlroom02.rts_atlashq_controlroom02': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_lounge.rts_atlashq_lounge': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_maintenance.rts_atlashq_maintenance': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_office.rts_atlashq_office': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_controlroomone.rts_atlashq_courtyard_dynamic_checkpoint_controlroomone': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_controlroomtwo.rts_atlashq_courtyard_dynamic_checkpoint_controlroomtwo': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_lounge.rts_atlashq_courtyard_dynamic_checkpoint_lounge': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_maintenance.rts_atlashq_courtyard_dynamic_checkpoint_maintenance': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_office.rts_atlashq_courtyard_dynamic_checkpoint_office': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_labs_2.rts_atlashq_labs_2': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_p_2.rts_atlashq_p_2': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_controlroomone.rts_autogen_checkpoint_controlroomone': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_controlroomtwo.rts_autogen_checkpoint_controlroomtwo': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_lounge.rts_autogen_checkpoint_lounge': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_maintenance.rts_autogen_checkpoint_maintenance': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_office.rts_autogen_checkpoint_office': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_159.rts_autogen_resurrecttravelstationobject_159': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_7.rts_autogen_resurrecttravelstationobject_7': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_2.rts_beach_p_2': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_3.rts_beach_p_3': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_5.rts_beach_p_5': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_6.rts_beach_p_6': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_7.rts_beach_p_7': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_plot_m_159.rts_beach_plot_m_159': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_1.rts_autogen_resurrecttravelstationobject_1': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_34437.rts_autogen_resurrecttravelstationobject_34437': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_36177.rts_autogen_resurrecttravelstationobject_36177': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_38715.rts_autogen_resurrecttravelstationobject_38715': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_44109.rts_autogen_resurrecttravelstationobject_44109': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_49115.rts_autogen_resurrecttravelstationobject_49115': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_boss_gigamind_38715.rts_city_boss_gigamind_38715': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_0.rts_city_dynamic_0': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_1.rts_city_dynamic_1': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_2.rts_city_dynamic_2': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_34437.rts_city_dynamic_34437': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_36177.rts_city_dynamic_36177': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_38715.rts_city_dynamic_38715': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_44109.rts_city_dynamic_44109': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_49115.rts_city_dynamic_49115': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_hub_49115.rts_city_hub_49115': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_14.rts_autogen_resurrecttravelstationobject_14': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_28.rts_autogen_resurrecttravelstationobject_28': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_afterdriving.rts_autogen_resurrecttravelstationobject_afterdriving': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt.rts_autogen_resurrecttravelstationobject_chkpt': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt_0.rts_autogen_resurrecttravelstationobject_chkpt_0': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt_1.rts_autogen_resurrecttravelstationobject_chkpt_1': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt_2.rts_autogen_resurrecttravelstationobject_chkpt_2': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_0.rts_cityvault_m_laststop_0': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_28.rts_cityvault_m_laststop_28': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_afterdriving.rts_cityvault_m_laststop_afterdriving': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt.rts_cityvault_m_laststop_chkpt': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt_0.rts_cityvault_m_laststop_chkpt_0': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt_1.rts_cityvault_m_laststop_chkpt_1': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt_2.rts_cityvault_m_laststop_chkpt_2': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_resurrecttravelstationobject.rts_cityvault_m_laststop_resurrecttravelstationobject': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation.rts_autogen_resurrecttravelstation': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_31032.rts_autogen_resurrecttravelstation_31032': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_36.rts_autogen_resurrecttravelstation_36': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_37.rts_autogen_resurrecttravelstation_37': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_54.rts_autogen_resurrecttravelstation_54': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation.rts_convoy_p_resurrecttravelstation': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_31032.rts_convoy_p_resurrecttravelstation_31032': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_36.rts_convoy_p_resurrecttravelstation_36': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_37.rts_convoy_p_resurrecttravelstation_37': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_54.rts_convoy_p_resurrecttravelstation_54': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/creatureslaughter/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_autogen_resurrecttravelstationobject3.rts_autogen_resurrecttravelstationobject3': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_autogen_resurrecttravelstationobject4.rts_autogen_resurrecttravelstationobject4': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_0.rts_crypt_p_0': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_resurrecttravelstationobject.rts_crypt_p_resurrecttravelstationobject': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_resurrecttravelstationobject3.rts_crypt_p_resurrecttravelstationobject3': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_resurrecttravelstationobject4.rts_crypt_p_resurrecttravelstationobject4': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject11.rts_autogen_resurrecttravelstationobject11': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_84.rts_autogen_resurrecttravelstationobject_84': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_85.rts_autogen_resurrecttravelstationobject_85': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_86.rts_autogen_resurrecttravelstationobject_86': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_87.rts_autogen_resurrecttravelstationobject_87': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_89.rts_autogen_resurrecttravelstationobject_89': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_84.rts_desert_p_84': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_85.rts_desert_p_85': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_86.rts_desert_p_86': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_87.rts_desert_p_87': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_89.rts_desert_p_89': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_poi_babydancer_84.rts_desert_poi_babydancer_84': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_poi_echonet_resurrecttravelstationobject11.rts_desert_poi_echonet_resurrecttravelstationobject11': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desertvault/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Desertvault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desertvault/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Desertvault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_13.rts_autogen_resurrecttravelstationobject_13': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_14.rts_autogen_resurrecttravelstationobject_14': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_4.rts_autogen_resurrecttravelstationobject_4': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_7.rts_autogen_resurrecttravelstationobject_7': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_8.rts_autogen_resurrecttravelstationobject_8': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_9.rts_autogen_resurrecttravelstationobject_9': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_asylum.rts_desolate_gameplay_asylum': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_beforerepaircamp.rts_desolate_gameplay_beforerepaircamp': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_beforetrauntarena.rts_desolate_gameplay_beforetrauntarena': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_eastmarsh.rts_desolate_gameplay_eastmarsh': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_finaleentrance.rts_desolate_gameplay_finaleentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_maliwancampentrance.rts_desolate_gameplay_maliwancampentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_maliwancampexit.rts_desolate_gameplay_maliwancampexit': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_northswampentrance.rts_desolate_gameplay_northswampentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_northtemplebelow.rts_desolate_gameplay_northtemplebelow': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_northtempleentrance.rts_desolate_gameplay_northtempleentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_typhoncampoutside.rts_desolate_gameplay_typhoncampoutside': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/finalboss/rts_autogen_resurrecttravelstationobject_5082.rts_autogen_resurrecttravelstationobject_5082': 'FinalBoss_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_1404.rts_autogen_resurrecttravelstationobject_1404': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_18.rts_autogen_resurrecttravelstationobject_18': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_48.rts_autogen_resurrecttravelstationobject_48': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_dynamic_48.rts_mansion_dynamic_48': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_0.rts_mansion_exterior_0': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_1.rts_mansion_exterior_1': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_1404.rts_mansion_exterior_1404': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_18.rts_mansion_exterior_18': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_48.rts_mansion_exterior_48': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_theater_resurrecttravelstationobject.rts_mansion_theater_resurrecttravelstationobject': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_54.rts_autogen_resurrecttravelstationobject_54': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_72.rts_autogen_resurrecttravelstationobject_72': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_90.rts_autogen_resurrecttravelstationobject_90': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_956.rts_autogen_resurrecttravelstationobject_956': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_28.rts_autogen_resurrecttravelstationobject_28': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_29.rts_autogen_resurrecttravelstationobject_29': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_36.rts_autogen_resurrecttravelstationobject_36': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_54.rts_autogen_resurrecttravelstationobject_54': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_m_bridgeinthedark_0.rts_mine_m_bridgeinthedark_0': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_0.rts_mine_p_0': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_28.rts_mine_p_28': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_29.rts_mine_p_29': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_54.rts_mine_p_54': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_section2_lobby_36.rts_mine_section2_lobby_36': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject10.rts_autogen_resurrecttravelstationobject10': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject9.rts_autogen_resurrecttravelstationobject9': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_240.rts_autogen_resurrecttravelstationobject_240': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_84.rts_autogen_resurrecttravelstationobject_84': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_87.rts_autogen_resurrecttravelstationobject_87': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_chopchop.rts_autogen_resurrecttravelstationobject_chopchop': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_desert.rts_autogen_resurrecttravelstationobject_desert': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_greaseland_4071.rts_autogen_resurrecttravelstationobject_greaseland_4071': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_homestead.rts_autogen_resurrecttravelstationobject_homestead': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_homestead_16407.rts_autogen_resurrecttravelstationobject_homestead_16407': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_orphanage.rts_autogen_resurrecttravelstationobject_orphanage': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_radiostation.rts_autogen_resurrecttravelstationobject_radiostation': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_ravecave.rts_autogen_resurrecttravelstationobject_ravecave': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_rollercoaster.rts_autogen_resurrecttravelstationobject_rollercoaster': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_spiderantcave.rts_autogen_resurrecttravelstationobject_spiderantcave': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadefestival/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadefestival/rts_autogen_resurrecttravelstationobject_3245.rts_autogen_resurrecttravelstationobject_3245': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadefestival/rts_autogen_resurrecttravelstationobject_668.rts_autogen_resurrecttravelstationobject_668': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject5.rts_autogen_resurrecttravelstationobject5': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject_42.rts_autogen_resurrecttravelstationobject_42': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject_43.rts_autogen_resurrecttravelstationobject_43': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject_44.rts_autogen_resurrecttravelstationobject_44': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_catwalks_resurrecttravelstationobject5.rts_motorcadeinterior_catwalks_resurrecttravelstationobject5': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_engine_43.rts_motorcadeinterior_engine_43': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_plot_44.rts_motorcadeinterior_plot_44': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_top_42.rts_motorcadeinterior_top_42': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_1.rts_autogen_resurrecttravelstationobject_1': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_28.rts_autogen_resurrecttravelstationobject_28': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_4.rts_autogen_resurrecttravelstationobject_4': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_0.rts_orbitalplatform_combat_0': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_1.rts_orbitalplatform_combat_1': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_2.rts_orbitalplatform_combat_2': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_28.rts_orbitalplatform_combat_28': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_3.rts_orbitalplatform_combat_3': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_4.rts_orbitalplatform_combat_4': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_5.rts_orbitalplatform_combat_5': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_m_oppresearch_2.rts_orbitalplatform_m_oppresearch_2': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_mission_0.rts_orbitalplatform_mission_0': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_14447.rts_autogen_resurrecttravelstationobject_14447': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_16242.rts_autogen_resurrecttravelstationobject_16242': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_19620.rts_autogen_resurrecttravelstationobject_19620': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_786.rts_autogen_resurrecttravelstationobject_786': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_1243.rts_autogen_resurrecttravelstationobject_1243': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_2268.rts_autogen_resurrecttravelstationobject_2268': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_3114.rts_autogen_resurrecttravelstationobject_3114': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_3242.rts_autogen_resurrecttravelstationobject_3242': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_3964.rts_autogen_resurrecttravelstationobject_3964': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_594.rts_autogen_resurrecttravelstationobject_594': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_6231.rts_autogen_resurrecttravelstationobject_6231': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_648.rts_autogen_resurrecttravelstationobject_648': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_74.rts_autogen_resurrecttravelstationobject_74': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_8752.rts_autogen_resurrecttravelstationobject_8752': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_884.rts_autogen_resurrecttravelstationobject_884': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_12.rts_autogen_resurrecttravelstationobject_12': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_13.rts_autogen_resurrecttravelstationobject_13': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_2220.rts_autogen_resurrecttravelstationobject_2220': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_2846.rts_autogen_resurrecttravelstationobject_2846': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_8159.rts_autogen_resurrecttravelstationobject_8159': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_pastbarricade.rts_autogen_resurrecttravelstationobject_pastbarricade': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_combat_2.rts_prologue_combat_2': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_combat_6.rts_prologue_combat_6': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_0.rts_prologue_dynamic_0': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_12.rts_prologue_dynamic_12': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_13.rts_prologue_dynamic_13': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_2.rts_prologue_dynamic_2': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_2220.rts_prologue_dynamic_2220': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_2846.rts_prologue_dynamic_2846': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_3.rts_prologue_dynamic_3': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_5.rts_prologue_dynamic_5': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_6.rts_prologue_dynamic_6': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_8159.rts_prologue_dynamic_8159': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_pastbarricade.rts_prologue_dynamic_pastbarricade': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial1/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial1/rts_autogen_resurrecttravelstationobject_180.rts_autogen_resurrecttravelstationobject_180': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial1/rts_autogen_resurrecttravelstationobject_730.rts_autogen_resurrecttravelstationobject_730': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial4/rts_autogen_resurrecttravelstationobject_1896.rts_autogen_resurrecttravelstationobject_1896': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial4/rts_autogen_resurrecttravelstationobject_3373.rts_autogen_resurrecttravelstationobject_3373': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial4/rts_autogen_resurrecttravelstationobject_3614.rts_autogen_resurrecttravelstationobject_3614': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial5/rts_autogen_resurrecttravelstationobject_13277.rts_autogen_resurrecttravelstationobject_13277': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial5/rts_autogen_resurrecttravelstationobject_3614.rts_autogen_resurrecttravelstationobject_3614': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial5/rts_autogen_resurrecttravelstationobject_3962.rts_autogen_resurrecttravelstationobject_3962': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial6/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial6/rts_autogen_resurrecttravelstationobject_1502.rts_autogen_resurrecttravelstationobject_1502': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial6/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial7/rts_autogen_resurrecttravelstationobject_afterencounter.rts_autogen_resurrecttravelstationobject_afterencounter': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial7/rts_autogen_resurrecttravelstationobject_afterencounter_7403.rts_autogen_resurrecttravelstationobject_afterencounter_7403': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial7/rts_autogen_resurrecttravelstationobject_afterencounter_7440.rts_autogen_resurrecttravelstationobject_afterencounter_7440': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial8/rts_autogen_resurrecttravelstationobject_afterencounter.rts_autogen_resurrecttravelstationobject_afterencounter': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial8/rts_autogen_resurrecttravelstationobject_afterencounter_1801.rts_autogen_resurrecttravelstationobject_afterencounter_1801': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial8/rts_autogen_resurrecttravelstationobject_afterencounter_24.rts_autogen_resurrecttravelstationobject_afterencounter_24': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/recruitment/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Recruitment_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/recruitment/rts_autogen_resurrecttravelstationobject_covcamp.rts_autogen_resurrecttravelstationobject_covcamp': 'Recruitment_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_13.rts_autogen_resurrecttravelstationobject_13': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_16.rts_autogen_resurrecttravelstationobject_16': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_2828.rts_autogen_resurrecttravelstationobject_2828': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_7547.rts_autogen_resurrecttravelstationobject_7547': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/techslaughter/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_1136.rts_autogen_resurrecttravelstationobject_1136': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_14.rts_autogen_resurrecttravelstationobject_14': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_660.rts_autogen_resurrecttravelstationobject_660': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_772.rts_autogen_resurrecttravelstationobject_772': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_84.rts_autogen_resurrecttravelstationobject_84': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_85.rts_autogen_resurrecttravelstationobject_85': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_86.rts_autogen_resurrecttravelstationobject_86': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_87.rts_autogen_resurrecttravelstationobject_87': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject4.rts_autogen_resurrecttravelstationobject4': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject8.rts_autogen_resurrecttravelstationobject8': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject9.rts_autogen_resurrecttravelstationobject9': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject_18.rts_autogen_resurrecttravelstationobject_18': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject_4123.rts_autogen_resurrecttravelstationobject_4123': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject_6904.rts_autogen_resurrecttravelstationobject_6904': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_combat_resurrecttravelstationobject.rts_watership_combat_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_leadup_geo_6904.rts_watership_leadup_geo_6904': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_mission_0.rts_watership_mission_0': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_mission_1.rts_watership_mission_1': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_mission_resurrecttravelstationobject.rts_watership_mission_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_p_resurrecttravelstationobject4.rts_watership_p_resurrecttravelstationobject4': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_p_resurrecttravelstationobject8.rts_watership_p_resurrecttravelstationobject8': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_sidemission_0.rts_watership_sidemission_0': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_sidemission_4123.rts_watership_sidemission_4123': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_sidemission_resurrecttravelstationobject.rts_watership_sidemission_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_1046.rts_autogen_resurrecttravelstationobject_1046': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_1190.rts_autogen_resurrecttravelstationobject_1190': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_36.rts_autogen_resurrecttravelstationobject_36': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_4761.rts_autogen_resurrecttravelstationobject_4761': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_4791.rts_autogen_resurrecttravelstationobject_4791': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_48.rts_autogen_resurrecttravelstationobject_48': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_5977.rts_autogen_resurrecttravelstationobject_5977': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_7157.rts_autogen_resurrecttravelstationobject_7157': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_9177.rts_autogen_resurrecttravelstationobject_9177': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_920.rts_autogen_resurrecttravelstationobject_920': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_1046.rts_wetlands_combat_1046': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_1190.rts_wetlands_combat_1190': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_36.rts_wetlands_combat_36': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_4761.rts_wetlands_combat_4761': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_4791.rts_wetlands_combat_4791': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_48.rts_wetlands_combat_48': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_5977.rts_wetlands_combat_5977': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_7157.rts_wetlands_combat_7157': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_9177.rts_wetlands_combat_9177': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_920.rts_wetlands_combat_920': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_autogen_resurrecttravelstationobject_108.rts_autogen_resurrecttravelstationobject_108': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_autogen_resurrecttravelstationobject_144.rts_autogen_resurrecttravelstationobject_144': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_autogen_resurrecttravelstationobject_54.rts_autogen_resurrecttravelstationobject_54': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_combat_144.rts_wetlandsvault_combat_144': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_p_108.rts_wetlandsvault_p_108': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_p_144.rts_wetlandsvault_p_144': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_p_54.rts_wetlandsvault_p_54': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_airport.rts_city_airport': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_atlashqgates.rts_city_atlashqgates': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_cvgate.rts_city_cvgate': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_maintexit.rts_city_maintexit': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_mallentrance.rts_city_mallentrance': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_cave.rts_cityvault_cave': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_phonebank.rts_cityvault_phonebank': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_stationentrance.rts_cityvault_stationentrance': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_vehiclepit1.rts_cityvault_vehiclepit1': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_vehiclepit2.rts_cityvault_vehiclepit2': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_bosscourtyard.rts_monastery_bosscourtyard': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_bridge.rts_monastery_bridge': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_cemetery.rts_monastery_cemetery': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_cliffpath.rts_monastery_cliffpath': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_ballpit.rts_orbitalplatform_ballpit': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_cargobay.rts_orbitalplatform_cargobay': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_commandcenter.rts_orbitalplatform_commandcenter': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_maintenance.rts_orbitalplatform_maintenance': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_thruster.rts_orbitalplatform_thruster': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_desertgate.rts_prologue_desertgate': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_ellies.rts_prologue_ellies': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_gatecamp.rts_prologue_gatecamp': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_launchpad.rts_prologue_launchpad': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_lilithbase.rts_prologue_lilithbase': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_navcamp.rts_prologue_navcamp': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_sacrificegate.rts_prologue_sacrificegate': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_vehiclecamp.rts_prologue_vehiclecamp': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/recruitment/rts_recruitment_entrance.rts_recruitment_entrance': 'Recruitment_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_holybroadgate.rts_sacrifice_holybroadgate': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_holybroadlobby.rts_sacrifice_holybroadlobby': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_mouthpiece.rts_sacrifice_mouthpiece': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_prologuegate.rts_sacrifice_prologuegate': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/wetlands/rts_wetlands_mansion.rts_wetlands_mansion': 'Wetlands_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/fts_bloodyharvest.fts_bloodyharvest': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_bloodyharvest_exit_sanctuary3.lts_bloodyharvest_exit_sanctuary3': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_bloodyharvest_sanctuary3.lts_bloodyharvest_sanctuary3': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_sanctuary3_bloodyharvest.lts_sanctuary3_bloodyharvest': 'Sanctuary3_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_sanctuary3_bloodyharvest_exit.lts_sanctuary3_bloodyharvest_exit': 'Sanctuary3_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_boss_2.rts_bloodyharvest_boss_2': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_combat_0.rts_bloodyharvest_combat_0': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_combat_2.rts_bloodyharvest_combat_2': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_p_2.rts_bloodyharvest_p_2': 'BloodyHarvest_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_casinointro_dlc1_pod.fts_casinointro_dlc1_pod': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_core_dlc1.fts_core_dlc1': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_core_dlc1_boss.fts_core_dlc1_boss': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_impound_dlc1.fts_impound_dlc1': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_impound_dlc1_exit.fts_impound_dlc1_exit': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_impound_dlc1_lowgrav.fts_impound_dlc1_lowgrav': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_entrance.fts_strip_dlc1_entrance': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_hideout.fts_strip_dlc1_hideout': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_market.fts_strip_dlc1_market': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_tricksynickarea.fts_strip_dlc1_tricksynickarea': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_vice.fts_strip_dlc1_vice': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_towerlair_dlc1_lobby.fts_towerlair_dlc1_lobby': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_towerlair_dlc1_scrooge.fts_towerlair_dlc1_scrooge': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_trashtown_dlc1.fts_trashtown_dlc1': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_trashtown_dlc1_town.fts_trashtown_dlc1_town': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_casinointro_strip.lts_casinointro_strip': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_core_strip.lts_core_strip': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_impound_strip.lts_impound_strip': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_casinointro.lts_strip_casinointro': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_core.lts_strip_core': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_impound.lts_strip_impound': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_towerlair.lts_strip_towerlair': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_trashtown.lts_strip_trashtown': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_towerlair_strip.lts_towerlair_strip': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_trashtown_strip.lts_trashtown_strip': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/lts_sanctuary3_dlc1.lts_sanctuary3_dlc1': 'Sanctuary3_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_011.rts_casino_travel_011': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_211.rts_casino_travel_211': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_311.rts_casino_travel_311': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_611.rts_casino_travel_611': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_711.rts_casino_travel_711': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_00.rts_core_travel_00': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_01.rts_core_travel_01': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_02.rts_core_travel_02': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_03.rts_core_travel_03': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_04.rts_core_travel_04': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_05.rts_core_travel_05': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_06.rts_core_travel_06': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_07.rts_core_travel_07': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_10.rts_core_travel_10': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_01.rts_impound_travel_01': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_02.rts_impound_travel_02': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_03.rts_impound_travel_03': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_04.rts_impound_travel_04': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_05.rts_impound_travel_05': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_06.rts_impound_travel_06': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_08.rts_impound_travel_08': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_09.rts_impound_travel_09': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_compound.rts_strip_travel_resurrecttravel_compound': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_deathtowers.rts_strip_travel_resurrecttravel_deathtowers': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_fightpit.rts_strip_travel_resurrecttravel_fightpit': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_market.rts_strip_travel_resurrecttravel_market': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_spa.rts_strip_travel_resurrecttravel_spa': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_square.rts_strip_travel_resurrecttravel_square': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_suit.rts_strip_travel_resurrecttravel_suit': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/towerlair/rts_towerlair_travel_1.rts_towerlair_travel_1': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_2.rts_trashtown_travel_2': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_3.rts_trashtown_travel_3': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_claptrapcave.rts_trashtown_travel_claptrapcave': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_claptraptoescort.rts_trashtown_travel_claptraptoescort': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_escortstart.rts_trashtown_travel_escortstart': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_outsidetrashtown.rts_trashtown_travel_outsidetrashtown': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_pretrashtown.rts_trashtown_travel_pretrashtown': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_underbeam.rts_trashtown_travel_underbeam': 'Trashtown_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_archive.fts_dlc2_archive': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_archives_oneway.fts_dlc2_archives_oneway': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_bar.fts_dlc2_bar': 'Bar_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_camp.fts_dlc2_camp': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_camp_oneway.fts_dlc2_camp_oneway': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_amourette.fts_dlc2_lake_amourette': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_droppod.fts_dlc2_lake_droppod': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_excavation.fts_dlc2_lake_excavation': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_gondola.fts_dlc2_lake_gondola': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_venue.fts_dlc2_venue': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_venue_mapstart.fts_dlc2_venue_mapstart': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_venue_oneway.fts_dlc2_venue_oneway': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_village_neararchives.fts_dlc2_village_neararchives': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_village_nearbar.fts_dlc2_village_nearbar': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_villagedistrict.fts_dlc2_villagedistrict': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_villagegardens.fts_dlc2_villagegardens': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_woods.fts_dlc2_woods': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_archive_village.lts_dlc2_archive_village': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_bar_lake.lts_dlc2_bar_lake': 'Bar_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_bar_village.lts_dlc2_bar_village': 'Bar_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_camp_lake.lts_dlc2_camp_lake': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_lake_bar.lts_dlc2_lake_bar': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_lake_camp.lts_dlc2_lake_camp': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_lake_woods.lts_dlc2_lake_woods': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_memories_woods.lts_dlc2_memories_woods': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_venue_village.lts_dlc2_venue_village': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_village_archive.lts_dlc2_village_archive': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_village_bar.lts_dlc2_village_bar': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_village_venue.lts_dlc2_village_venue': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_woods_lake.lts_dlc2_woods_lake': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_woods_memories.lts_dlc2_woods_memories': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/patchedleveltraveldata/lts_sanctuary3_dlc2.lts_sanctuary3_dlc2': 'Sanctuary3_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_1.rts_archive_1': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_2.rts_archive_2': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_3.rts_archive_3': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_4.rts_archive_4': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_5.rts_archive_5': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_1.rts_camp_1': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_2.rts_camp_2': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_3.rts_camp_3': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_4.rts_camp_4': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_5.rts_camp_5': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_6.rts_camp_6': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_7.rts_camp_7': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_1.rts_lake_1': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_2.rts_lake_2': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_3.rts_lake_3': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_4.rts_lake_4': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_5.rts_lake_5': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_6.rts_lake_6': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_7.rts_lake_7': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_1.rts_venue_1': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_2.rts_venue_2': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_3.rts_venue_3': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_4.rts_venue_4': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_5.rts_venue_5': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/village/rts_village_1.rts_village_1': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/village/rts_village_2.rts_village_2': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_1.rts_woods_1': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_2.rts_woods_2': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_3.rts_woods_3': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_4.rts_woods_4': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_5.rts_woods_5': 'Woods_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/fts_maliwantd_sendonly.fts_maliwantd_sendonly': 'Raid_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/fts_raid1.fts_raid1': 'Raid_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/fts_raid1droppod.fts_raid1droppod': 'Raid_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/lts_sanctuary3_raid1.lts_sanctuary3_raid1': 'Sanctuary3_P',
        }

