"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_sagemaker_1 = require("monocdk/aws-sagemaker");
const nag_pack_1 = require("../../../nag-pack");
/**
 * SageMaker notebook instances have direct internet access disabled - (Control IDs: AC-3, AC-4, AC-6, AC-21(b), SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_sagemaker_1.CfnNotebookInstance) {
        const directInternetAccess = nag_pack_1.resolveIfPrimitive(node, node.directInternetAccess);
        if (directInternetAccess == undefined ||
            directInternetAccess != 'Disabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzU2FnZU1ha2VyTm90ZWJvb2tEaXJlY3RJbnRlcm5ldEFjY2Vzc0Rpc2FibGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL05JU1QtODAwLTUzL3J1bGVzL3NhZ2VtYWtlci9uaXN0ODAwNTNTYWdlTWFrZXJOb3RlYm9va0RpcmVjdEludGVybmV0QWNjZXNzRGlzYWJsZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7RUFHRTs7QUFHRix5REFBNEQ7QUFDNUQsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxtQ0FBbUIsRUFBRTtRQUN2QyxNQUFNLG9CQUFvQixHQUFHLDZCQUFrQixDQUM3QyxJQUFJLEVBQ0osSUFBSSxDQUFDLG9CQUFvQixDQUMxQixDQUFDO1FBQ0YsSUFDRSxvQkFBb0IsSUFBSSxTQUFTO1lBQ2pDLG9CQUFvQixJQUFJLFVBQVUsRUFDbEM7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFkRCw0QkFjQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuTm90ZWJvb2tJbnN0YW5jZSB9IGZyb20gJ21vbm9jZGsvYXdzLXNhZ2VtYWtlcic7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogU2FnZU1ha2VyIG5vdGVib29rIGluc3RhbmNlcyBoYXZlIGRpcmVjdCBpbnRlcm5ldCBhY2Nlc3MgZGlzYWJsZWQgLSAoQ29udHJvbCBJRHM6IEFDLTMsIEFDLTQsIEFDLTYsIEFDLTIxKGIpLCBTQy03LCBTQy03KDMpKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbk5vdGVib29rSW5zdGFuY2UpIHtcbiAgICBjb25zdCBkaXJlY3RJbnRlcm5ldEFjY2VzcyA9IHJlc29sdmVJZlByaW1pdGl2ZShcbiAgICAgIG5vZGUsXG4gICAgICBub2RlLmRpcmVjdEludGVybmV0QWNjZXNzLFxuICAgICk7XG4gICAgaWYgKFxuICAgICAgZGlyZWN0SW50ZXJuZXRBY2Nlc3MgPT0gdW5kZWZpbmVkIHx8XG4gICAgICBkaXJlY3RJbnRlcm5ldEFjY2VzcyAhPSAnRGlzYWJsZWQnXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19