"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const nag_pack_1 = require("../../../nag-pack");
/**
 * S3 Buckets have object lock enabled - (Control ID: SC-28)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const objectLockEnabled = nag_pack_1.resolveIfPrimitive(node, node.objectLockEnabled);
        const objectLockConfiguration = monocdk_1.Stack.of(node).resolve(node.objectLockConfiguration);
        if (objectLockEnabled !== true ||
            objectLockConfiguration === undefined ||
            nag_pack_1.resolveIfPrimitive(node, objectLockConfiguration.objectLockEnabled) !==
                'Enabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzUzNCdWNrZXREZWZhdWx0TG9ja0VuYWJsZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvTklTVC04MDAtNTMvcnVsZXMvczMvbmlzdDgwMDUzUzNCdWNrZXREZWZhdWx0TG9ja0VuYWJsZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsMkNBQTJDO0FBQzNDLGdEQUF1RDtBQUV2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksa0JBQVMsRUFBRTtRQUM3QixNQUFNLGlCQUFpQixHQUFHLDZCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUMzRSxNQUFNLHVCQUF1QixHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUNwRCxJQUFJLENBQUMsdUJBQXVCLENBQzdCLENBQUM7UUFDRixJQUNFLGlCQUFpQixLQUFLLElBQUk7WUFDMUIsdUJBQXVCLEtBQUssU0FBUztZQUNyQyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsdUJBQXVCLENBQUMsaUJBQWlCLENBQUM7Z0JBQ2pFLFNBQVMsRUFDWDtZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWhCRCw0QkFnQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuQnVja2V0IH0gZnJvbSAnbW9ub2Nkay9hd3MtczMnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIFMzIEJ1Y2tldHMgaGF2ZSBvYmplY3QgbG9jayBlbmFibGVkIC0gKENvbnRyb2wgSUQ6IFNDLTI4KVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkJ1Y2tldCkge1xuICAgIGNvbnN0IG9iamVjdExvY2tFbmFibGVkID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUub2JqZWN0TG9ja0VuYWJsZWQpO1xuICAgIGNvbnN0IG9iamVjdExvY2tDb25maWd1cmF0aW9uID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgIG5vZGUub2JqZWN0TG9ja0NvbmZpZ3VyYXRpb24sXG4gICAgKTtcbiAgICBpZiAoXG4gICAgICBvYmplY3RMb2NrRW5hYmxlZCAhPT0gdHJ1ZSB8fFxuICAgICAgb2JqZWN0TG9ja0NvbmZpZ3VyYXRpb24gPT09IHVuZGVmaW5lZCB8fFxuICAgICAgcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG9iamVjdExvY2tDb25maWd1cmF0aW9uLm9iamVjdExvY2tFbmFibGVkKSAhPT1cbiAgICAgICAgJ0VuYWJsZWQnXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19