"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 * RDS DB instances and Aurora DB clusters have storage encryption enabled - (Control IDs: SC-13, SC-28)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.storageEncrypted == undefined) {
            return false;
        }
        const encrypted = nag_pack_1.resolveIfPrimitive(node, node.storageEncrypted);
        if (encrypted == false) {
            return false;
        }
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        const encrypted = nag_pack_1.resolveIfPrimitive(node, node.storageEncrypted);
        if ((encrypted == false || encrypted == undefined) &&
            (node.engine == undefined ||
                !node.engine.toLowerCase().includes('aurora'))) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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