"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_iam_1 = require("monocdk/aws-iam");
/**
 * IAM Group, User, and Roles do not contain inline policies - (Control ID: AC-6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnGroup ||
        node instanceof aws_iam_1.CfnUser ||
        node instanceof aws_iam_1.CfnRole) {
        const inlinePolicies = monocdk_1.Stack.of(node).resolve(node.policies);
        if (inlinePolicies != undefined) {
            return false;
        }
    }
    if (node instanceof aws_iam_1.CfnPolicy) {
        return false;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzSUFNTm9JbmxpbmVQb2xpY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvTklTVC04MDAtNTMvcnVsZXMvaWFtL25pc3Q4MDA1M0lBTU5vSW5saW5lUG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLDZDQUF3RTtBQUV4RTs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFDRSxJQUFJLFlBQVksa0JBQVE7UUFDeEIsSUFBSSxZQUFZLGlCQUFPO1FBQ3ZCLElBQUksWUFBWSxpQkFBTyxFQUN2QjtRQUNBLE1BQU0sY0FBYyxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUM3RCxJQUFJLGNBQWMsSUFBSSxTQUFTLEVBQUU7WUFDL0IsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsSUFBSSxJQUFJLFlBQVksbUJBQVMsRUFBRTtRQUM3QixPQUFPLEtBQUssQ0FBQztLQUNkO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBZkQsNEJBZUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuUm9sZSwgQ2ZuVXNlciwgQ2ZuR3JvdXAsIENmblBvbGljeSB9IGZyb20gJ21vbm9jZGsvYXdzLWlhbSc7XG5cbi8qKlxuICogSUFNIEdyb3VwLCBVc2VyLCBhbmQgUm9sZXMgZG8gbm90IGNvbnRhaW4gaW5saW5lIHBvbGljaWVzIC0gKENvbnRyb2wgSUQ6IEFDLTYpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChcbiAgICBub2RlIGluc3RhbmNlb2YgQ2ZuR3JvdXAgfHxcbiAgICBub2RlIGluc3RhbmNlb2YgQ2ZuVXNlciB8fFxuICAgIG5vZGUgaW5zdGFuY2VvZiBDZm5Sb2xlXG4gICkge1xuICAgIGNvbnN0IGlubGluZVBvbGljaWVzID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLnBvbGljaWVzKTtcbiAgICBpZiAoaW5saW5lUG9saWNpZXMgIT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUG9saWN5KSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19