"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ElastiCache Redis clusters retain automatic backups for at least 15 days - (Control IDs: CP-9(b), CP-10, SI-12)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnCacheCluster) {
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine.toLowerCase());
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (engine == 'redis' && (retention == undefined || retention < 15)) {
            return false;
        }
    }
    else if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (retention == undefined || retention < 15) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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