"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks - (Control IDs: SC-5)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        //get all associated CLBs
        const classicLBs = monocdk_1.Stack.of(node).resolve(node.loadBalancerNames);
        //get all associated Application LBs, Gateway LBs, and Network LBs
        const otherLBs = monocdk_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = nag_pack_1.resolveIfPrimitive(node, node.healthCheckType);
            //Do we use ELB health checks?
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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